# Makefile.M for extra/src/c-client directory
# $Id: Makefile.M,v 1.12 2003/02/24 18:21:51 vadz Exp $

# This is the "real" Makefile for the c-client directory.  It kludges
# around the Makefile provided with the library, coercing it to work
# with the Mahogany build system.

include ../../../makeopts

# we depend upon the fact that the last file created by c-client's
# setup is $(SET_UP), so if it is present, we're ready to go.
SET_UP := osdep.c

# linkage.c file is normally included by user code to initialize c-client, we
# use a slightly modified version of it
LINKAGE=linkage_no_ssl.c

# c-client cannot use a parallel make.  This may be excessive paranoia,
# but we go to a lot of trouble to avoid ever invoking it in parallel.
# strip off any -j arguments to environmental MAKE
MAKE := $(shell echo $(MAKE) | sed "1,1 s/-j[ 0-9]*//g")
# pick a single target in case we are parallel
TARGET := $(shell if test -f $(SET_UP); then echo c-client.a; else echo $(SET_UP); fi)

all:	$(TARGET) $(LINKAGE)
	@true

# only tripped if using a separate build directory
drivers: .src/drivers
	@# incredible as it may seem, Solaris ln does *NOT* overwrite the
	@# existing files and so simple "ln -sf .src/* ." fails because
	@# Makefile link already exists (it was created by configure)
	@for i in .src/*; do \
	    if test ! -f `basename $$i`; then ln -s $$i .; fi \
	done

# initial make call, set up for our OS type
$(SET_UP): drivers
	@$(MAKE) -j1 $(IMAP_OSTYPE) --no-print-directory \
		MAKE="$(MAKE) -j1" CC="$(CC)" \
		$(IMAP_SSLTYPE) \
		EXTRACFLAGS="$(IMAP_CPPFLAGS)"

# subsequent make call, only call c-client's Makefile if it looks
# like there's something to do
c-client.a: $(wildcard *.c) $(wildcard *.h)
	@$(MAKE) -j1 --no-print-directory MAKE="$(MAKE) -j1"

# we don't want to call ssl_onceonlyinit() from linkage.c, instead we do it
# ourselves later (the first time SSL is needed)
#
# cclient also disables plain passwords if using SSL by default, prevent this
# from happening
linkage_no_ssl.c: linkage.c
	grep -v ssl_onceonlyinit $< | grep -v SET_DISABLEPLAINTEXT > $@

clean:
	@$(MAKE) -j1 --no-print-directory clean 
	$(RM) X `find * -type l ! -name Makefile -print`

.PRECIOUS: $(SET_UP)
.PHONY: all clean
