///////////////////////////////////////////////////////////////////////////////
// Project:     M - cross platform e-mail GUI client
// File name:   Moptions.cpp: Mahogany options and their default values
// Purpose:     implements functions for reading options from profiles
//              conveniently
// Author:      Vadim Zeitlin
// Modified by:
// Created:     22.08.01
// CVS-ID:      $Id: Moptions.cpp,v 1.59 2003/07/23 23:09:10 nerijus Exp $
// Copyright:   (c) 2001 Vadim Zeitlin
// Licence:     M licence
///////////////////////////////////////////////////////////////////////////////

// ============================================================================
// declarations
// ============================================================================

// ----------------------------------------------------------------------------
// headers
// ----------------------------------------------------------------------------

#include "Mpch.h"

#ifndef  USE_PCH
   #include "Mcommon.h"
#endif

#include "Mdefaults.h"
#include "Moptions.h"

#include "FolderType.h" // for MF_FILE used by MP_LAST_CREATED_FOLDER_TYPE

// ----------------------------------------------------------------------------
// MOptionData
// ----------------------------------------------------------------------------

struct MOptionData
{
   MOptionData(const char *name_, long val)
   {
      name = name_;
      value.n = val;
      isNumeric = true;
   }

   MOptionData(const char *name_, const char *val)
   {
      name = name_;
      value.s = val;
      isNumeric = false;
   }

   const char *name;

   union
   {
      long n;
      const char *s;
   } value;

   bool isNumeric;
};

// ----------------------------------------------------------------------------
// private functions
// ----------------------------------------------------------------------------

// generate a unique id for the next option
static inline int NewMOption()
{
   static size_t s_optionLast = 0;

   return s_optionLast++;
}

// ============================================================================
// data
// ============================================================================

// ----------------------------------------------------------------------------
// MOption values
// ----------------------------------------------------------------------------

const MOption MP_PROFILE_TYPE;
const MOption MP_VERSION;
const MOption MP_FIRSTRUN;
const MOption MP_RECORDDEFAULTS;
const MOption MP_EXPAND_ENV_VARS;
const MOption MP_XPOS;
const MOption MP_YPOS;
const MOption MP_WIDTH;
const MOption MP_HEIGHT;
const MOption MP_ICONISED;
const MOption MP_MAXIMISED;
const MOption MP_SHOWLOG;
const MOption MP_LOGFILE;
const MOption MP_DEBUG_CCLIENT;
const MOption MP_SHOWADBEDITOR;
const MOption MP_SHOWTIPS;
const MOption MP_LASTTIP;
const MOption MP_HELPBROWSER_KIND;
const MOption MP_HELPBROWSER;
const MOption MP_HELPBROWSER_ISNS;
const MOption MP_HELPFRAME_WIDTH;
const MOption MP_HELPFRAME_HEIGHT;
const MOption MP_HELPFRAME_XPOS;
const MOption MP_HELPFRAME_YPOS;
const MOption MP_MBOXDIR;
const MOption MP_NEWS_SPOOL_DIR;
const MOption MP_TIFF2PS;
const MOption MP_TMPGFXFORMAT;
const MOption MP_EXPAND_TREECTRL;
const MOption MP_FOCUS_FOLLOWSMOUSE;
const MOption MP_DOCKABLE_MENUBARS;
const MOption MP_DOCKABLE_TOOLBARS;
const MOption MP_FLAT_TOOLBARS;
const MOption MP_USERDIR;
const MOption MP_LICENSE_ACCEPTED;

const MOption MP_GLOBALDIR;
const MOption MP_RUNONEONLY;

const MOption MP_TBARIMAGES;

#ifdef OS_UNIX
const MOption MP_PATHLIST;
const MOption MP_ROOTDIRNAME;
const MOption MP_USER_MDIR;
const MOption MP_AFMPATH;
const MOption MP_ETCPATH;
const MOption MP_PREFIXPATH;
#endif // OS_UNIX

const MOption MP_HELPDIR;
const MOption MP_CRYPTALGO;
const MOption MP_CRYPT_TWOFISH_OK;
const MOption MP_CRYPT_TESTDATA;
const MOption MP_LOCALE;
const MOption MP_CHARSET;
const MOption MP_ICON_MFRAME;
const MOption MP_ICON_MAINFRAME;
const MOption MP_ICONPATH;
const MOption MP_PROFILE_PATH;
const MOption MP_PROFILE_EXTENSION;
const MOption MP_PROFILE_IDENTITY;
const MOption MP_MAILCAP;
const MOption MP_MIMETYPES;
const MOption MP_DATE_FMT;
const MOption MP_DATE_GMT;
const MOption MP_SHOWCONSOLE;
const MOption MP_DONTOPENSTARTUP;
const MOption MP_OPENFOLDERS;
const MOption MP_REOPENLASTFOLDER;
const MOption MP_MAINFOLDER;
const MOption MP_PYTHONPATH;
const MOption MP_USEPYTHON;
const MOption MP_STARTUPSCRIPT;
const MOption MP_SHOWSPLASH;
const MOption MP_SPLASHDELAY;
const MOption MP_AUTOSAVEDELAY;
const MOption MP_POLLINCOMINGDELAY;
const MOption MP_POLL_OPENED_ONLY;
const MOption MP_COLLECTATSTARTUP;
const MOption MP_CONFIRMEXIT;
const MOption MP_OPEN_ON_CLICK;
const MOption MP_SHOW_HIDDEN_FOLDERS;
const MOption MP_CREATE_PROFILES;
const MOption MP_UMASK;
const MOption MP_LASTSELECTED_MESSAGE;
const MOption MP_AUTOSHOW_LASTSELECTED;
const MOption MP_AUTOSHOW_FIRSTMESSAGE;
const MOption MP_AUTOSHOW_FIRSTUNREADMESSAGE;
const MOption MP_PREVIEW_ON_SELECT;
const MOption MP_AUTOSHOW_SELECT;
const MOption MP_CONVERTPROGRAM;
const MOption MP_MODULES;
const MOption MP_COMPOSETEMPLATEPATH_USER;
const MOption MP_COMPOSETEMPLATEPATH_GLOBAL;
const MOption MP_FOLDERSTATUS_TREE;
const MOption MP_FOLDERSTATUS_STATBAR;
const MOption MP_FOLDERSTATUS_TITLEBAR;
const MOption MP_PRINT_COMMAND;
const MOption MP_PRINT_OPTIONS;
const MOption MP_PRINT_ORIENTATION;
const MOption MP_PRINT_MODE;
const MOption MP_PRINT_PAPER;
const MOption MP_PRINT_FILE;
const MOption MP_PRINT_COLOUR;
const MOption MP_PRINT_TOPMARGIN_X;
const MOption MP_PRINT_TOPMARGIN_Y;
const MOption MP_PRINT_BOTTOMMARGIN_X;
const MOption MP_PRINT_BOTTOMMARGIN_Y;
const MOption MP_PRINT_PREVIEWZOOM;
const MOption MP_BBDB_GENERATEUNIQUENAMES;
const MOption MP_BBDB_IGNOREANONYMOUS;
const MOption MP_BBDB_ANONYMOUS;
const MOption MP_BBDB_SAVEONEXIT;
const MOption MP_PERSONALNAME;
const MOption MP_ORGANIZATION;
const MOption MP_CURRENT_IDENTITY;
const MOption MP_USERNAME;
const MOption MP_HOSTNAME;
const MOption MP_ADD_DEFAULT_HOSTNAME;
const MOption MP_FROM_ADDRESS;
const MOption MP_REPLY_ADDRESS;
const MOption MP_POPHOST;
const MOption MP_POP_NO_AUTH;
const MOption MP_IMAPHOST;
const MOption MP_USE_SSL;
const MOption MP_USE_SSL_UNSIGNED;
const MOption MP_SMTPHOST;
const MOption MP_GUESS_SENDER;
const MOption MP_SENDER;
const MOption MP_SMTPHOST_LOGIN;
const MOption MP_SMTPHOST_PASSWORD;
const MOption MP_SMTPHOST_USE_SSL;
const MOption MP_SMTPHOST_USE_SSL_UNSIGNED;
const MOption MP_SMTP_USE_8BIT;
const MOption MP_SMTP_DISABLED_AUTHS;

#ifdef OS_UNIX
const MOption MP_SENDMAILCMD;
const MOption MP_USE_SENDMAIL;
#endif // Unix

const MOption MP_NNTPHOST;
const MOption MP_NNTPHOST_LOGIN;
const MOption MP_NNTPHOST_PASSWORD;
const MOption MP_NNTPHOST_USE_SSL;
const MOption MP_NNTPHOST_USE_SSL_UNSIGNED;
const MOption MP_BEACONHOST;
const MOption MP_SET_REPLY_FROM_TO;
const MOption MP_USEVCARD;
const MOption MP_VCARD;

const MOption MP_USE_FOLDER_CREATE_WIZARD;

#ifdef USE_DIALUP

const MOption MP_DIALUP_SUPPORT;
#ifdef OS_WIN
const MOption MP_NET_CONNECTION;
#else // !Windows
const MOption MP_NET_ON_COMMAND;
const MOption MP_NET_OFF_COMMAND;
#endif // Windows/!Windows

#endif // USE_DIALUP

const MOption MP_FOLDER_LOGIN;
const MOption MP_FOLDER_PASSWORD;
const MOption MP_LOGLEVEL;
const MOption MP_SHOWBUSY_DURING_SORT;
const MOption MP_FOLDERPROGRESS_THRESHOLD;
const MOption MP_MESSAGEPROGRESS_THRESHOLD_SIZE;
const MOption MP_MESSAGEPROGRESS_THRESHOLD_TIME;
const MOption MP_DEFAULT_SAVE_PATH;
const MOption MP_DEFAULT_SAVE_FILENAME;
const MOption MP_DEFAULT_SAVE_EXTENSION;
const MOption MP_DEFAULT_LOAD_PATH;
const MOption MP_DEFAULT_LOAD_FILENAME;
const MOption MP_DEFAULT_LOAD_EXTENSION;
const MOption MP_COMPOSE_TO;
const MOption MP_COMPOSE_CC;
const MOption MP_COMPOSE_BCC;
const MOption MP_COMPOSE_SHOW_FROM;
const MOption MP_LIST_ADDRESSES;
const MOption MP_DEFAULT_REPLY_KIND;
const MOption MP_REPLY_PREFIX;
const MOption MP_FORWARD_PREFIX;
const MOption MP_REPLY_COLLAPSE_PREFIX;
const MOption MP_REPLY_QUOTE_ORIG;
const MOption MP_REPLY_QUOTE_SELECTION;
const MOption MP_REPLY_MSGPREFIX;
const MOption MP_REPLY_MSGPREFIX_FROM_SENDER;
const MOption MP_REPLY_QUOTE_EMPTY;
const MOption MP_REPLY_DETECT_SIG;
#if wxUSE_REGEX
const MOption MP_REPLY_SIG_SEPARATOR;
#endif // wxUSE_REGEX
const MOption MP_COMPOSE_USE_SIGNATURE;
const MOption MP_COMPOSE_SIGNATURE;
const MOption MP_COMPOSE_USE_SIGNATURE_SEPARATOR;
const MOption MP_COMPOSE_USE_XFACE;
const MOption MP_COMPOSE_XFACE_FILE;
const MOption MP_FOLDER_TYPE;
const MOption MP_FOLDER_TRY_CREATE;
const MOption MP_FOLDER_ICON;
const MOption MP_FOLDER_TREEINDEX;
const MOption MP_MOVE_NEWMAIL;
const MOption MP_NEWMAIL_FOLDER;
const MOption MP_OUTBOX_NAME;
const MOption MP_USE_OUTBOX;
const MOption MP_TRASH_FOLDER;
const MOption MP_USE_TRASH_FOLDER;
const MOption MP_DRAFTS_FOLDER;
const MOption MP_DRAFTS_AUTODELETE;
const MOption MP_FOLDER_PATH;
const MOption MP_FOLDER_COMMENT;
const MOption MP_UPDATEINTERVAL;
const MOption MP_FOLDER_CLOSE_DELAY;
const MOption MP_CONN_CLOSE_DELAY;
const MOption MP_AUTOMATIC_WORDWRAP;
const MOption MP_WRAPMARGIN;
const MOption MP_VIEW_AUTOMATIC_WORDWRAP;
const MOption MP_VIEW_WRAPMARGIN;
const MOption MP_PLAIN_IS_TEXT;
const MOption MP_RFC822_IS_TEXT;
const MOption MP_SHOW_XFACES;
const MOption MP_INLINE_GFX;
const MOption MP_INLINE_GFX_EXTERNAL;
const MOption MP_INLINE_GFX_SIZE;
const MOption MP_MSGVIEW_SHOWBAR;
const MOption MP_MSGVIEW_VIEWER;
const MOption MP_MSGVIEW_HEADERS;
const MOption MP_MSGVIEW_ALL_HEADERS;
const MOption MP_MSGVIEW_AUTO_ENCODING;
const MOption MP_MSGVIEW_DEFAULT_ENCODING;
const MOption MP_LAST_CREATED_FOLDER_TYPE;
const MOption MP_FILTER_RULE;
const MOption MP_FOLDER_FILTERS;
const MOption MP_FOLDER_FILE_DRIVER;

const MOption MP_MVIEW_TITLE_FMT;
const MOption MP_MVIEW_FONT;
const MOption MP_MVIEW_FONT_DESC;
const MOption MP_MVIEW_FONT_SIZE;
const MOption MP_MVIEW_FGCOLOUR;
const MOption MP_MVIEW_BGCOLOUR;
const MOption MP_MVIEW_SIGCOLOUR;
const MOption MP_MVIEW_URLCOLOUR;
const MOption MP_MVIEW_ATTCOLOUR;
const MOption MP_MVIEW_QUOTED_COLOURIZE;
const MOption MP_MVIEW_QUOTED_CYCLE_COLOURS;
const MOption MP_MVIEW_QUOTED_COLOUR1;
const MOption MP_MVIEW_QUOTED_COLOUR2;
const MOption MP_MVIEW_QUOTED_COLOUR3;
const MOption MP_MVIEW_QUOTED_MAXWHITESPACE;
const MOption MP_MVIEW_QUOTED_MAXALPHA;
const MOption MP_MVIEW_HEADER_NAMES_COLOUR;
const MOption MP_MVIEW_HEADER_VALUES_COLOUR;
const MOption MP_HIGHLIGHT_SIGNATURE;
const MOption MP_HIGHLIGHT_URLS;

const MOption MP_FVIEW_FONT;
const MOption MP_FVIEW_FONT_DESC;
const MOption MP_FVIEW_FONT_SIZE;
const MOption MP_FVIEW_NAMES_ONLY;
const MOption MP_FVIEW_FGCOLOUR;
const MOption MP_FVIEW_BGCOLOUR;
const MOption MP_FVIEW_DELETEDCOLOUR;
const MOption MP_FVIEW_NEWCOLOUR;
const MOption MP_FVIEW_RECENTCOLOUR;
const MOption MP_FVIEW_UNREADCOLOUR;
const MOption MP_FVIEW_FLAGGEDCOLOUR;
const MOption MP_FVIEW_AUTONEXT_UNREAD_MSG;
const MOption MP_FVIEW_AUTONEXT_UNREAD_FOLDER;
const MOption MP_FVIEW_SIZE_FORMAT;
const MOption MP_FVIEW_STATUS_UPDATE;
const MOption MP_FVIEW_STATUS_FMT;
const MOption MP_FVIEW_PREVIEW_DELAY;

const MOption MP_FTREE_FGCOLOUR;
const MOption MP_FTREE_BGCOLOUR;
const MOption MP_FTREE_FORMAT;
const MOption MP_FTREE_PROPAGATE;
const MOption MP_FTREE_NEVER_UNREAD;
const MOption MP_FTREE_HOME;

const MOption MP_CVIEW_FONT;
const MOption MP_CVIEW_FONT_DESC;
const MOption MP_CVIEW_FONT_SIZE;
const MOption MP_CVIEW_FGCOLOUR;
const MOption MP_CVIEW_BGCOLOUR;
const MOption MP_CVIEW_COLOUR_HEADERS;

const MOption MP_MSGS_SERVER_SORT;
const MOption MP_MSGS_SORTBY;
const MOption MP_MSGS_RESORT_ON_CHANGE;

const MOption MP_MSGS_USE_THREADING;
const MOption MP_MSGS_SERVER_THREAD;
const MOption MP_MSGS_SERVER_THREAD_REF_ONLY;

const MOption MP_MSGS_GATHER_SUBJECTS;
const MOption MP_MSGS_BREAK_THREAD;
const MOption MP_MSGS_INDENT_IF_DUMMY;

#if wxUSE_REGEX
const MOption MP_MSGS_SIMPLIFYING_REGEX;
const MOption MP_MSGS_REPLACEMENT_STRING;
#else // !regex
const MOption MP_MSGS_REMOVE_LIST_PREFIX_GATHERING;
const MOption MP_MSGS_REMOVE_LIST_PREFIX_BREAKING;
#endif // regex/!regex

const MOption MP_MSGS_SEARCH_CRIT;
const MOption MP_MSGS_SEARCH_ARG;
const MOption MP_BROWSER;
const MOption MP_BROWSER_ISNS;
const MOption MP_BROWSER_INNW;
const MOption MP_EXTERNALEDITOR;
const MOption MP_ALWAYS_USE_EXTERNALEDITOR;
const MOption MP_PGP_COMMAND;
const MOption MP_PGP_KEYSERVER;
const MOption MP_PGP_GET_PUBKEY;
const MOption MP_USE_NEWMAILCOMMAND;
const MOption MP_NEWMAILCOMMAND;
const MOption MP_NEWMAIL_PLAY_SOUND;
const MOption MP_NEWMAIL_SOUND_FILE;
#if defined(OS_UNIX) || defined(__CYGWIN__)
const MOption MP_NEWMAIL_SOUND_PROGRAM;
#endif // OS_UNIX
const MOption MP_SHOW_NEWMAILMSG;
const MOption MP_SHOW_NEWMAILINFO;
const MOption MP_NEWMAIL_UNSEEN;
const MOption MP_COLLECT_INBOX;
const MOption MP_USEOUTGOINGFOLDER;
const MOption MP_OUTGOINGFOLDER;
const MOption MP_SHOWHEADERS;

const MOption MP_AUTOCOLLECT;
const MOption MP_AUTOCOLLECT_ADB;
const MOption MP_AUTOCOLLECT_SENDER;
const MOption MP_AUTOCOLLECT_NAMED;

const MOption MP_SSL_DLL_SSL;
const MOption MP_SSL_DLL_CRYPTO;
const MOption MP_INCFAX_SUPPORT;
const MOption MP_INCFAX_DOMAINS;
const MOption MP_ADB_SUBSTRINGEXPANSION;
const MOption MP_FVIEW_FROM_REPLACE;
const MOption MP_FROM_REPLACE_ADDRESSES;
const MOption MP_MAX_MESSAGE_SIZE;
const MOption MP_MAX_HEADERS_NUM;
const MOption MP_MAX_HEADERS_NUM_HARD;
const MOption MP_SAFE_FILTERS;

const MOption MP_IMAP_LOOKAHEAD;
const MOption MP_TCP_OPENTIMEOUT;
const MOption MP_TCP_READTIMEOUT;
const MOption MP_TCP_WRITETIMEOUT;
const MOption MP_TCP_CLOSETIMEOUT;
const MOption MP_TCP_RSHTIMEOUT;
const MOption MP_TCP_SSHTIMEOUT;
const MOption MP_RSH_PATH;
const MOption MP_SSH_PATH;

const MOption MP_FLC_STATUSWIDTH;
const MOption MP_FLC_SUBJECTWIDTH;
const MOption MP_FLC_FROMWIDTH;
const MOption MP_FLC_DATEWIDTH;
const MOption MP_FLC_SIZEWIDTH;
const MOption MP_FLC_STATUSCOL;
const MOption MP_FLC_SUBJECTCOL;
const MOption MP_FLC_FROMCOL;
const MOption MP_FLC_DATECOL;
const MOption MP_FLC_SIZECOL;
const MOption MP_FLC_MSGNOCOL;
const MOption MP_TESTENTRY;
const MOption MP_SYNC_REMOTE;
const MOption MP_SYNC_FOLDER;
const MOption MP_SYNC_DATE;
const MOption MP_SYNC_FILTERS;
const MOption MP_SYNC_IDS;
const MOption MP_SYNC_FOLDERS;
const MOption MP_SYNC_FOLDERGROUP;
const MOption MP_CONFIRM_SEND;
const MOption MP_PREVIEW_SEND;
const MOption MP_AWAY_AUTO_ENTER;
const MOption MP_AWAY_AUTO_EXIT;
const MOption MP_AWAY_REMEMBER;
const MOption MP_AWAY_STATUS;
const MOption MP_CREATE_INTERNAL_MESSAGE;

// ----------------------------------------------------------------------------
// defaults
// ----------------------------------------------------------------------------

#define DEFINE_OPTION(opt) MOptionData(opt##_NAME, opt##_DEFVAL)

// this array *MUST* be ordered according to MOption declarations above!
static const MOptionData MOptions[] =
{
    DEFINE_OPTION(MP_PROFILE_TYPE),
    DEFINE_OPTION(MP_VERSION),
    DEFINE_OPTION(MP_FIRSTRUN),
    DEFINE_OPTION(MP_RECORDDEFAULTS),
    DEFINE_OPTION(MP_EXPAND_ENV_VARS),
    DEFINE_OPTION(MP_XPOS),
    DEFINE_OPTION(MP_YPOS),
    DEFINE_OPTION(MP_WIDTH),
    DEFINE_OPTION(MP_HEIGHT),
    DEFINE_OPTION(MP_ICONISED),
    DEFINE_OPTION(MP_MAXIMISED),
    DEFINE_OPTION(MP_SHOWLOG),
    DEFINE_OPTION(MP_LOGFILE),
    DEFINE_OPTION(MP_DEBUG_CCLIENT),
    DEFINE_OPTION(MP_SHOWADBEDITOR),
    DEFINE_OPTION(MP_SHOWTIPS),
    DEFINE_OPTION(MP_LASTTIP),
    DEFINE_OPTION(MP_HELPBROWSER_KIND),
    DEFINE_OPTION(MP_HELPBROWSER),
    DEFINE_OPTION(MP_HELPBROWSER_ISNS),
    DEFINE_OPTION(MP_HELPFRAME_WIDTH),
    DEFINE_OPTION(MP_HELPFRAME_HEIGHT),
    DEFINE_OPTION(MP_HELPFRAME_XPOS),
    DEFINE_OPTION(MP_HELPFRAME_YPOS),
    DEFINE_OPTION(MP_MBOXDIR),
    DEFINE_OPTION(MP_NEWS_SPOOL_DIR),
    DEFINE_OPTION(MP_TIFF2PS),
    DEFINE_OPTION(MP_TMPGFXFORMAT),
    DEFINE_OPTION(MP_EXPAND_TREECTRL),
    DEFINE_OPTION(MP_FOCUS_FOLLOWSMOUSE),
    DEFINE_OPTION(MP_DOCKABLE_MENUBARS),
    DEFINE_OPTION(MP_DOCKABLE_TOOLBARS),
    DEFINE_OPTION(MP_FLAT_TOOLBARS),
    DEFINE_OPTION(MP_USERDIR),
    DEFINE_OPTION(MP_LICENSE_ACCEPTED),

    DEFINE_OPTION(MP_GLOBALDIR),
    DEFINE_OPTION(MP_RUNONEONLY),

    DEFINE_OPTION(MP_TBARIMAGES),

#ifdef OS_UNIX
    DEFINE_OPTION(MP_PATHLIST),
    DEFINE_OPTION(MP_ROOTDIRNAME),
    DEFINE_OPTION(MP_USER_MDIR),
    DEFINE_OPTION(MP_AFMPATH),
    DEFINE_OPTION(MP_ETCPATH),
    DEFINE_OPTION(MP_PREFIXPATH),
#endif // OS_UNIX

    DEFINE_OPTION(MP_HELPDIR),
    DEFINE_OPTION(MP_CRYPTALGO),
    DEFINE_OPTION(MP_CRYPT_TWOFISH_OK),
    DEFINE_OPTION(MP_CRYPT_TESTDATA),
    DEFINE_OPTION(MP_LOCALE),
    DEFINE_OPTION(MP_CHARSET),
    DEFINE_OPTION(MP_ICON_MFRAME),
    DEFINE_OPTION(MP_ICON_MAINFRAME),
    DEFINE_OPTION(MP_ICONPATH),
    DEFINE_OPTION(MP_PROFILE_PATH),
    DEFINE_OPTION(MP_PROFILE_EXTENSION),
    DEFINE_OPTION(MP_PROFILE_IDENTITY),
    DEFINE_OPTION(MP_MAILCAP),
    DEFINE_OPTION(MP_MIMETYPES),
    DEFINE_OPTION(MP_DATE_FMT),
    DEFINE_OPTION(MP_DATE_GMT),
    DEFINE_OPTION(MP_SHOWCONSOLE),
    DEFINE_OPTION(MP_DONTOPENSTARTUP),
    DEFINE_OPTION(MP_OPENFOLDERS),
    DEFINE_OPTION(MP_REOPENLASTFOLDER),
    DEFINE_OPTION(MP_MAINFOLDER),
    DEFINE_OPTION(MP_PYTHONPATH),
    DEFINE_OPTION(MP_USEPYTHON),
    DEFINE_OPTION(MP_STARTUPSCRIPT),
    DEFINE_OPTION(MP_SHOWSPLASH),
    DEFINE_OPTION(MP_SPLASHDELAY),
    DEFINE_OPTION(MP_AUTOSAVEDELAY),
    DEFINE_OPTION(MP_POLLINCOMINGDELAY),
    DEFINE_OPTION(MP_POLL_OPENED_ONLY),
    DEFINE_OPTION(MP_COLLECTATSTARTUP),
    DEFINE_OPTION(MP_CONFIRMEXIT),
    DEFINE_OPTION(MP_OPEN_ON_CLICK),
    DEFINE_OPTION(MP_SHOW_HIDDEN_FOLDERS),
    DEFINE_OPTION(MP_CREATE_PROFILES),
    DEFINE_OPTION(MP_UMASK),
    DEFINE_OPTION(MP_LASTSELECTED_MESSAGE),
    DEFINE_OPTION(MP_AUTOSHOW_LASTSELECTED),
    DEFINE_OPTION(MP_AUTOSHOW_FIRSTMESSAGE),
    DEFINE_OPTION(MP_AUTOSHOW_FIRSTUNREADMESSAGE),
    DEFINE_OPTION(MP_PREVIEW_ON_SELECT),
    DEFINE_OPTION(MP_AUTOSHOW_SELECT),
    DEFINE_OPTION(MP_CONVERTPROGRAM),
    DEFINE_OPTION(MP_MODULES),
    DEFINE_OPTION(MP_COMPOSETEMPLATEPATH_USER),
    DEFINE_OPTION(MP_COMPOSETEMPLATEPATH_GLOBAL),
    DEFINE_OPTION(MP_FOLDERSTATUS_TREE),
    DEFINE_OPTION(MP_FOLDERSTATUS_STATBAR),
    DEFINE_OPTION(MP_FOLDERSTATUS_TITLEBAR),
    DEFINE_OPTION(MP_PRINT_COMMAND),
    DEFINE_OPTION(MP_PRINT_OPTIONS),
    DEFINE_OPTION(MP_PRINT_ORIENTATION),
    DEFINE_OPTION(MP_PRINT_MODE),
    DEFINE_OPTION(MP_PRINT_PAPER),
    DEFINE_OPTION(MP_PRINT_FILE),
    DEFINE_OPTION(MP_PRINT_COLOUR),
    DEFINE_OPTION(MP_PRINT_TOPMARGIN_X),
    DEFINE_OPTION(MP_PRINT_TOPMARGIN_Y),
    DEFINE_OPTION(MP_PRINT_BOTTOMMARGIN_X),
    DEFINE_OPTION(MP_PRINT_BOTTOMMARGIN_Y),
    DEFINE_OPTION(MP_PRINT_PREVIEWZOOM),
    DEFINE_OPTION(MP_BBDB_GENERATEUNIQUENAMES),
    DEFINE_OPTION(MP_BBDB_IGNOREANONYMOUS),
    DEFINE_OPTION(MP_BBDB_ANONYMOUS),
    DEFINE_OPTION(MP_BBDB_SAVEONEXIT),
    DEFINE_OPTION(MP_PERSONALNAME),
    DEFINE_OPTION(MP_ORGANIZATION),
    DEFINE_OPTION(MP_CURRENT_IDENTITY),
    DEFINE_OPTION(MP_USERNAME),
    DEFINE_OPTION(MP_HOSTNAME),
    DEFINE_OPTION(MP_ADD_DEFAULT_HOSTNAME),
    DEFINE_OPTION(MP_FROM_ADDRESS),
    DEFINE_OPTION(MP_REPLY_ADDRESS),
    DEFINE_OPTION(MP_POPHOST),
    DEFINE_OPTION(MP_POP_NO_AUTH),
    DEFINE_OPTION(MP_IMAPHOST),
    DEFINE_OPTION(MP_USE_SSL),
    DEFINE_OPTION(MP_USE_SSL_UNSIGNED),
    DEFINE_OPTION(MP_SMTPHOST),
    DEFINE_OPTION(MP_GUESS_SENDER),
    DEFINE_OPTION(MP_SENDER),
    DEFINE_OPTION(MP_SMTPHOST_LOGIN),
    DEFINE_OPTION(MP_SMTPHOST_PASSWORD),
    DEFINE_OPTION(MP_SMTPHOST_USE_SSL),
    DEFINE_OPTION(MP_SMTPHOST_USE_SSL_UNSIGNED),
    DEFINE_OPTION(MP_SMTP_USE_8BIT),
    DEFINE_OPTION(MP_SMTP_DISABLED_AUTHS),

#ifdef OS_UNIX
    DEFINE_OPTION(MP_SENDMAILCMD),
    DEFINE_OPTION(MP_USE_SENDMAIL),
#endif // Unix

    DEFINE_OPTION(MP_NNTPHOST),
    DEFINE_OPTION(MP_NNTPHOST_LOGIN),
    DEFINE_OPTION(MP_NNTPHOST_PASSWORD),
    DEFINE_OPTION(MP_NNTPHOST_USE_SSL),
    DEFINE_OPTION(MP_NNTPHOST_USE_SSL_UNSIGNED),
    DEFINE_OPTION(MP_BEACONHOST),
    DEFINE_OPTION(MP_SET_REPLY_FROM_TO),
    DEFINE_OPTION(MP_USEVCARD),
    DEFINE_OPTION(MP_VCARD),

    DEFINE_OPTION(MP_USE_FOLDER_CREATE_WIZARD),

#ifdef USE_DIALUP
    DEFINE_OPTION(MP_DIALUP_SUPPORT),
#if defined(OS_WIN)
    DEFINE_OPTION(MP_NET_CONNECTION),
#elif defined(OS_UNIX)
    DEFINE_OPTION(MP_NET_ON_COMMAND),
    DEFINE_OPTION(MP_NET_OFF_COMMAND),
#endif
#endif // USE_DIALUP

    DEFINE_OPTION(MP_FOLDER_LOGIN),
    DEFINE_OPTION(MP_FOLDER_PASSWORD),
    DEFINE_OPTION(MP_LOGLEVEL),
    DEFINE_OPTION(MP_SHOWBUSY_DURING_SORT),
    DEFINE_OPTION(MP_FOLDERPROGRESS_THRESHOLD),
    DEFINE_OPTION(MP_MESSAGEPROGRESS_THRESHOLD_SIZE),
    DEFINE_OPTION(MP_MESSAGEPROGRESS_THRESHOLD_TIME),
    DEFINE_OPTION(MP_DEFAULT_SAVE_PATH),
    DEFINE_OPTION(MP_DEFAULT_SAVE_FILENAME),
    DEFINE_OPTION(MP_DEFAULT_SAVE_EXTENSION),
    DEFINE_OPTION(MP_DEFAULT_LOAD_PATH),
    DEFINE_OPTION(MP_DEFAULT_LOAD_FILENAME),
    DEFINE_OPTION(MP_DEFAULT_LOAD_EXTENSION),
    DEFINE_OPTION(MP_COMPOSE_TO),
    DEFINE_OPTION(MP_COMPOSE_CC),
    DEFINE_OPTION(MP_COMPOSE_BCC),
    DEFINE_OPTION(MP_COMPOSE_SHOW_FROM),
    DEFINE_OPTION(MP_LIST_ADDRESSES),
    DEFINE_OPTION(MP_DEFAULT_REPLY_KIND),
    DEFINE_OPTION(MP_REPLY_PREFIX),
    DEFINE_OPTION(MP_FORWARD_PREFIX),
    DEFINE_OPTION(MP_REPLY_COLLAPSE_PREFIX),
    DEFINE_OPTION(MP_REPLY_QUOTE_ORIG),
    DEFINE_OPTION(MP_REPLY_QUOTE_SELECTION),
    DEFINE_OPTION(MP_REPLY_MSGPREFIX),
    DEFINE_OPTION(MP_REPLY_MSGPREFIX_FROM_SENDER),
    DEFINE_OPTION(MP_REPLY_QUOTE_EMPTY),
    DEFINE_OPTION(MP_REPLY_DETECT_SIG),
#if wxUSE_REGEX
    DEFINE_OPTION(MP_REPLY_SIG_SEPARATOR),
#endif // wxUSE_REGEX
    DEFINE_OPTION(MP_COMPOSE_USE_SIGNATURE),
    DEFINE_OPTION(MP_COMPOSE_SIGNATURE),
    DEFINE_OPTION(MP_COMPOSE_USE_SIGNATURE_SEPARATOR),
    DEFINE_OPTION(MP_COMPOSE_USE_XFACE),
    DEFINE_OPTION(MP_COMPOSE_XFACE_FILE),
    DEFINE_OPTION(MP_FOLDER_TYPE),
    DEFINE_OPTION(MP_FOLDER_TRY_CREATE),
    DEFINE_OPTION(MP_FOLDER_ICON),
    DEFINE_OPTION(MP_FOLDER_TREEINDEX),
    DEFINE_OPTION(MP_MOVE_NEWMAIL),
    DEFINE_OPTION(MP_NEWMAIL_FOLDER),
    DEFINE_OPTION(MP_OUTBOX_NAME),
    DEFINE_OPTION(MP_USE_OUTBOX),
    DEFINE_OPTION(MP_TRASH_FOLDER),
    DEFINE_OPTION(MP_USE_TRASH_FOLDER),
    DEFINE_OPTION(MP_DRAFTS_FOLDER),
    DEFINE_OPTION(MP_DRAFTS_AUTODELETE),
    DEFINE_OPTION(MP_FOLDER_PATH),
    DEFINE_OPTION(MP_FOLDER_COMMENT),
    DEFINE_OPTION(MP_UPDATEINTERVAL),
    DEFINE_OPTION(MP_FOLDER_CLOSE_DELAY),
    DEFINE_OPTION(MP_CONN_CLOSE_DELAY),
    DEFINE_OPTION(MP_AUTOMATIC_WORDWRAP),
    DEFINE_OPTION(MP_WRAPMARGIN),
    DEFINE_OPTION(MP_VIEW_AUTOMATIC_WORDWRAP),
    DEFINE_OPTION(MP_VIEW_WRAPMARGIN),
    DEFINE_OPTION(MP_PLAIN_IS_TEXT),
    DEFINE_OPTION(MP_RFC822_IS_TEXT),
    DEFINE_OPTION(MP_SHOW_XFACES),
    DEFINE_OPTION(MP_INLINE_GFX),
    DEFINE_OPTION(MP_INLINE_GFX_EXTERNAL),
    DEFINE_OPTION(MP_INLINE_GFX_SIZE),
    DEFINE_OPTION(MP_MSGVIEW_SHOWBAR),
    DEFINE_OPTION(MP_MSGVIEW_VIEWER),
    DEFINE_OPTION(MP_MSGVIEW_HEADERS),
    DEFINE_OPTION(MP_MSGVIEW_ALL_HEADERS),
    DEFINE_OPTION(MP_MSGVIEW_AUTO_ENCODING),
    DEFINE_OPTION(MP_MSGVIEW_DEFAULT_ENCODING),
    DEFINE_OPTION(MP_LAST_CREATED_FOLDER_TYPE),
    DEFINE_OPTION(MP_FILTER_RULE),
    DEFINE_OPTION(MP_FOLDER_FILTERS),
    DEFINE_OPTION(MP_FOLDER_FILE_DRIVER),

    DEFINE_OPTION(MP_MVIEW_TITLE_FMT),
    DEFINE_OPTION(MP_MVIEW_FONT),
    DEFINE_OPTION(MP_MVIEW_FONT_DESC),
    DEFINE_OPTION(MP_MVIEW_FONT_SIZE),
    DEFINE_OPTION(MP_MVIEW_FGCOLOUR),
    DEFINE_OPTION(MP_MVIEW_BGCOLOUR),
    DEFINE_OPTION(MP_MVIEW_SIGCOLOUR),
    DEFINE_OPTION(MP_MVIEW_URLCOLOUR),
    DEFINE_OPTION(MP_MVIEW_ATTCOLOUR),
    DEFINE_OPTION(MP_MVIEW_QUOTED_COLOURIZE),
    DEFINE_OPTION(MP_MVIEW_QUOTED_CYCLE_COLOURS),
    DEFINE_OPTION(MP_MVIEW_QUOTED_COLOUR1),
    DEFINE_OPTION(MP_MVIEW_QUOTED_COLOUR2),
    DEFINE_OPTION(MP_MVIEW_QUOTED_COLOUR3),
    DEFINE_OPTION(MP_MVIEW_QUOTED_MAXWHITESPACE),
    DEFINE_OPTION(MP_MVIEW_QUOTED_MAXALPHA),
    DEFINE_OPTION(MP_MVIEW_HEADER_NAMES_COLOUR),
    DEFINE_OPTION(MP_MVIEW_HEADER_VALUES_COLOUR),
    DEFINE_OPTION(MP_HIGHLIGHT_SIGNATURE),
    DEFINE_OPTION(MP_HIGHLIGHT_URLS),

    DEFINE_OPTION(MP_FVIEW_FONT),
    DEFINE_OPTION(MP_FVIEW_FONT_DESC),
    DEFINE_OPTION(MP_FVIEW_FONT_SIZE),
    DEFINE_OPTION(MP_FVIEW_NAMES_ONLY),
    DEFINE_OPTION(MP_FVIEW_FGCOLOUR),
    DEFINE_OPTION(MP_FVIEW_BGCOLOUR),
    DEFINE_OPTION(MP_FVIEW_DELETEDCOLOUR),
    DEFINE_OPTION(MP_FVIEW_NEWCOLOUR),
    DEFINE_OPTION(MP_FVIEW_RECENTCOLOUR),
    DEFINE_OPTION(MP_FVIEW_UNREADCOLOUR),
    DEFINE_OPTION(MP_FVIEW_FLAGGEDCOLOUR),
    DEFINE_OPTION(MP_FVIEW_AUTONEXT_UNREAD_MSG),
    DEFINE_OPTION(MP_FVIEW_AUTONEXT_UNREAD_FOLDER),
    DEFINE_OPTION(MP_FVIEW_SIZE_FORMAT),
    DEFINE_OPTION(MP_FVIEW_STATUS_UPDATE),
    DEFINE_OPTION(MP_FVIEW_STATUS_FMT),
    DEFINE_OPTION(MP_FVIEW_PREVIEW_DELAY),

    DEFINE_OPTION(MP_FTREE_FGCOLOUR),
    DEFINE_OPTION(MP_FTREE_BGCOLOUR),
    DEFINE_OPTION(MP_FTREE_FORMAT),
    DEFINE_OPTION(MP_FTREE_PROPAGATE),
    DEFINE_OPTION(MP_FTREE_NEVER_UNREAD),
    DEFINE_OPTION(MP_FTREE_HOME),

    DEFINE_OPTION(MP_CVIEW_FONT),
    DEFINE_OPTION(MP_CVIEW_FONT_DESC),
    DEFINE_OPTION(MP_CVIEW_FONT_SIZE),
    DEFINE_OPTION(MP_CVIEW_FGCOLOUR),
    DEFINE_OPTION(MP_CVIEW_BGCOLOUR),
    DEFINE_OPTION(MP_CVIEW_COLOUR_HEADERS),

    DEFINE_OPTION(MP_MSGS_SERVER_SORT),
    DEFINE_OPTION(MP_MSGS_SORTBY),
    DEFINE_OPTION(MP_MSGS_RESORT_ON_CHANGE),

    DEFINE_OPTION(MP_MSGS_USE_THREADING),
    DEFINE_OPTION(MP_MSGS_SERVER_THREAD),
    DEFINE_OPTION(MP_MSGS_SERVER_THREAD_REF_ONLY),

    DEFINE_OPTION(MP_MSGS_GATHER_SUBJECTS),
    DEFINE_OPTION(MP_MSGS_BREAK_THREAD),
    DEFINE_OPTION(MP_MSGS_INDENT_IF_DUMMY),

#if wxUSE_REGEX
    DEFINE_OPTION(MP_MSGS_SIMPLIFYING_REGEX),
    DEFINE_OPTION(MP_MSGS_REPLACEMENT_STRING),
#else // !regex
    DEFINE_OPTION(MP_MSGS_REMOVE_LIST_PREFIX_GATHERING),
    DEFINE_OPTION(MP_MSGS_REMOVE_LIST_PREFIX_BREAKING),
#endif // regex/!regex

    DEFINE_OPTION(MP_MSGS_SEARCH_CRIT),
    DEFINE_OPTION(MP_MSGS_SEARCH_ARG),
    DEFINE_OPTION(MP_BROWSER),
    DEFINE_OPTION(MP_BROWSER_ISNS),
    DEFINE_OPTION(MP_BROWSER_INNW),
    DEFINE_OPTION(MP_EXTERNALEDITOR),
    DEFINE_OPTION(MP_ALWAYS_USE_EXTERNALEDITOR),
    DEFINE_OPTION(MP_PGP_COMMAND),
    DEFINE_OPTION(MP_PGP_KEYSERVER),
    DEFINE_OPTION(MP_PGP_GET_PUBKEY),
    DEFINE_OPTION(MP_USE_NEWMAILCOMMAND),
    DEFINE_OPTION(MP_NEWMAILCOMMAND),
    DEFINE_OPTION(MP_NEWMAIL_PLAY_SOUND),
    DEFINE_OPTION(MP_NEWMAIL_SOUND_FILE),
#if defined(OS_UNIX) || defined(__CYGWIN__)
    DEFINE_OPTION(MP_NEWMAIL_SOUND_PROGRAM),
#endif // OS_UNIX
    DEFINE_OPTION(MP_SHOW_NEWMAILMSG),
    DEFINE_OPTION(MP_SHOW_NEWMAILINFO),
    DEFINE_OPTION(MP_NEWMAIL_UNSEEN),
    DEFINE_OPTION(MP_COLLECT_INBOX),
    DEFINE_OPTION(MP_USEOUTGOINGFOLDER),
    DEFINE_OPTION(MP_OUTGOINGFOLDER),
    DEFINE_OPTION(MP_SHOWHEADERS),
    DEFINE_OPTION(MP_AUTOCOLLECT),
    DEFINE_OPTION(MP_AUTOCOLLECT_ADB),
    DEFINE_OPTION(MP_AUTOCOLLECT_SENDER),
    DEFINE_OPTION(MP_AUTOCOLLECT_NAMED),
    DEFINE_OPTION(MP_SSL_DLL_SSL),
    DEFINE_OPTION(MP_SSL_DLL_CRYPTO),
    DEFINE_OPTION(MP_INCFAX_SUPPORT),
    DEFINE_OPTION(MP_INCFAX_DOMAINS),
    DEFINE_OPTION(MP_ADB_SUBSTRINGEXPANSION),
    DEFINE_OPTION(MP_FVIEW_FROM_REPLACE),
    DEFINE_OPTION(MP_FROM_REPLACE_ADDRESSES),
    DEFINE_OPTION(MP_MAX_MESSAGE_SIZE),
    DEFINE_OPTION(MP_MAX_HEADERS_NUM),
    DEFINE_OPTION(MP_MAX_HEADERS_NUM_HARD),
    DEFINE_OPTION(MP_SAFE_FILTERS),
    DEFINE_OPTION(MP_IMAP_LOOKAHEAD),
    DEFINE_OPTION(MP_TCP_OPENTIMEOUT),
    DEFINE_OPTION(MP_TCP_READTIMEOUT),
    DEFINE_OPTION(MP_TCP_WRITETIMEOUT),
    DEFINE_OPTION(MP_TCP_CLOSETIMEOUT),
    DEFINE_OPTION(MP_TCP_RSHTIMEOUT),
    DEFINE_OPTION(MP_TCP_SSHTIMEOUT),
    DEFINE_OPTION(MP_RSH_PATH),
    DEFINE_OPTION(MP_SSH_PATH),
    DEFINE_OPTION(MP_FLC_STATUSWIDTH),
    DEFINE_OPTION(MP_FLC_SUBJECTWIDTH),
    DEFINE_OPTION(MP_FLC_FROMWIDTH),
    DEFINE_OPTION(MP_FLC_DATEWIDTH),
    DEFINE_OPTION(MP_FLC_SIZEWIDTH),
    DEFINE_OPTION(MP_FLC_STATUSCOL),
    DEFINE_OPTION(MP_FLC_SUBJECTCOL),
    DEFINE_OPTION(MP_FLC_FROMCOL),
    DEFINE_OPTION(MP_FLC_DATECOL),
    DEFINE_OPTION(MP_FLC_SIZECOL),
    DEFINE_OPTION(MP_FLC_MSGNOCOL),
    DEFINE_OPTION(MP_TESTENTRY),
    DEFINE_OPTION(MP_SYNC_REMOTE),
    DEFINE_OPTION(MP_SYNC_FOLDER),
    DEFINE_OPTION(MP_SYNC_DATE),
    DEFINE_OPTION(MP_SYNC_FILTERS),
    DEFINE_OPTION(MP_SYNC_IDS),
    DEFINE_OPTION(MP_SYNC_FOLDERS),
    DEFINE_OPTION(MP_SYNC_FOLDERGROUP),
    DEFINE_OPTION(MP_CONFIRM_SEND),
    DEFINE_OPTION(MP_PREVIEW_SEND),
    DEFINE_OPTION(MP_AWAY_AUTO_ENTER),
    DEFINE_OPTION(MP_AWAY_AUTO_EXIT),
    DEFINE_OPTION(MP_AWAY_REMEMBER),
    DEFINE_OPTION(MP_AWAY_STATUS),
    DEFINE_OPTION(MP_CREATE_INTERNAL_MESSAGE),
};

// ============================================================================
// implementation
// ============================================================================

// ----------------------------------------------------------------------------
// MOption
// ----------------------------------------------------------------------------

MOption::MOption()
{
   m_id = NewMOption();
}

// ----------------------------------------------------------------------------
// global functions
// ----------------------------------------------------------------------------

extern MOptionValue GetOptionValue(Profile *profile, const MOption opt)
{
   MOptionValue value;
   const char *name = GetOptionName(opt);
   if ( IsNumeric(opt) )
      value.Set(profile->readEntry(name, GetNumericDefault(opt)));
   else
      value.Set(profile->readEntry(name, GetStringDefault(opt)));

   return value;
}

extern long GetNumericOptionValue(Profile *profile, const MOption opt)
{
   const MOptionData& optdata = MOptions[opt.GetId()];

   return profile->readEntry(optdata.name, optdata.value.n);
}

extern const char *GetOptionName(const MOption opt)
{
   ASSERT_MSG( (size_t)opt.GetId() < WXSIZEOF(MOptions),
               _T("invalid option index!") );

   return MOptions[opt.GetId()].name;
}

extern bool IsNumeric(const MOption opt)
{
   return MOptions[opt.GetId()].isNumeric;
}

extern long GetNumericDefault(const MOption opt)
{
   return MOptions[opt.GetId()].value.n;
}

extern const char *GetStringDefault(const MOption opt)
{
   return MOptions[opt.GetId()].value.s;
}

extern int GetFontFamilyFromProfile(Profile *profile, const MOption option)
{
   static const int fontFamilies[] =
   {
      wxDEFAULT,
      wxDECORATIVE,
      wxROMAN,
      wxSCRIPT,
      wxSWISS,
      wxMODERN,
      wxTELETYPE
   };

   int font = GetOptionValue(profile, option);
   if ( font < 0 || (size_t)font > WXSIZEOF(fontFamilies) )
   {
      wxFAIL_MSG( _T("bad font setting in config") );

      font = 0;
   }

   return fontFamilies[font];
}

