///////////////////////////////////////////////////////////////////////////////
// Project:     M - cross platform e-mail GUI client
// File name:   mail/LogCircle.cpp
// Purpose:     implements MLogCircle class
// Author:      Vadim Zeitlin
// Modified by:
// Created:     04.07.02 (extracted from MailFolder.cpp)
// CVS-ID:      $Id: LogCircle.cpp,v 1.2 2002/09/12 02:36:50 nerijus Exp $
// Copyright:   (c) 2002 Vadim Zeitlin <vadim@wxwindows.org>
// Licence:     M license
///////////////////////////////////////////////////////////////////////////////

#ifdef __GNUG__
   #pragma implementation "LogCircle.h"
#endif

#include "Mpch.h"

#ifndef USE_PCH
   #include "Mcommon.h"
#endif

#include "LogCircle.h"

// ============================================================================
// MLogCircle implementation
// ============================================================================

MLogCircle::MLogCircle(int n)
{
   m_N = n;
   m_Messages = new String[m_N];
   m_Next = 0;
}

MLogCircle::   ~MLogCircle()
{
   delete [] m_Messages;
}

void
MLogCircle:: Add(const String &txt)
{
   m_Messages[m_Next++] = txt;
   if(m_Next == m_N)
      m_Next = 0;
}

bool
MLogCircle:: Find(const String needle, String *store) const
{
   // searches backwards (most relevant first)
   // search from m_Next-1 to 0
   if(m_Next > 0)
      for(int i = m_Next-1; i >= 0 ; i--)
      {
         wxLogTrace(_T("logcircle"), _T("checking msg %d, %s"), i, m_Messages[i].c_str());
         if(m_Messages[i].Contains(needle))
         {
            if(store) *store = m_Messages[i];
            return true;
         }
      }
   // search from m_N-1 down to m_Next:
   for(int i = m_N-1; i >= m_Next; i--)
   {
      wxLogTrace(_T("logcircle"), _T("checking msg %d, %s"), i, m_Messages[i].c_str());
      if(m_Messages[i].Contains(needle))
      {
         if(store) *store = m_Messages[i];
         return true;
      }
   }

   return false;
}

String
MLogCircle::GetLog(void) const
{
   String log;
   // search from m_Next to m_N
   int i;
   for(i = m_Next; i < m_N ; i++)
      log << m_Messages[i] << '\n';
         // search from 0 to m_Next-1:
   for(i = 0; i < m_Next; i++)
      log << m_Messages[i] << '\n';
   return log;
}

/* static */
void
MLogCircle::GuessError(void) const
{
   String guess,
          err;

   if ( Find("No such host", &err) )
   {
      guess = _("The server name could not be resolved "
                "(maybe the network connection is down?)");
   }
   else if ( Find("User unknown", &err) )
   {
      guess = _("One or more email addresses were not recognised.");
   }
   // check for various POP3 bad login/password messages
   else if ( Find("authorization failed", &err) ||
             Find("password wrong", &err) ||
             Find("bad password", &err) ||
             Find("unknown user name", &err) ||
             Find("Bad authentication", &err) ||
             Find("Password supplied for", &err) || // ... <email addr> is incorrect
             Find("Invalid password", &err) ||
             Find("Invalid login", &err) )
   {
      guess = _("Incorrect username or password: "
                "please verify if they are correct.");
   }
   // the SMTP error messages are not redirected to MLogCircle yet anyhow...
#if 0
   // SMTP 554 error
   else if ( Find("recipients failed", &err) )
   {
      guess = _("Mail server didn't accept one or more of the message recipients");
   }
#endif // 0
   // these are generated by c-client
   else if ( Find("INVALID_ADDRESS", &err) ||
             Find(".SYNTAX-ERROR.", &err) )
   {
      guess = _("The message contained an invalid address specification.");
   }
   // check for various POP3 server messages telling us that another session
   // is active
   else if ( Find("mailbox locked", &err) ||
             Find("lock busy", &err) ||
             Find("[IN-USE]", &err) )
   {
       guess = _("The mailbox is already opened from another session, "
                 "please close it first and retry.");
   }

   if ( !guess.empty() )
   {
      wxLogMessage(guess);
      wxLogMessage(_("The exact error message was: %s"), err.c_str());
   }
}

void
MLogCircle::Clear(void)
{
   for(int i = 0; i < m_N; i++)
   {
      m_Messages[i].clear();
   }
}


