/*
 * write_data v1.3   (c) 1998,2004 by van Hauser / THC <vh@thc.org>
 * http://www.thc.org
 *
 * writes data from a file to a blockdevice.
 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SIZE 100000    /* max bytes to read */


void wrong_syntax () {
    printf("Error: Filename must be the original filename generated by get_date\n");
    printf("Syntax of defined filename:  <start_address>.<no_of_bytes_to_read\n");
    exit(1);
}

int main (int argc, char *argv[]) {
    char dev[100];
    unsigned long bytes, wrote;
    off_t start;
    struct stat st;
    int f;
    char buf[MAX_SIZE];
    char filename[50];
    char tmpbuf[50];
    char *c_ptr, *c_ptr2;

    if (argc!=3) {
        printf("Syntax: %s blockdevice filename\n",argv[0]);
        printf("filename must be the original filename generated by get_data\n");
        exit(1);
    }
    strncpy(dev, argv[1], sizeof(dev)-1);
    strncpy(filename, argv[2], sizeof(filename)-1);
    
    c_ptr2 = strcpy(tmpbuf, filename);
    if ((c_ptr = (char *) strstr(tmpbuf, ".")) == NULL) {
        wrong_syntax();
    }
    *c_ptr = '\0';
    c_ptr++;
    if (sizeof(start) < 8)
      start = atol(c_ptr2);
    else
      start = atoll(c_ptr2);
    bytes = atol(c_ptr);
    if (sizeof(start) < 8)
      sprintf(tmpbuf, "%lu.%lu", (unsigned long) start, bytes);
    else
      sprintf(tmpbuf, "%llu.%lu", (unsigned long long) start, bytes);
    if (strcmp(filename, tmpbuf) != 0) {
        wrong_syntax();
    }

    if ((bytes < 1) || (bytes > MAX_SIZE)) {
	printf("Error: number of bytes to read must be between 1 and %d\n", MAX_SIZE);
	exit (1);
    }
    if (lstat(dev, &st) != 0) {
	perror("Can't access blockdevice");
	exit(1);
    }
    if ((st.st_mode & S_IFBLK) != S_IFBLK) {
    	printf("Warning: %s is not a block device\n", dev);
    }
    if ((f = open(filename, O_RDONLY)) < 0) {
	perror("Can't open filename for reading");
	exit(1);
    }
    fstat(f, &st);
    if (st.st_size != bytes) {
        printf("Error: size of file is %lu, but the filename suggests it should be %lu!\n", (long unsigned int)st.st_size, bytes);
	exit(1);    
    }
    read(f, buf, bytes);
    close(f);
    sync();
    if ((f = open(dev, O_WRONLY)) < 0) {
        perror("Could not open blockdevice for writing");
        exit(1);
    }
    if (lseek(f, start, SEEK_SET) < 0) {
        if (sizeof(start) < 8)
  	  printf("Can't seek to offset %lu\n", (unsigned long) start);
  	else
  	  printf("Can't seek to offset %llu\n", (unsigned long long) start);
	exit(1);
    }
    wrote = write(f, buf, bytes);
    if (wrote < bytes) {
        printf("Could only write %lu bytes data to %s!\n", wrote, dev);
        if (wrote < 1) {
            perror("");
        }
        exit(1);
    }
    close(f);
    sync();
    if (sizeof(start) < 8)
      printf("Wrote file %s (%lu bytes starting at address %lu) to blockdevice %s.\n", filename, bytes, (unsigned long) start, dev);
    else
      printf("Wrote file %s (%lu bytes starting at address %llu) to blockdevice %s.\n", filename, bytes, (unsigned long long) start, dev);
    exit(0);
}
