/*
 * search_data v1.3   (c) 1998,2004 by van Hauser / THC <vh@thc.org>
 * http://www.thc.org
 *
 * searchs for data on a blockdevice
 */
#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define NEEDLE_SIZE 1024
#define BUFSIZE 65536
#define VH_DUMP_ROWS              16
#define WRAP_DUMP		  64

char needle[NEEDLE_SIZE];
unsigned long add_count = 0;
off_t count = 0;
unsigned int son, dump = 0;
char *prog;

void help() {
    printf("Syntax: %s [-i] [-d] blockdevice searchstring\n", prog);
    printf("[-i] ignore case\n");
    printf("[-d] hexdump location\n");
    exit(1);
}                        

void clean_string (char *buf) {
    unsigned int i = son;
    char *c_ptr = buf + son - 1;
    do {    
        c_ptr++; i++;
        if ( (*c_ptr < 32) || (*c_ptr > 126) || (i > 60) ) {
            *c_ptr = '\0';
        }
    } while (*c_ptr != '\0');
}

void vh_dump_asciihex(unsigned char *string, int length) {
    unsigned char *p = (unsigned char *) string;
    unsigned char lastrow_data[16];
    int rows = length / VH_DUMP_ROWS;
    int lastrow = length % VH_DUMP_ROWS;
    int i, j;

    for (i = 0; i < rows; i++) {
        printf("%04hx:  ", i * 16);
        for (j = 0; j < VH_DUMP_ROWS; j++) {
            printf("%02x", p[(i * 16) + j]);
            if (j % 2 == 1)
                printf(" ");
        }
        printf("   [ ");
        for (j = 0; j < VH_DUMP_ROWS; j++) {
            if (isprint(p[(i * 16) + j]))
                printf("%c", p[(i * 16) + j]);
            else
                printf(".");
        }
        printf(" ]\n");
    }
    if (lastrow > 0) {
        memset(lastrow_data, 0, sizeof(lastrow_data));
        memcpy(lastrow_data, p + length - lastrow, lastrow);
        printf("%04hx:  ", i * 16);
        for (j = 0; j < lastrow; j++) {
            printf("%02x", p[(i * 16) + j]);
            if (j % 2 == 1)
                printf(" ");
        }
        while(j < VH_DUMP_ROWS) {
            printf("  ");
            if (j % 2 == 1)
                printf(" ");
            j++;
        }
        printf("   [ ");
        for (j = 0; j < lastrow; j++) {
            if (isprint(p[(i * 16) + j]))
                printf("%c", p[(i * 16) + j]);
            else
                printf(".");
        }
        while(j < VH_DUMP_ROWS) {
            printf(" ");
            j++;
        }
        printf(" ]\n");
    }
}


void search (char *buf, unsigned long bufsize) {
    char tmpbuf[70];
    unsigned int i = 0;
    char *c_ptr = buf;
    while (bufsize >= (son + i)) {
        if (strncmp(c_ptr, needle, son) == 0) {
            if (dump == 0) {
	      strncpy(tmpbuf, c_ptr, sizeof(tmpbuf) - 1);
	      clean_string(tmpbuf);
	      if (sizeof(count) < 8)
	        printf("found at %lu: %s\n", (unsigned long) (count + add_count + i), tmpbuf);
	      else
	        printf("found at %llu: %s\n", (unsigned long long) (count + add_count + i), tmpbuf);
	    } else {
	      if (sizeof(count) < 8)
	        printf("Found at %lu:\n", (unsigned long) (count + add_count + i));
	      else
	        printf("Found at %llu:\n", (unsigned long long) (count + add_count + i));
	      vh_dump_asciihex((c_ptr - buf) > WRAP_DUMP ? c_ptr - WRAP_DUMP : buf, (c_ptr - buf) + WRAP_DUMP + son <= bufsize ? son + WRAP_DUMP + WRAP_DUMP : bufsize - (c_ptr - buf));
	    }
        }
        c_ptr++; i++;
    }
}

int main (int argc, char *argv[]) {
    char dev[100];
    FILE *f;
    struct stat st;
    unsigned long loop = 0, read_error = 0;
    size_t reat = 0, reat_old = 0;
    unsigned int jump_size, ignore = 0, i = 1;
    char buf[BUFSIZE];
    char tmpbuf[(NEEDLE_SIZE - 1)*2];
    
    prog = argv[0];
    if ((argc < 3) || (argc > 5)) {
	help(1);
    }
    if (argc >= 4) {
	if (strncmp(argv[i], "-i", 2) != 0) {
	  if (strncmp(argv[i], "-d", 2) != 0) {
	    help();
	  } else
	  dump = 1;
	} else
  	  ignore = 1;
        i++;
    }
    if (argc == 5) {
	if (strncmp(argv[i], "-i", 2) != 0) {
	  if (strncmp(argv[i], "-d", 2) != 0) {
	    help();
	  } else
	  dump = 1;
	} else
  	  ignore = 1;
        i++;
    }

    strncpy(dev, argv[i++], sizeof(dev) - 1);
    strncpy(needle, argv[i++], sizeof(needle) - 1);
    if (lstat(dev, &st) != 0) {
        perror("Can't access blockdevice");
        exit(1);
    }
    if ((st.st_mode & S_IFBLK) != S_IFBLK) {
        printf("Warning: %s is not a block device\n", dev);
    }
    if ((f = fopen(dev, "r")) == NULL) {
        perror("Can't open blockdevice for reading");
	exit(1);
    }

    jump_size = strlen(needle) - 1;
    son = strlen(needle);
    if (ignore) {
        for (i=0; i<son; i++) {
             needle[i] = tolower(needle[i]);
        }
    }
    do {
        loop++;
        jump_size = son - 1;
        reat = fread(&buf, 1, BUFSIZE, f);
        if (reat != BUFSIZE) {
            read_error++;
	    if (reat <= strlen (needle) -1) {
                jump_size = (unsigned int) (reat % BUFSIZE);
            }
        }
        if (reat > 0) {
          if (ignore) {
            for (i=0; i<reat; i++) {
                buf[i] = tolower(buf[i]);
            }
          }
          if (loop > 1) {
            add_count = (unsigned long) (BUFSIZE + 1 - son);
            memcpy(tmpbuf + son - 1, buf, jump_size);
	    search(tmpbuf, son - 1 + jump_size);
            count = count + reat_old;
            add_count = 0;
          }
  	  search(buf, reat);
	  memcpy(tmpbuf, buf + reat + 1 - son, son - 1);
	  reat_old = reat;
	}
    } while ((feof(f) == 0) && (read_error == 0));
    fclose(f);
    exit(0);
}
