/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.mapyrus.Constants;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;

public class ColorDatabase {
    private static Hashtable mColors = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized void load() throws MapyrusException, IOException {
        var3 = null;
        if (ColorDatabase.mColors != null) {
            return;
        }
        ColorDatabase.mColors = new Hashtable<K, V>();
        ColorDatabase.mColors.put("aliceblue", new Color(240, 248, 255));
        ColorDatabase.mColors.put("antiquewhite", new Color(250, 235, 215));
        ColorDatabase.mColors.put("aqua", new Color(0, 255, 255));
        ColorDatabase.mColors.put("aquamarine", new Color(127, 255, 212));
        ColorDatabase.mColors.put("azure", new Color(240, 255, 255));
        ColorDatabase.mColors.put("beige", new Color(245, 245, 220));
        ColorDatabase.mColors.put("bisque", new Color(255, 228, 196));
        ColorDatabase.mColors.put("black", new Color(0, 0, 0));
        ColorDatabase.mColors.put("blanchedalmond", new Color(255, 235, 205));
        ColorDatabase.mColors.put("blue", new Color(0, 0, 255));
        ColorDatabase.mColors.put("blueviolet", new Color(138, 43, 226));
        ColorDatabase.mColors.put("brown", new Color(165, 42, 42));
        ColorDatabase.mColors.put("burlywood", new Color(222, 184, 135));
        ColorDatabase.mColors.put("cadetblue", new Color(95, 158, 160));
        ColorDatabase.mColors.put("chartreuse", new Color(127, 255, 0));
        ColorDatabase.mColors.put("chocolate", new Color(210, 105, 30));
        ColorDatabase.mColors.put("coral", new Color(255, 127, 80));
        ColorDatabase.mColors.put("cornflowerblue", new Color(100, 149, 237));
        ColorDatabase.mColors.put("cornsilk", new Color(255, 248, 220));
        ColorDatabase.mColors.put("crimson", new Color(220, 20, 60));
        ColorDatabase.mColors.put("cyan", new Color(0, 255, 255));
        ColorDatabase.mColors.put("darkblue", new Color(0, 0, 139));
        ColorDatabase.mColors.put("darkcyan", new Color(0, 139, 139));
        ColorDatabase.mColors.put("darkgoldenrod", new Color(184, 134, 11));
        ColorDatabase.mColors.put("darkgray", new Color(169, 169, 169));
        ColorDatabase.mColors.put("darkgreen", new Color(0, 100, 0));
        ColorDatabase.mColors.put("darkgrey", new Color(169, 169, 169));
        ColorDatabase.mColors.put("darkkhaki", new Color(189, 183, 107));
        ColorDatabase.mColors.put("darkmagenta", new Color(139, 0, 139));
        ColorDatabase.mColors.put("darkolivegreen", new Color(85, 107, 47));
        ColorDatabase.mColors.put("darkorange", new Color(255, 140, 0));
        ColorDatabase.mColors.put("darkorchid", new Color(153, 50, 204));
        ColorDatabase.mColors.put("darkred", new Color(139, 0, 0));
        ColorDatabase.mColors.put("darksalmon", new Color(233, 150, 122));
        ColorDatabase.mColors.put("darkseagreen", new Color(143, 188, 143));
        ColorDatabase.mColors.put("darkslateblue", new Color(72, 61, 139));
        ColorDatabase.mColors.put("darkslategray", new Color(47, 79, 79));
        ColorDatabase.mColors.put("darkslategrey", new Color(47, 79, 79));
        ColorDatabase.mColors.put("darkturquoise", new Color(0, 206, 209));
        ColorDatabase.mColors.put("darkviolet", new Color(148, 0, 211));
        ColorDatabase.mColors.put("deeppink", new Color(255, 20, 147));
        ColorDatabase.mColors.put("deepskyblue", new Color(0, 191, 255));
        ColorDatabase.mColors.put("dimgray", new Color(105, 105, 105));
        ColorDatabase.mColors.put("dimgrey", new Color(105, 105, 105));
        ColorDatabase.mColors.put("dodgerblue", new Color(30, 144, 255));
        ColorDatabase.mColors.put("firebrick", new Color(178, 34, 34));
        ColorDatabase.mColors.put("floralwhite", new Color(255, 250, 240));
        ColorDatabase.mColors.put("forestgreen", new Color(34, 139, 34));
        ColorDatabase.mColors.put("fuchsia", new Color(255, 0, 255));
        ColorDatabase.mColors.put("gainsboro", new Color(220, 220, 220));
        ColorDatabase.mColors.put("ghostwhite", new Color(248, 248, 255));
        ColorDatabase.mColors.put("gold", new Color(255, 215, 0));
        ColorDatabase.mColors.put("goldenrod", new Color(218, 165, 32));
        ColorDatabase.mColors.put("gray", new Color(128, 128, 128));
        ColorDatabase.mColors.put("green", new Color(0, 128, 0));
        ColorDatabase.mColors.put("greenyellow", new Color(173, 255, 47));
        ColorDatabase.mColors.put("grey", new Color(128, 128, 128));
        ColorDatabase.mColors.put("honeydew", new Color(240, 255, 240));
        ColorDatabase.mColors.put("hotpink", new Color(255, 105, 180));
        ColorDatabase.mColors.put("indianred", new Color(205, 92, 92));
        ColorDatabase.mColors.put("indigo", new Color(75, 0, 130));
        ColorDatabase.mColors.put("ivory", new Color(255, 255, 240));
        ColorDatabase.mColors.put("khaki", new Color(240, 230, 140));
        ColorDatabase.mColors.put("lavender", new Color(230, 230, 250));
        ColorDatabase.mColors.put("lavenderblush", new Color(255, 240, 245));
        ColorDatabase.mColors.put("lawngreen", new Color(124, 252, 0));
        ColorDatabase.mColors.put("lemonchiffon", new Color(255, 250, 205));
        ColorDatabase.mColors.put("lightblue", new Color(173, 216, 230));
        ColorDatabase.mColors.put("lightcoral", new Color(240, 128, 128));
        ColorDatabase.mColors.put("lightcyan", new Color(224, 255, 255));
        ColorDatabase.mColors.put("lightgoldenrodyellow", new Color(250, 250, 210));
        ColorDatabase.mColors.put("lightgray", new Color(211, 211, 211));
        ColorDatabase.mColors.put("lightgreen", new Color(144, 238, 144));
        ColorDatabase.mColors.put("lightgrey", new Color(211, 211, 211));
        ColorDatabase.mColors.put("lightpink", new Color(255, 182, 193));
        ColorDatabase.mColors.put("lightsalmon", new Color(255, 160, 122));
        ColorDatabase.mColors.put("lightseagreen", new Color(32, 178, 170));
        ColorDatabase.mColors.put("lightskyblue", new Color(135, 206, 250));
        ColorDatabase.mColors.put("lightslategray", new Color(119, 136, 153));
        ColorDatabase.mColors.put("lightslategrey", new Color(119, 136, 153));
        ColorDatabase.mColors.put("lightsteelblue", new Color(176, 196, 222));
        ColorDatabase.mColors.put("lightyellow", new Color(255, 255, 224));
        ColorDatabase.mColors.put("lime", new Color(0, 255, 0));
        ColorDatabase.mColors.put("limegreen", new Color(50, 205, 50));
        ColorDatabase.mColors.put("linen", new Color(250, 240, 230));
        ColorDatabase.mColors.put("magenta", new Color(255, 0, 255));
        ColorDatabase.mColors.put("maroon", new Color(128, 0, 0));
        ColorDatabase.mColors.put("mediumaquamarine", new Color(102, 205, 170));
        ColorDatabase.mColors.put("mediumblue", new Color(0, 0, 205));
        ColorDatabase.mColors.put("mediumorchid", new Color(186, 85, 211));
        ColorDatabase.mColors.put("mediumpurple", new Color(147, 112, 219));
        ColorDatabase.mColors.put("mediumseagreen", new Color(60, 179, 113));
        ColorDatabase.mColors.put("mediumslateblue", new Color(123, 104, 238));
        ColorDatabase.mColors.put("mediumspringgreen", new Color(0, 250, 154));
        ColorDatabase.mColors.put("mediumturquoise", new Color(72, 209, 204));
        ColorDatabase.mColors.put("mediumvioletred", new Color(199, 21, 133));
        ColorDatabase.mColors.put("midnightblue", new Color(25, 25, 112));
        ColorDatabase.mColors.put("mintcream", new Color(245, 255, 250));
        ColorDatabase.mColors.put("mistyrose", new Color(255, 228, 225));
        ColorDatabase.mColors.put("moccasin", new Color(255, 228, 181));
        ColorDatabase.mColors.put("navajowhite", new Color(255, 222, 173));
        ColorDatabase.mColors.put("navy", new Color(0, 0, 128));
        ColorDatabase.mColors.put("oldlace", new Color(253, 245, 230));
        ColorDatabase.mColors.put("olive", new Color(128, 128, 0));
        ColorDatabase.mColors.put("olivedrab", new Color(107, 142, 35));
        ColorDatabase.mColors.put("orange", new Color(255, 165, 0));
        ColorDatabase.mColors.put("orangered", new Color(255, 69, 0));
        ColorDatabase.mColors.put("orchid", new Color(218, 112, 214));
        ColorDatabase.mColors.put("palegoldenrod", new Color(238, 232, 170));
        ColorDatabase.mColors.put("palegreen", new Color(152, 251, 152));
        ColorDatabase.mColors.put("paleturquoise", new Color(175, 238, 238));
        ColorDatabase.mColors.put("palevioletred", new Color(219, 112, 147));
        ColorDatabase.mColors.put("papayawhip", new Color(255, 239, 213));
        ColorDatabase.mColors.put("peachpuff", new Color(255, 218, 185));
        ColorDatabase.mColors.put("peru", new Color(205, 133, 63));
        ColorDatabase.mColors.put("pink", new Color(255, 192, 203));
        ColorDatabase.mColors.put("plum", new Color(221, 160, 221));
        ColorDatabase.mColors.put("powderblue", new Color(176, 224, 230));
        ColorDatabase.mColors.put("purple", new Color(128, 0, 128));
        ColorDatabase.mColors.put("red", new Color(255, 0, 0));
        ColorDatabase.mColors.put("rosybrown", new Color(188, 143, 143));
        ColorDatabase.mColors.put("royalblue", new Color(65, 105, 225));
        ColorDatabase.mColors.put("saddlebrown", new Color(139, 69, 19));
        ColorDatabase.mColors.put("salmon", new Color(250, 128, 114));
        ColorDatabase.mColors.put("sandybrown", new Color(244, 164, 96));
        ColorDatabase.mColors.put("seagreen", new Color(46, 139, 87));
        ColorDatabase.mColors.put("seashell", new Color(255, 245, 238));
        ColorDatabase.mColors.put("sienna", new Color(160, 82, 45));
        ColorDatabase.mColors.put("silver", new Color(192, 192, 192));
        ColorDatabase.mColors.put("skyblue", new Color(135, 206, 235));
        ColorDatabase.mColors.put("slateblue", new Color(106, 90, 205));
        ColorDatabase.mColors.put("slategray", new Color(112, 128, 144));
        ColorDatabase.mColors.put("slategrey", new Color(112, 128, 144));
        ColorDatabase.mColors.put("snow", new Color(255, 250, 250));
        ColorDatabase.mColors.put("springgreen", new Color(0, 255, 127));
        ColorDatabase.mColors.put("steelblue", new Color(70, 130, 180));
        ColorDatabase.mColors.put("tan", new Color(210, 180, 140));
        ColorDatabase.mColors.put("teal", new Color(0, 128, 128));
        ColorDatabase.mColors.put("thistle", new Color(216, 191, 216));
        ColorDatabase.mColors.put("tomato", new Color(255, 99, 71));
        ColorDatabase.mColors.put("turquoise", new Color(64, 224, 208));
        ColorDatabase.mColors.put("violet", new Color(238, 130, 238));
        ColorDatabase.mColors.put("wheat", new Color(245, 222, 179));
        ColorDatabase.mColors.put("white", new Color(255, 255, 255));
        ColorDatabase.mColors.put("whitesmoke", new Color(245, 245, 245));
        ColorDatabase.mColors.put("yellow", new Color(255, 255, 0));
        ColorDatabase.mColors.put("yellowgreen", new Color(154, 205, 50));
        ColorDatabase.mColors.put("amber", new Color(255, 140, 0));
        var4_1 = 0;
        while (true) {
            if (var4_1 > 100) {
                ColorDatabase.mColors.put("pastelblue", new Color(161, 178, 227));
                ColorDatabase.mColors.put("pastelpink", new Color(216, 161, 227));
                ColorDatabase.mColors.put("pastelgreen", new Color(161, 227, 186));
                ColorDatabase.mColors.put("pastelbrown", new Color(227, 213, 161));
                ColorDatabase.mColors.put("seablue", new Color(51, 204, 255));
                ColorDatabase.mColors.put("lightorange", new Color(255, 204, 0));
                ColorDatabase.mColors.put("antiquewhite1", new Color(255, 239, 219));
                ColorDatabase.mColors.put("antiquewhite2", new Color(238, 223, 204));
                ColorDatabase.mColors.put("antiquewhite3", new Color(205, 192, 176));
                ColorDatabase.mColors.put("antiquewhite4", new Color(139, 131, 120));
                ColorDatabase.mColors.put("aquamarine1", new Color(127, 255, 212));
                ColorDatabase.mColors.put("aquamarine2", new Color(118, 238, 198));
                ColorDatabase.mColors.put("aquamarine3", new Color(102, 205, 170));
                ColorDatabase.mColors.put("aquamarine4", new Color(69, 139, 116));
                ColorDatabase.mColors.put("azure1", new Color(240, 255, 255));
                ColorDatabase.mColors.put("azure2", new Color(224, 238, 238));
                ColorDatabase.mColors.put("azure3", new Color(193, 205, 205));
                ColorDatabase.mColors.put("azure4", new Color(131, 139, 139));
                ColorDatabase.mColors.put("banana", new Color(227, 207, 87));
                ColorDatabase.mColors.put("bisque1", new Color(255, 228, 196));
                ColorDatabase.mColors.put("bisque2", new Color(238, 213, 183));
                ColorDatabase.mColors.put("bisque3", new Color(205, 183, 158));
                ColorDatabase.mColors.put("bisque4", new Color(139, 125, 107));
                ColorDatabase.mColors.put("blue2", new Color(0, 0, 238));
                ColorDatabase.mColors.put("blue3", new Color(0, 0, 205));
                ColorDatabase.mColors.put("blue4", new Color(0, 0, 139));
                ColorDatabase.mColors.put("brown1", new Color(255, 64, 64));
                ColorDatabase.mColors.put("brown2", new Color(238, 59, 59));
                ColorDatabase.mColors.put("brown3", new Color(205, 51, 51));
                ColorDatabase.mColors.put("brown4", new Color(139, 35, 35));
                ColorDatabase.mColors.put("burlywood1", new Color(255, 211, 155));
                ColorDatabase.mColors.put("burlywood2", new Color(238, 197, 145));
                ColorDatabase.mColors.put("burlywood3", new Color(205, 170, 125));
                ColorDatabase.mColors.put("burlywood4", new Color(139, 115, 85));
                ColorDatabase.mColors.put("burntsienna", new Color(138, 54, 15));
                ColorDatabase.mColors.put("burntumber", new Color(138, 51, 36));
                ColorDatabase.mColors.put("cadetblue1", new Color(152, 245, 255));
                ColorDatabase.mColors.put("cadetblue2", new Color(142, 229, 238));
                ColorDatabase.mColors.put("cadetblue3", new Color(122, 197, 205));
                ColorDatabase.mColors.put("cadetblue4", new Color(83, 134, 139));
                ColorDatabase.mColors.put("cadmiumorange", new Color(255, 97, 3));
                ColorDatabase.mColors.put("cadmiumyellow", new Color(255, 153, 18));
                ColorDatabase.mColors.put("carrot", new Color(237, 145, 33));
                ColorDatabase.mColors.put("chartreuse1", new Color(127, 255, 0));
                ColorDatabase.mColors.put("chartreuse2", new Color(118, 238, 0));
                ColorDatabase.mColors.put("chartreuse3", new Color(102, 205, 0));
                ColorDatabase.mColors.put("chartreuse4", new Color(69, 139, 0));
                ColorDatabase.mColors.put("chocolate1", new Color(255, 127, 36));
                ColorDatabase.mColors.put("chocolate2", new Color(238, 118, 33));
                ColorDatabase.mColors.put("chocolate3", new Color(205, 102, 29));
                ColorDatabase.mColors.put("chocolate4", new Color(139, 69, 19));
                ColorDatabase.mColors.put("cobaltgreen", new Color(61, 145, 64));
                ColorDatabase.mColors.put("cobalt", new Color(61, 89, 171));
                ColorDatabase.mColors.put("coldgrey", new Color(128, 138, 135));
                ColorDatabase.mColors.put("coral1", new Color(255, 114, 86));
                ColorDatabase.mColors.put("coral2", new Color(238, 106, 80));
                ColorDatabase.mColors.put("coral3", new Color(205, 91, 69));
                ColorDatabase.mColors.put("coral4", new Color(139, 62, 47));
                ColorDatabase.mColors.put("cornsilk1", new Color(255, 248, 220));
                ColorDatabase.mColors.put("cornsilk2", new Color(238, 232, 205));
                ColorDatabase.mColors.put("cornsilk3", new Color(205, 200, 177));
                ColorDatabase.mColors.put("cornsilk4", new Color(139, 136, 120));
                ColorDatabase.mColors.put("cyan2", new Color(0, 238, 238));
                ColorDatabase.mColors.put("cyan3", new Color(0, 205, 205));
                ColorDatabase.mColors.put("cyan4", new Color(0, 139, 139));
                ColorDatabase.mColors.put("darkgoldenrod1", new Color(255, 185, 15));
                ColorDatabase.mColors.put("darkgoldenrod2", new Color(238, 173, 14));
                ColorDatabase.mColors.put("darkgoldenrod3", new Color(205, 149, 12));
                ColorDatabase.mColors.put("darkgoldenrod4", new Color(139, 101, 8));
                ColorDatabase.mColors.put("darkolivegreen1", new Color(202, 255, 112));
                ColorDatabase.mColors.put("darkolivegreen2", new Color(188, 238, 104));
                ColorDatabase.mColors.put("darkolivegreen3", new Color(162, 205, 90));
                ColorDatabase.mColors.put("darkolivegreen4", new Color(110, 139, 61));
                ColorDatabase.mColors.put("darkorange1", new Color(255, 127, 0));
                ColorDatabase.mColors.put("darkorange2", new Color(238, 118, 0));
                ColorDatabase.mColors.put("darkorange3", new Color(205, 102, 0));
                ColorDatabase.mColors.put("darkorange4", new Color(139, 69, 0));
                ColorDatabase.mColors.put("darkorchid1", new Color(191, 62, 255));
                ColorDatabase.mColors.put("darkorchid2", new Color(178, 58, 238));
                ColorDatabase.mColors.put("darkorchid3", new Color(154, 50, 205));
                ColorDatabase.mColors.put("darkorchid4", new Color(104, 34, 139));
                ColorDatabase.mColors.put("darkseagreen1", new Color(193, 255, 193));
                ColorDatabase.mColors.put("darkseagreen2", new Color(180, 238, 180));
                ColorDatabase.mColors.put("darkseagreen3", new Color(155, 205, 155));
                ColorDatabase.mColors.put("darkseagreen4", new Color(105, 139, 105));
                ColorDatabase.mColors.put("darkslategray1", new Color(151, 255, 255));
                ColorDatabase.mColors.put("darkslategray2", new Color(141, 238, 238));
                ColorDatabase.mColors.put("darkslategray3", new Color(121, 205, 205));
                ColorDatabase.mColors.put("darkslategray4", new Color(82, 139, 139));
                ColorDatabase.mColors.put("deeppink1", new Color(255, 20, 147));
                ColorDatabase.mColors.put("deeppink2", new Color(238, 18, 137));
                ColorDatabase.mColors.put("deeppink3", new Color(205, 16, 118));
                ColorDatabase.mColors.put("deeppink4", new Color(139, 10, 80));
                ColorDatabase.mColors.put("deepskyblue1", new Color(0, 191, 255));
                ColorDatabase.mColors.put("deepskyblue2", new Color(0, 178, 238));
                ColorDatabase.mColors.put("deepskyblue3", new Color(0, 154, 205));
                ColorDatabase.mColors.put("deepskyblue4", new Color(0, 104, 139));
                ColorDatabase.mColors.put("dodgerblue1", new Color(30, 144, 255));
                ColorDatabase.mColors.put("dodgerblue2", new Color(28, 134, 238));
                ColorDatabase.mColors.put("dodgerblue3", new Color(24, 116, 205));
                ColorDatabase.mColors.put("dodgerblue4", new Color(16, 78, 139));
                ColorDatabase.mColors.put("eggshell", new Color(252, 230, 201));
                ColorDatabase.mColors.put("emeraldgreen", new Color(0, 201, 87));
                ColorDatabase.mColors.put("firebrick1", new Color(255, 48, 48));
                ColorDatabase.mColors.put("firebrick2", new Color(238, 44, 44));
                ColorDatabase.mColors.put("firebrick3", new Color(205, 38, 38));
                ColorDatabase.mColors.put("firebrick4", new Color(139, 26, 26));
                ColorDatabase.mColors.put("flesh", new Color(255, 125, 64));
                ColorDatabase.mColors.put("gold1", new Color(255, 215, 0));
                ColorDatabase.mColors.put("gold2", new Color(238, 201, 0));
                ColorDatabase.mColors.put("gold3", new Color(205, 173, 0));
                ColorDatabase.mColors.put("gold4", new Color(139, 117, 0));
                ColorDatabase.mColors.put("goldenrod1", new Color(255, 193, 37));
                ColorDatabase.mColors.put("goldenrod2", new Color(238, 180, 34));
                ColorDatabase.mColors.put("goldenrod3", new Color(205, 155, 29));
                ColorDatabase.mColors.put("goldenrod4", new Color(139, 105, 20));
                ColorDatabase.mColors.put("green1", new Color(0, 255, 0));
                ColorDatabase.mColors.put("green2", new Color(0, 238, 0));
                ColorDatabase.mColors.put("green3", new Color(0, 205, 0));
                ColorDatabase.mColors.put("green4", new Color(0, 139, 0));
                ColorDatabase.mColors.put("honeydew1", new Color(240, 255, 240));
                ColorDatabase.mColors.put("honeydew2", new Color(224, 238, 224));
                ColorDatabase.mColors.put("honeydew3", new Color(193, 205, 193));
                ColorDatabase.mColors.put("honeydew4", new Color(131, 139, 131));
                ColorDatabase.mColors.put("hotpink1", new Color(255, 110, 180));
                ColorDatabase.mColors.put("hotpink2", new Color(238, 106, 167));
                ColorDatabase.mColors.put("hotpink3", new Color(205, 96, 144));
                ColorDatabase.mColors.put("hotpink4", new Color(139, 58, 98));
                ColorDatabase.mColors.put("indianred1", new Color(255, 106, 106));
                ColorDatabase.mColors.put("indianred2", new Color(238, 99, 99));
                ColorDatabase.mColors.put("indianred3", new Color(205, 85, 85));
                ColorDatabase.mColors.put("indianred4", new Color(139, 58, 58));
                ColorDatabase.mColors.put("ivory1", new Color(255, 255, 240));
                ColorDatabase.mColors.put("ivory2", new Color(238, 238, 224));
                ColorDatabase.mColors.put("ivory3", new Color(205, 205, 193));
                ColorDatabase.mColors.put("ivory4", new Color(139, 139, 131));
                ColorDatabase.mColors.put("ivoryblack", new Color(41, 36, 33));
                ColorDatabase.mColors.put("khaki1", new Color(255, 246, 143));
                ColorDatabase.mColors.put("khaki2", new Color(238, 230, 133));
                ColorDatabase.mColors.put("khaki3", new Color(205, 198, 115));
                ColorDatabase.mColors.put("khaki4", new Color(139, 134, 78));
                ColorDatabase.mColors.put("lavenderblush1", new Color(255, 240, 245));
                ColorDatabase.mColors.put("lavenderblush2", new Color(238, 224, 229));
                ColorDatabase.mColors.put("lavenderblush3", new Color(205, 193, 197));
                ColorDatabase.mColors.put("lavenderblush4", new Color(139, 131, 134));
                ColorDatabase.mColors.put("lemonchiffon1", new Color(255, 250, 205));
                ColorDatabase.mColors.put("lemonchiffon2", new Color(238, 233, 191));
                ColorDatabase.mColors.put("lemonchiffon3", new Color(205, 201, 165));
                ColorDatabase.mColors.put("lemonchiffon4", new Color(139, 137, 112));
                ColorDatabase.mColors.put("lightblue1", new Color(191, 239, 255));
                ColorDatabase.mColors.put("lightblue2", new Color(178, 223, 238));
                ColorDatabase.mColors.put("lightblue3", new Color(154, 192, 205));
                ColorDatabase.mColors.put("lightblue4", new Color(104, 131, 139));
                ColorDatabase.mColors.put("lightcyan1", new Color(224, 255, 255));
                ColorDatabase.mColors.put("lightcyan2", new Color(209, 238, 238));
                ColorDatabase.mColors.put("lightcyan3", new Color(180, 205, 205));
                ColorDatabase.mColors.put("lightcyan4", new Color(122, 139, 139));
                ColorDatabase.mColors.put("lightgoldenrod1", new Color(255, 236, 139));
                ColorDatabase.mColors.put("lightgoldenrod2", new Color(238, 220, 130));
                ColorDatabase.mColors.put("lightgoldenrod3", new Color(205, 190, 112));
                ColorDatabase.mColors.put("lightgoldenrod4", new Color(139, 129, 76));
                ColorDatabase.mColors.put("lightpink1", new Color(255, 174, 185));
                ColorDatabase.mColors.put("lightpink2", new Color(238, 162, 173));
                ColorDatabase.mColors.put("lightpink3", new Color(205, 140, 149));
                ColorDatabase.mColors.put("lightpink4", new Color(139, 95, 101));
                ColorDatabase.mColors.put("lightsalmon1", new Color(255, 160, 122));
                ColorDatabase.mColors.put("lightsalmon2", new Color(238, 149, 114));
                ColorDatabase.mColors.put("lightsalmon3", new Color(205, 129, 98));
                ColorDatabase.mColors.put("lightsalmon4", new Color(139, 87, 66));
                ColorDatabase.mColors.put("lightskyblue1", new Color(176, 226, 255));
                ColorDatabase.mColors.put("lightskyblue2", new Color(164, 211, 238));
                ColorDatabase.mColors.put("lightskyblue3", new Color(141, 182, 205));
                ColorDatabase.mColors.put("lightskyblue4", new Color(96, 123, 139));
                ColorDatabase.mColors.put("lightslateblue", new Color(132, 112, 255));
                ColorDatabase.mColors.put("lightsteelblue1", new Color(202, 225, 255));
                ColorDatabase.mColors.put("lightsteelblue2", new Color(188, 210, 238));
                ColorDatabase.mColors.put("lightsteelblue3", new Color(162, 181, 205));
                ColorDatabase.mColors.put("lightsteelblue4", new Color(110, 123, 139));
                ColorDatabase.mColors.put("lightyellow1", new Color(255, 255, 224));
                ColorDatabase.mColors.put("lightyellow2", new Color(238, 238, 209));
                ColorDatabase.mColors.put("lightyellow3", new Color(205, 205, 180));
                ColorDatabase.mColors.put("lightyellow4", new Color(139, 139, 122));
                ColorDatabase.mColors.put("magenta2", new Color(238, 0, 238));
                ColorDatabase.mColors.put("magenta3", new Color(205, 0, 205));
                ColorDatabase.mColors.put("magenta4", new Color(139, 0, 139));
                ColorDatabase.mColors.put("manganeseblue", new Color(3, 168, 158));
                ColorDatabase.mColors.put("maroon1", new Color(255, 52, 179));
                ColorDatabase.mColors.put("maroon2", new Color(238, 48, 167));
                ColorDatabase.mColors.put("maroon3", new Color(205, 41, 144));
                ColorDatabase.mColors.put("maroon4", new Color(139, 28, 98));
                ColorDatabase.mColors.put("mediumorchid1", new Color(224, 102, 255));
                ColorDatabase.mColors.put("mediumorchid2", new Color(209, 95, 238));
                ColorDatabase.mColors.put("mediumorchid3", new Color(180, 82, 205));
                ColorDatabase.mColors.put("mediumorchid4", new Color(122, 55, 139));
                ColorDatabase.mColors.put("mediumpurple1", new Color(171, 130, 255));
                ColorDatabase.mColors.put("mediumpurple2", new Color(159, 121, 238));
                ColorDatabase.mColors.put("mediumpurple3", new Color(137, 104, 205));
                ColorDatabase.mColors.put("mediumpurple4", new Color(93, 71, 139));
                ColorDatabase.mColors.put("melon", new Color(227, 168, 105));
                ColorDatabase.mColors.put("mistyrose1", new Color(255, 228, 225));
                ColorDatabase.mColors.put("mistyrose2", new Color(238, 213, 210));
                ColorDatabase.mColors.put("mistyrose3", new Color(205, 183, 181));
                ColorDatabase.mColors.put("mistyrose4", new Color(139, 125, 123));
                ColorDatabase.mColors.put("navajowhite1", new Color(255, 222, 173));
                ColorDatabase.mColors.put("navajowhite2", new Color(238, 207, 161));
                ColorDatabase.mColors.put("navajowhite3", new Color(205, 179, 139));
                ColorDatabase.mColors.put("navajowhite4", new Color(139, 121, 94));
                ColorDatabase.mColors.put("olivedrab1", new Color(192, 255, 62));
                ColorDatabase.mColors.put("olivedrab2", new Color(179, 238, 58));
                ColorDatabase.mColors.put("olivedrab3", new Color(154, 205, 50));
                ColorDatabase.mColors.put("olivedrab4", new Color(105, 139, 34));
                ColorDatabase.mColors.put("orange1", new Color(255, 165, 0));
                ColorDatabase.mColors.put("orange2", new Color(238, 154, 0));
                ColorDatabase.mColors.put("orange3", new Color(205, 133, 0));
                ColorDatabase.mColors.put("orange4", new Color(139, 90, 0));
                ColorDatabase.mColors.put("orangered1", new Color(255, 69, 0));
                ColorDatabase.mColors.put("orangered2", new Color(238, 64, 0));
                ColorDatabase.mColors.put("orangered3", new Color(205, 55, 0));
                ColorDatabase.mColors.put("orangered4", new Color(139, 37, 0));
                ColorDatabase.mColors.put("orchid1", new Color(255, 131, 250));
                ColorDatabase.mColors.put("orchid2", new Color(238, 122, 233));
                ColorDatabase.mColors.put("orchid3", new Color(205, 105, 201));
                ColorDatabase.mColors.put("orchid4", new Color(139, 71, 137));
                ColorDatabase.mColors.put("palegreen1", new Color(154, 255, 154));
                ColorDatabase.mColors.put("palegreen2", new Color(144, 238, 144));
                ColorDatabase.mColors.put("palegreen3", new Color(124, 205, 124));
                ColorDatabase.mColors.put("palegreen4", new Color(84, 139, 84));
                ColorDatabase.mColors.put("paleturquoise1", new Color(187, 255, 255));
                ColorDatabase.mColors.put("paleturquoise2", new Color(174, 238, 238));
                ColorDatabase.mColors.put("paleturquoise3", new Color(150, 205, 205));
                ColorDatabase.mColors.put("paleturquoise4", new Color(102, 139, 139));
                ColorDatabase.mColors.put("palevioletred1", new Color(255, 130, 171));
                ColorDatabase.mColors.put("palevioletred2", new Color(238, 121, 159));
                ColorDatabase.mColors.put("palevioletred3", new Color(205, 104, 137));
                ColorDatabase.mColors.put("palevioletred4", new Color(139, 71, 93));
                ColorDatabase.mColors.put("peachpuff1", new Color(255, 218, 185));
                ColorDatabase.mColors.put("peachpuff2", new Color(238, 203, 173));
                ColorDatabase.mColors.put("peachpuff3", new Color(205, 175, 149));
                ColorDatabase.mColors.put("peachpuff4", new Color(139, 119, 101));
                ColorDatabase.mColors.put("peacock", new Color(51, 161, 201));
                ColorDatabase.mColors.put("pink1", new Color(255, 181, 197));
                ColorDatabase.mColors.put("pink2", new Color(238, 169, 184));
                ColorDatabase.mColors.put("pink3", new Color(205, 145, 158));
                ColorDatabase.mColors.put("pink4", new Color(139, 99, 108));
                ColorDatabase.mColors.put("plum1", new Color(255, 187, 255));
                ColorDatabase.mColors.put("plum2", new Color(238, 174, 238));
                ColorDatabase.mColors.put("plum3", new Color(205, 150, 205));
                ColorDatabase.mColors.put("plum4", new Color(139, 102, 139));
                ColorDatabase.mColors.put("purple1", new Color(155, 48, 255));
                ColorDatabase.mColors.put("purple2", new Color(145, 44, 238));
                ColorDatabase.mColors.put("purple3", new Color(125, 38, 205));
                ColorDatabase.mColors.put("purple4", new Color(85, 26, 139));
                ColorDatabase.mColors.put("raspberry", new Color(135, 38, 87));
                ColorDatabase.mColors.put("rawsienna", new Color(199, 97, 20));
                ColorDatabase.mColors.put("red1", new Color(255, 0, 0));
                ColorDatabase.mColors.put("red2", new Color(238, 0, 0));
                ColorDatabase.mColors.put("red3", new Color(205, 0, 0));
                ColorDatabase.mColors.put("red4", new Color(139, 0, 0));
                ColorDatabase.mColors.put("rosybrown1", new Color(255, 193, 193));
                ColorDatabase.mColors.put("rosybrown2", new Color(238, 180, 180));
                ColorDatabase.mColors.put("rosybrown3", new Color(205, 155, 155));
                ColorDatabase.mColors.put("rosybrown4", new Color(139, 105, 105));
                ColorDatabase.mColors.put("royalblue1", new Color(72, 118, 255));
                ColorDatabase.mColors.put("royalblue2", new Color(67, 110, 238));
                ColorDatabase.mColors.put("royalblue3", new Color(58, 95, 205));
                ColorDatabase.mColors.put("royalblue4", new Color(39, 64, 139));
                ColorDatabase.mColors.put("salmon1", new Color(255, 140, 105));
                ColorDatabase.mColors.put("salmon2", new Color(238, 130, 98));
                ColorDatabase.mColors.put("salmon3", new Color(205, 112, 84));
                ColorDatabase.mColors.put("salmon4", new Color(139, 76, 57));
                ColorDatabase.mColors.put("sapgreen", new Color(48, 128, 20));
                ColorDatabase.mColors.put("seagreen1", new Color(84, 255, 159));
                ColorDatabase.mColors.put("seagreen2", new Color(78, 238, 148));
                ColorDatabase.mColors.put("seagreen3", new Color(67, 205, 128));
                ColorDatabase.mColors.put("seagreen4", new Color(46, 139, 87));
                ColorDatabase.mColors.put("seashell1", new Color(255, 245, 238));
                ColorDatabase.mColors.put("seashell2", new Color(238, 229, 222));
                ColorDatabase.mColors.put("seashell3", new Color(205, 197, 191));
                ColorDatabase.mColors.put("seashell4", new Color(139, 134, 130));
                ColorDatabase.mColors.put("sepia", new Color(94, 38, 18));
                ColorDatabase.mColors.put("sgibeet", new Color(142, 56, 142));
                ColorDatabase.mColors.put("sgibrightgray", new Color(197, 193, 170));
                ColorDatabase.mColors.put("sgichartreuse", new Color(113, 198, 113));
                ColorDatabase.mColors.put("sgidarkgray", new Color(85, 85, 85));
                ColorDatabase.mColors.put("sgigray12", new Color(30, 30, 30));
                ColorDatabase.mColors.put("sgigray16", new Color(40, 40, 40));
                ColorDatabase.mColors.put("sgigray32", new Color(81, 81, 81));
                ColorDatabase.mColors.put("sgigray36", new Color(91, 91, 91));
                ColorDatabase.mColors.put("sgigray52", new Color(132, 132, 132));
                ColorDatabase.mColors.put("sgigray56", new Color(142, 142, 142));
                ColorDatabase.mColors.put("sgigray72", new Color(183, 183, 183));
                ColorDatabase.mColors.put("sgigray76", new Color(193, 193, 193));
                ColorDatabase.mColors.put("sgigray92", new Color(234, 234, 234));
                ColorDatabase.mColors.put("sgigray96", new Color(244, 244, 244));
                ColorDatabase.mColors.put("sgilightblue", new Color(125, 158, 192));
                ColorDatabase.mColors.put("sgilightgray", new Color(170, 170, 170));
                ColorDatabase.mColors.put("sgiolivedrab", new Color(142, 142, 56));
                ColorDatabase.mColors.put("sgisalmon", new Color(198, 113, 113));
                ColorDatabase.mColors.put("sgislateblue", new Color(113, 113, 198));
                ColorDatabase.mColors.put("sgiteal", new Color(56, 142, 142));
                ColorDatabase.mColors.put("sienna1", new Color(255, 130, 71));
                ColorDatabase.mColors.put("sienna2", new Color(238, 121, 66));
                ColorDatabase.mColors.put("sienna3", new Color(205, 104, 57));
                ColorDatabase.mColors.put("sienna4", new Color(139, 71, 38));
                ColorDatabase.mColors.put("skyblue1", new Color(135, 206, 255));
                ColorDatabase.mColors.put("skyblue2", new Color(126, 192, 238));
                ColorDatabase.mColors.put("skyblue3", new Color(108, 166, 205));
                ColorDatabase.mColors.put("skyblue4", new Color(74, 112, 139));
                ColorDatabase.mColors.put("slateblue1", new Color(131, 111, 255));
                ColorDatabase.mColors.put("slateblue2", new Color(122, 103, 238));
                ColorDatabase.mColors.put("slateblue3", new Color(105, 89, 205));
                ColorDatabase.mColors.put("slateblue4", new Color(71, 60, 139));
                ColorDatabase.mColors.put("slategray1", new Color(198, 226, 255));
                ColorDatabase.mColors.put("slategray2", new Color(185, 211, 238));
                ColorDatabase.mColors.put("slategray3", new Color(159, 182, 205));
                ColorDatabase.mColors.put("slategray4", new Color(108, 123, 139));
                ColorDatabase.mColors.put("snow1", new Color(255, 250, 250));
                ColorDatabase.mColors.put("snow2", new Color(238, 233, 233));
                ColorDatabase.mColors.put("snow3", new Color(205, 201, 201));
                ColorDatabase.mColors.put("snow4", new Color(139, 137, 137));
                ColorDatabase.mColors.put("springgreen1", new Color(0, 238, 118));
                ColorDatabase.mColors.put("springgreen2", new Color(0, 205, 102));
                ColorDatabase.mColors.put("springgreen3", new Color(0, 139, 69));
                ColorDatabase.mColors.put("steelblue1", new Color(99, 184, 255));
                ColorDatabase.mColors.put("steelblue2", new Color(92, 172, 238));
                ColorDatabase.mColors.put("steelblue3", new Color(79, 148, 205));
                ColorDatabase.mColors.put("steelblue4", new Color(54, 100, 139));
                ColorDatabase.mColors.put("tan1", new Color(255, 165, 79));
                ColorDatabase.mColors.put("tan2", new Color(238, 154, 73));
                ColorDatabase.mColors.put("tan3", new Color(205, 133, 63));
                ColorDatabase.mColors.put("tan4", new Color(139, 90, 43));
                ColorDatabase.mColors.put("thistle1", new Color(255, 225, 255));
                ColorDatabase.mColors.put("thistle2", new Color(238, 210, 238));
                ColorDatabase.mColors.put("thistle3", new Color(205, 181, 205));
                ColorDatabase.mColors.put("thistle4", new Color(139, 123, 139));
                ColorDatabase.mColors.put("tomato1", new Color(255, 99, 71));
                ColorDatabase.mColors.put("tomato2", new Color(238, 92, 66));
                ColorDatabase.mColors.put("tomato3", new Color(205, 79, 57));
                ColorDatabase.mColors.put("tomato4", new Color(139, 54, 38));
                ColorDatabase.mColors.put("turquoise1", new Color(0, 245, 255));
                ColorDatabase.mColors.put("turquoise2", new Color(0, 229, 238));
                ColorDatabase.mColors.put("turquoise3", new Color(0, 197, 205));
                ColorDatabase.mColors.put("turquoise4", new Color(0, 134, 139));
                ColorDatabase.mColors.put("turquoiseblue", new Color(0, 199, 140));
                ColorDatabase.mColors.put("violetred1", new Color(255, 62, 150));
                ColorDatabase.mColors.put("violetred2", new Color(238, 58, 140));
                ColorDatabase.mColors.put("violetred3", new Color(205, 50, 120));
                ColorDatabase.mColors.put("violetred4", new Color(139, 34, 82));
                ColorDatabase.mColors.put("warmgrey", new Color(128, 128, 105));
                ColorDatabase.mColors.put("wheat1", new Color(255, 231, 186));
                ColorDatabase.mColors.put("wheat2", new Color(238, 216, 174));
                ColorDatabase.mColors.put("wheat3", new Color(205, 186, 150));
                ColorDatabase.mColors.put("wheat4", new Color(139, 126, 102));
                ColorDatabase.mColors.put("yellow1", new Color(255, 255, 0));
                ColorDatabase.mColors.put("yellow2", new Color(238, 238, 0));
                ColorDatabase.mColors.put("yellow3", new Color(205, 205, 0));
                ColorDatabase.mColors.put("yellow4", new Color(139, 139, 0));
                ** try [egrp 0[TRYBLOCK] [0 : 12394->12404)] { 
lbl1019:
                // 1 sources

                break;
            }
            var5_2 = (int)Math.round((double)var4_1 / 100.0 * 255.0);
            var6_7 = new Color(var5_2, var5_2, var5_2);
            ColorDatabase.mColors.put("grey" + var4_1, var6_7);
            ColorDatabase.mColors.put("gray" + var4_1, var6_7);
            var4_1 += 10;
        }
        {
            var0_8 = System.getProperty("Mapyrus.rgb.file");
        }
lbl1030:
        // 1 sources

        catch (SecurityException var5_3) {
            var0_8 = null;
        }
        try {
            if (var0_8 == null) {
                var0_8 = "rgb.txt";
            }
            var3 = new LineNumberReader(new FileReader(var0_8));
        }
        catch (FileNotFoundException var5_4) {
            var0_8 = null;
        }
        try {
            if (var0_8 == null) {
                var0_8 = "/usr/lib/X11/rgb.txt";
                if (Constants.getOSName().indexOf("SUNOS") >= 0) {
                    var0_8 = "/usr/openwin/lib/X11/rgb.txt";
                }
                var3 = new LineNumberReader(new FileReader(var0_8));
            }
        }
        catch (FileNotFoundException var5_5) {
            return;
        }
        try {
            block11: while (true) {
                if ((var1_9 = var3.readLine()) == null) {
                    var13_17 = null;
                    break;
                }
                var2_10 = new StringTokenizer(var1_9);
                if (var2_10.countTokens() < 4) continue;
                var5_6 = var2_10.nextToken();
                var6_7 = var2_10.nextToken();
                var7_11 = var2_10.nextToken();
                var8_12 = var2_10.nextToken();
                while (true) {
                    if (!var2_10.hasMoreTokens()) {
                        if (var5_6.startsWith("!")) continue block11;
                        try {
                            var9_13 = Integer.parseInt(var5_6);
                            var10_15 = Integer.parseInt((String)var6_7);
                            var11_16 = Integer.parseInt(var7_11);
                            ColorDatabase.mColors.put(var8_12.toLowerCase(), new Color(var9_13, var10_15, var11_16));
                            continue block11;
                        }
                        catch (NumberFormatException var9_14) {
                            throw new MapyrusException(var0_8 + ":" + var3.getLineNumber() + ": " + MapyrusMessages.get("invalidcolor"));
                        }
                    }
                    var8_12 = var8_12.concat(var2_10.nextToken());
                }
                break;
            }
        }
        catch (Throwable var12_19) {
            var13_18 = null;
            var3.close();
            throw var12_19;
        }
        var3.close();
    }

    public static Color getColor(String string, int n, Color color) throws MapyrusException {
        Color color2;
        if (string.startsWith("#") || string.startsWith("0x") || string.startsWith("0X")) {
            int n2 = string.charAt(0) == '#' ? 1 : 2;
            try {
                int n3 = Integer.parseInt(string.substring(n2), 16);
                color2 = new Color((n3 &= 0xFFFFFF) | n << 24, true);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MapyrusException(MapyrusMessages.get("invalidcolor") + ": " + string);
            }
        } else if (string.equals("brighter")) {
            int n4 = color.getAlpha();
            color2 = color.brighter();
            if (n != n4) {
                color2 = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), n);
            }
        } else if (string.equals("darker")) {
            int n5 = color.getAlpha();
            color2 = color.darker();
            if (n != n5) {
                color2 = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), n);
            }
        } else if (string.equals("softer")) {
            int n6;
            int n7;
            int n8 = 128 + color.getRed() / 2;
            if (n8 > 255) {
                n8 = 255;
            }
            if ((n7 = 128 + color.getGreen() / 2) > 255) {
                n7 = 255;
            }
            if ((n6 = 128 + color.getBlue() / 2) > 255) {
                n6 = 255;
            }
            color2 = new Color(n8, n7, n6, n);
        } else if (string.equals("contrast")) {
            int n9 = color.getRed() * 3 + color.getGreen() * 4 + color.getBlue() * 3;
            color2 = n9 > 1275 ? (n == 255 ? Color.BLACK : new Color(0, 0, 0, n)) : (n == 255 ? Color.WHITE : new Color(255, 255, 255, n));
        } else if (string.equals("current")) {
            color2 = color;
        } else {
            int n10;
            color2 = (Color)mColors.get(string);
            if (color2 == null) {
                n10 = string.length();
                StringBuffer stringBuffer = new StringBuffer(n10);
                int n11 = 0;
                while (n11 < n10) {
                    char c = string.charAt(n11);
                    if (!Character.isWhitespace(c)) {
                        stringBuffer.append(Character.toLowerCase(c));
                    }
                    ++n11;
                }
                color2 = (Color)mColors.get(stringBuffer.toString());
                if (color2 != null) {
                    mColors.put(string, color2);
                }
            }
            if (n != 255) {
                n10 = color2.getRGB();
                color2 = new Color((n10 &= 0xFFFFFF) | n << 24, true);
            }
        }
        return color2;
    }

    public static String toHexString(Color color) {
        StringBuffer stringBuffer = new StringBuffer("#");
        String string = Integer.toHexString(color.getRed());
        String string2 = Integer.toHexString(color.getGreen());
        String string3 = Integer.toHexString(color.getBlue());
        if (string.length() < 2) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        if (string2.length() < 2) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string2);
        if (string3.length() < 2) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }
}

