/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import org.mapyrus.Argument;
import org.mapyrus.Constants;
import org.mapyrus.Context;
import org.mapyrus.Dataset;
import org.mapyrus.LRUCache;
import org.mapyrus.LegendEntryList;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.MimeTypes;
import org.mapyrus.Row;
import org.mapyrus.dataset.DatasetFactory;
import org.mapyrus.dataset.GeographicDataset;
import org.mapyrus.font.StringDimension;
import org.mapyrus.image.Bitmap;
import org.mapyrus.image.ImageIOWrapper;

public class ContextStack {
    private static final int MAX_STACK_LENGTH = 30;
    private static final String INTERNAL_VARIABLE_PREFIX = "Mapyrus.";
    private static final String PATH_VARIABLE = "path";
    private static final String WORLDS_VARIABLE = "worlds";
    private static final String DATASET_VARIABLE = "dataset";
    private static final String PAGE_VARIABLE = "page";
    private static final String SCREEN_VARIABLE = "screen";
    private static final String IMAGEMAP_VARIABLE = "imagemap";
    private LinkedList mStack = new LinkedList();
    private LegendEntryList mLegendEntries;
    private LRUCache mIconCache;
    private long mStartTime;
    private Point mImagemapPoint;
    private String mHTTPResponse;

    public ContextStack() {
        this.mStack.add(new Context());
        this.mStartTime = System.currentTimeMillis();
        this.mImagemapPoint = null;
        this.mLegendEntries = new LegendEntryList();
        this.mIconCache = new LRUCache(64);
        this.mHTTPResponse = "HTTP/1.0 200 OK" + Constants.LINE_SEPARATOR + "Content-Type" + ": " + MimeTypes.get("html") + Constants.LINE_SEPARATOR;
    }

    private Context getCurrentContext() {
        return (Context)this.mStack.getLast();
    }

    private int popContext() throws IOException, MapyrusException {
        int n = this.mStack.size();
        if (n > 0) {
            Context context = (Context)this.mStack.removeLast();
            int n2 = context.closeContext();
            if (--n > 0 && n2 != 0) {
                this.getCurrentContext().setAttributesChanged(n2);
            }
        }
        return n;
    }

    private void pushContext(String string) throws MapyrusException {
        if (this.mStack.size() == 30) {
            throw new MapyrusException(MapyrusMessages.get("recursion"));
        }
        this.mStack.add(new Context(this.getCurrentContext(), string));
    }

    public void setImagemapPoint(Point point) {
        this.mImagemapPoint = point;
    }

    public void setOutputFormat(String string, String string2, double d, double d2, String string3, PrintStream printStream) throws IOException, MapyrusException {
        this.getCurrentContext().setOutputFormat(string, string2, d, d2, string3, printStream);
    }

    public void setOutputFormat(BufferedImage bufferedImage, PrintWriter printWriter, String string) throws IOException, MapyrusException {
        this.getCurrentContext().setOutputFormat(bufferedImage, printWriter, string);
    }

    public void setOutputFormat(BufferedImage bufferedImage, String string) throws IOException, MapyrusException {
        this.getCurrentContext().setOutputFormat(bufferedImage, string);
    }

    public void closeOutputFormat() throws IOException, MapyrusException {
        this.getCurrentContext().closeOutputFormat();
    }

    public void setLinestyle(double d, int n, int n2, double d2, float[] fArray) {
        this.getCurrentContext().setLinestyle(d, n, n2, d2, fArray);
    }

    public void setColor(Color color) {
        this.getCurrentContext().setColor(color);
    }

    public void setBlend(String string) {
        this.getCurrentContext().setBlend(string);
    }

    public Color getColor() {
        Color color = this.getCurrentContext().getColor();
        return color;
    }

    public void setFont(String string, double d, double d2, double d3) {
        this.getCurrentContext().setFont(string, d, d2, d3);
    }

    public void setJustify(int n) {
        this.getCurrentContext().setJustify(n);
    }

    public void setScaling(double d) throws MapyrusException {
        if (d == 0.0) {
            throw new MapyrusException(MapyrusMessages.get("invalidscaling"));
        }
        if (d != 1.0) {
            this.getCurrentContext().setScaling(d);
        }
    }

    public void setTranslation(double d, double d2) {
        if (d != 0.0 || d2 != 0.0) {
            this.getCurrentContext().setTranslation(d, d2);
        }
    }

    public void setRotation(double d) {
        if (d != 0.0) {
            this.getCurrentContext().setRotation(d);
        }
    }

    public void setWorlds(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, int n, boolean bl) throws MapyrusException {
        this.getCurrentContext().setWorlds(d, d2, d3, d4, d5, d6, d7, d8, n, bl);
    }

    public void setTransform(String string, String string2) throws MapyrusException {
        this.getCurrentContext().setReprojection(string, string2);
    }

    public Argument transformToWorlds(Argument argument) throws MapyrusException {
        Argument argument2 = this.getCurrentContext().transformToWorlds(argument);
        return argument2;
    }

    public Argument transformToPage(Argument argument) throws MapyrusException {
        Argument argument2 = this.getCurrentContext().transformToPage(argument);
        return argument2;
    }

    public void setDataset(String string, String string2, String string3, InputStream inputStream) throws MapyrusException {
        GeographicDataset geographicDataset = DatasetFactory.open(string, string2, string3, inputStream);
        this.getCurrentContext().setDataset(geographicDataset);
    }

    public void setStdout(PrintStream printStream) throws IOException {
        this.getCurrentContext().setStdout(printStream);
    }

    public void moveTo(double d, double d2) throws MapyrusException {
        this.getCurrentContext().moveTo(d, d2);
    }

    public void lineTo(double d, double d2) throws MapyrusException {
        this.getCurrentContext().lineTo(d, d2);
    }

    public void rlineTo(double d, double d2) throws MapyrusException {
        this.getCurrentContext().rlineTo(d, d2);
    }

    public void arcTo(int n, double d, double d2, double d3, double d4) throws MapyrusException {
        this.getCurrentContext().arcTo(n, d, d2, d3, d4);
    }

    public void curveTo(double d, double d2, double d3, double d4, double d5, double d6) throws MapyrusException {
        this.getCurrentContext().curveTo(d, d2, d3, d4, d5, d6);
    }

    public void sineWaveTo(double d, double d2, double d3, double d4) throws MapyrusException {
        this.getCurrentContext().sineWaveTo(d, d2, d3, d4);
    }

    public void ellipseTo(double d, double d2, double d3, double d4) throws MapyrusException {
        this.getCurrentContext().ellipseTo(d, d2, d3, d4);
    }

    public void clearPath() {
        this.getCurrentContext().clearPath();
    }

    public void closePath() {
        this.getCurrentContext().closePath();
    }

    public void drawIcon(String string, double d) throws IOException, MapyrusException {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        BufferedImage bufferedImage = (BufferedImage)this.mIconCache.get(string);
        if (bufferedImage == null) {
            if (string.length() >= 3) {
                char c = string.charAt(0);
                char c2 = Character.toLowerCase(string.charAt(1));
                if (c == '#') {
                    bl = true;
                    n = 0;
                } else if (c == '0' && c2 == 'x') {
                    bl = true;
                    n = 0;
                } else if (!(c != '0' && c != '1' || c2 != '0' && c2 != '1')) {
                    bl = true;
                    n = 1;
                } else if (string.startsWith("resource:")) {
                    bl2 = true;
                    string = string.substring(9);
                }
            }
            if (bl) {
                Bitmap bitmap = new Bitmap(string, n, this.getCurrentContext().getColor());
                bufferedImage = bitmap.getBufferedImage();
            } else {
                try {
                    URL uRL;
                    if (bl2) {
                        ClassLoader classLoader = this.getClass().getClassLoader();
                        uRL = classLoader.getResource(string);
                    } else {
                        uRL = new URL(string);
                    }
                    bufferedImage = ImageIOWrapper.read(uRL, this.getCurrentContext().getColor());
                }
                catch (MalformedURLException malformedURLException) {
                    bufferedImage = ImageIOWrapper.read(new File(string), this.getCurrentContext().getColor());
                }
                if (bufferedImage == null) {
                    throw new MapyrusException(MapyrusMessages.get("invalidformat") + ": " + string);
                }
            }
            if (!bl && bufferedImage.getHeight() * bufferedImage.getWidth() <= 16384) {
                this.mIconCache.put(string, bufferedImage);
            }
        }
        this.getCurrentContext().drawIcon(bufferedImage, d);
    }

    public void drawGeoImage(String string, String string2) throws IOException, MapyrusException {
        this.getCurrentContext().drawGeoImage(string, string2);
    }

    public void drawEPS(String string, double d) throws IOException, MapyrusException {
        this.getCurrentContext().drawEPS(string, d);
    }

    public void drawSVG(String string, double d) throws IOException, MapyrusException {
        this.getCurrentContext().drawSVG(string, d);
    }

    public void addSVGCode(String string) throws IOException, MapyrusException {
        this.getCurrentContext().addSVGCode(string);
    }

    public void samplePath(double d, double d2) throws MapyrusException {
        this.getCurrentContext().samplePath(d, d2);
    }

    public void stripePath(double d, double d2) {
        this.getCurrentContext().stripePath(d, d2);
    }

    public void translatePath(double d, double d2) {
        this.getCurrentContext().translatePath(d, d2);
    }

    public void parallelPath(double[] dArray) throws MapyrusException {
        this.getCurrentContext().parallelPath(dArray);
    }

    public void selectPath(double[] dArray, double[] dArray2) throws MapyrusException {
        this.getCurrentContext().selectPath(dArray, dArray2);
    }

    public void createSinkhole() {
        this.getCurrentContext().createSinkhole();
    }

    public void guillotine(double d, double d2, double d3, double d4) throws MapyrusException {
        this.getCurrentContext().guillotine(d, d2, d3, d4);
    }

    public void protect(double d, double d2, double d3, double d4) throws MapyrusException {
        this.getCurrentContext().setPageMask(d, d2, d3, d4, 1);
    }

    public void protect(Argument argument) throws MapyrusException {
        this.getCurrentContext().setPageMask(argument, 1);
    }

    public void protect() throws MapyrusException {
        this.getCurrentContext().setPageMask(1);
    }

    public void unprotect(double d, double d2, double d3, double d4) throws MapyrusException {
        this.getCurrentContext().setPageMask(d, d2, d3, d4, 0);
    }

    public void unprotect(Argument argument) throws MapyrusException {
        this.getCurrentContext().setPageMask(argument, 0);
    }

    public void unprotect() throws MapyrusException {
        this.getCurrentContext().setPageMask(0);
    }

    public boolean isProtected(double d, double d2, double d3, double d4) throws MapyrusException {
        boolean bl = this.getCurrentContext().isPageMaskAllZero(d, d2, d3, d4);
        return !bl;
    }

    public boolean isProtected(Argument argument) throws MapyrusException {
        boolean bl = this.getCurrentContext().isPageMaskAllZero(argument);
        return !bl;
    }

    public boolean isProtected() throws MapyrusException {
        boolean bl = this.getCurrentContext().isPageMaskAllZero();
        return !bl;
    }

    public void stroke(String string) throws IOException, MapyrusException {
        this.getCurrentContext().stroke(string);
    }

    public void fill(String string) throws IOException, MapyrusException {
        this.getCurrentContext().fill(string);
    }

    public void gradientFill(Color color, Color color2, Color color3, Color color4, Color color5) throws IOException, MapyrusException {
        this.getCurrentContext().gradientFill(color, color2, color3, color4, color5);
    }

    public void setEventScript(String string) throws IOException, MapyrusException {
        this.getCurrentContext().setEventScript(string);
    }

    public void clipOutside() throws MapyrusException {
        this.getCurrentContext().clipOutside();
    }

    public void clipInside() {
        this.getCurrentContext().clipInside();
    }

    public void label(String string) throws IOException, MapyrusException {
        this.getCurrentContext().label(string);
    }

    public void flowLabel(double d, double d2, String string) throws IOException, MapyrusException {
        this.getCurrentContext().flowLabel(d, d2, string);
    }

    public void drawTable(String string, ArrayList arrayList) throws IOException, MapyrusException {
        this.getCurrentContext().drawTable(string, arrayList);
    }

    public void drawTree(String string, Argument argument) throws IOException, MapyrusException {
        this.getCurrentContext().drawTree(string, argument);
    }

    public int getMoveToCount() {
        int n = this.getCurrentContext().getMoveToCount();
        return n;
    }

    public int getLineToCount() {
        int n = this.getCurrentContext().getLineToCount();
        return n;
    }

    public ArrayList getMoveToRotations() {
        return this.getCurrentContext().getMoveToRotations();
    }

    public ArrayList getMoveTos() throws MapyrusException {
        return this.getCurrentContext().getMoveTos();
    }

    public StringDimension getStringDimension(String string) throws MapyrusException {
        StringDimension stringDimension;
        try {
            stringDimension = this.getCurrentContext().getStringDimension(string, true);
        }
        catch (IOException iOException) {
            throw new MapyrusException(iOException.getMessage());
        }
        return stringDimension;
    }

    public double getResolution() throws MapyrusException {
        double d = this.getCurrentContext().getResolution();
        return d;
    }

    public Row fetchRow() throws MapyrusException {
        Dataset dataset = this.getCurrentContext().getDataset();
        if (dataset == null) {
            throw new MapyrusException(MapyrusMessages.get("nodataset"));
        }
        return dataset.fetchRow();
    }

    public String[] getDatasetFieldNames() throws MapyrusException {
        Dataset dataset = this.getCurrentContext().getDataset();
        if (dataset == null) {
            throw new MapyrusException(MapyrusMessages.get("nodataset"));
        }
        String[] stringArray = dataset.getFieldNames();
        return stringArray;
    }

    public PrintStream getStdout() {
        return this.getCurrentContext().getStdout();
    }

    private Argument getBoundingBoxVariable(String string, Rectangle2D rectangle2D) {
        Argument argument = rectangle2D == null ? Argument.numericZero : (string.equals("min.x") ? new Argument(rectangle2D.getMinX()) : (string.equals("min.y") ? new Argument(rectangle2D.getMinY()) : (string.equals("max.x") ? new Argument(rectangle2D.getMaxX()) : (string.equals("max.y") ? new Argument(rectangle2D.getMaxY()) : (string.equals("center.x") || string.equals("centre.x") ? new Argument(rectangle2D.getCenterX()) : (string.equals("center.y") || string.equals("centre.y") ? new Argument(rectangle2D.getCenterY()) : (string.equals("width") ? new Argument(rectangle2D.getWidth()) : (string.equals("height") ? new Argument(rectangle2D.getHeight()) : null))))))));
        return argument;
    }

    private Argument setTwoDigitNumber(int n) {
        Argument argument = n >= 10 ? new Argument(1, Integer.toString(n)) : new Argument(1, "0" + Integer.toString(n));
        return argument;
    }

    /*
     * Unable to fully structure code
     */
    public Argument getVariableValue(String var1_1, String var2_2) throws MapyrusException {
        block40: {
            block38: {
                block58: {
                    block57: {
                        block56: {
                            block55: {
                                block54: {
                                    block53: {
                                        block52: {
                                            block51: {
                                                block50: {
                                                    block49: {
                                                        block48: {
                                                            block47: {
                                                                block46: {
                                                                    block45: {
                                                                        block44: {
                                                                            block43: {
                                                                                block42: {
                                                                                    block41: {
                                                                                        block39: {
                                                                                            var3_3 = null;
                                                                                            if (!var1_1.startsWith("Mapyrus.") || var1_1.length() <= "Mapyrus.".length() || var1_1.equals("Mapyrus.http.header")) break block38;
                                                                                            var5_4 = var1_1.charAt("Mapyrus.".length());
                                                                                            if (var5_4 != 'f' || !var1_1.equals("Mapyrus.fetch.more")) break block39;
                                                                                            var10_5 = this.getCurrentContext().getDataset();
                                                                                            var3_3 = var10_5 != null && var10_5.hasMoreRows() ? Argument.numericOne : Argument.numericZero;
                                                                                            break block40;
                                                                                        }
                                                                                        if (var5_4 != 'f' || !var1_1.equals("Mapyrus.fetch.count")) break block41;
                                                                                        var10_6 = this.getCurrentContext().getDataset();
                                                                                        var3_3 = var10_6 == null ? Argument.numericZero : new Argument(var10_6.getFetchCount());
                                                                                        break block40;
                                                                                    }
                                                                                    if (var5_4 != 't' || !var1_1.equals("Mapyrus.timer")) break block42;
                                                                                    var3_3 = new Argument((double)(System.currentTimeMillis() - this.mStartTime) / 1000.0);
                                                                                    break block40;
                                                                                }
                                                                                if (var5_4 != 't' || !var1_1.startsWith("Mapyrus.time.")) break block43;
                                                                                var4_11 = var1_1.substring("Mapyrus.".length() + "time.".length());
                                                                                var10_7 = new GregorianCalendar();
                                                                                if (var4_11.equals("hour")) {
                                                                                    var3_3 = this.setTwoDigitNumber(var10_7.get(11));
                                                                                } else if (var4_11.equals("minute")) {
                                                                                    var3_3 = this.setTwoDigitNumber(var10_7.get(12));
                                                                                } else if (var4_11.equals("second")) {
                                                                                    var3_3 = this.setTwoDigitNumber(var10_7.get(13));
                                                                                } else if (var4_11.equals("day")) {
                                                                                    var3_3 = this.setTwoDigitNumber(var10_7.get(5));
                                                                                } else if (var4_11.equals("day.name")) {
                                                                                    var11_17 = new SimpleDateFormat("EEEE");
                                                                                    var3_3 = new Argument(1, var11_17.format(var10_7.getTime()));
                                                                                } else if (var4_11.equals("month")) {
                                                                                    var3_3 = this.setTwoDigitNumber(var10_7.get(2) + 1);
                                                                                } else if (var4_11.equals("month.name")) {
                                                                                    var11_18 = new SimpleDateFormat("MMMM");
                                                                                    var3_3 = new Argument(1, var11_18.format(var10_7.getTime()));
                                                                                } else if (var4_11.equals("week.of.year")) {
                                                                                    var3_3 = new Argument(var10_7.get(3));
                                                                                } else if (var4_11.equals("day.of.week")) {
                                                                                    var12_24 = var10_7.get(7);
                                                                                    var11_19 = var12_24 == 2 ? 1 : (var12_24 == 3 ? 2 : (var12_24 == 4 ? 3 : (var12_24 == 5 ? 4 : (var12_24 == 6 ? 5 : (var12_24 == 7 ? 6 : 7)))));
                                                                                    var3_3 = new Argument(var11_19);
                                                                                } else {
                                                                                    var3_3 = var4_11.equals("year") ? new Argument(var10_7.get(1)) : (var4_11.equals("stamp") ? new Argument(1, var10_7.getTime().toString()) : null);
                                                                                }
                                                                                break block40;
                                                                            }
                                                                            if (var5_4 != 'v' || !var1_1.equals("Mapyrus.version")) break block44;
                                                                            var3_3 = new Argument(1, Constants.getVersion());
                                                                            break block40;
                                                                        }
                                                                        if (var5_4 != 'f' || !var1_1.equals("Mapyrus.freeMemory")) break block45;
                                                                        var3_3 = new Argument(Runtime.getRuntime().freeMemory());
                                                                        break block40;
                                                                    }
                                                                    if (var5_4 != 't' || !var1_1.equals("Mapyrus.totalMemory")) break block46;
                                                                    var3_3 = new Argument(Runtime.getRuntime().totalMemory());
                                                                    break block40;
                                                                }
                                                                if (var5_4 != 'f' || !var1_1.equals("Mapyrus.filename")) break block47;
                                                                var3_3 = new Argument(1, var2_2);
                                                                break block40;
                                                            }
                                                            if (var5_4 != 'r' || !var1_1.equals("Mapyrus.rotation")) break block48;
                                                            var3_3 = new Argument(Math.toDegrees(this.getCurrentContext().getRotation()));
                                                            break block40;
                                                        }
                                                        if (var5_4 != 's' || !var1_1.equals("Mapyrus.scale")) break block49;
                                                        var3_3 = new Argument(this.getCurrentContext().getScaling());
                                                        break block40;
                                                    }
                                                    if (var5_4 != 'k' || !var1_1.equals("Mapyrus.key.count")) break block50;
                                                    var3_3 = new Argument(this.mLegendEntries.size());
                                                    break block40;
                                                }
                                                if (var5_4 != 'k' || !var1_1.equals("Mapyrus.key.next")) break block51;
                                                var10_8 = this.mLegendEntries.first();
                                                var3_3 = var10_8 == null ? Argument.emptyString : new Argument(1, var10_8.getBlockName());
                                                break block40;
                                            }
                                            if (!var1_1.startsWith("Mapyrus.page.")) break block52;
                                            var4_12 = var1_1.substring("Mapyrus.".length() + "page".length() + 1);
                                            var3_3 = var4_12.equals("width") ? new Argument(this.getCurrentContext().getPageWidth()) : (var4_12.equals("height") ? new Argument(this.getCurrentContext().getPageHeight()) : (var4_12.equals("format") ? new Argument(1, this.getCurrentContext().getPageFormat()) : (var4_12.equals("resolution.mm") ? new Argument(this.getCurrentContext().getResolution()) : (var4_12.equals("resolution.dpi") ? new Argument(25.4 / this.getCurrentContext().getResolution()) : null))));
                                            break block40;
                                        }
                                        if (!var1_1.startsWith("Mapyrus.screen.")) break block53;
                                        var4_13 = var1_1.substring("Mapyrus.".length() + "screen".length() + 1);
                                        var3_3 = var4_13.equals("width") ? new Argument(Constants.getScreenWidth()) : (var4_13.equals("height") ? new Argument(Constants.getScreenHeight()) : (var4_13.equals("resolution.dpi") ? new Argument(Constants.getScreenResolution()) : (var4_13.equals("resolution.mm") ? new Argument(25.4 / (double)Constants.getScreenResolution()) : null)));
                                        break block40;
                                    }
                                    if (!var1_1.startsWith("Mapyrus.path.")) break block54;
                                    var4_14 = var1_1.substring("Mapyrus.".length() + "path".length() + 1);
                                    if (var4_14.equals("length")) {
                                        var3_3 = new Argument(this.getCurrentContext().getPathLength());
                                    } else if (var4_14.equals("area")) {
                                        var3_3 = new Argument(this.getCurrentContext().getPathArea());
                                    } else if (var4_14.equals("centroid.x")) {
                                        var3_3 = new Argument(this.getCurrentContext().getPathCentroid().getX());
                                    } else if (var4_14.equals("centroid.y")) {
                                        var3_3 = new Argument(this.getCurrentContext().getPathCentroid().getY());
                                    } else {
                                        var9_26 = this.getCurrentContext().getBounds2D();
                                        var3_3 = this.getBoundingBoxVariable(var4_14, var9_26);
                                    }
                                    break block40;
                                }
                                if (!var1_1.equals("Mapyrus.path")) break block55;
                                var3_3 = this.getCurrentContext().getPathArgument();
                                break block40;
                            }
                            if (!var1_1.startsWith("Mapyrus.worlds.")) break block56;
                            var9_27 = this.getCurrentContext().getWorldExtents();
                            var4_15 = var1_1.substring("Mapyrus.".length() + "worlds".length() + 1);
                            var3_3 = var4_15.equals("scale") ? new Argument(this.getCurrentContext().getWorldScale()) : this.getBoundingBoxVariable(var4_15, var9_27);
                            break block40;
                        }
                        if (!var1_1.startsWith("Mapyrus.dataset.")) break block57;
                        var10_9 = this.getCurrentContext().getDataset();
                        if (var10_9 == null) {
                            var3_3 = Argument.emptyString;
                        } else {
                            var4_16 = var1_1.substring("Mapyrus.".length() + "dataset".length() + 1);
                            if (var4_16.equals("projection")) {
                                var11_20 = var10_9.getProjection();
                                var3_3 = var11_20 == null ? Argument.emptyString : new Argument(1, var11_20);
                            } else if (var4_16.equals("fieldnames")) {
                                var11_21 = var10_9.getFieldNames();
                                var3_3 = new Argument();
                                var8_28 = 0;
                                while (var8_28 < var11_21.length) {
                                    var3_3.addHashMapEntry(String.valueOf(var8_28 + 1), new Argument(1, var11_21[var8_28]));
                                    ++var8_28;
                                }
                            } else {
                                var11_22 = var10_9.getWorlds();
                                var3_3 = this.getBoundingBoxVariable(var4_16, var11_22);
                            }
                        }
                        break block40;
                    }
                    if (!var1_1.equals("Mapyrus.imagemap.x")) break block58;
                    var3_3 = this.mImagemapPoint == null ? Argument.numericMinusOne : new Argument(this.mImagemapPoint.x);
                    break block40;
                }
                if (!var1_1.equals("Mapyrus.imagemap.y")) break block40;
                var3_3 = this.mImagemapPoint == null ? Argument.numericMinusOne : new Argument(this.mImagemapPoint.y);
                break block40;
            }
            var10_10 = (Context)this.mStack.getLast();
            if (this.mStack.size() > 1 && var10_10.hasLocalScope(var1_1)) {
                var3_3 = var10_10.getVariableValue(var1_1);
            } else {
                var10_10 = (Context)this.mStack.getFirst();
                var3_3 = var10_10.getVariableValue(var1_1);
                var11_23 = null;
                try {
                    if (var3_3 != null || (var11_23 = System.getProperty(var1_1)) == null) ** GOTO lbl174
                    var6_29 = Double.parseDouble(var11_23);
                    var3_3 = new Argument(var6_29);
                }
                catch (SecurityException var12_25) {
                }
                catch (NumberFormatException var13_30) {
                    var3_3 = new Argument(1, var11_23);
                }
            }
        }
        return var3_3;
    }

    public void setLocalScope(String string) throws MapyrusException {
        this.getCurrentContext().setLocalScope(string);
    }

    public void defineVariable(String string, Argument argument) {
        Context context = this.getCurrentContext();
        Context context2 = context.hasLocalScope(string) ? context : (Context)this.mStack.getFirst();
        context2.defineVariable(string, argument);
    }

    public void defineHashMapEntry(String string, String string2, Argument argument) {
        Context context = this.getCurrentContext();
        Context context2 = context.hasLocalScope(string) ? context : (Context)this.mStack.getFirst();
        context2.defineHashMapEntry(string, string2, argument);
    }

    public void addLegendEntry(String string, int n, Argument[] argumentArray, int n2, int n3) {
        String string2 = this.getCurrentContext().getBlockName();
        if (string2 != null) {
            this.mLegendEntries.add(string2, argumentArray, n2, n3, n, string);
        }
    }

    public LegendEntryList getLegendEntries() {
        return this.mLegendEntries;
    }

    public void setHTTPReponse(String string) {
        this.mHTTPResponse = string;
    }

    public String getHTTPResponse() {
        return this.mHTTPResponse;
    }

    public void saveState(String string) throws MapyrusException {
        this.pushContext(string);
    }

    public void restoreState() throws IOException, MapyrusException {
        this.popContext();
    }

    public void closeContextStack() throws IOException, MapyrusException {
        int n = 0;
        try {
            while ((n = this.popContext()) > 0) {
            }
        }
        catch (IOException iOException) {
            do {
                try {
                    n = this.popContext();
                }
                catch (IOException iOException2) {
                }
                catch (MapyrusException mapyrusException) {
                    // empty catch block
                }
            } while (n > 0);
            throw iOException;
        }
        catch (MapyrusException mapyrusException) {
            do {
                try {
                    n = this.popContext();
                }
                catch (IOException iOException) {
                }
                catch (MapyrusException mapyrusException2) {
                    // empty catch block
                }
            } while (n > 0);
            throw mapyrusException;
        }
    }
}

