/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.awt.geom.Rectangle2D;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.Row;
import org.mapyrus.dataset.GeographicDataset;

public class Dataset {
    private GeographicDataset mDataset;
    private Row mDatasetRow;
    private int mDatasetRowCount;

    public Dataset(GeographicDataset geographicDataset) throws MapyrusException {
        this.mDataset = geographicDataset;
        this.mDatasetRow = geographicDataset.fetch();
        this.mDatasetRowCount = 0;
    }

    public String getProjection() {
        return this.mDataset.getProjection();
    }

    public Rectangle2D.Double getWorlds() {
        return this.mDataset.getWorlds();
    }

    public String[] getFieldNames() {
        return this.mDataset.getFieldNames();
    }

    public boolean hasMoreRows() {
        return this.mDatasetRow != null;
    }

    public Row fetchRow() throws MapyrusException {
        if (this.mDatasetRow == null) {
            throw new MapyrusException(MapyrusMessages.get("norows"));
        }
        Row row = this.mDatasetRow;
        this.mDatasetRow = this.mDataset.fetch();
        ++this.mDatasetRowCount;
        return row;
    }

    public int getFetchCount() {
        return this.mDatasetRowCount;
    }

    public void close() throws MapyrusException {
        try {
            block4: {
                if (this.mDataset == null) break block4;
                this.mDataset.close();
            }
            Object var3_1 = null;
            this.mDataset = null;
            this.mDatasetRow = null;
            this.mDatasetRowCount = 0;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.mDataset = null;
            this.mDatasetRow = null;
            this.mDatasetRowCount = 0;
            throw throwable;
        }
    }
}

