/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.mapyrus.Argument;
import org.mapyrus.Constants;
import org.mapyrus.ContextStack;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.NumericalAnalysis;
import org.mapyrus.Preprocessor;
import org.mapyrus.function.Function;
import org.mapyrus.function.FunctionTable;

public class Expression {
    private static final int NO_OPERATION = 0;
    private static final int PLUS_OPERATION = 1;
    private static final int CONCAT_OPERATION = 2;
    private static final int MINUS_OPERATION = 3;
    private static final int MULTIPLY_OPERATION = 4;
    private static final int REPEAT_OPERATION = 5;
    private static final int DIVIDE_OPERATION = 6;
    private static final int MODULO_OPERATION = 7;
    private static final int LEXICAL_EQUALS_OPERATION = 100;
    private static final int LEXICAL_NOT_EQUALS_OPERATION = 101;
    private static final int LEXICAL_GREATER_THAN_OPERATION = 102;
    private static final int LEXICAL_LESS_THAN_OPERATION = 103;
    private static final int LEXICAL_GREATER_EQUAL_OPERATION = 104;
    private static final int LEXICAL_LESS_EQUAL_OPERATION = 105;
    private static final int NUMERIC_EQUALS_OPERATION = 200;
    private static final int NUMERIC_NOT_EQUALS_OPERATION = 201;
    private static final int NUMERIC_GREATER_THAN_OPERATION = 202;
    private static final int NUMERIC_LESS_THAN_OPERATION = 203;
    private static final int NUMERIC_GREATER_EQUAL_OPERATION = 204;
    private static final int NUMERIC_LESS_EQUAL_OPERATION = 205;
    private static final int CONDITIONAL_OPERATION = 300;
    private static final int ASSIGN_OPERATION = 400;
    private static final int AND_OPERATION = 500;
    private static final int OR_OPERATION = 501;
    private static final int NOT_OPERATION = 502;
    private static final int HASHMAP_REFERENCE = 600;
    ExpressionTreeNode mExprTree;

    private ExpressionTreeNode parseOrBoolean(Preprocessor preprocessor, HashMap hashMap) throws IOException, MapyrusException {
        ExpressionTreeNode expressionTreeNode;
        block2: {
            int n;
            expressionTreeNode = this.parseAndBoolean(preprocessor, hashMap);
            while ((n = preprocessor.readNonSpace()) == 111 || n == 79) {
                int n2 = preprocessor.read();
                if (n2 == 114 || n2 == 82) {
                    ExpressionTreeNode expressionTreeNode2 = this.parseAndBoolean(preprocessor, hashMap);
                    expressionTreeNode = new ExpressionTreeNode(expressionTreeNode, 501, expressionTreeNode2);
                    continue;
                }
                preprocessor.unread(n2);
                preprocessor.unread(n);
                break block2;
            }
            preprocessor.unread(n);
        }
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseAndBoolean(Preprocessor preprocessor, HashMap hashMap) throws IOException, MapyrusException {
        ExpressionTreeNode expressionTreeNode;
        block4: {
            int n;
            expressionTreeNode = this.parseNotBoolean(preprocessor, hashMap);
            while ((n = preprocessor.readNonSpace()) == 97 || n == 65) {
                int n2 = preprocessor.read();
                if (n2 == 110 || n2 == 78) {
                    int n3 = preprocessor.read();
                    if (n3 == 100 || n3 == 68) {
                        ExpressionTreeNode expressionTreeNode2 = this.parseNotBoolean(preprocessor, hashMap);
                        expressionTreeNode = new ExpressionTreeNode(expressionTreeNode, 500, expressionTreeNode2);
                        continue;
                    }
                    preprocessor.unread(n3);
                    preprocessor.unread(n2);
                    preprocessor.unread(n);
                } else {
                    preprocessor.unread(n2);
                    preprocessor.unread(n);
                }
                break block4;
            }
            preprocessor.unread(n);
        }
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseNotBoolean(Preprocessor preprocessor, HashMap hashMap) throws IOException, MapyrusException {
        ExpressionTreeNode expressionTreeNode = null;
        int n = preprocessor.readNonSpace();
        if (n == 110 || n == 78) {
            int n2 = preprocessor.read();
            if (n2 == 111 || n2 == 79) {
                int n3 = preprocessor.read();
                if (n3 == 116 || n3 == 84) {
                    int n4 = preprocessor.read();
                    if (!Character.isLetterOrDigit((char)n4) && n4 != 95 && n4 != 46) {
                        ExpressionTreeNode expressionTreeNode2 = this.parseNotBoolean(preprocessor, hashMap);
                        expressionTreeNode = new ExpressionTreeNode(expressionTreeNode2, 502, null);
                    } else {
                        preprocessor.unread(n4);
                        preprocessor.unread(n3);
                        preprocessor.unread(n2);
                        preprocessor.unread(n);
                    }
                } else {
                    preprocessor.unread(n3);
                    preprocessor.unread(n2);
                    preprocessor.unread(n);
                }
            } else {
                preprocessor.unread(n2);
                preprocessor.unread(n);
            }
        } else {
            preprocessor.unread(n);
        }
        if (expressionTreeNode == null) {
            expressionTreeNode = this.parseAssignment(preprocessor, hashMap);
        }
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseAssignment(Preprocessor preprocessor, HashMap hashMap) throws IOException, MapyrusException {
        ExpressionTreeNode expressionTreeNode;
        block3: {
            int n;
            expressionTreeNode = this.parseConditional(preprocessor, hashMap);
            while ((n = preprocessor.readNonSpace()) == 61) {
                int n2 = preprocessor.read();
                preprocessor.unread(n2);
                if (n2 != 61) {
                    if (expressionTreeNode.mIsLeaf ? expressionTreeNode.mLeafArg.getType() != 3 : expressionTreeNode.mOperation != 600) {
                        throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("variableexpected"));
                    }
                    ExpressionTreeNode expressionTreeNode2 = this.parseConditional(preprocessor, hashMap);
                    expressionTreeNode = new ExpressionTreeNode(expressionTreeNode, 400, expressionTreeNode2);
                    continue;
                }
                preprocessor.unread(n);
                break block3;
            }
            preprocessor.unread(n);
        }
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseConditional(Preprocessor preprocessor, HashMap hashMap) throws IOException, MapyrusException {
        int n;
        ExpressionTreeNode expressionTreeNode = this.parseComparison(preprocessor, hashMap);
        while ((n = preprocessor.readNonSpace()) == 63) {
            ExpressionTreeNode expressionTreeNode2 = this.parseOrBoolean(preprocessor, hashMap);
            n = preprocessor.readNonSpace();
            if (n == 58) {
                ExpressionTreeNode expressionTreeNode3 = this.parseOrBoolean(preprocessor, hashMap);
                expressionTreeNode = new ExpressionTreeNode(expressionTreeNode, 300, expressionTreeNode2, expressionTreeNode3);
                continue;
            }
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidconditional"));
        }
        preprocessor.unread(n);
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseComparison(Preprocessor preprocessor, HashMap hashMap) throws IOException, MapyrusException {
        int n;
        ExpressionTreeNode expressionTreeNode = this.parseExpression(preprocessor, hashMap);
        while (true) {
            int n2;
            int n3 = 0;
            n = preprocessor.readNonSpace();
            if (n == 60 || n == 62 || n == 33 || n == 61) {
                n2 = preprocessor.read();
                if (n2 == 61) {
                    n3 = n == 61 ? 200 : (n == 33 ? 201 : (n == 60 ? 205 : 204));
                } else {
                    preprocessor.unread(n2);
                    if (n == 60) {
                        n3 = 203;
                    } else if (n == 62) {
                        n3 = 202;
                    }
                }
            } else if (n == 108 || n == 101 || n == 103 || n == 110) {
                n2 = preprocessor.read();
                if (n == 110 && n2 == 101) {
                    n3 = 101;
                } else if (n == 101 && n2 == 113) {
                    n3 = 100;
                } else if (n == 108 && n2 == 116) {
                    n3 = 103;
                } else if (n == 108 && n2 == 101) {
                    n3 = 105;
                } else if (n == 103 && n2 == 116) {
                    n3 = 102;
                } else if (n == 103 && n2 == 101) {
                    n3 = 104;
                } else {
                    preprocessor.unread(n2);
                }
            }
            if (n3 == 0) break;
            ExpressionTreeNode expressionTreeNode2 = this.parseExpression(preprocessor, hashMap);
            expressionTreeNode = new ExpressionTreeNode(expressionTreeNode, n3, expressionTreeNode2);
        }
        preprocessor.unread(n);
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseExpression(Preprocessor preprocessor, HashMap hashMap) throws IOException, MapyrusException {
        int n;
        ExpressionTreeNode expressionTreeNode = this.parseTerm(preprocessor, hashMap);
        while ((n = preprocessor.readNonSpace()) == 43 || n == 45 || n == 46) {
            ExpressionTreeNode expressionTreeNode2 = this.parseTerm(preprocessor, hashMap);
            int n2 = n == 43 ? 1 : (n == 45 ? 3 : 2);
            expressionTreeNode = new ExpressionTreeNode(expressionTreeNode, n2, expressionTreeNode2);
        }
        preprocessor.unread(n);
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseTerm(Preprocessor preprocessor, HashMap hashMap) throws IOException, MapyrusException {
        int n;
        ExpressionTreeNode expressionTreeNode = this.parseUnary(preprocessor, hashMap);
        while ((n = preprocessor.readNonSpace()) == 42 || n == 47 || n == 120 || n == 37) {
            int n2 = n == 42 ? 4 : (n == 47 ? 6 : (n == 37 ? 7 : 5));
            ExpressionTreeNode expressionTreeNode2 = this.parseUnary(preprocessor, hashMap);
            expressionTreeNode = new ExpressionTreeNode(expressionTreeNode, n2, expressionTreeNode2);
        }
        preprocessor.unread(n);
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseUnary(Preprocessor preprocessor, HashMap hashMap) throws IOException, MapyrusException {
        int n = preprocessor.readNonSpace();
        if (n != 43 && n != 45) {
            preprocessor.unread(n);
        }
        ExpressionTreeNode expressionTreeNode = this.parseHashMapReference(preprocessor, hashMap);
        if (n == 45) {
            ExpressionTreeNode expressionTreeNode2 = new ExpressionTreeNode(Argument.numericMinusOne);
            expressionTreeNode = new ExpressionTreeNode(expressionTreeNode2, 4, expressionTreeNode);
        }
        return expressionTreeNode;
    }

    private ExpressionTreeNode parseHashMapReference(Preprocessor preprocessor, HashMap hashMap) throws IOException, MapyrusException {
        int n;
        ExpressionTreeNode expressionTreeNode = this.parseFactor(preprocessor, hashMap);
        while ((n = preprocessor.readNonSpace()) == 91) {
            ExpressionTreeNode expressionTreeNode2 = this.parseOrBoolean(preprocessor, hashMap);
            n = preprocessor.readNonSpace();
            if (n != 93) {
                throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": ']'");
            }
            expressionTreeNode = new ExpressionTreeNode(expressionTreeNode, 600, expressionTreeNode2);
        }
        preprocessor.unread(n);
        return expressionTreeNode;
    }

    /*
     * Unable to fully structure code
     */
    private ExpressionTreeNode parseFactor(Preprocessor var1_1, HashMap var2_2) throws IOException, MapyrusException {
        block42: {
            block43: {
                var4_3 = new StringBuffer();
                var6_4 = var1_1.readNonSpace();
                if (var6_4 == 39 || var6_4 == 34) {
                    var7_5 = var6_4;
                    var9_6 = false;
                    var8_7 = false;
                    var11_8 = 0;
                    var10_9 = 0;
                    while ((var6_4 = var1_1.read()) != var7_5 || var9_6) {
                        if (var6_4 == -1) {
                            throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
                        }
                        if (var8_7) {
                            if (Character.isDigit((char)var6_4) && var11_8 < 3) {
                                var10_9 *= 8;
                                var10_9 += var6_4 - 48;
                                ++var11_8;
                            } else {
                                var4_3.append((char)var10_9);
                                var8_7 = false;
                            }
                        }
                        if (var8_7) continue;
                        if (var9_6) {
                            if (var6_4 == 110) {
                                var4_3.append(Constants.LINE_SEPARATOR);
                            } else if (var6_4 == 116) {
                                var4_3.append("\t");
                            } else if (Character.isDigit((char)var6_4)) {
                                var8_7 = true;
                                var10_9 = var6_4 - 48;
                                var11_8 = 1;
                            } else if (var6_4 != 114) {
                                var4_3.append((char)var6_4);
                            }
                            var9_6 = false;
                            continue;
                        }
                        if (var6_4 == 92) {
                            var9_6 = true;
                            continue;
                        }
                        var4_3.append((char)var6_4);
                    }
                    if (var8_7) {
                        var4_3.append((char)var10_9);
                    }
                    return new ExpressionTreeNode(new Argument(1, var4_3.toString()));
                }
                if (!Character.isDigit((char)var6_4) && var6_4 != 46) break block42;
                var3_10 = false;
                while (Character.isDigit((char)var6_4)) {
                    var3_10 = true;
                    var4_3.append((char)var6_4);
                    var6_4 = var1_1.read();
                }
                if (var6_4 == 46) {
                    var4_3.append((char)var6_4);
                    var6_4 = var1_1.read();
                }
                while (Character.isDigit((char)var6_4)) {
                    var3_10 = true;
                    var4_3.append((char)var6_4);
                    var6_4 = var1_1.read();
                }
                if (!var3_10) {
                    throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidnumber"));
                }
                if (var6_4 != 101 && var6_4 != 69) break block43;
                var4_3.append((char)var6_4);
                var6_4 = var1_1.read();
                if (var6_4 == 43 || var6_4 == 45) {
                    var4_3.append((char)var6_4);
                    var6_4 = var1_1.read();
                }
                if (Character.isDigit((char)var6_4)) ** GOTO lbl84
                throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidnumber"));
lbl-1000:
                // 1 sources

                {
                    var4_3.append((char)var6_4);
                    var6_4 = var1_1.read();
lbl84:
                    // 2 sources

                    ** while (Character.isDigit((char)((char)var6_4)))
                }
            }
            var1_1.unread(var6_4);
            var12_11 = 0.0;
            try {
                var12_11 = Double.parseDouble(var4_3.toString());
            }
            catch (NumberFormatException var14_13) {
                // empty catch block
            }
            return new ExpressionTreeNode(new Argument(var12_11));
        }
        if (var6_4 == -1) {
            throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (var6_4 == 40) {
            var5_15 = this.parseOrBoolean(var1_1, var2_2);
            var6_4 = var1_1.readNonSpace();
            if (var6_4 != 41) {
                throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unmatchedbracket"));
            }
        } else if (Character.isLetter((char)var6_4) || var6_4 == 36) {
            var4_3.append((char)var6_4);
            var6_4 = var1_1.read();
            while (var6_4 != -1 && (var6_4 == 46 || var6_4 == 95 || var6_4 == 58 || Character.isLetterOrDigit((char)var6_4))) {
                var4_3.append((char)var6_4);
                var6_4 = var1_1.read();
            }
            var12_12 = FunctionTable.getFunction(var4_3.toString());
            if (var12_12 == null) {
                var12_12 = (Function)var2_2.get(var4_3.toString());
            }
            if (var12_12 != null) {
                if (Character.isWhitespace((char)var6_4)) {
                    var6_4 = var1_1.readNonSpace();
                }
                if (var6_4 != 40) {
                    throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": '('");
                }
                var13_16 = var12_12.getMinArgumentCount();
                var14_14 = var12_12.getMaxArgumentCount();
                var15_17 = new ArrayList<ExpressionTreeNode>(4);
                var16_18 = 0;
                while (var16_18 < var14_14) {
                    var6_4 = var1_1.readNonSpace();
                    if (var16_18 >= var13_16 && var6_4 == 41) {
                        var1_1.unread(var6_4);
                        break;
                    }
                    if (var16_18 == 0) {
                        var1_1.unread(var6_4);
                    } else if (var6_4 != 44) {
                        throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("wrongfunctionvalues") + ": " + var4_3.toString());
                    }
                    var17_19 = this.parseOrBoolean(var1_1, var2_2);
                    var15_17.add(var17_19);
                    ++var16_18;
                }
                var6_4 = var1_1.readNonSpace();
                if (var6_4 != 41) {
                    throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("wrongfunctionvalues") + ": " + var4_3.toString());
                }
                var5_15 = new ExpressionTreeNode(var12_12, var15_17);
            } else {
                var1_1.unread(var6_4);
                var5_15 = new ExpressionTreeNode(new Argument(3, var4_3.toString()));
            }
        } else {
            throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidexpression"));
        }
        return var5_15;
    }

    public Expression(Preprocessor preprocessor, HashMap hashMap) throws IOException, MapyrusException {
        this.mExprTree = this.parseOrBoolean(preprocessor, hashMap);
    }

    public Expression(double d) {
        this.mExprTree = new ExpressionTreeNode(new Argument(d));
    }

    public Expression(String string) {
        this.mExprTree = new ExpressionTreeNode(new Argument(1, string));
    }

    public Argument evaluate(ContextStack contextStack, String string) throws MapyrusException {
        return this.mExprTree.evaluate(contextStack, string);
    }

    public String getVariableName() {
        if (this.mExprTree.mIsLeaf && this.mExprTree.mLeafArg.getType() == 3) {
            return this.mExprTree.mLeafArg.getVariableName();
        }
        return null;
    }

    public static void main(String[] stringArray) {
        block7: {
            try {
                ContextStack contextStack = new ContextStack();
                HashMap hashMap = new HashMap();
                contextStack.defineVariable("pi", new Argument(3.1415));
                Preprocessor preprocessor = new Preprocessor(stringArray[0]);
                Expression expression = new Expression(preprocessor, hashMap);
                preprocessor.read();
                Expression expression2 = new Expression(preprocessor, hashMap);
                Argument argument = expression.evaluate(contextStack, "test");
                Argument argument2 = expression2.evaluate(contextStack, "test");
                if (argument.getType() == 0) {
                    System.out.println("a1=" + argument.getNumericValue());
                } else {
                    System.out.println("a1 = " + argument.getStringValue());
                }
                if (argument2.getType() == 0) {
                    System.out.println("a2=" + argument2.getNumericValue());
                    break block7;
                }
                System.out.println("a2 = " + argument2.getStringValue());
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            catch (MapyrusException mapyrusException) {}
        }
    }

    private class ExpressionTreeNode {
        boolean mIsLeaf;
        Argument mLeafArg;
        int mOperation;
        ArrayList mBranches;
        boolean mIsFunction;
        Function mFunction;

        public ExpressionTreeNode(Argument argument) {
            this.mIsLeaf = true;
            this.mIsFunction = false;
            this.mLeafArg = argument;
        }

        public ExpressionTreeNode(ExpressionTreeNode expressionTreeNode, int n, ExpressionTreeNode expressionTreeNode2) {
            this.mIsFunction = false;
            this.mIsLeaf = false;
            this.mBranches = new ArrayList(2);
            this.mBranches.add(expressionTreeNode);
            this.mBranches.add(expressionTreeNode2);
            this.mOperation = n;
        }

        public ExpressionTreeNode(ExpressionTreeNode expressionTreeNode, int n, ExpressionTreeNode expressionTreeNode2, ExpressionTreeNode expressionTreeNode3) {
            this.mIsFunction = false;
            this.mIsLeaf = false;
            this.mBranches = new ArrayList(3);
            this.mBranches.add(expressionTreeNode);
            this.mBranches.add(expressionTreeNode2);
            this.mBranches.add(expressionTreeNode3);
            this.mOperation = n;
        }

        public ExpressionTreeNode(Function function, ArrayList arrayList) {
            this.mIsLeaf = false;
            this.mIsFunction = true;
            this.mFunction = function;
            this.mBranches = arrayList;
        }

        public Argument evaluate(ContextStack contextStack, String string) throws MapyrusException {
            return this.traverse(this, contextStack, string);
        }

        private Argument evaluateFunction(ContextStack contextStack, String string) throws MapyrusException {
            Argument argument;
            int n = this.mBranches.size();
            ArrayList<Argument> arrayList = new ArrayList<Argument>(n);
            int n2 = 0;
            while (n2 < n) {
                ExpressionTreeNode expressionTreeNode = (ExpressionTreeNode)this.mBranches.get(n2);
                arrayList.add(this.traverse(expressionTreeNode, contextStack, string));
                ++n2;
            }
            try {
                argument = this.mFunction.evaluate(contextStack, arrayList);
            }
            catch (MapyrusException mapyrusException) {
                throw new MapyrusException(this.mFunction.getName() + ": " + mapyrusException.getMessage());
            }
            return argument;
        }

        private Argument traverse(ExpressionTreeNode expressionTreeNode, ContextStack contextStack, String string) throws MapyrusException {
            Argument argument;
            boolean bl = false;
            double d = 0.0;
            String string2 = null;
            if (expressionTreeNode.mIsLeaf) {
                if (expressionTreeNode.mLeafArg.getType() == 3) {
                    argument = contextStack.getVariableValue(expressionTreeNode.mLeafArg.getVariableName(), string);
                    if (argument == null) {
                        argument = Argument.emptyString;
                    }
                } else {
                    argument = expressionTreeNode.mLeafArg;
                }
            } else if (expressionTreeNode.mIsFunction) {
                argument = expressionTreeNode.evaluateFunction(contextStack, string);
            } else if (expressionTreeNode.mOperation == 502) {
                double d2;
                ExpressionTreeNode expressionTreeNode2 = (ExpressionTreeNode)expressionTreeNode.mBranches.get(0);
                Argument argument2 = this.traverse(expressionTreeNode2, contextStack, string);
                argument = argument2.getType() == 0 ? (NumericalAnalysis.equals(d2 = argument2.getNumericValue(), 0.0) ? Argument.numericOne : Argument.numericZero) : (argument2.getStringValue().length() == 0 ? Argument.numericOne : Argument.numericZero);
            } else if (expressionTreeNode.mOperation == 400) {
                ExpressionTreeNode expressionTreeNode3 = (ExpressionTreeNode)expressionTreeNode.mBranches.get(0);
                ExpressionTreeNode expressionTreeNode4 = (ExpressionTreeNode)expressionTreeNode.mBranches.get(1);
                Argument argument3 = this.traverse(expressionTreeNode4, contextStack, string);
                if (expressionTreeNode3.mIsLeaf) {
                    String string3 = expressionTreeNode3.mLeafArg.getVariableName();
                    contextStack.defineVariable(string3, argument3);
                } else if (expressionTreeNode3.mOperation == 600 && ((ExpressionTreeNode)expressionTreeNode3.mBranches.get((int)0)).mIsLeaf) {
                    String string4 = ((ExpressionTreeNode)expressionTreeNode3.mBranches.get((int)0)).mLeafArg.getVariableName();
                    if (string4 == null) {
                        throw new MapyrusException(MapyrusMessages.get("invalidvariable"));
                    }
                    Argument argument4 = this.traverse((ExpressionTreeNode)expressionTreeNode3.mBranches.get(1), contextStack, string);
                    if (argument4.getType() != 0 && argument4.getType() != 1) {
                        throw new MapyrusException(MapyrusMessages.get("invalidhashmapkey"));
                    }
                    contextStack.defineHashMapEntry(string4, argument4.getStringValue(), argument3);
                } else {
                    throw new MapyrusException(MapyrusMessages.get("invalidvariable"));
                }
                argument = argument3;
            } else if (expressionTreeNode.mOperation == 600) {
                Argument argument5;
                Object object;
                ExpressionTreeNode expressionTreeNode5 = (ExpressionTreeNode)expressionTreeNode.mBranches.get(0);
                ExpressionTreeNode expressionTreeNode6 = (ExpressionTreeNode)expressionTreeNode.mBranches.get(1);
                if (expressionTreeNode5.mIsLeaf && expressionTreeNode5.mLeafArg.getType() == 3) {
                    object = expressionTreeNode5.mLeafArg.getVariableName();
                    argument5 = contextStack.getVariableValue((String)object, string);
                } else if (expressionTreeNode5.mIsFunction) {
                    argument5 = this.traverse(expressionTreeNode5, contextStack, string);
                } else {
                    throw new MapyrusException(MapyrusMessages.get("variableexpected"));
                }
                object = this.traverse(expressionTreeNode6, contextStack, string);
                if (((Argument)object).getType() != 0 && ((Argument)object).getType() != 1) {
                    throw new MapyrusException(MapyrusMessages.get("invalidhashmapkey"));
                }
                argument = argument5 == null || argument5.getType() != 2 ? Argument.emptyString : argument5.getHashMapEntry(((Argument)object).getStringValue());
            } else if (expressionTreeNode.mOperation == 300) {
                ExpressionTreeNode expressionTreeNode7 = (ExpressionTreeNode)expressionTreeNode.mBranches.get(0);
                Argument argument6 = this.traverse(expressionTreeNode7, contextStack, string);
                if (argument6.getNumericValue() != 0.0) {
                    ExpressionTreeNode expressionTreeNode8 = (ExpressionTreeNode)expressionTreeNode.mBranches.get(1);
                    argument = this.traverse(expressionTreeNode8, contextStack, string);
                } else {
                    ExpressionTreeNode expressionTreeNode9 = (ExpressionTreeNode)expressionTreeNode.mBranches.get(2);
                    argument = this.traverse(expressionTreeNode9, contextStack, string);
                }
            } else {
                ExpressionTreeNode expressionTreeNode10 = (ExpressionTreeNode)expressionTreeNode.mBranches.get(0);
                ExpressionTreeNode expressionTreeNode11 = (ExpressionTreeNode)expressionTreeNode.mBranches.get(1);
                Argument argument7 = this.traverse(expressionTreeNode10, contextStack, string);
                Argument argument8 = this.traverse(expressionTreeNode11, contextStack, string);
                switch (expressionTreeNode.mOperation) {
                    case 1: {
                        d = argument7.getNumericValue() + argument8.getNumericValue();
                        bl = false;
                        break;
                    }
                    case 2: {
                        string2 = argument7.toString() + argument8.toString();
                        bl = true;
                        break;
                    }
                    case 3: {
                        d = argument7.getNumericValue() - argument8.getNumericValue();
                        bl = false;
                        break;
                    }
                    case 4: {
                        d = argument7.getNumericValue() * argument8.getNumericValue();
                        bl = false;
                        break;
                    }
                    case 5: {
                        StringBuffer stringBuffer = new StringBuffer();
                        int n = (int)Math.floor(argument8.getNumericValue());
                        int n2 = 0;
                        while (n2 < n) {
                            stringBuffer.append(argument7.toString());
                            ++n2;
                        }
                        string2 = stringBuffer.toString();
                        bl = true;
                        break;
                    }
                    case 6: {
                        d = argument7.getNumericValue() / argument8.getNumericValue();
                        bl = false;
                        break;
                    }
                    case 7: {
                        d = NumericalAnalysis.fmod(argument7.getNumericValue(), argument8.getNumericValue());
                        bl = false;
                        break;
                    }
                    case 200: {
                        double d3 = argument7.getNumericValue();
                        double d4 = argument8.getNumericValue();
                        d = NumericalAnalysis.equals(d3, d4) ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 201: {
                        double d5 = argument7.getNumericValue();
                        double d6 = argument8.getNumericValue();
                        d = NumericalAnalysis.equals(d5, d6) ? 0.0 : 1.0;
                        bl = false;
                        break;
                    }
                    case 202: {
                        double d7 = argument7.getNumericValue();
                        double d8 = argument8.getNumericValue();
                        d = d7 > d8 && !NumericalAnalysis.equals(d7, d8) ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 204: {
                        double d9 = argument7.getNumericValue();
                        double d10 = argument8.getNumericValue();
                        d = d9 > d10 || NumericalAnalysis.equals(d9, d10) ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 203: {
                        double d11 = argument7.getNumericValue();
                        double d12 = argument8.getNumericValue();
                        d = d11 < d12 && !NumericalAnalysis.equals(d11, d12) ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 205: {
                        double d13 = argument7.getNumericValue();
                        double d14 = argument8.getNumericValue();
                        d = d13 < d14 || NumericalAnalysis.equals(d13, d14) ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 500: {
                        d = argument7.getNumericValue() != 0.0 && argument8.getNumericValue() != 0.0 ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 501: {
                        d = argument7.getNumericValue() != 0.0 || argument8.getNumericValue() != 0.0 ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 100: {
                        d = argument7.toString().equals(argument8.toString()) ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 101: {
                        d = argument7.toString().equals(argument8.toString()) ? 0.0 : 1.0;
                        bl = false;
                        break;
                    }
                    case 102: {
                        d = argument7.toString().compareTo(argument8.toString()) > 0 ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 104: {
                        d = argument7.toString().compareTo(argument8.toString()) >= 0 ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 103: {
                        d = argument7.toString().compareTo(argument8.toString()) < 0 ? 1.0 : 0.0;
                        bl = false;
                        break;
                    }
                    case 105: {
                        d = argument7.toString().compareTo(argument8.toString()) <= 0 ? 1.0 : 0.0;
                        bl = false;
                    }
                }
                if (!bl) {
                    if (Double.isInfinite(d) || Double.isNaN(d)) {
                        throw new MapyrusException(MapyrusMessages.get("numericoverflow"));
                    }
                    argument = d == 0.0 ? Argument.numericZero : (d == 1.0 ? Argument.numericOne : new Argument(d));
                } else {
                    argument = string2.length() == 0 ? Argument.emptyString : new Argument(1, string2);
                }
            }
            return argument;
        }

        public String toString() {
            String string;
            if (this.mIsLeaf) {
                string = this.mLeafArg.toString();
            } else {
                ExpressionTreeNode expressionTreeNode;
                String string2 = "";
                switch (this.mOperation) {
                    case 1: {
                        string2 = "+";
                        break;
                    }
                    case 2: {
                        string2 = ".";
                        break;
                    }
                    case 3: {
                        string2 = "-";
                        break;
                    }
                    case 4: {
                        string2 = "*";
                        break;
                    }
                    case 5: {
                        string2 = "x";
                        break;
                    }
                    case 6: {
                        string2 = "/";
                        break;
                    }
                    case 7: {
                        string2 = "%";
                        break;
                    }
                    case 100: {
                        string2 = "eq";
                        break;
                    }
                    case 101: {
                        string2 = "ne";
                        break;
                    }
                    case 102: {
                        string2 = "gt";
                        break;
                    }
                    case 103: {
                        string2 = "lt";
                        break;
                    }
                    case 104: {
                        string2 = "ge";
                        break;
                    }
                    case 105: {
                        string2 = "le";
                        break;
                    }
                    case 200: {
                        string2 = "==";
                        break;
                    }
                    case 201: {
                        string2 = "!=";
                        break;
                    }
                    case 202: {
                        string2 = ">";
                        break;
                    }
                    case 203: {
                        string2 = "<";
                        break;
                    }
                    case 204: {
                        string2 = ">=";
                        break;
                    }
                    case 205: {
                        string2 = "<=";
                        break;
                    }
                    case 300: {
                        string2 = "?";
                        break;
                    }
                    case 400: {
                        string2 = "=";
                        break;
                    }
                    case 500: {
                        string2 = "and";
                        break;
                    }
                    case 501: {
                        string2 = "or";
                        break;
                    }
                    case 502: {
                        string2 = "not";
                        break;
                    }
                    case 600: {
                        string2 = "[";
                    }
                }
                StringBuffer stringBuffer = new StringBuffer();
                ExpressionTreeNode expressionTreeNode2 = (ExpressionTreeNode)this.mBranches.get(0);
                stringBuffer.append(expressionTreeNode2.toString());
                stringBuffer.append(' ');
                stringBuffer.append(string2);
                stringBuffer.append(' ');
                if (this.mOperation != 502) {
                    expressionTreeNode = (ExpressionTreeNode)this.mBranches.get(1);
                    stringBuffer.append(expressionTreeNode.toString());
                }
                if (this.mOperation == 600) {
                    stringBuffer.append(']');
                }
                if (this.mOperation == 300) {
                    expressionTreeNode = (ExpressionTreeNode)this.mBranches.get(2);
                    stringBuffer.append(" : ").append(expressionTreeNode.toString());
                }
                string = stringBuffer.toString();
            }
            return string;
        }
    }
}

