/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.mapyrus.Argument;
import org.mapyrus.Constants;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.NumericalAnalysis;
import org.mapyrus.geom.LineEquation;

public class GeometricPath {
    static final int CALCULATE_LENGTHS = 1;
    static final int CALCULATE_AREAS = 2;
    static final int CALCULATE_CENTROID = 3;
    static final int CALCULATE_PIP = 4;
    private static final double ONE_OVER_SQRT_TWO = 0.707106781186547;
    static AffineTransform mIdentityMatrix = new AffineTransform();
    private GeneralPath mPath;
    private ArrayList mRotations;
    private ArrayList mMoveTos;
    private int mNLineTos;

    public GeometricPath() {
        this.mPath = new GeneralPath();
        this.mRotations = new ArrayList();
        this.mMoveTos = new ArrayList();
        this.mNLineTos = 0;
    }

    public GeometricPath(GeometricPath geometricPath) {
        this.mPath = (GeneralPath)geometricPath.mPath.clone();
        this.mNLineTos = geometricPath.mNLineTos;
        this.mMoveTos = (ArrayList)geometricPath.mMoveTos.clone();
        this.mRotations = (ArrayList)geometricPath.mRotations.clone();
    }

    public void moveTo(float f, float f2, double d) {
        this.mPath.moveTo(f, f2);
        this.mMoveTos.add(new Point2D.Float(f, f2));
        this.mRotations.add(new Double(d));
    }

    public void lineTo(float f, float f2) {
        this.mPath.lineTo(f, f2);
        ++this.mNLineTos;
    }

    public void arcTo(int n, float f, float f2, float f3, float f4) throws MapyrusException {
        Point2D point2D = this.mPath.getCurrentPoint();
        if (point2D == null) {
            throw new MapyrusException(MapyrusMessages.get("noarcstart"));
        }
        float f5 = (float)point2D.getX();
        float f6 = (float)point2D.getY();
        if (NumericalAnalysis.equals(f5, f3) && NumericalAnalysis.equals(f6, f4)) {
            f3 = f5;
            f4 = f6;
        }
        double d = Point2D.distance(f, f2, f3, f4);
        Arc2D.Float float_ = new Arc2D.Float();
        float_.setArcByCenter(f, f2, d, 0.0, 1.0, 0);
        float_.setAngles(f5, f6, f3, f4);
        if ((double)n < 0.0) {
            float_.setAngleExtent(float_.getAngleExtent() - 360.0);
        }
        this.mPath.append(float_, true);
        ++this.mNLineTos;
    }

    public void curveTo(float f, float f2, float f3, float f4, float f5, float f6) throws MapyrusException {
        Point2D point2D = this.mPath.getCurrentPoint();
        if (point2D == null) {
            throw new MapyrusException(MapyrusMessages.get("nobezierstart"));
        }
        this.mPath.curveTo(f, f2, f3, f4, f5, f6);
        ++this.mNLineTos;
    }

    public void ellipseTo(double d, double d2, double d3, double d4, double d5) {
        Point2D point2D;
        Ellipse2D.Double double_ = new Ellipse2D.Double(d - d3 / 2.0, d2 - d4 / 2.0, d3, d4);
        if (d5 != 0.0) {
            GeneralPath generalPath = new GeneralPath(double_);
            AffineTransform affineTransform = AffineTransform.getRotateInstance(d5, d, d2);
            generalPath.transform(affineTransform);
            this.mPath.append(generalPath, false);
            point2D = generalPath.getCurrentPoint();
        } else {
            this.mPath.append(double_, false);
            point2D = new Point2D.Float((float)(d + d3), (float)d2);
        }
        this.mMoveTos.add(point2D);
        ++this.mNLineTos;
    }

    public void closePath() {
        this.mPath.closePath();
        ++this.mNLineTos;
    }

    public void append(GeometricPath geometricPath, boolean bl) {
        this.mPath.append(geometricPath.getShape(), bl);
        ArrayList arrayList = geometricPath.getMoveTos();
        ArrayList arrayList2 = geometricPath.getMoveToRotations();
        int n = 0;
        while (n < arrayList.size()) {
            this.mMoveTos.add(arrayList.get(n));
            this.mRotations.add(arrayList2.get(n));
            ++n;
        }
    }

    public int getMoveToCount() {
        return this.mMoveTos.size();
    }

    public int getLineToCount() {
        return this.mNLineTos;
    }

    public ArrayList getMoveTos() {
        return this.mMoveTos;
    }

    public ArrayList getMoveToRotations() {
        return this.mRotations;
    }

    public Rectangle2D getBounds2D() {
        return this.mPath.getBounds2D();
    }

    public GeneralPath getShape() {
        return this.mPath;
    }

    public ArrayList getSubPathPoints(double d, double d2) {
        double d3;
        float[] fArray = new float[6];
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        boolean bl = false;
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        double d11 = 0.0;
        PathIterator pathIterator = this.mPath.getPathIterator(Constants.IDENTITY_MATRIX, 25.4 / (double)Constants.getScreenResolution());
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            if (n == 0) {
                d5 = d9 = (double)fArray[0];
                d6 = d10 = (double)fArray[1];
            } else {
                if (n == 4) {
                    d7 = d9;
                    d8 = d10;
                } else {
                    d7 = fArray[0];
                    d8 = fArray[1];
                }
                d3 = Math.sqrt((d7 - d5) * (d7 - d5) + (d8 - d6) * (d8 - d6));
                if (d4 + d3 >= d) {
                    double d12;
                    int n2 = arrayList.size();
                    if (n2 == 0) {
                        if (d3 > 0.0) {
                            d12 = (d - d4) / d3;
                            if (d12 < 0.0) {
                                d3 += -d12 * d3;
                            }
                        } else {
                            d12 = 0.0;
                        }
                        d5 += d12 * (d7 - d5);
                        d6 += d12 * (d8 - d6);
                        arrayList.add(new Point2D.Double(d5, d6));
                        bl = true;
                    }
                    if (bl) {
                        if (d4 + d3 > d + d2) {
                            d12 = d3 > 0.0 ? (d + d2 - d4) / d3 : 0.0;
                            d5 += d12 * (d7 - d5);
                            d6 += d12 * (d8 - d6);
                            arrayList.add(new Point2D.Double(d5, d6));
                            bl = false;
                        } else {
                            arrayList.add(new Point2D.Double(d7, d8));
                            d11 = Math.atan2(d8 - d6, d7 - d5);
                        }
                    }
                }
                d4 += d3;
                d5 = d7;
                d6 = d8;
            }
            pathIterator.next();
        }
        if (bl) {
            d3 = d + d2 - d4;
            arrayList.add(new Point2D.Double(d7 += Math.cos(d11) * d3, d8 += Math.sin(d11) * d3));
        }
        return arrayList;
    }

    public void reset() {
        this.mPath.reset();
        this.mRotations.clear();
        this.mMoveTos.clear();
        this.mNLineTos = 0;
    }

    public double getArea(double d) {
        double d2 = 0.0;
        double[] dArray = this.walkPath(2, d);
        int n = 0;
        while (n < dArray.length) {
            d2 += dArray[n];
            ++n;
        }
        return Math.abs(d2);
    }

    public double getLength(double d) {
        double d2 = 0.0;
        double[] dArray = this.walkPath(1, d);
        int n = 0;
        while (n < dArray.length) {
            d2 += dArray[n];
            ++n;
        }
        return d2;
    }

    public Point2D.Double getCentroid(double d) {
        double[] dArray = this.walkPath(3, d);
        return new Point2D.Double(dArray[0], dArray[1]);
    }

    public boolean isClockwise(double d) {
        double[] dArray = this.walkPath(2, d);
        return dArray[0] < 0.0;
    }

    private double[] walkPath(int n, double d) {
        double[] dArray;
        PathIterator pathIterator = this.mPath.getPathIterator(mIdentityMatrix, d);
        float[] fArray = new float[6];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        int n2 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n3 = n == 3 ? 2 : this.getMoveToCount();
        double[] dArray2 = dArray = new double[n3];
        double[] dArray3 = dArray;
        int n4 = 0;
        while (n4 < dArray.length) {
            dArray[n4] = 0.0;
            ++n4;
        }
        while (!pathIterator.isDone()) {
            int n5 = pathIterator.currentSegment(fArray);
            if (n5 == 0) {
                f = f3 = fArray[0];
                f2 = f4 = fArray[1];
                ++n2;
            } else {
                float f5;
                float f6;
                if (n5 == 4) {
                    f6 = f3;
                    f5 = f4;
                } else {
                    f6 = fArray[0];
                    f5 = fArray[1];
                }
                if (n == 1) {
                    int n6 = n2 - 1;
                    dArray[n6] = dArray[n6] + Math.sqrt((f6 - f) * (f6 - f) + (f5 - f2) * (f5 - f2));
                } else if (n == 2) {
                    int n7 = n2 - 1;
                    dArray2[n7] = dArray2[n7] + (double)(f * f5 - f6 * f2) / 2.0;
                } else if (n == 3) {
                    double d5 = f * f5 - f6 * f2;
                    d4 += d5;
                    d3 += (double)(f6 + f) * d5;
                    d2 += (double)(f5 + f2) * d5;
                }
                f = f6;
                f2 = f5;
            }
            pathIterator.next();
        }
        if (n == 3) {
            dArray3[0] = d3 / (3.0 * d4);
            dArray3[1] = d2 / (3.0 * d4);
        }
        return dArray;
    }

    public Argument toArgument(double d) {
        Argument argument;
        int n = this.mMoveTos.size();
        if (n == 0) {
            argument = Argument.emptyGeometry;
        } else if (this.mNLineTos == 0) {
            double[] dArray;
            if (n == 1) {
                Point2D.Float float_ = (Point2D.Float)this.mMoveTos.get(0);
                dArray = new double[]{100.0, 1.0, 0.0, float_.x, float_.y};
            } else {
                dArray = new double[2 + n * 5];
                dArray[0] = 103.0;
                dArray[1] = n;
                int n2 = 2;
                int n3 = 0;
                while (n3 < n) {
                    Point2D.Float float_ = (Point2D.Float)this.mMoveTos.get(n3);
                    dArray[n2++] = 100.0;
                    dArray[n2++] = 1.0;
                    dArray[n2++] = 0.0;
                    dArray[n2++] = float_.x;
                    dArray[n2++] = float_.y;
                    ++n3;
                }
            }
            argument = new Argument((int)dArray[0], dArray);
        } else {
            int n4;
            float[] fArray = new float[6];
            PathIterator pathIterator = this.mPath.getPathIterator(mIdentityMatrix, d);
            int n5 = 2;
            while (!pathIterator.isDone()) {
                n4 = pathIterator.currentSegment(fArray);
                n5 = n4 == 0 ? (n5 += 5) : (n5 += 3);
                pathIterator.next();
            }
            double[] dArray = new double[n5];
            boolean bl = false;
            double d2 = Double.MAX_VALUE;
            double d3 = Double.MAX_VALUE;
            double d4 = d2;
            double d5 = d3;
            int n6 = 0;
            int n7 = 0;
            n5 = 0;
            int n8 = 0;
            int n9 = 0;
            pathIterator = this.mPath.getPathIterator(mIdentityMatrix, d);
            while (!pathIterator.isDone()) {
                n4 = pathIterator.currentSegment(fArray);
                if (n4 == 0) {
                    if (n5 > 0) {
                        if (d4 == d2 && d5 == d3) {
                            bl = true;
                        }
                        if (bl) {
                            dArray[n9] = 102.0;
                            ++n6;
                        } else {
                            dArray[n9] = 101.0;
                            ++n7;
                        }
                        dArray[n9 + 1] = n5;
                        n9 = n8;
                    }
                    n5 = 1;
                    bl = false;
                    dArray[n8 += 2] = 0.0;
                    dArray[n8 + 1] = d2 = (double)fArray[0];
                    dArray[n8 + 2] = d3 = (double)fArray[1];
                    n8 += 3;
                } else if (n4 == 4) {
                    bl = true;
                    dArray[n8] = 1.0;
                    dArray[n8 + 1] = d2;
                    dArray[n8 + 2] = d3;
                    n8 += 3;
                    ++n5;
                } else {
                    dArray[n8] = 1.0;
                    dArray[n8 + 1] = fArray[0];
                    dArray[n8 + 2] = fArray[1];
                    n8 += 3;
                    ++n5;
                }
                d4 = fArray[0];
                d5 = fArray[1];
                pathIterator.next();
            }
            if (n5 > 1) {
                if (d4 == d2 && d5 == d3) {
                    bl = true;
                }
                if (bl) {
                    dArray[n9] = 102.0;
                    ++n6;
                } else {
                    dArray[n9] = 101.0;
                    ++n7;
                }
                dArray[n9 + 1] = n5;
            }
            if (n6 + n7 > 1) {
                System.arraycopy(dArray, 0, dArray, 2, dArray.length - 2);
                dArray[0] = n7 == 0 ? 105.0 : (n6 == 0 ? 104.0 : 106.0);
                dArray[1] = n6 + n7;
            }
            argument = new Argument((int)dArray[0], dArray);
        }
        return argument;
    }

    public GeometricPath translatePath(double d, double d2) {
        GeometricPath geometricPath = new GeometricPath();
        geometricPath.mPath = (GeneralPath)this.mPath.clone();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(d, d2);
        geometricPath.mPath.transform(affineTransform);
        int n = 0;
        while (n < this.mMoveTos.size()) {
            Point2D.Float float_ = (Point2D.Float)this.mMoveTos.get(n);
            float_ = new Point2D.Float((float)((double)float_.x + d), (float)((double)float_.y + d2));
            geometricPath.mMoveTos.add(float_);
            ++n;
        }
        geometricPath.mNLineTos = this.mNLineTos;
        geometricPath.mRotations = (ArrayList)this.mRotations.clone();
        return geometricPath;
    }

    private GeometricPath createParallelPath(double[] dArray, ArrayList arrayList, GeometricPath geometricPath, boolean bl) {
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < dArray.length) {
            Point2D.Double double_;
            LineEquation lineEquation;
            boolean bl2 = false;
            LineEquation lineEquation2 = null;
            if (bl) {
                lineEquation = (LineEquation)arrayList.get(n - 1);
                lineEquation = lineEquation.createParallel(dArray[n2]);
            } else {
                lineEquation = null;
            }
            int n3 = 0;
            while (n3 < n) {
                LineEquation lineEquation3 = (LineEquation)arrayList.get(n3);
                lineEquation2 = lineEquation3.createParallel(dArray[n2]);
                double_ = lineEquation == null ? lineEquation2.getStartPoint() : lineEquation2.intersect(lineEquation, false);
                if (double_ != null) {
                    if (bl2) {
                        geometricPath.lineTo((float)double_.x, (float)double_.y);
                    } else {
                        geometricPath.moveTo((float)double_.x, (float)double_.y, 0.0);
                        bl2 = true;
                    }
                }
                lineEquation = lineEquation2;
                ++n3;
            }
            if (bl) {
                geometricPath.closePath();
            } else if (lineEquation2 != null) {
                double_ = lineEquation2.getEndPoint();
                geometricPath.lineTo((float)double_.x, (float)double_.y);
            }
            ++n2;
        }
        return geometricPath;
    }

    public GeometricPath parallelPath(double[] dArray, double d) {
        GeometricPath geometricPath = new GeometricPath();
        float[] fArray = new float[6];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        boolean bl = false;
        ArrayList<LineEquation> arrayList = new ArrayList<LineEquation>();
        PathIterator pathIterator = this.mPath.getPathIterator(mIdentityMatrix, d);
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            if (n == 0) {
                if (!arrayList.isEmpty()) {
                    if (f5 == f && f6 == f2) {
                        bl = true;
                    }
                    this.createParallelPath(dArray, arrayList, geometricPath, bl);
                    arrayList.clear();
                    bl = false;
                }
                f3 = f = fArray[0];
                f4 = f2 = fArray[1];
            } else {
                if (n == 4) {
                    f5 = f;
                    f6 = f2;
                    bl = true;
                } else {
                    f5 = fArray[0];
                    f6 = fArray[1];
                }
                if (f3 != f5 || f4 != f6) {
                    LineEquation lineEquation = new LineEquation(f3, f4, f5, f6);
                    arrayList.add(lineEquation);
                }
                f3 = f5;
                f4 = f6;
            }
            pathIterator.next();
        }
        if (!arrayList.isEmpty()) {
            if (f5 == f && f6 == f2) {
                bl = true;
            }
            this.createParallelPath(dArray, arrayList, geometricPath, bl);
        }
        return geometricPath;
    }

    public GeometricPath samplePath(double d, double d2, double d3) {
        int n;
        float[] fArray = new float[6];
        double d4 = 0.0;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        GeometricPath geometricPath = new GeometricPath();
        double[] dArray = null;
        int n2 = 0;
        if (d < 0.0) {
            n = -1;
            d = -d;
            dArray = this.walkPath(1, d3);
        } else {
            n = 1;
        }
        PathIterator pathIterator = this.mPath.getPathIterator(mIdentityMatrix, d3);
        while (!pathIterator.isDone()) {
            int n3 = pathIterator.currentSegment(fArray);
            if (n3 == 0) {
                if (n > 0) {
                    d4 = d2;
                } else {
                    double d5 = dArray[n2] - d2;
                    d4 = NumericalAnalysis.fmod(d5, d);
                }
                f = f3 = fArray[0];
                f2 = f4 = fArray[1];
            } else {
                float f7;
                float f8;
                if (n3 == 4) {
                    f8 = f3;
                    f7 = f4;
                } else {
                    f8 = fArray[0];
                    f7 = fArray[1];
                }
                double d6 = Math.sqrt((f8 - f) * (f8 - f) + (f7 - f2) * (f7 - f2));
                double d7 = Math.atan2(f7 - f2, f8 - f);
                double d8 = Math.cos(d7);
                double d9 = Math.sin(d7);
                int n4 = 0;
                while (d4 + (double)n4 * d < d6 || NumericalAnalysis.equals(d4 + (double)n4 * d, d6)) {
                    f5 = (float)((double)f + (d4 + (double)n4 * d) * d8);
                    f6 = (float)((double)f2 + (d4 + (double)n4 * d) * d9);
                    geometricPath.moveTo(f5, f6, d7);
                    ++n4;
                }
                d4 += d * (double)n4;
                d4 -= d6;
                f = f8;
                f2 = f7;
            }
            pathIterator.next();
        }
        return geometricPath;
    }

    public GeometricPath stripePath(double d, double d2) {
        long l;
        double d3;
        double d4;
        double d5;
        double d6;
        GeometricPath geometricPath = new GeometricPath();
        Rectangle2D rectangle2D = this.getBounds2D();
        int n = 4;
        double[] dArray = new double[n * 2];
        AffineTransform affineTransform = new AffineTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        dArray[0] = 0.0;
        dArray[1] = 0.0;
        dArray[2] = 0.0;
        dArray[3] = rectangle2D.getHeight();
        dArray[4] = rectangle2D.getWidth();
        dArray[5] = dArray[3];
        dArray[6] = dArray[4];
        dArray[7] = 0.0;
        affineTransform2.rotate(-d2);
        affineTransform2.transform(dArray, 0, dArray, 0, n);
        double d7 = d6 = dArray[0];
        double d8 = d5 = dArray[1];
        int n2 = 1;
        while (n2 < n) {
            d7 = Math.min(d7, dArray[n2 * 2]);
            d8 = Math.min(d8, dArray[n2 * 2 + 1]);
            d6 = Math.max(d6, dArray[n2 * 2]);
            d5 = Math.max(d5, dArray[n2 * 2 + 1]);
            ++n2;
        }
        double d9 = Math.cos(d2);
        double d10 = rectangle2D.getMinX();
        double d11 = rectangle2D.getMinY();
        if (Math.abs(d9) > 0.707106781186547) {
            d4 = d / d9;
            d3 = Math.tan(d2) * rectangle2D.getMinX();
            l = Math.round((d11 - d3) / d4);
            d11 = d3 + (double)l * d4;
        } else {
            d4 = d / Math.sin(d2);
            double d12 = rectangle2D.getMinY() / Math.tan(d2);
            l = Math.round((d10 - d12) / d4);
            d10 = d12 + (double)l * d4;
        }
        affineTransform.translate(d10, d11);
        affineTransform.rotate(d2);
        d4 = d / 2.0;
        d3 = Math.floor((d8 - d) / d) * d;
        while (d3 <= d5 + d) {
            dArray[0] = d7 - d4;
            dArray[1] = dArray[3] = d3;
            dArray[2] = d6 + d4;
            affineTransform.transform(dArray, 0, dArray, 0, 2);
            geometricPath.moveTo((float)dArray[0], (float)dArray[1], 0.0);
            geometricPath.lineTo((float)dArray[2], (float)dArray[3]);
            d3 += d;
        }
        return geometricPath;
    }

    private void sortParts(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        int n2 = 1;
        while (n2 < n) {
            int n3 = n2;
            while (n3 < n) {
                if (dArray[n3] < dArray[n3 - 1]) {
                    double d = dArray[n3];
                    dArray[n3] = dArray[n3 - 1];
                    dArray[n3 - 1] = d;
                    d = dArray2[n3];
                    dArray2[n3] = dArray2[n3 - 1];
                    dArray2[n3 - 1] = d;
                }
                ++n3;
            }
            ++n2;
        }
    }

    private int mergeSelectedParts(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length];
        double[] dArray4 = new double[dArray2.length];
        int n = 1;
        int n2 = 0;
        while (n2 < dArray.length) {
            if (dArray[n2] < 0.0) {
                int n3 = n2;
                dArray2[n3] = dArray2[n3] + dArray[n2];
                dArray[n2] = 0.0;
            }
            if (dArray2[n2] < 0.0) {
                dArray2[n2] = 0.0;
            }
            ++n2;
        }
        this.sortParts(dArray, dArray2);
        dArray3[0] = dArray[0];
        dArray4[0] = dArray2[0];
        n2 = 1;
        while (n2 < dArray.length) {
            double d = dArray[n2];
            double d2 = dArray[n2] + dArray2[n2];
            double d3 = dArray3[n - 1] + dArray4[n - 1];
            if (d < d3) {
                if (d2 > d3) {
                    dArray4[n - 1] = d2 - dArray3[n - 1];
                }
            } else {
                dArray3[n] = dArray[n2];
                dArray4[n] = dArray2[n2];
                ++n;
            }
            ++n2;
        }
        System.arraycopy(dArray3, 0, dArray, 0, n);
        System.arraycopy(dArray4, 0, dArray2, 0, n);
        return n;
    }

    public GeometricPath selectPath(double[] dArray, double[] dArray2, double d) {
        double d2;
        double d3;
        double d4;
        double d5;
        GeometricPath geometricPath = new GeometricPath();
        float[] fArray = new float[6];
        double d6 = 0.0;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        double d7 = 0.0;
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        int n3 = this.mergeSelectedParts(dArray, dArray2);
        PathIterator pathIterator = this.mPath.getPathIterator(mIdentityMatrix, d);
        while (!pathIterator.isDone() && n < n3) {
            int n4 = pathIterator.currentSegment(fArray);
            if (n4 == 0) {
                f = f5 = fArray[0];
                f2 = f6 = fArray[1];
                if (bl) {
                    geometricPath.moveTo(f, f2, 0.0);
                }
            } else {
                if (n2 > 0) {
                    f = f3;
                    f2 = f4;
                }
                if (n4 == 4) {
                    f3 = f5;
                    f4 = f6;
                } else {
                    f3 = fArray[0];
                    f4 = fArray[1];
                }
                d6 = Math.sqrt((f3 - f) * (f3 - f) + (f4 - f2) * (f4 - f2));
                while (n < n3 && d7 + d6 > dArray[n]) {
                    if (bl) {
                        if (d7 + d6 <= dArray[n] + dArray2[n]) {
                            geometricPath.lineTo(f3, f4);
                            break;
                        }
                        d5 = Math.atan2(f4 - f2, f3 - f);
                        d4 = Math.cos(d5);
                        d3 = Math.sin(d5);
                        d2 = dArray[n] + dArray2[n] - d7;
                        f7 = (float)((double)f + d4 * d2);
                        f8 = (float)((double)f2 + d3 * d2);
                        geometricPath.lineTo(f7, f8);
                        bl = false;
                        ++n;
                        continue;
                    }
                    d5 = Math.atan2(f4 - f2, f3 - f);
                    d4 = Math.cos(d5);
                    d3 = Math.sin(d5);
                    f7 = (float)((double)f + d4 * (dArray[n] - d7));
                    f8 = (float)((double)f2 + d3 * (dArray[n] - d7));
                    geometricPath.moveTo(f7, f8, 0.0);
                    bl = true;
                }
                d7 += d6;
                ++n2;
            }
            pathIterator.next();
        }
        if (bl) {
            if (dArray[n] + dArray2[n] >= d7) {
                geometricPath.lineTo(f3, f4);
            } else {
                d5 = Math.atan2(f4 - f2, f3 - f);
                d4 = Math.cos(d5);
                d3 = Math.sin(d5);
                d2 = dArray[n] + dArray2[n] - (d7 - d6);
                f7 = (float)((double)f + d4 * d2);
                f8 = (float)((double)f2 + d3 * d2);
                geometricPath.lineTo(f7, f8);
            }
        }
        return geometricPath;
    }
}

