/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapyrus.Constants;
import org.mapyrus.ContextStack;
import org.mapyrus.FileOrURL;
import org.mapyrus.Interpreter;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.MimeTypes;
import org.mapyrus.Pool;

public class HTTPRequest
extends Thread {
    public static final String HTTP_OK_KEYWORD = "HTTP/1.0 200 OK";
    private static final String HTTP_BAD_KEYWORD = "HTTP/1.0 400 Bad Request";
    private static final String HTTP_NOT_FOUND_KEYWORD = "HTTP/1.0 404 Not Found";
    private static final int HTTP_OK_CODE = 200;
    private static final int HTTP_BAD_CODE = 400;
    private static final int HTTP_NOT_FOUND_CODE = 404;
    public static final String CONTENT_TYPE_KEYWORD = "Content-Type";
    private static final String CONTENT_LENGTH_KEYWORD = "Content-Length";
    private static final String GET_REQUEST_KEYWORD = "GET";
    private static final int GET_REQUEST = 1;
    private static final String POST_REQUEST_KEYWORD = "POST";
    private static final int POST_REQUEST = 2;
    public static final String HTTP_HEADER_ARRAY = "Mapyrus.http.header";
    private Pool mPool;
    private Interpreter mInterpreter;
    private Socket mSocket;
    private String mMimeType;
    private String mFilename;
    private Point mImagemapPoint;
    private String mCommands;
    private int mReturnStatus;
    private String mErrorMessage;
    private Logger mLogger;
    private long mCreationTimeMillis;

    public HTTPRequest(Socket socket, Interpreter interpreter, Pool pool, Logger logger) {
        this.mSocket = socket;
        this.mInterpreter = interpreter;
        this.mPool = pool;
        this.mImagemapPoint = null;
        this.mReturnStatus = 200;
        this.mLogger = logger;
        this.mCreationTimeMillis = System.currentTimeMillis();
    }

    private boolean isLegalVariable(String string) {
        boolean bl = true;
        int n = string.length();
        int n2 = 0;
        while (n2 < n && bl) {
            char c = string.charAt(n2);
            bl = Character.isLetterOrDigit(c) || c == '$' && n2 == 0 || (c == '.' || c == '_' || c == ':') && n2 > 0;
            ++n2;
        }
        return bl;
    }

    private StringBuffer addVariable(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append("let ");
        stringBuffer.append(string);
        stringBuffer.append("='");
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (c == '\'') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            ++n2;
        }
        stringBuffer.append("'");
        stringBuffer.append(Constants.LINE_SEPARATOR);
        return stringBuffer;
    }

    private StringBuffer parseForm(String string) throws MapyrusException, IOException {
        int n;
        StringTokenizer stringTokenizer;
        String string2;
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        int n2 = string.lastIndexOf(63);
        if (n2 >= 0) {
            try {
                string2 = string.substring(n2 + 1);
                string = string.substring(0, n2);
                stringTokenizer = new StringTokenizer(string2, ",");
                if (stringTokenizer.countTokens() == 2) {
                    n = Integer.parseInt(stringTokenizer.nextToken());
                    int n3 = Integer.parseInt(stringTokenizer.nextToken());
                    this.mImagemapPoint = new Point(n, n3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            n = (string2 = URLDecoder.decode(string2, "UTF-8")).indexOf(61);
            if (n <= 0) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            if (!this.isLegalVariable(string3)) {
                throw new MapyrusException(MapyrusMessages.get("variableexpected") + ": " + string2);
            }
            this.addVariable(stringBuffer, string3.toUpperCase(), string4);
        }
        return stringBuffer;
    }

    private void parseRequest(BufferedReader bufferedReader) throws IOException, MapyrusException {
        String string;
        int n;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        String string2 = bufferedReader.readLine();
        if (string2 == null) {
            string2 = "";
        }
        if (this.mLogger.isLoggable(Level.INFO)) {
            object = this.getName() + ": " + MapyrusMessages.get("httpheader") + ": " + string2;
            this.mLogger.info((String)object);
        }
        if (((StringTokenizer)(object = new StringTokenizer(string2))).countTokens() < 3) {
            throw new MapyrusException(MapyrusMessages.get("invalidhttp") + ": " + string2);
        }
        String string3 = ((StringTokenizer)object).nextToken();
        if (string3.equals(GET_REQUEST_KEYWORD)) {
            n = 1;
        } else if (string3.equals(POST_REQUEST_KEYWORD)) {
            n = 2;
        } else {
            throw new MapyrusException(MapyrusMessages.get("invalidhttp") + ": " + string2);
        }
        String string4 = ((StringTokenizer)object).nextToken();
        if (!string4.startsWith("/")) {
            throw new MapyrusException(MapyrusMessages.get("invalidhttp") + ": " + string2);
        }
        int n3 = string4.indexOf(63);
        this.mFilename = n3 >= 0 ? string4.substring(1, n3) : string4.substring(1);
        File file = new File(this.mFilename);
        if (this.mFilename.indexOf(File.separatorChar) >= 0 || this.mFilename.indexOf(47) >= 0 || this.mFilename.indexOf(92) >= 0 || !file.exists()) {
            throw new FileNotFoundException(MapyrusMessages.get("httpnotfound") + ": " + this.mFilename);
        }
        int n4 = this.mFilename.lastIndexOf(46);
        if (n4 > 0) {
            string = this.mFilename.substring(n4 + 1);
            this.mMimeType = MimeTypes.get(string);
        } else {
            this.mMimeType = null;
        }
        if (this.mMimeType == null && n3 >= 0 && n == 1) {
            stringBuffer.append(this.parseForm(string4.substring(n3 + 1)));
        }
        string = bufferedReader.readLine();
        while (string != null && string.length() > 0) {
            int n5;
            if (this.mLogger.isLoggable(Level.FINER)) {
                this.mLogger.finer(this.getName() + ": " + MapyrusMessages.get("httpheader") + ": " + string);
            }
            if ((n5 = string.indexOf(58)) >= 0) {
                String string5 = string.substring(0, n5);
                String string6 = string.substring(n5 + 1).trim();
                int n6 = string5.length();
                int n7 = 0;
                boolean bl = true;
                while (n7 < n6) {
                    char c = string5.charAt(n7);
                    if (!Character.isLetterOrDigit(c) && c != '-') {
                        bl = false;
                    }
                    ++n7;
                }
                if (bl) {
                    this.addVariable(stringBuffer, "Mapyrus.http.header['" + string5 + "']", string6);
                }
                if (string5.equals(CONTENT_LENGTH_KEYWORD)) {
                    try {
                        n2 = Integer.parseInt(string6);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new MapyrusException(MapyrusMessages.get("invalidhttp") + ": " + string);
                    }
                }
            }
            string = bufferedReader.readLine();
        }
        if (n == 2) {
            StringBuffer stringBuffer2 = new StringBuffer(n2);
            int n8 = 0;
            while (n8 < n2) {
                int n9 = bufferedReader.read();
                if (n9 < 0) {
                    throw new MapyrusException(MapyrusMessages.get("missinghttppost"));
                }
                stringBuffer2.append((char)n9);
                ++n8;
            }
            if (this.mLogger.isLoggable(Level.FINE)) {
                this.mLogger.fine(this.getName() + ": " + MapyrusMessages.get("httpheader") + ": " + stringBuffer2.toString());
            }
            stringBuffer.append(this.parseForm(stringBuffer2.toString()));
        }
        if (this.mMimeType == null) {
            stringBuffer.append("include ");
            stringBuffer.append(this.mFilename);
            stringBuffer.append(Constants.LINE_SEPARATOR);
            this.mCommands = stringBuffer.toString();
        }
    }

    private String exceptionToString(Exception exception) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = exception.getMessage();
        if (string != null) {
            stringBuffer.append(exception.getMessage()).append(Constants.LINE_SEPARATOR);
        }
        stringBuffer.append(exception.getClass().getName());
        stringBuffer.append(Constants.LINE_SEPARATOR);
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        int n = 0;
        while (n < stackTraceElementArray.length) {
            string = stackTraceElementArray[n].toString();
            if (string != null) {
                stringBuffer.append(string).append(Constants.LINE_SEPARATOR);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        Object object2;
        Object object3;
        String string;
        BufferedInputStream bufferedInputStream;
        BufferedReader bufferedReader;
        BufferedOutputStream bufferedOutputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        block60: {
            byteArrayOutputStream = new ByteArrayOutputStream();
            bufferedOutputStream = null;
            bufferedReader = null;
            bufferedInputStream = null;
            string = null;
            try {
                block64: {
                    bufferedReader = new BufferedReader(new InputStreamReader(this.mSocket.getInputStream()));
                    try {
                        this.parseRequest(bufferedReader);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.mReturnStatus = 404;
                        this.mErrorMessage = fileNotFoundException.getMessage();
                    }
                    if (this.mReturnStatus == 404) break block60;
                    if (this.mMimeType != null) break block64;
                    object3 = new FileOrURL(new StringReader(this.mCommands), this.getName());
                    object2 = new ContextStack();
                    if (this.mImagemapPoint != null) {
                        ((ContextStack)object2).setImagemapPoint(this.mImagemapPoint);
                    }
                    object = new PrintStream(byteArrayOutputStream);
                    try {
                        byte[] byArray = new byte[]{};
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        this.mInterpreter.interpret((ContextStack)object2, (FileOrURL)object3, byteArrayInputStream, (PrintStream)object);
                        string = ((ContextStack)object2).getHTTPResponse().trim() + Constants.LINE_SEPARATOR + Constants.LINE_SEPARATOR;
                        ((ContextStack)object2).closeContextStack();
                        object2 = null;
                        Object var13_26 = null;
                    }
                    catch (Throwable throwable) {
                        Object var13_27 = null;
                        try {
                            if (object2 != null) {
                                ((ContextStack)object2).closeContextStack();
                            }
                        }
                        catch (IOException iOException) {
                        }
                        catch (MapyrusException mapyrusException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        if (object2 != null) {
                            ((ContextStack)object2).closeContextStack();
                        }
                    }
                    catch (IOException iOException) {
                    }
                    catch (MapyrusException mapyrusException) {}
                    ((PrintStream)object).flush();
                    break block60;
                }
                bufferedInputStream = new BufferedInputStream(new FileInputStream(this.mFilename));
            }
            catch (IOException iOException) {
                this.mReturnStatus = 400;
                this.mErrorMessage = iOException.getMessage();
            }
            catch (MapyrusException mapyrusException) {
                this.mReturnStatus = 400;
                this.mErrorMessage = mapyrusException.getMessage();
            }
            catch (Exception exception) {
                this.mReturnStatus = 400;
                this.mErrorMessage = this.exceptionToString(exception);
            }
        }
        try {
            bufferedOutputStream = new BufferedOutputStream(this.mSocket.getOutputStream());
            if (this.mReturnStatus == 200) {
                String string2 = this.mMimeType == null ? string : HTTP_OK_KEYWORD + Constants.LINE_SEPARATOR + CONTENT_TYPE_KEYWORD + ": " + this.mMimeType + Constants.LINE_SEPARATOR + Constants.LINE_SEPARATOR;
                if (this.mLogger.isLoggable(Level.FINE)) {
                    object2 = new StringTokenizer(string2, Constants.LINE_SEPARATOR);
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        object = ((StringTokenizer)object2).nextToken();
                        this.mLogger.fine(this.getName() + ": " + MapyrusMessages.get("httpreturn") + ": " + (String)object);
                    }
                }
                bufferedOutputStream.write(string2.getBytes());
                if (this.mMimeType == null) {
                    byteArrayOutputStream.writeTo(bufferedOutputStream);
                    if (this.mLogger.isLoggable(Level.FINE)) {
                        this.mLogger.fine(this.getName() + ": " + MapyrusMessages.get("httpreturned") + ": " + byteArrayOutputStream.size());
                    }
                } else {
                    int n = 0;
                    object = new byte[512];
                    int n2 = bufferedInputStream.read((byte[])object);
                    while (n2 > 0) {
                        bufferedOutputStream.write((byte[])object, 0, n2);
                        n += n2;
                        n2 = bufferedInputStream.read((byte[])object);
                    }
                    if (this.mLogger.isLoggable(Level.FINE)) {
                        this.mLogger.fine(this.getName() + ": " + MapyrusMessages.get("httpreturned") + ": " + n);
                    }
                }
            } else {
                object3 = MimeTypes.get("txt");
                Object object4 = object2 = this.mReturnStatus == 404 ? HTTP_NOT_FOUND_KEYWORD : HTTP_BAD_KEYWORD;
                if (this.mLogger.isLoggable(Level.FINE)) {
                    this.mLogger.fine(this.getName() + ": " + MapyrusMessages.get("httpreturn") + ": " + (String)object2);
                    this.mLogger.fine(this.getName() + ": " + MapyrusMessages.get("httpreturn") + ": " + CONTENT_TYPE_KEYWORD + ": " + (String)object3);
                }
                String string3 = (String)object2 + Constants.LINE_SEPARATOR + CONTENT_TYPE_KEYWORD + ": " + (String)object3 + Constants.LINE_SEPARATOR + Constants.LINE_SEPARATOR + this.mErrorMessage + Constants.LINE_SEPARATOR;
                bufferedOutputStream.write(string3.getBytes());
            }
            bufferedOutputStream.flush();
        }
        catch (IOException iOException) {
            if (this.mReturnStatus == 200) {
                this.mReturnStatus = 400;
                this.mErrorMessage = iOException.toString();
            }
        }
        finally {
            try {
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (this.mSocket != null) {
                    this.mSocket.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        this.mPool.put(this.mInterpreter);
    }

    public boolean getStatus() {
        return this.mReturnStatus == 200;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public long getCreationTime() {
        return this.mCreationTimeMillis;
    }
}

