/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.mapyrus.Argument;
import org.mapyrus.ColorDatabase;
import org.mapyrus.Constants;
import org.mapyrus.ContextStack;
import org.mapyrus.DefaultFieldNames;
import org.mapyrus.Expression;
import org.mapyrus.FileOrURL;
import org.mapyrus.LegendEntry;
import org.mapyrus.LegendEntryList;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.NumericalAnalysis;
import org.mapyrus.PageSize;
import org.mapyrus.ParsedStatement;
import org.mapyrus.Preprocessor;
import org.mapyrus.Row;
import org.mapyrus.Statement;
import org.mapyrus.Throttle;
import org.mapyrus.function.UserFunction;

public class Interpreter {
    private static final char COMMENT_CHAR = '#';
    private static final char ARGUMENT_SEPARATOR = ',';
    private static final char PARAM_SEPARATOR = ',';
    private static final String BEGIN_KEYWORD = "begin";
    private static final String FUNCTION_KEYWORD = "function";
    private static final String END_KEYWORD = "end";
    private static final String IF_KEYWORD = "if";
    private static final String THEN_KEYWORD = "then";
    private static final String ELSE_KEYWORD = "else";
    private static final String ELIF_KEYWORD = "elif";
    private static final String ENDIF_KEYWORD = "endif";
    private static final String WHILE_KEYWORD = "while";
    private static final String REPEAT_KEYWORD = "repeat";
    private static final String DO_KEYWORD = "do";
    private static final String DONE_KEYWORD = "done";
    private static final String FOR_KEYWORD = "for";
    private static final String IN_KEYWORD = "in";
    private static final int AT_ARGUMENT = 1;
    private static final int AT_SEPARATOR = 2;
    private static final int AT_PARAM = 3;
    private static final int AT_PARAM_SEPARATOR = 4;
    public static final String CAP_BUTT_STRING = "butt";
    public static final String CAP_ROUND_STRING = "round";
    public static final String CAP_SQUARE_STRING = "square";
    public static final String JOIN_BEVEL_STRING = "bevel";
    public static final String JOIN_MITER_STRING = "miter";
    public static final String JOIN_ROUND_STRING = "round";
    private ContextStack mContext;
    private InputStream mStdinStream;
    private PrintStream mStdoutStream;
    Argument[] mExecuteArgs = null;
    private HashMap mStatementBlocks = new HashMap();
    private HashMap mUserFunctions = new HashMap();
    private static HashMap mWorldUnitsLookup = new HashMap();
    private boolean mInComment = false;
    private static HashMap mKeywordLookup;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setColor(ContextStack contextStack, Argument[] argumentArray, int n) throws MapyrusException {
        int n2 = 255;
        float f = 1.0f;
        if (n == 1 || n == 2) {
            Color color;
            String string = argumentArray[0].getStringValue();
            if (n == 2) {
                f = (float)argumentArray[1].getNumericValue();
                if (f < 0.0f) {
                    f = 0.0f;
                } else if (f > 1.0f) {
                    f = 1.0f;
                }
                n2 = (int)Math.round((double)f * 255.0);
            }
            if ((color = ColorDatabase.getColor(string, n2, contextStack.getColor())) == null) {
                throw new MapyrusException(MapyrusMessages.get("colornotfound") + ": " + string);
            }
            contextStack.setColor(color);
            return;
        } else {
            if (n != 4 && n != 5) throw new MapyrusException(MapyrusMessages.get("invalidcolor"));
            String string = argumentArray[0].getStringValue();
            float f2 = (float)argumentArray[1].getNumericValue();
            float f3 = (float)argumentArray[2].getNumericValue();
            float f4 = (float)argumentArray[3].getNumericValue();
            if (n == 5) {
                f = (float)argumentArray[4].getNumericValue();
                if (f < 0.0f) {
                    f = 0.0f;
                } else if (f > 1.0f) {
                    f = 1.0f;
                }
                n2 = (int)Math.round((double)f * 255.0);
            }
            if (f3 < 0.0f) {
                f3 = 0.0f;
            } else if (f3 > 1.0f) {
                f3 = 1.0f;
            }
            if (f4 < 0.0f) {
                f4 = 0.0f;
            } else if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            if (string.equalsIgnoreCase("hsb")) {
                int n3 = Color.HSBtoRGB(f2, f3, f4);
                contextStack.setColor(new Color((n3 &= 0xFFFFFF) | n2 << 24, true));
                return;
            } else {
                if (!string.equalsIgnoreCase("rgb")) throw new MapyrusException(MapyrusMessages.get("invalidcolortype") + ": " + string);
                if (f2 < 0.0f) {
                    f2 = 0.0f;
                } else if (f2 > 1.0f) {
                    f2 = 1.0f;
                }
                contextStack.setColor(new Color(f2, f3, f4, f));
            }
        }
    }

    private void setLinestyle(ContextStack contextStack, Argument[] argumentArray, int n) throws MapyrusException {
        String string;
        double d = 0.1;
        double d2 = 0.0;
        float[] fArray = null;
        int n2 = 2;
        int n3 = 0;
        if (n == 0) {
            throw new MapyrusException(MapyrusMessages.get("invalidlinestyle"));
        }
        d = argumentArray[0].getNumericValue();
        if (d < 0.0) {
            throw new MapyrusException(MapyrusMessages.get("invalidlinewidth") + ": " + d);
        }
        if (n >= 2) {
            string = argumentArray[1].getStringValue().toLowerCase();
            if (string.equals(CAP_BUTT_STRING)) {
                n2 = 0;
            } else if (string.equals("round")) {
                n2 = 1;
            } else if (string.equals(CAP_SQUARE_STRING)) {
                n2 = 2;
            } else {
                throw new MapyrusException(MapyrusMessages.get("invalidendcap") + ": " + string);
            }
        }
        if (n >= 3) {
            string = argumentArray[2].getStringValue().toLowerCase();
            if (string.equals(JOIN_BEVEL_STRING)) {
                n3 = 2;
            } else if (string.equals(JOIN_MITER_STRING)) {
                n3 = 0;
            } else if (string.equals("round")) {
                n3 = 1;
            } else {
                throw new MapyrusException(MapyrusMessages.get("invalidlinejoin") + ": " + string);
            }
        }
        if (n >= 4 && (d2 = argumentArray[3].getNumericValue()) < 0.0) {
            throw new MapyrusException(MapyrusMessages.get("invaliddashphase") + ": " + d2);
        }
        if (n >= 5) {
            fArray = new float[n - 4];
            int n4 = 4;
            while (n4 < n) {
                fArray[n4 - 4] = (float)argumentArray[n4].getNumericValue();
                if ((double)fArray[n4 - 4] <= 0.0) {
                    throw new MapyrusException(MapyrusMessages.get("invaliddashpattern") + ": " + fArray[n4 - 4]);
                }
                ++n4;
            }
        }
        contextStack.setLinestyle(d, n2, n3, d2, fArray);
    }

    private void setJustify(ContextStack contextStack, String string) {
        int n = (string = string.toLowerCase()).indexOf("center") >= 0 || string.indexOf("centre") >= 0 ? 2 : (string.indexOf("right") >= 0 ? 4 : 1);
        n = string.indexOf("top") >= 0 ? (n |= 8) : (string.indexOf("middle") >= 0 ? (n |= 0x10) : (n |= 0x20));
        contextStack.setJustify(n);
    }

    private void setFont(ContextStack contextStack, Argument[] argumentArray, int n) throws MapyrusException {
        double d;
        double d2 = 0.0;
        double d3 = 1.0;
        if (n == 2 || n == 3) {
            d = argumentArray[1].getNumericValue();
            if (d <= 0.0) {
                throw new MapyrusException(MapyrusMessages.get("invalidsize") + ": " + d);
            }
            if (n == 3) {
                String string = argumentArray[2].getStringValue();
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2;
                    String string3 = stringTokenizer.nextToken();
                    if (string3.startsWith("outlinewidth=")) {
                        string2 = string3.substring(13);
                        try {
                            d2 = Double.parseDouble(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new MapyrusException(MapyrusMessages.get("invalidlinewidth") + ": " + string2);
                        }
                        if (!(d2 < 0.0)) continue;
                        throw new MapyrusException(MapyrusMessages.get("invalidlinewidth") + ": " + d2);
                    }
                    if (!string3.startsWith("linespacing=")) continue;
                    string2 = string3.substring(12);
                    try {
                        d3 = Double.parseDouble(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new MapyrusException(MapyrusMessages.get("invalidspacing") + ": " + string2);
                    }
                }
            }
        } else {
            throw new MapyrusException(MapyrusMessages.get("invalidfont"));
        }
        contextStack.setFont(argumentArray[0].getStringValue(), d, d2, d3);
    }

    private void displayLegend(Statement statement, ContextStack contextStack, double d) throws MapyrusException, IOException {
        LegendEntryList legendEntryList = contextStack.getLegendEntries();
        ArrayList arrayList = contextStack.getMoveTos();
        legendEntryList.ignoreAdditions();
        long l = Math.min(legendEntryList.size(), arrayList.size());
        int n = 0;
        while ((long)n < l) {
            int n2;
            LegendEntry legendEntry = legendEntryList.pop();
            String string = legendEntry.getBlockName();
            Statement statement2 = (Statement)this.mStatementBlocks.get(string);
            if (statement2 == null) {
                throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("undefinedproc") + ": " + string);
            }
            ArrayList arrayList2 = statement2.getBlockParameters();
            if (legendEntry.getBlockArgs().length != arrayList2.size()) {
                throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("wrongparameters"));
            }
            contextStack.saveState(string);
            Point2D.Float float_ = (Point2D.Float)arrayList.get(n);
            contextStack.setTranslation(float_.x, float_.y);
            contextStack.clearPath();
            contextStack.moveTo(d * 1.1 + 2.0, d / 2.0);
            String string2 = legendEntry.getDescription();
            while ((n2 = string2.indexOf("(#)")) >= 0) {
                string2 = string2.substring(0, n2 + 1) + legendEntry.getReferenceCount() + string2.substring(n2 + 2);
            }
            contextStack.label(string2);
            contextStack.clearPath();
            if (legendEntry.getType() == 1) {
                contextStack.setTranslation(d / 2.0, d / 2.0);
                contextStack.moveTo(0.0, 0.0);
            } else if (legendEntry.getType() == 2) {
                contextStack.moveTo(0.0, d / 2.0);
                contextStack.lineTo(d, d / 2.0);
            } else if (legendEntry.getType() == 3) {
                contextStack.moveTo(0.0, d / 2.0);
                contextStack.lineTo(d / 3.0, d);
                contextStack.lineTo(d * 2.0 / 3.0, 0.0);
                contextStack.lineTo(d, d / 2.0);
            } else if (legendEntry.getType() == 4) {
                contextStack.moveTo(0.0, 0.0);
                contextStack.lineTo(0.0, d);
                contextStack.lineTo(d, d);
                contextStack.lineTo(d, 0.0);
                contextStack.lineTo(0.0, 0.0);
            }
            if (legendEntry.getType() == 4) {
                contextStack.saveState(string);
            }
            this.makeCall(statement2, arrayList2, legendEntry.getBlockArgs());
            if (legendEntry.getType() == 4) {
                contextStack.restoreState();
                contextStack.setColor(Color.BLACK);
                contextStack.setLinestyle(0.1, 0, 2, 0.0, null);
                contextStack.stroke(null);
            }
            contextStack.restoreState();
            ++n;
        }
        legendEntryList.acceptAdditions();
    }

    private int addGeometryToPath(ContextStack contextStack, double[] dArray, int n) throws MapyrusException {
        int n2 = (int)dArray[n];
        int n3 = (int)dArray[n + 1];
        n += 2;
        switch (n2) {
            case 100: 
            case 101: 
            case 102: {
                int n4 = 0;
                while (n4 < n3) {
                    double d = dArray[n + 1];
                    double d2 = dArray[n + 2];
                    if (dArray[n] == 0.0) {
                        contextStack.moveTo(d, d2);
                    } else {
                        contextStack.lineTo(d, d2);
                    }
                    n += 3;
                    ++n4;
                }
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                int n5 = 0;
                while (n5 < n3) {
                    n = this.addGeometryToPath(contextStack, dArray, n);
                    ++n5;
                }
                break;
            }
        }
        return n;
    }

    private void execute(Statement statement, ContextStack contextStack) throws MapyrusException, IOException {
        Object object;
        double d = 0.0;
        if (Thread.interrupted()) {
            throw new MapyrusException(MapyrusMessages.get("interrupted"));
        }
        Throttle.sleep();
        Expression[] expressionArray = statement.getExpressions();
        int n = expressionArray.length;
        int n2 = statement.getType();
        if (n2 == 70) {
            int n3 = 0;
            while (n3 < n) {
                object = expressionArray[n3].getVariableName();
                if (object == null) {
                    throw new MapyrusException(MapyrusMessages.get("variableexpected"));
                }
                contextStack.setLocalScope((String)object);
                ++n3;
            }
        } else {
            if (this.mExecuteArgs == null || n > this.mExecuteArgs.length) {
                this.mExecuteArgs = new Argument[n];
            }
            String string = statement.getFilename();
            int n4 = 0;
            while (n4 < n) {
                this.mExecuteArgs[n4] = expressionArray[n4].evaluate(contextStack, string);
                ++n4;
            }
        }
        switch (n2) {
            case 9: {
                this.setColor(contextStack, this.mExecuteArgs, n);
                break;
            }
            case 10: {
                if (n == 1) {
                    contextStack.setBlend(this.mExecuteArgs[0].getStringValue());
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidblend"));
            }
            case 11: {
                this.setLinestyle(contextStack, this.mExecuteArgs, n);
                break;
            }
            case 12: {
                this.setFont(contextStack, this.mExecuteArgs, n);
                break;
            }
            case 13: {
                if (n == 1) {
                    this.setJustify(contextStack, this.mExecuteArgs[0].getStringValue());
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidjustify"));
            }
            case 14: 
            case 15: 
            case 16: {
                if (n > 0 && n % 2 == 0) {
                    int n5 = 0;
                    while (n5 < n) {
                        if (n2 == 14) {
                            contextStack.moveTo(this.mExecuteArgs[n5].getNumericValue(), this.mExecuteArgs[n5 + 1].getNumericValue());
                        } else if (n2 == 15) {
                            contextStack.lineTo(this.mExecuteArgs[n5].getNumericValue(), this.mExecuteArgs[n5 + 1].getNumericValue());
                        } else {
                            contextStack.rlineTo(this.mExecuteArgs[n5].getNumericValue(), this.mExecuteArgs[n5 + 1].getNumericValue());
                        }
                        n5 += 2;
                    }
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("wrongcoordinate"));
            }
            case 17: {
                if (n == 5) {
                    int n6 = this.mExecuteArgs[0].getNumericValue() > 0.0 ? 1 : -1;
                    contextStack.arcTo(n6, this.mExecuteArgs[1].getNumericValue(), this.mExecuteArgs[2].getNumericValue(), this.mExecuteArgs[3].getNumericValue(), this.mExecuteArgs[4].getNumericValue());
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidarc"));
            }
            case 18: {
                if (n == 3) {
                    double d2 = this.mExecuteArgs[0].getNumericValue();
                    double d3 = this.mExecuteArgs[1].getNumericValue();
                    d = this.mExecuteArgs[2].getNumericValue();
                    if (!(d > 0.0)) break;
                    contextStack.moveTo(d2 - d, d3);
                    contextStack.arcTo(1, d2, d3, d2 - d, d3);
                    contextStack.closePath();
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidcircle"));
            }
            case 19: {
                if (n == 4) {
                    double d4 = this.mExecuteArgs[0].getNumericValue();
                    double d5 = this.mExecuteArgs[1].getNumericValue();
                    double d6 = this.mExecuteArgs[2].getNumericValue();
                    double d7 = this.mExecuteArgs[3].getNumericValue();
                    if (!(d6 > 0.0) || !(d7 > 0.0)) break;
                    contextStack.ellipseTo(d4 - d6, d5 - d7, d4 + d6, d5 + d7);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidellipse"));
            }
            case 20: {
                if (n == 4) {
                    double d8 = this.mExecuteArgs[0].getNumericValue();
                    double d9 = this.mExecuteArgs[1].getNumericValue();
                    d = this.mExecuteArgs[2].getNumericValue();
                    double d10 = this.mExecuteArgs[3].getNumericValue();
                    if (!(d > 0.0) || !(d10 > 0.0)) break;
                    double d11 = d * 0.552285;
                    double d12 = d11 / 2.0;
                    contextStack.moveTo(d8 - d, d9);
                    contextStack.curveTo(d8 - d, d9 - d12, d8 - d11, d9 - d / 2.0, d8, d9 - d / 2.0);
                    contextStack.curveTo(d8 + d11, d9 - d / 2.0, d8 + d, d9 - d12, d8 + d, d9);
                    contextStack.lineTo(d8 + d, d9 + d10);
                    contextStack.curveTo(d8 + d, d9 + d10 - d12, d8 + d11, d9 + d10 - d / 2.0, d8, d9 + d10 - d / 2.0);
                    contextStack.curveTo(d8 - d11, d9 + d10 - d / 2.0, d8 - d, d9 + d10 - d12, d8 - d, d9 + d10);
                    contextStack.closePath();
                    contextStack.ellipseTo(d8 - d, d9 + d10 - d / 2.0, d8 + d, d9 + d10 + d / 2.0);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidcylinder"));
            }
            case 21: {
                if (n == 3) {
                    double d13 = this.mExecuteArgs[0].getNumericValue();
                    double d14 = this.mExecuteArgs[1].getNumericValue();
                    d = this.mExecuteArgs[2].getNumericValue();
                    if (!(d > 0.0)) break;
                    double d15 = d;
                    contextStack.moveTo(d13 - d, d14);
                    contextStack.arcTo(-1, d13, d14, d13 + d, d14);
                    contextStack.curveTo(d13 + d, d14 + d15, d13, d14 + d * 3.0 - d15, d13, d14 + d * 3.0);
                    contextStack.curveTo(d13, d14 + d * 3.0 - d15, d13 - d, d14 + d15, d13 - d, d14);
                    contextStack.closePath();
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidraindrop"));
            }
            case 22: {
                if (n == 6) {
                    double d16 = this.mExecuteArgs[0].getNumericValue();
                    double d17 = this.mExecuteArgs[1].getNumericValue();
                    double d18 = this.mExecuteArgs[2].getNumericValue();
                    double d19 = this.mExecuteArgs[3].getNumericValue();
                    double d20 = this.mExecuteArgs[4].getNumericValue();
                    double d21 = this.mExecuteArgs[5].getNumericValue();
                    contextStack.curveTo(d16, d17, d18, d19, d20, d21);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidbezier"));
            }
            case 23: {
                if (n == 4) {
                    double d22 = this.mExecuteArgs[0].getNumericValue();
                    double d23 = this.mExecuteArgs[1].getNumericValue();
                    double d24 = this.mExecuteArgs[2].getNumericValue();
                    double d25 = this.mExecuteArgs[3].getNumericValue();
                    contextStack.sineWaveTo(d22, d23, d24, d25);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidsinewave"));
            }
            case 24: {
                if (n == 5 || n == 6) {
                    double d26 = this.mExecuteArgs[0].getNumericValue();
                    double d27 = this.mExecuteArgs[1].getNumericValue();
                    d = this.mExecuteArgs[2].getNumericValue();
                    double d28 = this.mExecuteArgs[3].getNumericValue();
                    double d29 = this.mExecuteArgs[4].getNumericValue();
                    double d30 = d28 + d29;
                    double d31 = n == 6 ? this.mExecuteArgs[5].getNumericValue() : 0.0;
                    int n7 = d29 > 0.0 ? -1 : 1;
                    d28 = Math.toRadians(d28);
                    d30 = Math.toRadians(d30);
                    if (!(d > 0.0) || d29 == 0.0) break;
                    double d32 = Math.cos(d28);
                    double d33 = Math.sin(d28);
                    double d34 = Math.cos(d30);
                    double d35 = Math.sin(d30);
                    double d36 = d26 + d32 * d;
                    double d37 = d27 + d33 * d;
                    double d38 = d26 + d34 * d;
                    double d39 = d27 + d35 * d;
                    contextStack.moveTo(d26, d27);
                    contextStack.lineTo(d36, d37);
                    contextStack.arcTo(n7, d26, d27, d38, d39);
                    contextStack.closePath();
                    if (!(d31 > 0.0)) break;
                    if (n7 == 1 && d32 < 0.0 || n7 == -1 && d32 > 0.0) {
                        contextStack.moveTo(d36, d37);
                        contextStack.lineTo(d36, d37 - d31);
                        contextStack.lineTo(d26, d27 - d31);
                        contextStack.lineTo(d26, d27);
                        contextStack.closePath();
                    }
                    if (n7 == 1 && d34 > 0.0 || n7 == -1 && d34 < 0.0) {
                        contextStack.moveTo(d38, d39);
                        contextStack.lineTo(d38, d39 - d31);
                        contextStack.lineTo(d26, d27 - d31);
                        contextStack.lineTo(d26, d27);
                        contextStack.closePath();
                    }
                    if (!(d33 < 0.0) && !(d35 < 0.0) && !(Math.abs(d29) > 180.0)) break;
                    double d40 = d36;
                    double d41 = d37;
                    if (d33 > 0.0) {
                        d40 = d26 + d * (double)n7;
                        d41 = d27;
                    }
                    contextStack.moveTo(d40, d41);
                    contextStack.lineTo(d40, d41 - d31);
                    double d42 = d38;
                    double d43 = d39;
                    if (d35 > 0.0) {
                        d42 = d26 - d * (double)n7;
                        d43 = d27;
                    }
                    contextStack.arcTo(n7, d26, d27 - d31, d42, d43 - d31);
                    contextStack.lineTo(d42, d43);
                    contextStack.arcTo(-n7, d26, d27, d40, d41);
                    contextStack.closePath();
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidwedge"));
            }
            case 25: {
                if (n == 5) {
                    double d44 = this.mExecuteArgs[0].getNumericValue();
                    double d45 = this.mExecuteArgs[1].getNumericValue();
                    d = this.mExecuteArgs[2].getNumericValue();
                    double d46 = this.mExecuteArgs[3].getNumericValue();
                    double d47 = this.mExecuteArgs[4].getNumericValue();
                    d47 = Math.toRadians(d47);
                    if (!(d > 0.0) || d46 == 0.0) break;
                    double d48 = contextStack.getResolution();
                    double d49 = Math.acos((d - d48) / d);
                    double d50 = d49 / (Math.PI * 2);
                    d50 /= Math.abs(d46);
                    double d51 = 1.0;
                    int n8 = 0;
                    while (d51 > 0.0) {
                        double d52 = d * d51 * Math.cos(Math.PI * 2 * d46 * d51 + d47) + d44;
                        double d53 = d * d51 * Math.sin(Math.PI * 2 * d46 * d51 + d47) + d45;
                        if (n8 == 0) {
                            contextStack.moveTo(d52, d53);
                        } else {
                            contextStack.lineTo(d52, d53);
                        }
                        d51 = 1.0 - (double)(++n8) * d50;
                    }
                    contextStack.lineTo(d44, d45);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidspiral"));
            }
            case 30: {
                if (n == 3) {
                    double d54 = this.mExecuteArgs[0].getNumericValue();
                    double d55 = this.mExecuteArgs[1].getNumericValue();
                    d = this.mExecuteArgs[2].getNumericValue();
                    double d56 = 0.8660254 * d;
                    double d57 = 0.5 * d;
                    if (!(d > 0.0)) break;
                    contextStack.moveTo(d54 - d57, d55 - d56);
                    contextStack.lineTo(d54 + d57, d55 - d56);
                    contextStack.lineTo(d54 + d, d55);
                    contextStack.lineTo(d54 + d57, d55 + d56);
                    contextStack.lineTo(d54 - d57, d55 + d56);
                    contextStack.lineTo(d54 - d, d55);
                    contextStack.closePath();
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidhexagon"));
            }
            case 31: {
                if (n == 3) {
                    double d58 = this.mExecuteArgs[0].getNumericValue();
                    double d59 = this.mExecuteArgs[1].getNumericValue();
                    d = this.mExecuteArgs[2].getNumericValue();
                    double d60 = 0.809017 * d;
                    double d61 = 0.59778525 * d;
                    double d62 = 0.309017 * d;
                    double d63 = 0.95105652 * d;
                    if (!(d > 0.0)) break;
                    contextStack.moveTo(d58 - d61, d59 - d60);
                    contextStack.lineTo(d58 + d61, d59 - d60);
                    contextStack.lineTo(d58 + d63, d59 + d62);
                    contextStack.lineTo(d58, d59 + d);
                    contextStack.lineTo(d58 - d63, d59 + d62);
                    contextStack.closePath();
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidpentagon"));
            }
            case 32: {
                if (n == 4) {
                    double d64 = this.mExecuteArgs[0].getNumericValue();
                    double d65 = this.mExecuteArgs[1].getNumericValue();
                    d = this.mExecuteArgs[2].getNumericValue();
                    double d66 = this.mExecuteArgs[3].getNumericValue();
                    d66 = Math.toRadians(d66);
                    double d67 = 0.5 * d;
                    double d68 = 0.8660254 * d;
                    AffineTransform affineTransform = AffineTransform.getTranslateInstance(d64, d65);
                    affineTransform.rotate(d66);
                    Point2D.Double double_ = new Point2D.Double(0.0, d);
                    affineTransform.transform(double_, double_);
                    contextStack.moveTo(double_.x, double_.y);
                    double_.x = d68;
                    double_.y = -d67;
                    affineTransform.transform(double_, double_);
                    contextStack.lineTo(double_.x, double_.y);
                    double_.x = -d68;
                    double_.y = -d67;
                    affineTransform.transform(double_, double_);
                    contextStack.lineTo(double_.x, double_.y);
                    contextStack.closePath();
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidtriangle"));
            }
            case 33: {
                if (n == 4) {
                    double d69 = this.mExecuteArgs[0].getNumericValue();
                    double d70 = this.mExecuteArgs[1].getNumericValue();
                    d = this.mExecuteArgs[2].getNumericValue();
                    int n9 = (int)this.mExecuteArgs[3].getNumericValue();
                    if (!(d > 0.0) || n9 <= 0) break;
                    double d71 = Math.PI * 2 / (double)n9;
                    double d72 = 1.5707963267948966;
                    double d73 = d71 / 3.0;
                    double d74 = d * Math.sin(d73 / 2.0) / Math.sin(Math.PI - d73 / 2.0 - d71 / 2.0);
                    int n10 = 0;
                    while (n10 < n9) {
                        double d75 = d69 + Math.cos(d72) * d;
                        double d76 = d70 + Math.sin(d72) * d;
                        if (n10 == 0) {
                            contextStack.moveTo(d75, d76);
                        } else {
                            contextStack.lineTo(d75, d76);
                        }
                        d75 = d69 + Math.cos(d72 - d71 / 2.0) * d74;
                        d76 = d70 + Math.sin(d72 - d71 / 2.0) * d74;
                        contextStack.lineTo(d75, d76);
                        d72 -= d71;
                        ++n10;
                    }
                    contextStack.closePath();
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidstar"));
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 43: 
            case 48: 
            case 49: {
                if (n == 4 || (n2 == 27 || n2 == 28 || n2 == 29) && n == 5) {
                    double d77;
                    double d78;
                    double d79;
                    double d80;
                    double d81;
                    double d82;
                    double d83 = this.mExecuteArgs[0].getNumericValue();
                    double d84 = this.mExecuteArgs[1].getNumericValue();
                    double d85 = this.mExecuteArgs[2].getNumericValue();
                    double d86 = this.mExecuteArgs[3].getNumericValue();
                    double d87 = 1.0;
                    double d88 = 0.0;
                    if (d83 < d85) {
                        d82 = d83;
                        d81 = d85;
                    } else {
                        d82 = d85;
                        d81 = d83;
                    }
                    if (d84 < d86) {
                        d80 = d84;
                        d79 = d86;
                    } else {
                        d80 = d86;
                        d79 = d84;
                    }
                    if (n2 == 27) {
                        d78 = d79 - d80;
                        d77 = d81 - d82;
                        if (n == 5) {
                            d = this.mExecuteArgs[4].getNumericValue();
                            if (d > d77 / 2.0) {
                                d = d77 / 2.0;
                            }
                            if (d > d78 / 2.0) {
                                d = d78 / 2.0;
                            }
                        } else {
                            d = Math.min(d77 / 10.0, d78 / 10.0);
                        }
                        if (d <= 0.0) {
                            n2 = 26;
                        }
                    } else if (n2 == 28) {
                        d88 = Math.min(d81 - d82, d79 - d80);
                        if (n == 5) {
                            d88 = this.mExecuteArgs[4].getNumericValue();
                        }
                    } else if (n2 == 29) {
                        if (n == 5) {
                            d87 = this.mExecuteArgs[4].getNumericValue();
                        }
                        if (d87 <= 0.0) {
                            throw new MapyrusException(MapyrusMessages.get("invalidsize") + ": " + d87);
                        }
                    }
                    if (n2 == 26 || n2 == 28) {
                        contextStack.moveTo(d82, d80);
                        contextStack.lineTo(d82, d79);
                        contextStack.lineTo(d81, d79);
                        contextStack.lineTo(d81, d80);
                        contextStack.closePath();
                        if (n2 != 28) break;
                        d78 = Math.cos(Math.toRadians(30.0));
                        d77 = Math.sin(Math.toRadians(30.0));
                        d83 = d81 + d88 * d78;
                        d84 = d79 + d88 * d77;
                        contextStack.moveTo(d81, d79);
                        contextStack.lineTo(d83, d84);
                        contextStack.lineTo(d83, d84 - (d79 - d80));
                        contextStack.lineTo(d81, d80);
                        contextStack.closePath();
                        d83 = d82 + d88 * d78;
                        d84 = d79 + d88 * d77;
                        contextStack.moveTo(d82, d79);
                        contextStack.lineTo(d83, d84);
                        contextStack.lineTo(d83 + (d81 - d82), d84);
                        contextStack.lineTo(d81, d79);
                        contextStack.closePath();
                        break;
                    }
                    if (n2 == 27) {
                        contextStack.moveTo(d82, d79 - d);
                        contextStack.arcTo(1, d82 + d, d79 - d, d82 + d, d79);
                        contextStack.lineTo(d81 - d, d79);
                        contextStack.arcTo(1, d81 - d, d79 - d, d81, d79 - d);
                        contextStack.lineTo(d81, d80 + d);
                        contextStack.arcTo(1, d81 - d, d80 + d, d81 - d, d80);
                        contextStack.lineTo(d82 + d, d80);
                        contextStack.arcTo(1, d82 + d, d80 + d, d82, d80 + d);
                        contextStack.closePath();
                        break;
                    }
                    if (n2 == 29) {
                        int n11 = 0;
                        d84 = d80;
                        while (d84 < d79) {
                            d86 = d84 + d87;
                            if (d86 > d79) {
                                d86 = d79;
                            }
                            int n12 = 0;
                            d83 = d82;
                            while (d83 < d81) {
                                if ((n11 + n12) % 2 == 0) {
                                    d85 = d83 + d87;
                                    if (d85 > d81) {
                                        d85 = d81;
                                    }
                                    contextStack.moveTo(d83, d84);
                                    contextStack.lineTo(d83, d86);
                                    contextStack.lineTo(d85, d86);
                                    contextStack.lineTo(d85, d84);
                                    contextStack.closePath();
                                }
                                d83 = d82 + (double)(++n12) * d87;
                            }
                            d84 = d80 + (double)(++n11) * d87;
                        }
                        break;
                    }
                    if (n2 == 43) {
                        contextStack.guillotine(d82, d80, d81, d79);
                        break;
                    }
                    if (n2 == 48) {
                        contextStack.protect(d82, d80, d81, d79);
                        break;
                    }
                    contextStack.unprotect(d82, d80, d81, d79);
                    break;
                }
                if (n == 1 && (n2 == 48 || n2 == 49)) {
                    Argument argument = this.mExecuteArgs[0];
                    if (n2 == 48) {
                        contextStack.protect(argument);
                        break;
                    }
                    contextStack.unprotect(argument);
                    break;
                }
                if (n == 0 && n2 == 48) {
                    contextStack.protect();
                    break;
                }
                if (n == 0 && n2 == 49) {
                    contextStack.unprotect();
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidbox"));
            }
            case 34: {
                int n13 = 0;
                while (n13 < n) {
                    object = this.mExecuteArgs[n13].getGeometryValue();
                    this.addGeometryToPath(contextStack, (double[])object, 0);
                    ++n13;
                }
                break;
            }
            case 35: {
                if (n > 0) {
                    throw new MapyrusException(MapyrusMessages.get("unexpectedvalues"));
                }
                contextStack.clearPath();
                break;
            }
            case 36: {
                if (n > 0) {
                    throw new MapyrusException(MapyrusMessages.get("unexpectedvalues"));
                }
                contextStack.closePath();
                break;
            }
            case 37: {
                if (n == 2) {
                    contextStack.samplePath(this.mExecuteArgs[0].getNumericValue(), this.mExecuteArgs[1].getNumericValue());
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidpathsample"));
            }
            case 38: {
                if (n == 2) {
                    double d89 = this.mExecuteArgs[1].getNumericValue();
                    contextStack.stripePath(this.mExecuteArgs[0].getNumericValue(), Math.toRadians(d89));
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidpathstripe"));
            }
            case 39: {
                if (n == 2) {
                    contextStack.translatePath(this.mExecuteArgs[0].getNumericValue(), this.mExecuteArgs[1].getNumericValue());
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidpathshift"));
            }
            case 40: {
                if (n > 0) {
                    object = new double[n];
                    int n14 = 0;
                    while (n14 < n) {
                        object[n14] = this.mExecuteArgs[n14].getNumericValue();
                        ++n14;
                    }
                    contextStack.parallelPath((double[])object);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invaliddistance"));
            }
            case 41: {
                if (n > 0 && n % 2 == 0) {
                    object = new double[n / 2];
                    double[] dArray = new double[n / 2];
                    int n15 = 0;
                    while (n15 < n / 2) {
                        object[n15] = this.mExecuteArgs[n15 * 2].getNumericValue();
                        dArray[n15] = this.mExecuteArgs[n15 * 2 + 1].getNumericValue();
                        ++n15;
                    }
                    contextStack.selectPath((double[])object, dArray);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("unexpectedvalues"));
            }
            case 42: {
                if (n > 0) {
                    throw new MapyrusException(MapyrusMessages.get("unexpectedvalues"));
                }
                contextStack.createSinkhole();
                break;
            }
            case 44: {
                if (n > 0) {
                    object = new StringBuffer(this.mExecuteArgs[0].getStringValue());
                    int n16 = 1;
                    while (n16 < n) {
                        ((StringBuffer)object).append(this.mExecuteArgs[n16].getStringValue()).append(Constants.LINE_SEPARATOR);
                        ++n16;
                    }
                    contextStack.stroke(((StringBuffer)object).toString());
                    break;
                }
                contextStack.stroke(null);
                break;
            }
            case 45: {
                if (n > 0) {
                    object = new StringBuffer(this.mExecuteArgs[0].getStringValue());
                    int n17 = 1;
                    while (n17 < n) {
                        ((StringBuffer)object).append(this.mExecuteArgs[n17].getStringValue()).append(Constants.LINE_SEPARATOR);
                        ++n17;
                    }
                    contextStack.fill(((StringBuffer)object).toString());
                    break;
                }
                contextStack.fill(null);
                break;
            }
            case 46: {
                if (n == 4 || n == 5) {
                    object = contextStack.getColor();
                    Color color = ColorDatabase.getColor(this.mExecuteArgs[0].toString(), 255, (Color)object);
                    if (color == null) {
                        throw new MapyrusException(MapyrusMessages.get("invalidcolor") + ": " + this.mExecuteArgs[0].toString());
                    }
                    Color color2 = ColorDatabase.getColor(this.mExecuteArgs[1].toString(), 255, (Color)object);
                    if (color2 == null) {
                        throw new MapyrusException(MapyrusMessages.get("invalidcolor") + ": " + this.mExecuteArgs[1].toString());
                    }
                    Color color3 = ColorDatabase.getColor(this.mExecuteArgs[2].toString(), 255, (Color)object);
                    if (color3 == null) {
                        throw new MapyrusException(MapyrusMessages.get("invalidcolor") + ": " + this.mExecuteArgs[2].toString());
                    }
                    Color color4 = ColorDatabase.getColor(this.mExecuteArgs[3].toString(), 255, (Color)object);
                    if (color4 == null) {
                        throw new MapyrusException(MapyrusMessages.get("invalidcolor") + ": " + this.mExecuteArgs[3].toString());
                    }
                    Color color5 = null;
                    if (n == 5 && (color5 = ColorDatabase.getColor(this.mExecuteArgs[4].toString(), 255, (Color)object)) == null) {
                        throw new MapyrusException(MapyrusMessages.get("invalidcolor") + ": " + this.mExecuteArgs[4].toString());
                    }
                    contextStack.gradientFill(color, color2, color3, color4, color5);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidgradientfill"));
            }
            case 47: {
                if (n >= 1) {
                    object = new StringBuffer();
                    int n18 = 0;
                    while (n18 < n) {
                        if (n18 > 0) {
                            ((StringBuffer)object).append(Constants.LINE_SEPARATOR);
                        }
                        ((StringBuffer)object).append(this.mExecuteArgs[n18].toString());
                        ++n18;
                    }
                    contextStack.setEventScript(((StringBuffer)object).toString());
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidscript"));
            }
            case 50: {
                if (n != 1) {
                    throw new MapyrusException(MapyrusMessages.get("noclipside"));
                }
                object = this.mExecuteArgs[0].toString();
                if (((String)object).startsWith(IN_KEYWORD) || ((String)object).startsWith("IN")) {
                    contextStack.clipInside();
                    break;
                }
                contextStack.clipOutside();
                break;
            }
            case 68: {
                if (n == 1) {
                    PrintStream printStream;
                    String string = this.mExecuteArgs[0].getStringValue();
                    if (string.equals("-")) {
                        printStream = this.mStdoutStream;
                    } else if (string.startsWith("|")) {
                        String string2 = string.substring(1).trim();
                        String[] stringArray = Constants.getOSName().indexOf("WIN") >= 0 ? new String[]{string2} : new String[]{"sh", "-c", string2};
                        Process process = Runtime.getRuntime().exec(stringArray);
                        OutputStream outputStream = process.getOutputStream();
                        printStream = new PrintStream(outputStream);
                    } else {
                        FileOutputStream fileOutputStream = new FileOutputStream(string);
                        printStream = new PrintStream(fileOutputStream);
                    }
                    contextStack.setStdout(printStream);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidsetoutput"));
            }
            case 51: 
            case 52: 
            case 69: {
                String string;
                int n19;
                int n20 = 0;
                double d90 = 0.0;
                double d91 = 0.0;
                if (n2 == 52) {
                    if (n < 2) {
                        throw new MapyrusException(MapyrusMessages.get("invalidpathoffset"));
                    }
                    d91 = this.mExecuteArgs[0].getNumericValue();
                    d90 = this.mExecuteArgs[1].getNumericValue();
                    n19 = 2;
                } else {
                    n19 = 0;
                }
                if (n == n19 + 1) {
                    string = this.mExecuteArgs[n19].toString();
                    n20 += string.length();
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n21 = n19;
                    while (n21 < n) {
                        if (n21 > n19) {
                            stringBuffer.append(' ');
                        }
                        String string3 = this.mExecuteArgs[n21].toString();
                        stringBuffer.append(string3);
                        n20 += string3.length();
                        ++n21;
                    }
                    string = stringBuffer.toString();
                }
                if (n2 == 69) {
                    contextStack.getStdout().println(string);
                    break;
                }
                if (n20 <= 0) break;
                if (n2 == 52) {
                    contextStack.flowLabel(d91, d90, string);
                    break;
                }
                contextStack.label(string);
                break;
            }
            case 53: 
            case 54: {
                if (n2 == 54 && n == 2 || n2 == 53 && n >= 2) {
                    String string = this.mExecuteArgs[0].getStringValue();
                    ArrayList<Argument> arrayList = new ArrayList<Argument>(n - 1);
                    int n22 = 1;
                    while (n22 < n) {
                        Argument argument;
                        if (this.mExecuteArgs[n22].getType() == 2) {
                            argument = this.mExecuteArgs[n22];
                        } else {
                            argument = new Argument();
                            argument.addHashMapEntry("1", this.mExecuteArgs[n22]);
                        }
                        arrayList.add(argument);
                        ++n22;
                    }
                    if (n2 == 53) {
                        contextStack.drawTable(string, arrayList);
                        break;
                    }
                    contextStack.drawTree(string, (Argument)arrayList.get(0));
                    break;
                }
                if (n2 == 53) {
                    throw new MapyrusException(MapyrusMessages.get("invalidtable"));
                }
                throw new MapyrusException(MapyrusMessages.get("invalidtree"));
            }
            case 55: {
                if (n == 1 || n == 2) {
                    double d92 = n == 2 ? this.mExecuteArgs[1].getNumericValue() : 0.0;
                    contextStack.drawIcon(this.mExecuteArgs[0].getStringValue(), d92);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidicon"));
            }
            case 56: {
                if (n == 1 || n == 2) {
                    String string = this.mExecuteArgs[0].getStringValue();
                    String string4 = n == 2 ? this.mExecuteArgs[1].getStringValue() : "";
                    contextStack.drawGeoImage(string, string4);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidgeoimage"));
            }
            case 57: {
                if (n == 1 || n == 2) {
                    double d93 = n == 2 ? this.mExecuteArgs[1].getNumericValue() : 0.0;
                    contextStack.drawEPS(this.mExecuteArgs[0].getStringValue(), d93);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalideps"));
            }
            case 58: {
                if (n == 1 || n == 2) {
                    double d94 = n == 2 ? this.mExecuteArgs[1].getNumericValue() : 0.0;
                    contextStack.drawSVG(this.mExecuteArgs[0].getStringValue(), d94);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidsvg"));
            }
            case 59: {
                int n23 = 0;
                while (n23 < n) {
                    contextStack.addSVGCode(this.mExecuteArgs[n23].getStringValue());
                    ++n23;
                }
                break;
            }
            case 60: {
                if (n == 1) {
                    double d95 = this.mExecuteArgs[0].getNumericValue();
                    contextStack.setScaling(d95);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidscaling"));
            }
            case 61: {
                if (n == 1) {
                    double d96 = this.mExecuteArgs[0].getNumericValue();
                    contextStack.setRotation(Math.toRadians(d96));
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidrotation"));
            }
            case 62: {
                double d97;
                double d98;
                double d99;
                double d100;
                if (n == 4 || n == 5) {
                    d100 = 0.0;
                    d99 = 0.0;
                    d98 = 0.0;
                    d97 = 0.0;
                } else if (n == 8 || n == 9) {
                    d97 = this.mExecuteArgs[4].getNumericValue();
                    d98 = this.mExecuteArgs[5].getNumericValue();
                    d99 = this.mExecuteArgs[6].getNumericValue();
                    d100 = this.mExecuteArgs[7].getNumericValue();
                } else {
                    throw new MapyrusException(MapyrusMessages.get("invalidworlds"));
                }
                double d101 = this.mExecuteArgs[0].getNumericValue();
                double d102 = this.mExecuteArgs[1].getNumericValue();
                double d103 = this.mExecuteArgs[2].getNumericValue();
                double d104 = this.mExecuteArgs[3].getNumericValue();
                int n24 = 1;
                boolean bl = false;
                String string = n == 5 ? this.mExecuteArgs[4].getStringValue() : (n == 9 ? this.mExecuteArgs[8].getStringValue() : "");
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string5;
                    String string6 = stringTokenizer.nextToken();
                    if (string6.startsWith("units=")) {
                        string5 = string6.substring(6);
                        Integer n25 = (Integer)mWorldUnitsLookup.get(string5);
                        if (n25 == null) {
                            throw new MapyrusException(MapyrusMessages.get("invalidworldunits") + ": " + string5);
                        }
                        n24 = n25;
                        continue;
                    }
                    if (!string6.startsWith("distortion=")) continue;
                    string5 = string6.substring(11);
                    bl = string5.equalsIgnoreCase("true");
                }
                contextStack.setWorlds(d101, d102, d103, d104, d97, d98, d99, d100, n24, bl);
                break;
            }
            case 63: {
                if (n == 2) {
                    contextStack.setTransform(this.mExecuteArgs[0].getStringValue(), this.mExecuteArgs[1].getStringValue());
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidtransform"));
            }
            case 64: {
                if (n == 3) {
                    contextStack.setDataset(this.mExecuteArgs[0].getStringValue(), this.mExecuteArgs[1].getStringValue(), this.mExecuteArgs[2].getStringValue(), this.mStdinStream);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invaliddataset"));
            }
            case 65: {
                Row row = contextStack.fetchRow();
                String[] stringArray = contextStack.getDatasetFieldNames();
                int n26 = 0;
                while (n26 < row.size()) {
                    String string = stringArray != null ? stringArray[n26] : DefaultFieldNames.get(n26);
                    contextStack.defineVariable(string, (Argument)row.get(n26));
                    ++n26;
                }
                break;
            }
            case 66: {
                if (n >= 3 && n <= 5) {
                    int n27;
                    double d105;
                    double d106;
                    String string = this.mExecuteArgs[0].getStringValue();
                    String string7 = this.mExecuteArgs[1].getStringValue();
                    if (n == 3 || this.mExecuteArgs[2].getType() == 1) {
                        String string8 = this.mExecuteArgs[2].getStringValue();
                        PageSize pageSize = new PageSize(string8);
                        d106 = pageSize.getDimension().getX();
                        d105 = pageSize.getDimension().getY();
                        n27 = 3;
                    } else {
                        d106 = this.mExecuteArgs[2].getNumericValue();
                        d105 = this.mExecuteArgs[3].getNumericValue();
                        n27 = 4;
                    }
                    String string9 = n27 < n ? this.mExecuteArgs[n27].getStringValue() : "";
                    if (d106 <= 0.0) {
                        throw new MapyrusException(MapyrusMessages.get("invalidpagesize") + ": " + d106);
                    }
                    if (d105 <= 0.0) {
                        throw new MapyrusException(MapyrusMessages.get("invalidpagesize") + ": " + d105);
                    }
                    contextStack.setOutputFormat(string, string7, d106, d105, string9, contextStack.getStdout());
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidpage"));
            }
            case 67: {
                contextStack.closeOutputFormat();
                break;
            }
            case 70: {
                break;
            }
            case 72: {
                if (n == 1) {
                    String string = this.mExecuteArgs[0].getStringValue();
                    StringReader stringReader = new StringReader(string);
                    String string10 = "(in eval)";
                    FileOrURL fileOrURL = new FileOrURL(stringReader, string10);
                    byte[] byArray = new byte[]{};
                    this.interpret(contextStack, fileOrURL, new ByteArrayInputStream(byArray), contextStack.getStdout());
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalideval"));
            }
            case 71: {
                break;
            }
            case 73: {
                if (n >= 2) {
                    String string = this.mExecuteArgs[0].getStringValue();
                    String string11 = this.mExecuteArgs[1].getStringValue();
                    int n28 = LegendEntry.parseTypeString(string);
                    if (n28 < 0) {
                        throw new MapyrusException(MapyrusMessages.get("invalidlegendtype") + ": " + string);
                    }
                    this.mContext.addLegendEntry(string11, n28, this.mExecuteArgs, 2, n - 2);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidlegendentry"));
            }
            case 74: {
                if (n == 1) {
                    double d107 = this.mExecuteArgs[0].getNumericValue();
                    this.displayLegend(statement, contextStack, d107);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("nolegendsize"));
            }
            case 75: {
                if (n == 1) {
                    String string = this.mExecuteArgs[0].getStringValue();
                    String string12 = "HTTP/1.0 200 OK" + Constants.LINE_SEPARATOR + "Content-Type" + ": " + string + Constants.LINE_SEPARATOR;
                    contextStack.setHTTPReponse(string12);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("nomimetype"));
            }
            case 76: {
                StringBuffer stringBuffer = new StringBuffer(128);
                int n29 = 0;
                while (n29 < n) {
                    stringBuffer.append(this.mExecuteArgs[n29].getStringValue());
                    stringBuffer.append(Constants.LINE_SEPARATOR);
                    ++n29;
                }
                contextStack.setHTTPReponse(stringBuffer.toString());
            }
        }
    }

    private String parseWord(int n, Preprocessor preprocessor) throws IOException, MapyrusException {
        StringBuffer stringBuffer = new StringBuffer();
        if (!Character.isLetter((char)n) && n != 36) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidkeyword"));
        }
        do {
            stringBuffer.append((char)n);
        } while (Character.isLetterOrDigit((char)(n = preprocessor.read())) || n == 46 || n == 95 || n == 58);
        preprocessor.unread(n);
        return stringBuffer.toString();
    }

    private int readSkipComments(Preprocessor preprocessor) throws IOException, MapyrusException {
        int n = preprocessor.read();
        while (this.mInComment || n == 35) {
            if (n == 35) {
                this.mInComment = true;
                n = preprocessor.read();
                continue;
            }
            if (n == 10 || n == -1) {
                this.mInComment = false;
                continue;
            }
            n = preprocessor.read();
        }
        return n;
    }

    private Statement parseSimpleStatement(String string, Preprocessor preprocessor) throws MapyrusException, IOException {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        Statement statement = null;
        boolean bl = false;
        int n = 1;
        int n2 = this.readSkipComments(preprocessor);
        while (!bl) {
            if (n2 == -1 || n2 == 10) {
                bl = true;
                continue;
            }
            if (Character.isWhitespace((char)n2)) {
                n2 = this.readSkipComments(preprocessor);
                continue;
            }
            if (n == 2) {
                if (n2 != 44) {
                    throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": '" + ',' + "'");
                }
                n2 = this.readSkipComments(preprocessor);
                n = 1;
                continue;
            }
            preprocessor.unread(n2);
            Expression expression = new Expression(preprocessor, this.mUserFunctions);
            arrayList.add(expression);
            n2 = this.readSkipComments(preprocessor);
            n = 2;
        }
        if (n2 == -1 && arrayList.size() == 0) {
            statement = null;
        } else {
            Expression[] expressionArray = new Expression[arrayList.size()];
            int n3 = 0;
            while (n3 < expressionArray.length) {
                expressionArray[n3] = (Expression)arrayList.get(n3);
                ++n3;
            }
            statement = new Statement(string, expressionArray);
            statement.setFilenameAndLineNumber(preprocessor.getCurrentFilename(), preprocessor.getCurrentLineNumber());
        }
        return statement;
    }

    private ArrayList parseParameters(Preprocessor preprocessor) throws IOException, MapyrusException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 3;
        int n2 = this.readSkipComments(preprocessor);
        while (n2 != -1 && n2 != 10) {
            if (Character.isWhitespace((char)n2)) {
                n2 = this.readSkipComments(preprocessor);
                continue;
            }
            if (n == 3) {
                arrayList.add(this.parseWord(n2, preprocessor));
                n = 4;
                n2 = this.readSkipComments(preprocessor);
                continue;
            }
            if (n2 != 44) {
                throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": '" + ',' + "'");
            }
            n = 3;
            n2 = this.readSkipComments(preprocessor);
        }
        return arrayList;
    }

    private ParsedStatement parseProcedureBlock(Preprocessor preprocessor, boolean bl) throws IOException, MapyrusException {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        boolean bl2 = false;
        UserFunction userFunction = null;
        int n = this.readSkipComments(preprocessor);
        while (Character.isWhitespace((char)n)) {
            n = this.readSkipComments(preprocessor);
        }
        String string = this.parseWord(n, preprocessor);
        ArrayList arrayList2 = this.parseParameters(preprocessor);
        if (bl) {
            userFunction = new UserFunction(string, arrayList2, null, this);
            this.mUserFunctions.put(string, userFunction);
        }
        do {
            ParsedStatement parsedStatement;
            if ((parsedStatement = this.parseStatementOrKeyword(preprocessor, true)) == null) {
                throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
            }
            if (parsedStatement.isStatement()) {
                arrayList.add(parsedStatement.getStatement());
                continue;
            }
            if (parsedStatement.getKeywordType() == 1) {
                bl2 = true;
                continue;
            }
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + END_KEYWORD);
        } while (!bl2);
        if (bl) {
            userFunction.setStatements(arrayList);
        }
        Statement statement = new Statement(string, arrayList2, arrayList);
        return new ParsedStatement(statement);
    }

    /*
     * Unable to fully structure code
     */
    private ParsedStatement parseLoopStatement(Preprocessor var1_1, boolean var2_2, boolean var3_3) throws IOException, MapyrusException {
        var6_4 = new ArrayList<Statement>();
        var8_5 = var1_1.getCurrentFilename();
        var9_6 = var1_1.getCurrentLineNumber();
        var5_7 = new Expression(var1_1, this.mUserFunctions);
        var4_8 = this.parseStatementOrKeyword(var1_1, var3_3);
        if (var4_8 == null) {
            throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (var4_8.isStatement() || var4_8.getKeywordType() != 7) {
            throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + "do");
        }
        var4_8 = this.parseStatementOrKeyword(var1_1, var3_3);
        if (var4_8 != null) ** GOTO lbl18
        throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
lbl-1000:
        // 1 sources

        {
            var6_4.add(var4_8.getStatement());
            var4_8 = this.parseStatementOrKeyword(var1_1, var3_3);
            if (var4_8 != null) continue;
            throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
lbl18:
            // 2 sources

            ** while (var4_8.isStatement())
        }
lbl19:
        // 1 sources

        if (var4_8.getKeywordType() != 8) {
            throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + "done");
        }
        var7_9 = new Statement(var5_7, var6_4, var2_2);
        var7_9.setFilenameAndLineNumber(var8_5, var9_6);
        return new ParsedStatement(var7_9);
    }

    /*
     * Unable to fully structure code
     */
    private ParsedStatement parseForStatement(Preprocessor var1_1, boolean var2_2) throws IOException, MapyrusException {
        var6_3 = new ArrayList<Statement>();
        var8_4 = var1_1.getCurrentFilename();
        var9_5 = var1_1.getCurrentLineNumber();
        var4_6 = new Expression(var1_1, this.mUserFunctions);
        var3_7 = this.parseStatementOrKeyword(var1_1, var2_2);
        if (var3_7 == null) {
            throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (var3_7.isStatement() || var3_7.getKeywordType() != 9) {
            throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + "in");
        }
        var5_8 = new Expression(var1_1, this.mUserFunctions);
        var3_7 = this.parseStatementOrKeyword(var1_1, var2_2);
        if (var3_7 == null) {
            throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (var3_7.isStatement() || var3_7.getKeywordType() != 7) {
            throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + "do");
        }
        var3_7 = this.parseStatementOrKeyword(var1_1, var2_2);
        if (var3_7 != null) ** GOTO lbl24
        throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
lbl-1000:
        // 1 sources

        {
            var6_3.add(var3_7.getStatement());
            var3_7 = this.parseStatementOrKeyword(var1_1, var2_2);
            if (var3_7 != null) continue;
            throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
lbl24:
            // 2 sources

            ** while (var3_7.isStatement())
        }
lbl25:
        // 1 sources

        if (var3_7.getKeywordType() != 8) {
            throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + "done");
        }
        var7_9 = new Statement(var4_6, var5_8, var6_3);
        var7_9.setFilenameAndLineNumber(var8_4, var9_5);
        return new ParsedStatement(var7_9);
    }

    /*
     * Unable to fully structure code
     */
    private ParsedStatement parseIfStatement(Preprocessor var1_1, boolean var2_2) throws IOException, MapyrusException {
        block8: {
            block7: {
                var4_3 = var1_1.getCurrentFilename();
                var5_4 = var1_1.getCurrentLineNumber();
                var7_5 = new ArrayList<Statement>();
                var8_6 = new ArrayList<Statement>();
                var10_7 = true;
                var6_8 = new Expression(var1_1, this.mUserFunctions);
                var3_9 = this.parseStatementOrKeyword(var1_1, var2_2);
                if (var3_9 == null) {
                    throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
                }
                if (var3_9.isStatement() || var3_9.getKeywordType() != 2) {
                    throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + "then");
                }
                var3_9 = this.parseStatementOrKeyword(var1_1, var2_2);
                if (var3_9 != null) ** GOTO lbl20
                throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
lbl-1000:
                // 1 sources

                {
                    var7_5.add(var3_9.getStatement());
                    var3_9 = this.parseStatementOrKeyword(var1_1, var2_2);
                    if (var3_9 != null) continue;
                    throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
lbl20:
                    // 2 sources

                    ** while (var3_9.isStatement())
                }
lbl21:
                // 1 sources

                if (var3_9.getKeywordType() != 3) break block7;
                var3_9 = this.parseStatementOrKeyword(var1_1, var2_2);
                if (var3_9 != null) ** GOTO lbl30
                throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
lbl-1000:
                // 1 sources

                {
                    var8_6.add(var3_9.getStatement());
                    var3_9 = this.parseStatementOrKeyword(var1_1, var2_2);
                    if (var3_9 != null) continue;
                    throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
lbl30:
                    // 2 sources

                    ** while (var3_9.isStatement())
                }
lbl31:
                // 1 sources

                break block8;
            }
            if (var3_9.getKeywordType() == 4) {
                var3_9 = this.parseIfStatement(var1_1, var2_2);
                if (!var3_9.isStatement()) {
                    throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + "endif");
                }
                var8_6.add(var3_9.getStatement());
                var10_7 = false;
            }
        }
        if (var10_7 && var3_9.getKeywordType() != 5) {
            throw new MapyrusException(var1_1.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + "endif");
        }
        var9_10 = new Statement(var6_8, var7_5, var8_6);
        var9_10.setFilenameAndLineNumber(var4_3, var5_4);
        return new ParsedStatement(var9_10);
    }

    private ParsedStatement parseStatementOrKeyword(Preprocessor preprocessor, boolean bl) throws MapyrusException, IOException {
        ParsedStatement parsedStatement = null;
        boolean bl2 = false;
        int n = this.readSkipComments(preprocessor);
        bl2 = false;
        while (!bl2) {
            if (n == -1) {
                bl2 = true;
                break;
            }
            if (Character.isWhitespace((char)n)) {
                n = this.readSkipComments(preprocessor);
                continue;
            }
            String string = this.parseWord(n, preprocessor);
            String string2 = string.toLowerCase();
            if (string2.equals(BEGIN_KEYWORD) || string2.equals(FUNCTION_KEYWORD)) {
                if (bl) {
                    throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("nestedproc"));
                }
                parsedStatement = this.parseProcedureBlock(preprocessor, string2.equals(FUNCTION_KEYWORD));
            } else if (string2.equals(IF_KEYWORD)) {
                parsedStatement = this.parseIfStatement(preprocessor, bl);
            } else if (string2.equals(WHILE_KEYWORD)) {
                parsedStatement = this.parseLoopStatement(preprocessor, true, bl);
            } else if (string2.equals(REPEAT_KEYWORD)) {
                parsedStatement = this.parseLoopStatement(preprocessor, false, bl);
            } else if (string2.equals(FOR_KEYWORD)) {
                parsedStatement = this.parseForStatement(preprocessor, bl);
            } else {
                parsedStatement = (ParsedStatement)mKeywordLookup.get(string2);
                if (parsedStatement == null) {
                    Statement statement = this.parseSimpleStatement(string, preprocessor);
                    parsedStatement = new ParsedStatement(statement);
                }
            }
            bl2 = true;
        }
        return parsedStatement;
    }

    private Statement parseStatement(Preprocessor preprocessor) throws IOException, MapyrusException {
        ParsedStatement parsedStatement = this.parseStatementOrKeyword(preprocessor, false);
        if (parsedStatement == null) {
            return null;
        }
        if (!parsedStatement.isStatement()) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidkeyword"));
        }
        return parsedStatement.getStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interpret(ContextStack contextStack, FileOrURL fileOrURL, InputStream inputStream, PrintStream printStream) throws IOException, MapyrusException {
        Preprocessor preprocessor = new Preprocessor(fileOrURL);
        this.mInComment = false;
        this.mStdinStream = inputStream;
        this.mStdoutStream = printStream;
        this.mContext = contextStack;
        contextStack.setStdout(printStream);
        try {
            Statement statement;
            while ((statement = this.parseStatement(preprocessor)) != null) {
                Argument argument = this.executeStatement(statement);
                if (argument != null) break;
            }
            Object var9_8 = null;
            preprocessor.close();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            preprocessor.close();
            throw throwable;
        }
    }

    private void makeCall(Statement statement, ArrayList arrayList, Argument[] argumentArray) throws IOException, MapyrusException {
        int n = 0;
        while (n < argumentArray.length) {
            String string = (String)arrayList.get(n);
            this.mContext.setLocalScope(string);
            this.mContext.defineVariable(string, argumentArray[n]);
            ++n;
        }
        ArrayList arrayList2 = statement.getStatementBlock();
        int n2 = 0;
        while (n2 < arrayList2.size()) {
            Statement statement2 = (Statement)arrayList2.get(n2);
            if (this.executeStatement(statement2) != null) break;
            ++n2;
        }
    }

    public Argument executeStatement(Statement statement) throws IOException, MapyrusException {
        Argument argument;
        block31: {
            int n;
            block36: {
                Argument argument2;
                block35: {
                    Argument argument3;
                    block34: {
                        Argument argument4;
                        block33: {
                            block32: {
                                n = statement.getType();
                                argument = null;
                                if (n != 6) break block32;
                                this.mStatementBlocks.put(statement.getBlockName(), statement);
                                break block31;
                            }
                            if (n != 1001) break block33;
                            Expression[] expressionArray = statement.getExpressions();
                            if (expressionArray.length > 1) {
                                throw new MapyrusException(MapyrusMessages.get("invalidexpression"));
                            }
                            argument = expressionArray.length == 0 ? Argument.emptyString : expressionArray[0].evaluate(this.mContext, statement.getFilename());
                            break block31;
                        }
                        if (n != 2) break block34;
                        Expression[] expressionArray = statement.getExpressions();
                        try {
                            argument4 = expressionArray[0].evaluate(this.mContext, statement.getFilename());
                        }
                        catch (MapyrusException mapyrusException) {
                            throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + mapyrusException.getMessage());
                        }
                        if (argument4.getType() != 0) {
                            throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidexpression"));
                        }
                        ArrayList arrayList = argument4.getNumericValue() != 0.0 ? statement.getThenStatements() : statement.getElseStatements();
                        if (arrayList == null) break block31;
                        int n2 = 0;
                        while (n2 < arrayList.size()) {
                            statement = (Statement)arrayList.get(n2);
                            argument = this.executeStatement(statement);
                            if (argument == null) {
                                ++n2;
                                continue;
                            }
                            break block31;
                        }
                        break block31;
                    }
                    if (n != 4 && n != 3) break block35;
                    Expression[] expressionArray = statement.getExpressions();
                    ArrayList arrayList = statement.getLoopStatements();
                    try {
                        argument3 = expressionArray[0].evaluate(this.mContext, statement.getFilename());
                    }
                    catch (MapyrusException mapyrusException) {
                        throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + mapyrusException.getMessage());
                    }
                    if (argument3.getType() != 0) {
                        throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidexpression"));
                    }
                    int n3 = 0;
                    if (n == 3) {
                        double d = argument3.getNumericValue();
                        n3 = NumericalAnalysis.equals(d, (double)((int)d)) ? (int)Math.round(d) : (int)argument3.getNumericValue();
                    }
                    int n4 = 0;
                    int n5 = n;
                    while (argument == null && (n5 == 4 && argument3.getNumericValue() != 0.0 || n5 == 3 && n4 < n3)) {
                        int n6 = 0;
                        while (n6 < arrayList.size()) {
                            Statement statement2 = (Statement)arrayList.get(n6);
                            argument = this.executeStatement(statement2);
                            if (argument != null) break;
                            ++n6;
                        }
                        if (n5 == 4 && argument == null && (argument3 = expressionArray[0].evaluate(this.mContext, statement.getFilename())).getType() != 0) {
                            throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidexpression"));
                        }
                        ++n4;
                    }
                    break block31;
                }
                if (n != 5) break block36;
                Expression[] expressionArray = statement.getExpressions();
                Expression expression = statement.getForHashMap();
                ArrayList arrayList = statement.getLoopStatements();
                String string = expressionArray[0].getVariableName();
                try {
                    argument2 = expression.evaluate(this.mContext, statement.getFilename());
                }
                catch (MapyrusException mapyrusException) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + mapyrusException.getMessage());
                }
                if (string == null) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("variableexpected"));
                }
                if (argument2.getType() != 2) break block31;
                Object[] objectArray = argument2.getHashMapKeys();
                boolean bl = false;
                int n7 = 0;
                while (n7 < objectArray.length && !bl) {
                    String string2 = (String)objectArray[n7];
                    this.mContext.defineVariable(string, new Argument(1, string2));
                    int n8 = 0;
                    while (n8 < arrayList.size()) {
                        Statement statement3 = (Statement)arrayList.get(n8);
                        argument = this.executeStatement(statement3);
                        if (argument != null) break;
                        ++n8;
                    }
                    ++n7;
                }
                break block31;
            }
            if (n == 1000) {
                int n9;
                Argument[] argumentArray;
                String string = statement.getBlockName();
                Statement statement4 = (Statement)this.mStatementBlocks.get(string);
                if (statement4 == null) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("undefinedproc") + ": " + string);
                }
                ArrayList arrayList = statement4.getBlockParameters();
                Expression[] expressionArray = statement.getExpressions();
                if (expressionArray.length != arrayList.size()) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("wrongparameters"));
                }
                try {
                    argumentArray = new Argument[expressionArray.length];
                    n9 = 0;
                    while (n9 < argumentArray.length) {
                        argumentArray[n9] = expressionArray[n9].evaluate(this.mContext, statement.getFilename());
                        ++n9;
                    }
                }
                catch (MapyrusException mapyrusException) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + mapyrusException.getMessage());
                }
                n9 = this.mContext.getMoveToCount();
                int n10 = this.mContext.getLineToCount();
                if (n9 > 0 && n10 == 0) {
                    ArrayList arrayList2 = this.mContext.getMoveTos();
                    ArrayList arrayList3 = this.mContext.getMoveToRotations();
                    int n11 = 0;
                    while (n11 < n9) {
                        this.mContext.saveState(string);
                        Point2D.Float float_ = (Point2D.Float)arrayList2.get(n11);
                        this.mContext.setTranslation(float_.x, float_.y);
                        this.mContext.clearPath();
                        double d = (Double)arrayList3.get(n11);
                        this.mContext.setRotation(d);
                        this.makeCall(statement4, arrayList, argumentArray);
                        this.mContext.restoreState();
                        ++n11;
                    }
                } else {
                    this.mContext.saveState(string);
                    this.makeCall(statement4, arrayList, argumentArray);
                    this.mContext.restoreState();
                }
            } else {
                try {
                    this.execute(statement, this.mContext);
                }
                catch (MapyrusException mapyrusException) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + mapyrusException.getMessage());
                }
                catch (IOException iOException) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + iOException.getMessage());
                }
            }
        }
        return argument;
    }

    public Object clone() {
        Interpreter interpreter = new Interpreter();
        interpreter.mExecuteArgs = null;
        interpreter.mContext = null;
        interpreter.mInComment = false;
        interpreter.mStatementBlocks = (HashMap)this.mStatementBlocks.clone();
        interpreter.mUserFunctions = new HashMap(this.mUserFunctions.size());
        Iterator iterator = this.mUserFunctions.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            UserFunction userFunction = (UserFunction)this.mUserFunctions.get(string);
            interpreter.mUserFunctions.put(string, userFunction.clone(interpreter));
        }
        interpreter.mStdinStream = null;
        interpreter.mStdoutStream = null;
        return interpreter;
    }

    static {
        mWorldUnitsLookup.put("m", new Integer(1));
        mWorldUnitsLookup.put("metres", new Integer(1));
        mWorldUnitsLookup.put("meters", new Integer(1));
        mWorldUnitsLookup.put("feet", new Integer(2));
        mWorldUnitsLookup.put("foot", new Integer(2));
        mWorldUnitsLookup.put("ft", new Integer(2));
        mWorldUnitsLookup.put("degrees", new Integer(3));
        mWorldUnitsLookup.put("degree", new Integer(3));
        mWorldUnitsLookup.put("deg", new Integer(3));
        mKeywordLookup = new HashMap();
        mKeywordLookup.put(END_KEYWORD, new ParsedStatement(1));
        mKeywordLookup.put(THEN_KEYWORD, new ParsedStatement(2));
        mKeywordLookup.put(ELSE_KEYWORD, new ParsedStatement(3));
        mKeywordLookup.put(ELIF_KEYWORD, new ParsedStatement(4));
        mKeywordLookup.put(ENDIF_KEYWORD, new ParsedStatement(5));
        mKeywordLookup.put(DO_KEYWORD, new ParsedStatement(7));
        mKeywordLookup.put(DONE_KEYWORD, new ParsedStatement(8));
        mKeywordLookup.put(IN_KEYWORD, new ParsedStatement(9));
    }
}

