/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapyrus.ColorDatabase;
import org.mapyrus.Constants;
import org.mapyrus.ContextStack;
import org.mapyrus.FileOrURL;
import org.mapyrus.HTTPRequest;
import org.mapyrus.Interpreter;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.Pool;
import org.mapyrus.Throttle;
import org.mapyrus.logging.SingleLineFormatter;

public class Mapyrus {
    private static final String OUT_OF_MEMORY_MESSAGE = "Out of memory.  Use Java -Xmx option to increase memory\navailable to Mapyrus.  For example, java -Xmx256m -classpath ...\n";
    private Interpreter mInterpreter = new Interpreter();
    private ContextStack mContext = new ContextStack();
    static /* synthetic */ Class class$org$mapyrus$Mapyrus;

    private StringReader makeStringReader(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(Constants.LINE_SEPARATOR);
            ++n;
        }
        StringReader stringReader = new StringReader(stringBuffer.toString());
        return stringReader;
    }

    public void interpret(String[] stringArray, InputStream inputStream, PrintStream printStream) throws IOException, MapyrusException {
        StringReader stringReader = this.makeStringReader(stringArray);
        FileOrURL fileOrURL = new FileOrURL(stringReader, "commands");
        ColorDatabase.load();
        this.mInterpreter.interpret(this.mContext, fileOrURL, inputStream, printStream);
    }

    public void setPage(BufferedImage bufferedImage, String string) throws IOException, MapyrusException {
        if (string == null) {
            string = "";
        }
        Mapyrus.initialise();
        this.mContext.setOutputFormat(bufferedImage, string);
    }

    public void close() throws IOException, MapyrusException {
        try {
            block5: {
                try {
                    if (this.mContext == null) break block5;
                    this.mContext.closeContextStack();
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (MapyrusException mapyrusException) {
                    throw mapyrusException;
                }
            }
            Object var4_1 = null;
            this.mContext = null;
            this.mInterpreter = null;
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            this.mContext = null;
            this.mInterpreter = null;
            throw throwable;
        }
    }

    private static void printUsageAndExit() {
        String[] stringArray = new String[]{"Usage:", "java [-Dvariable=value] ... -classpath " + "Mapyrus".toLowerCase() + ".jar org.mapyrus.Mapyrus", "        [options] filename ...", "", "Mapyrus reads each file or URL in turn.", "If filename is '-' then standard input is read.", "", "Variables and configuration are passed to Mapyrus using the Java -D option.", "", "Options:", "  -e <commands> runs given commands instead of reading commands from a file", "  -h            print this message", "  -l <level>    sets logging level for HTTP server.  One of ", "                FINEST, FINER, FINE, CONFIG, INFO, WARNING, SEVERE.", "  -r <percent>  sets maximum CPU load.  Mapyrus runs more slowly,", "                giving other processes more CPU time", "  -s <port>     starts Mapyrus as a self-contained HTTP server on the", "                given port.  Refer to manual for detailed instructions.", "  -v            print version information and exit"};
        String[] stringArray2 = new String[]{"Mapyrus comes with ABSOLUTELY NO WARRANTY, not even for MERCHANTABILITY or", "FITNESS FOR A PARTICULAR PURPOSE.  You may redistribute copies of Mapyrus", "under the terms of the GNU Lesser General Public License.  For more", "information about these matters, see the file named COPYING."};
        int n = 0;
        while (n < stringArray.length) {
            System.out.println(stringArray[n]);
            ++n;
        }
        System.out.println("");
        int n2 = 0;
        while (n2 < stringArray2.length) {
            System.out.println(stringArray2[n2]);
            ++n2;
        }
        System.out.println("");
        System.out.println("Report bugs to <simoc@users.sourceforge.net>.");
        System.exit(1);
    }

    private static boolean processFile(ContextStack contextStack, FileOrURL fileOrURL, Interpreter interpreter, boolean bl) {
        try {
            interpreter.interpret(contextStack, fileOrURL, System.in, System.out);
            if (bl) {
                fileOrURL.getReader().close();
            }
        }
        catch (MapyrusException mapyrusException) {
            System.err.println(mapyrusException.getMessage());
            return false;
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
            return false;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.err.println(OUT_OF_MEMORY_MESSAGE);
            outOfMemoryError.printStackTrace();
            return false;
        }
        return true;
    }

    private static void initialise() {
        try {
            ColorDatabase.load();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            System.exit(1);
        }
        catch (MapyrusException mapyrusException) {
            System.err.println(mapyrusException.getMessage());
            System.exit(1);
        }
    }

    private static Socket acceptConnection(ServerSocket serverSocket, Logger logger) throws IOException {
        Socket socket = null;
        while (socket == null) {
            try {
                socket = serverSocket.accept();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                logger.info(MapyrusMessages.get("idle"));
            }
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void serveHttp(Interpreter interpreter, int n, Level level) {
        HashSet<HTTPRequest> hashSet;
        ServerSocket serverSocket = null;
        Pool pool = new Pool();
        pool.put(interpreter);
        int n2 = 1;
        while (true) {
            if (n2 >= 8) {
                hashSet = new HashSet<HTTPRequest>();
            }
            pool.put(interpreter.clone());
            ++n2;
        }
        String string = (class$org$mapyrus$Mapyrus == null ? (class$org$mapyrus$Mapyrus = Mapyrus.class$("org.mapyrus.Mapyrus")) : class$org$mapyrus$Mapyrus).getName();
        Logger logger = Logger.getLogger(string);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(new SingleLineFormatter());
        if (level != null) {
            logger.setLevel(level);
            consoleHandler.setLevel(level);
        }
        logger.addHandler(consoleHandler);
        logger.setUseParentHandlers(false);
        try {
            serverSocket = new ServerSocket(n);
            n = serverSocket.getLocalPort();
        }
        catch (IOException iOException) {
            System.err.println(MapyrusMessages.get("inithttpfailed") + ": " + iOException.getMessage());
            return;
        }
        String string2 = "Mapyrus " + Constants.getVersion() + " " + Constants.getReleaseDate();
        String string3 = MapyrusMessages.get("httpthreadedserver") + ": " + 8;
        String string4 = MapyrusMessages.get("acceptinghttp") + ": " + n;
        logger.config(string2);
        logger.config(string3);
        logger.config(string4);
        if (!logger.isLoggable(Level.CONFIG)) {
            System.out.println(string2);
            System.out.println(string3);
            System.out.println(string4);
        }
        while (true) {
            IOException iOException22;
            Object var22_24;
            Socket socket = null;
            try {
                try {
                    socket = Mapyrus.acceptConnection(serverSocket, logger);
                    socket.setSoTimeout(30000);
                    interpreter = (Interpreter)pool.get(30000L);
                    if (interpreter == null) {
                        throw new MapyrusException(MapyrusMessages.get("httptimeout"));
                    }
                    HTTPRequest hTTPRequest = new HTTPRequest(socket, interpreter, pool, logger);
                    hashSet.add(hTTPRequest);
                    logger.fine(MapyrusMessages.get("startedthread") + ": " + hTTPRequest.getName());
                    socket = null;
                    hTTPRequest.start();
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        HTTPRequest hTTPRequest2 = (HTTPRequest)iterator.next();
                        if (!hTTPRequest2.isAlive()) {
                            hTTPRequest2.join();
                            logger.fine(MapyrusMessages.get("joinedthread") + ": " + hTTPRequest2.getName());
                            if (!hTTPRequest2.getStatus()) {
                                logger.severe(hTTPRequest2.getName() + ": " + hTTPRequest2.getErrorMessage());
                            }
                            iterator.remove();
                            continue;
                        }
                        long l = System.currentTimeMillis();
                        long l2 = l - hTTPRequest2.getCreationTime();
                        if (l2 <= 600000L) continue;
                        hTTPRequest2.interrupt();
                    }
                }
                catch (IOException iOException) {
                    logger.severe(iOException.getMessage());
                    var22_24 = null;
                    try {
                        if (socket == null) continue;
                        socket.close();
                    }
                    catch (IOException iOException22) {}
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    logger.severe(interruptedException.getMessage());
                    var22_24 = null;
                    try {}
                    catch (IOException iOException22) {}
                    if (socket == null) continue;
                    socket.close();
                    continue;
                }
                catch (MapyrusException mapyrusException) {
                    logger.severe(mapyrusException.getMessage());
                    var22_24 = null;
                    try {}
                    catch (IOException iOException22) {}
                    if (socket == null) continue;
                    socket.close();
                    continue;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    logger.severe(OUT_OF_MEMORY_MESSAGE);
                    var22_24 = null;
                    try {}
                    catch (IOException iOException22) {}
                    if (socket == null) continue;
                    socket.close();
                    continue;
                }
                var22_24 = null;
                {
                }
            }
            catch (Throwable throwable) {
                var22_24 = null;
                try {}
                catch (IOException iOException22) {
                    throw throwable;
                }
                if (socket == null) throw throwable;
                socket.close();
                throw throwable;
            }
            try {}
            catch (IOException iOException22) {}
            if (socket == null) continue;
            socket.close();
        }
    }

    private static String getJavaConfiguration() {
        String string;
        String string2;
        String string3 = System.getProperty("java.vendor");
        if (string3 == null) {
            string3 = "null";
        }
        if ((string2 = System.getProperty("java.version")) == null) {
            string2 = "null";
        }
        if ((string = System.getProperty("java.home")) == null) {
            string = "null";
        }
        return "Java version " + string2 + " (" + string3 + ") in " + string;
    }

    public static void main(String[] stringArray) {
        Object object;
        FileOrURL fileOrURL = null;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        Level level = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray.length == 0) {
            Mapyrus.printUsageAndExit();
        }
        while (n < stringArray.length && stringArray[n].startsWith("-") && stringArray[n].length() > 1) {
            object = stringArray[n];
            if (((String)object).equals("-h") || ((String)object).equals("--help") || ((String)object).equals("-?")) {
                Mapyrus.printUsageAndExit();
                continue;
            }
            if (((String)object).equals("-v") || ((String)object).equals("--version")) {
                System.out.println("Mapyrus " + Constants.getVersion() + " " + Constants.getReleaseDate());
                System.out.println(Mapyrus.getJavaConfiguration());
                System.exit(1);
                continue;
            }
            if (((String)object).equals("-s")) {
                if (n + 1 == stringArray.length) {
                    Mapyrus.printUsageAndExit();
                }
                try {
                    n2 = Integer.parseInt(stringArray[n + 1]);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(MapyrusMessages.get("invalidnumber") + ": " + stringArray[n + 1]);
                    Mapyrus.printUsageAndExit();
                }
                n += 2;
                bl = true;
                continue;
            }
            if (((String)object).equals("-e")) {
                if (n + 1 == stringArray.length) {
                    Mapyrus.printUsageAndExit();
                }
                stringBuffer.append(stringArray[n + 1]);
                stringBuffer.append(Constants.LINE_SEPARATOR);
                n += 2;
                continue;
            }
            if (((String)object).equals("-l")) {
                if (n + 1 == stringArray.length) {
                    Mapyrus.printUsageAndExit();
                }
                try {
                    level = Level.parse(stringArray[n + 1]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println(illegalArgumentException.getMessage());
                    System.exit(1);
                }
                n += 2;
                continue;
            }
            if (((String)object).equals("-r")) {
                if (n + 1 == stringArray.length) {
                    Mapyrus.printUsageAndExit();
                }
                try {
                    int n3 = Integer.parseInt(stringArray[n + 1]);
                    Throttle.setMaxLoad(n3);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(MapyrusMessages.get("invalidnumber") + ": " + stringArray[n + 1]);
                    Mapyrus.printUsageAndExit();
                }
                n += 2;
                continue;
            }
            if (((String)object).equals("--")) {
                ++n;
                break;
            }
            System.err.println(MapyrusMessages.get("invalidoption") + ": " + (String)object);
            System.exit(1);
        }
        Mapyrus.initialise();
        ContextStack contextStack = new ContextStack();
        object = new Interpreter();
        if (stringBuffer.length() > 0) {
            fileOrURL = new FileOrURL(new StringReader(stringBuffer.toString()), "-e");
            if (!Mapyrus.processFile(contextStack, fileOrURL, (Interpreter)object, false)) {
                System.exit(1);
            }
        } else {
            int n4 = n;
            while (n4 < stringArray.length) {
                boolean bl2 = stringArray[n4].equals("-");
                if (bl2) {
                    fileOrURL = new FileOrURL(new InputStreamReader(System.in), "standard input");
                } else {
                    try {
                        fileOrURL = new FileOrURL(stringArray[n4]);
                    }
                    catch (IOException iOException) {
                        System.err.println(iOException.getMessage());
                        System.exit(1);
                    }
                    catch (MapyrusException mapyrusException) {
                        System.err.println(mapyrusException.getMessage());
                        System.exit(1);
                    }
                }
                if (!Mapyrus.processFile(contextStack, fileOrURL, (Interpreter)object, !bl2)) {
                    System.exit(1);
                }
                ++n4;
            }
        }
        try {
            contextStack.closeContextStack();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            System.exit(1);
        }
        catch (MapyrusException mapyrusException) {
            System.err.println(mapyrusException.getMessage());
            System.exit(1);
        }
        if (bl) {
            Mapyrus.serveHttp((Interpreter)object, n2, level);
            System.exit(1);
        }
        System.exit(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

