/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.mapyrus.Constants;
import org.mapyrus.ImageSelection;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.Mutex;

public class MapyrusFrame {
    private Mutex mMutex;
    JFrame mFrame;
    BufferedImage mImage;

    public MapyrusFrame(String string, BufferedImage bufferedImage) {
        Container container;
        this.mImage = bufferedImage;
        this.mFrame = new JFrame(string);
        ImageIcon imageIcon = new ImageIcon(bufferedImage);
        JLabel jLabel = new JLabel(imageIcon);
        Container container2 = this.mFrame.getContentPane();
        container2.setLayout(new BorderLayout());
        double d = Constants.getScreenWidth() / 25.4 * (double)Constants.getScreenResolution();
        double d2 = Constants.getScreenHeight() / 25.4 * (double)Constants.getScreenResolution();
        if ((double)bufferedImage.getWidth() > d || (double)bufferedImage.getHeight() > d2) {
            container = new ScrollPane();
            container.add(jLabel);
            container2.add((Component)container, "Center");
        } else {
            container2.add((Component)jLabel, "Center");
        }
        this.mMutex = new Mutex();
        this.mMutex.lock();
        container = new JMenuBar();
        JMenu jMenu = new JMenu(MapyrusMessages.get("file"));
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem(MapyrusMessages.get("exportaspng"));
        jMenuItem.setMnemonic(69);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapyrusFrame.this.exportToPNG();
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(MapyrusMessages.get("exit"));
        jMenuItem2.setMnemonic(88);
        jMenu.addSeparator();
        jMenu.add(jMenuItem2);
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapyrusFrame.this.mMutex.unlock();
            }
        });
        JMenu jMenu2 = new JMenu(MapyrusMessages.get("edit"));
        jMenu2.setMnemonic(69);
        JMenuItem jMenuItem3 = new JMenuItem(MapyrusMessages.get("copy"));
        jMenuItem3.setMnemonic(67);
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageSelection imageSelection = new ImageSelection(MapyrusFrame.this.mImage);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(imageSelection, null);
            }
        });
        jMenu2.add(jMenuItem3);
        ((JMenuBar)container).add(jMenu);
        ((JMenuBar)container).add(jMenu2);
        container2.add((Component)container, "North");
        this.mFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MapyrusFrame.this.mMutex.unlock();
            }
        });
        this.mFrame.pack();
        this.mFrame.setVisible(true);
    }

    private void exportToPNG() {
        block2: {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setFileFilter(new PNGImageFilter());
            int n = jFileChooser.showSaveDialog(this.mFrame);
            if (n != 0) break block2;
            try {
                File file = jFileChooser.getSelectedFile();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                ImageIO.write((RenderedImage)this.mImage, "png", fileOutputStream);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.mFrame, iOException.getMessage(), "Mapyrus", 0);
            }
        }
    }

    public void waitForClose() {
        this.mMutex.lock();
    }

    private class PNGImageFilter
    extends FileFilter {
        private PNGImageFilter() {
        }

        public boolean accept(File file) {
            boolean bl = file.isDirectory();
            if (!bl) {
                String string = file.getName();
                bl = string.endsWith(".png") || string.endsWith(".PNG");
            }
            return bl;
        }

        public String getDescription() {
            return MapyrusMessages.get("pngimagefiles");
        }
    }
}

