/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class PageMask {
    BufferedImage mMask;
    private Graphics2D mMaskGraphics;
    private int mMaskWidth;
    private int mMaskHeight;
    private static final int PIXELS_PER_MM = 3;

    public PageMask(int n, int n2) {
        this.mMask = new BufferedImage(n * 3, n2 * 3, 12);
        this.mMaskGraphics = (Graphics2D)this.mMask.getGraphics();
        this.mMaskGraphics.scale(3.0, 3.0);
        this.mMaskGraphics.setColor(Color.BLACK);
        this.mMaskGraphics.fillRect(0, 0, n, n2);
        this.mMaskWidth = n;
        this.mMaskHeight = n2;
    }

    public void setValue(int n, int n2, int n3, int n4, int n5) {
        int n6 = Math.min(n, n3);
        int n7 = Math.max(n, n3);
        int n8 = Math.min(n2, n4);
        int n9 = Math.max(n2, n4);
        int n10 = Math.max(n7 - n6, 1);
        int n11 = Math.max(n9 - n8, 1);
        this.mMaskGraphics.setColor(n5 != 0 ? Color.WHITE : Color.BLACK);
        this.mMaskGraphics.fillRect(n6, n8, n10, n11);
    }

    public void setValue(Shape shape, int n) {
        this.mMaskGraphics.setColor(n != 0 ? Color.WHITE : Color.BLACK);
        Rectangle2D rectangle2D = shape.getBounds2D();
        if (rectangle2D.getWidth() == 0.0 && rectangle2D.getHeight() == 0.0) {
            this.mMaskGraphics.fillRect((int)rectangle2D.getMinX(), (int)rectangle2D.getMinY(), 1, 1);
        } else {
            this.mMaskGraphics.fill(shape);
        }
    }

    public boolean isAllZero(int n, int n2, int n3, int n4) {
        int n5 = Math.min(n, n3);
        int n6 = Math.max(n, n3);
        int n7 = Math.min(n2, n4);
        int n8 = Math.max(n2, n4);
        boolean bl = n5 < 0 || n7 < 0 || n6 >= this.mMaskWidth || n8 >= this.mMaskHeight;
        int n9 = n7 * 3;
        while (!bl && n9 <= n8 * 3) {
            int n10 = n5 * 3;
            while (!bl && n10 <= n6 * 3) {
                int n11 = this.mMask.getRGB(n10, n9) & 0xFFFFFF;
                bl = n11 != 0;
                ++n10;
            }
            ++n9;
        }
        return !bl;
    }

    public boolean isAllZero(Shape shape) {
        boolean bl;
        Rectangle2D rectangle2D = shape.getBounds2D();
        boolean bl2 = bl = rectangle2D.getMinX() < 0.0 || rectangle2D.getMinY() < 0.0 || rectangle2D.getMaxX() >= (double)this.mMaskWidth || rectangle2D.getMaxY() >= (double)this.mMaskHeight;
        if (!bl) {
            BufferedImage bufferedImage = new BufferedImage(this.mMaskWidth * 3, this.mMaskHeight * 3, 12);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.scale(3.0, 3.0);
            graphics2D.setColor(Color.BLACK);
            graphics2D.fillRect(0, 0, this.mMaskWidth, this.mMaskHeight);
            graphics2D.setColor(Color.WHITE);
            if (rectangle2D.getWidth() == 0.0 && rectangle2D.getHeight() == 0.0) {
                graphics2D.fillRect((int)rectangle2D.getMinX(), (int)rectangle2D.getMinY(), 1, 1);
            } else {
                graphics2D.fill(shape);
            }
            int n = (int)(rectangle2D.getMinY() * 3.0);
            int n2 = (int)(rectangle2D.getMaxX() * 3.0);
            int n3 = (int)(rectangle2D.getMaxY() * 3.0);
            while (n <= n3 && !bl) {
                int n4 = (int)(rectangle2D.getMinX() * 3.0);
                while (n4 <= n2 && !bl) {
                    int n5 = bufferedImage.getRGB(n4, n) & 0xFFFFFF;
                    if (n5 != 0) {
                        int n6 = this.mMask.getRGB(n4, n) & 0xFFFFFF;
                        bl = n6 != 0;
                    }
                    ++n4;
                }
                ++n;
            }
        }
        return !bl;
    }
}

