/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.LinkedList;
import org.mapyrus.FileOrURL;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;

class Preprocessor {
    private static final String INCLUDE_KEYWORD = "include";
    private LinkedList mFileStack;
    private FileOrURL mInitialFile;
    private StringBuffer mCurrentLine = null;
    private int mCurrentLineIndex = 0;

    private void initFileStack(FileOrURL fileOrURL) {
        this.mFileStack = new LinkedList();
        this.mFileStack.add(fileOrURL);
        this.mInitialFile = fileOrURL;
    }

    public Preprocessor(FileOrURL fileOrURL) {
        this.initFileStack(fileOrURL);
    }

    public Preprocessor(String string) throws IOException, MapyrusException {
        FileOrURL fileOrURL = new FileOrURL(string);
        this.initFileStack(fileOrURL);
    }

    private void openIncludedFile(String string) throws MalformedURLException, IOException, MapyrusException {
        FileOrURL fileOrURL = (FileOrURL)this.mFileStack.getLast();
        FileOrURL fileOrURL2 = fileOrURL.isURL() ? new FileOrURL(string, fileOrURL) : new FileOrURL(string);
        if (fileOrURL2.isURL()) {
            String string2;
            try {
                string2 = fileOrURL2.getURLContentType();
            }
            catch (IOException iOException) {
                fileOrURL2.getReader().close();
                throw iOException;
            }
            if (!string2.startsWith("text/")) {
                fileOrURL2.getReader().close();
                throw new MapyrusException(MapyrusMessages.get("nottextfile") + ": " + fileOrURL2.toString());
            }
        }
        this.mFileStack.add(fileOrURL2);
    }

    public int readNonSpace() throws IOException, MapyrusException {
        int n;
        while ((n = this.read()) != -1 && Character.isWhitespace((char)n) && n != 10) {
        }
        return n;
    }

    public int read() throws IOException, MapyrusException {
        if (this.mCurrentLine != null && this.mCurrentLineIndex < this.mCurrentLine.length()) {
            char c = this.mCurrentLine.charAt(this.mCurrentLineIndex++);
            return c;
        }
        this.mCurrentLineIndex = 0;
        FileOrURL fileOrURL = (FileOrURL)this.mFileStack.getLast();
        LineNumberReader lineNumberReader = fileOrURL.getReader();
        String string = lineNumberReader.readLine();
        if (string == null) {
            this.mFileStack.removeLast();
            lineNumberReader.close();
            if (this.mFileStack.size() > 0) {
                this.mCurrentLine = null;
                return this.read();
            }
            return -1;
        }
        this.mCurrentLine = new StringBuffer(string);
        while (string != null && string.endsWith("\\")) {
            int n = this.mCurrentLine.length();
            this.mCurrentLine.deleteCharAt(n - 1);
            string = lineNumberReader.readLine();
            if (string == null) continue;
            this.mCurrentLine.append(string);
        }
        this.mCurrentLine.append('\n');
        String string2 = this.mCurrentLine.toString().trim();
        if (string2.toLowerCase().startsWith(INCLUDE_KEYWORD)) {
            if (string2.length() == INCLUDE_KEYWORD.length()) {
                throw new MapyrusException(this.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("missingfilename"));
            }
            if (Character.isWhitespace(string2.charAt(INCLUDE_KEYWORD.length()))) {
                String string3 = string2.substring(INCLUDE_KEYWORD.length() + 1).trim();
                int n = string3.length();
                if (n > 1 && (string3.startsWith("\"") && string3.endsWith("\"") || string3.startsWith("'") && string3.endsWith("'") || string3.startsWith("<") && string3.endsWith(">"))) {
                    string3 = string3.substring(1, n - 1);
                }
                try {
                    this.openIncludedFile(string3);
                }
                catch (Exception exception) {
                    throw new MapyrusException(this.getCurrentFilenameAndLineNumber() + ": " + exception.getMessage());
                }
                this.mCurrentLine = null;
                return this.read();
            }
        }
        char c = this.mCurrentLine.charAt(this.mCurrentLineIndex++);
        return c;
    }

    public void unread(int n) {
        if (n == -1) {
            // empty if block
        }
        if (this.mCurrentLine == null) {
            Character c = new Character((char)n);
            this.mCurrentLine = new StringBuffer(c.toString());
            this.mCurrentLineIndex = 0;
        } else if (this.mCurrentLineIndex > 0 && n == this.mCurrentLine.charAt(this.mCurrentLineIndex - 1)) {
            --this.mCurrentLineIndex;
        } else {
            Character c = new Character((char)n);
            this.mCurrentLine.insert(this.mCurrentLineIndex, c.toString());
        }
    }

    private FileOrURL getCurrentFileOrURL() {
        FileOrURL fileOrURL = this.mFileStack.size() > 0 ? (FileOrURL)this.mFileStack.getLast() : this.mInitialFile;
        return fileOrURL;
    }

    public String getCurrentFilename() {
        FileOrURL fileOrURL = this.getCurrentFileOrURL();
        return fileOrURL.toString();
    }

    public int getCurrentLineNumber() {
        FileOrURL fileOrURL = this.getCurrentFileOrURL();
        return fileOrURL.getReader().getLineNumber();
    }

    public String getCurrentFilenameAndLineNumber() {
        return this.getCurrentFilename() + ":" + this.getCurrentLineNumber();
    }

    public void close() {
        while (!this.mFileStack.isEmpty()) {
            FileOrURL fileOrURL = (FileOrURL)this.mFileStack.removeLast();
            LineNumberReader lineNumberReader = fileOrURL.getReader();
            try {
                ((Reader)lineNumberReader).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.mFileStack = null;
    }
}

