/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.util.ArrayList;
import java.util.HashMap;
import org.mapyrus.Expression;

public class Statement {
    public static final int CONDITIONAL = 2;
    public static final int REPEAT_LOOP = 3;
    public static final int WHILE_LOOP = 4;
    public static final int FOR_LOOP = 5;
    public static final int BLOCK = 6;
    public static final int COLOR = 9;
    public static final int BLEND = 10;
    public static final int LINESTYLE = 11;
    public static final int FONT = 12;
    public static final int JUSTIFY = 13;
    public static final int MOVE = 14;
    public static final int DRAW = 15;
    public static final int RDRAW = 16;
    public static final int ARC = 17;
    public static final int CIRCLE = 18;
    public static final int ELLIPSE = 19;
    public static final int CYLINDER = 20;
    public static final int RAINDROP = 21;
    public static final int BEZIER = 22;
    public static final int SINEWAVE = 23;
    public static final int WEDGE = 24;
    public static final int SPIRAL = 25;
    public static final int BOX = 26;
    public static final int ROUNDEDBOX = 27;
    public static final int BOX3D = 28;
    public static final int CHESSBOARD = 29;
    public static final int HEXAGON = 30;
    public static final int PENTAGON = 31;
    public static final int TRIANGLE = 32;
    public static final int STAR = 33;
    public static final int ADDPATH = 34;
    public static final int CLEARPATH = 35;
    public static final int CLOSEPATH = 36;
    public static final int SAMPLEPATH = 37;
    public static final int STRIPEPATH = 38;
    public static final int SHIFTPATH = 39;
    public static final int PARALLELPATH = 40;
    public static final int SELECTPATH = 41;
    public static final int SINKHOLE = 42;
    public static final int GUILLOTINE = 43;
    public static final int STROKE = 44;
    public static final int FILL = 45;
    public static final int GRADIENTFILL = 46;
    public static final int EVENTSCRIPT = 47;
    public static final int PROTECT = 48;
    public static final int UNPROTECT = 49;
    public static final int CLIP = 50;
    public static final int LABEL = 51;
    public static final int FLOWLABEL = 52;
    public static final int TABLE = 53;
    public static final int TREE = 54;
    public static final int ICON = 55;
    public static final int GEOIMAGE = 56;
    public static final int EPS = 57;
    public static final int SVG = 58;
    public static final int SVGCODE = 59;
    public static final int SCALE = 60;
    public static final int ROTATE = 61;
    public static final int WORLDS = 62;
    public static final int PROJECT = 63;
    public static final int DATASET = 64;
    public static final int FETCH = 65;
    public static final int NEWPAGE = 66;
    public static final int ENDPAGE = 67;
    public static final int SETOUTPUT = 68;
    public static final int PRINT = 69;
    public static final int LOCAL = 70;
    public static final int LET = 71;
    public static final int EVAL = 72;
    public static final int KEY = 73;
    public static final int LEGEND = 74;
    public static final int MIMETYPE = 75;
    public static final int HTTPRESPONSE = 76;
    public static final int CALL = 1000;
    public static final int RETURN = 1001;
    private int mType;
    private ArrayList mThenStatements;
    private ArrayList mElseStatements;
    private ArrayList mLoopStatements;
    private String mBlockName;
    private ArrayList mStatementBlock;
    private ArrayList mParameters;
    private Expression[] mExpressions;
    private Expression mForHashMapExpression;
    private String mFilename;
    private int mLineNumber;
    private static HashMap mStatementTypeLookup = new HashMap();

    private int getStatementType(String string) {
        Integer n = (Integer)mStatementTypeLookup.get(string.toLowerCase());
        int n2 = n == null ? 1000 : n;
        return n2;
    }

    public Statement(String string, Expression[] expressionArray) {
        this.mType = this.getStatementType(string);
        if (this.mType == 1000) {
            this.mBlockName = string;
        }
        this.mExpressions = expressionArray;
    }

    public Statement(String string, ArrayList arrayList, ArrayList arrayList2) {
        this.mBlockName = string;
        this.mParameters = arrayList;
        this.mStatementBlock = arrayList2;
        this.mType = 6;
    }

    public Statement(Expression expression, ArrayList arrayList, ArrayList arrayList2) {
        this.mType = 2;
        this.mExpressions = new Expression[1];
        this.mExpressions[0] = expression;
        this.mThenStatements = arrayList;
        this.mElseStatements = arrayList2;
    }

    public Statement(Expression expression, ArrayList arrayList, boolean bl) {
        this.mType = bl ? 4 : 3;
        this.mExpressions = new Expression[1];
        this.mExpressions[0] = expression;
        this.mLoopStatements = arrayList;
    }

    public Statement(Expression expression, Expression expression2, ArrayList arrayList) {
        this.mType = 5;
        this.mExpressions = new Expression[1];
        this.mExpressions[0] = expression;
        this.mForHashMapExpression = expression2;
        this.mLoopStatements = arrayList;
    }

    public void setFilenameAndLineNumber(String string, int n) {
        this.mFilename = string;
        this.mLineNumber = n;
    }

    public String getFilenameAndLineNumber() {
        return this.mFilename + ":" + this.mLineNumber;
    }

    public String getFilename() {
        return this.mFilename;
    }

    public int getType() {
        return this.mType;
    }

    public Expression[] getExpressions() {
        return this.mExpressions;
    }

    public ArrayList getThenStatements() {
        return this.mThenStatements;
    }

    public ArrayList getElseStatements() {
        return this.mElseStatements;
    }

    public ArrayList getLoopStatements() {
        return this.mLoopStatements;
    }

    public Expression getForHashMap() {
        return this.mForHashMapExpression;
    }

    public String getBlockName() {
        return this.mBlockName;
    }

    public ArrayList getBlockParameters() {
        return this.mParameters;
    }

    public ArrayList getStatementBlock() {
        return this.mStatementBlock;
    }

    static {
        mStatementTypeLookup.put("color", new Integer(9));
        mStatementTypeLookup.put("colour", new Integer(9));
        mStatementTypeLookup.put("blend", new Integer(10));
        mStatementTypeLookup.put("linestyle", new Integer(11));
        mStatementTypeLookup.put("font", new Integer(12));
        mStatementTypeLookup.put("justify", new Integer(13));
        mStatementTypeLookup.put("move", new Integer(14));
        mStatementTypeLookup.put("draw", new Integer(15));
        mStatementTypeLookup.put("rdraw", new Integer(16));
        mStatementTypeLookup.put("arc", new Integer(17));
        mStatementTypeLookup.put("circle", new Integer(18));
        mStatementTypeLookup.put("ellipse", new Integer(19));
        mStatementTypeLookup.put("cylinder", new Integer(20));
        mStatementTypeLookup.put("raindrop", new Integer(21));
        mStatementTypeLookup.put("bezier", new Integer(22));
        mStatementTypeLookup.put("sinewave", new Integer(23));
        mStatementTypeLookup.put("wedge", new Integer(24));
        mStatementTypeLookup.put("spiral", new Integer(25));
        mStatementTypeLookup.put("box", new Integer(26));
        mStatementTypeLookup.put("roundedbox", new Integer(27));
        mStatementTypeLookup.put("box3d", new Integer(28));
        mStatementTypeLookup.put("chessboard", new Integer(29));
        mStatementTypeLookup.put("hexagon", new Integer(30));
        mStatementTypeLookup.put("pentagon", new Integer(31));
        mStatementTypeLookup.put("triangle", new Integer(32));
        mStatementTypeLookup.put("star", new Integer(33));
        mStatementTypeLookup.put("addpath", new Integer(34));
        mStatementTypeLookup.put("clearpath", new Integer(35));
        mStatementTypeLookup.put("closepath", new Integer(36));
        mStatementTypeLookup.put("samplepath", new Integer(37));
        mStatementTypeLookup.put("stripepath", new Integer(38));
        mStatementTypeLookup.put("shiftpath", new Integer(39));
        mStatementTypeLookup.put("parallelpath", new Integer(40));
        mStatementTypeLookup.put("selectpath", new Integer(41));
        mStatementTypeLookup.put("sinkhole", new Integer(42));
        mStatementTypeLookup.put("guillotine", new Integer(43));
        mStatementTypeLookup.put("stroke", new Integer(44));
        mStatementTypeLookup.put("fill", new Integer(45));
        mStatementTypeLookup.put("gradientfill", new Integer(46));
        mStatementTypeLookup.put("eventscript", new Integer(47));
        mStatementTypeLookup.put("protect", new Integer(48));
        mStatementTypeLookup.put("unprotect", new Integer(49));
        mStatementTypeLookup.put("clip", new Integer(50));
        mStatementTypeLookup.put("label", new Integer(51));
        mStatementTypeLookup.put("flowlabel", new Integer(52));
        mStatementTypeLookup.put("table", new Integer(53));
        mStatementTypeLookup.put("tree", new Integer(54));
        mStatementTypeLookup.put("icon", new Integer(55));
        mStatementTypeLookup.put("geoimage", new Integer(56));
        mStatementTypeLookup.put("eps", new Integer(57));
        mStatementTypeLookup.put("svg", new Integer(58));
        mStatementTypeLookup.put("svgcode", new Integer(59));
        mStatementTypeLookup.put("scale", new Integer(60));
        mStatementTypeLookup.put("rotate", new Integer(61));
        mStatementTypeLookup.put("worlds", new Integer(62));
        mStatementTypeLookup.put("project", new Integer(63));
        mStatementTypeLookup.put("dataset", new Integer(64));
        mStatementTypeLookup.put("fetch", new Integer(65));
        mStatementTypeLookup.put("newpage", new Integer(66));
        mStatementTypeLookup.put("endpage", new Integer(67));
        mStatementTypeLookup.put("setoutput", new Integer(68));
        mStatementTypeLookup.put("print", new Integer(69));
        mStatementTypeLookup.put("local", new Integer(70));
        mStatementTypeLookup.put("let", new Integer(71));
        mStatementTypeLookup.put("eval", new Integer(72));
        mStatementTypeLookup.put("key", new Integer(73));
        mStatementTypeLookup.put("legend", new Integer(74));
        mStatementTypeLookup.put("mimetype", new Integer(75));
        mStatementTypeLookup.put("httpresponse", new Integer(76));
        mStatementTypeLookup.put("return", new Integer(1001));
    }
}

