/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.util.Enumeration;
import java.util.Hashtable;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;

public class WorldCoordinateTransform {
    private static Hashtable mDefinedCoordinateSystems;
    private int mSourceSystem;
    private int mDestinationSystem;

    private static native int define(String var0);

    private static native int transform(int var0, int var1, double[] var2, int var3);

    private static synchronized int defineCoordinateSystem(String string) throws MapyrusException {
        Integer n = (Integer)mDefinedCoordinateSystems.get(string);
        if (n == null) {
            int n2 = WorldCoordinateTransform.define(string);
            if (n2 < 0) {
                throw new MapyrusException(MapyrusMessages.get("definetransform") + ": " + string);
            }
            n = new Integer(n2);
            mDefinedCoordinateSystems.put(string, n);
        }
        return n;
    }

    private static synchronized void transform(int n, int n2, double[] dArray) throws MapyrusException {
        int n3 = WorldCoordinateTransform.transform(n, n2, dArray, dArray.length / 2);
        if (n3 * 2 != dArray.length) {
            String string = null;
            String string2 = null;
            Enumeration enumeration = mDefinedCoordinateSystems.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                Integer n4 = (Integer)mDefinedCoordinateSystems.get(string3);
                if (n4 == n) {
                    string = string3;
                }
                if (n4 != n2) continue;
                string2 = string3;
            }
            throw new MapyrusException(MapyrusMessages.get("transformerror") + ": " + string + " " + string2 + ": " + dArray[n3 * 2] + " " + dArray[n3 * 2 + 1]);
        }
    }

    public WorldCoordinateTransform(String string, String string2) throws MapyrusException {
        this.mSourceSystem = WorldCoordinateTransform.defineCoordinateSystem(string);
        this.mDestinationSystem = WorldCoordinateTransform.defineCoordinateSystem(string2);
    }

    public void forwardTransform(double[] dArray) throws MapyrusException {
        if (this.mSourceSystem != this.mDestinationSystem) {
            WorldCoordinateTransform.transform(this.mSourceSystem, this.mDestinationSystem, dArray);
        }
    }

    public void backwardTransform(double[] dArray) throws MapyrusException {
        if (this.mSourceSystem != this.mDestinationSystem) {
            WorldCoordinateTransform.transform(this.mDestinationSystem, this.mSourceSystem, dArray);
        }
    }

    static {
        System.loadLibrary("mapyrusproj");
        mDefinedCoordinateSystems = new Hashtable();
    }
}

