/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.dataset;

import java.awt.geom.Rectangle2D;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.mapyrus.Argument;
import org.mapyrus.DefaultFieldNames;
import org.mapyrus.FileOrURL;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.Row;
import org.mapyrus.dataset.GeographicDataset;

public class GrassDataset
implements GeographicDataset {
    private String mFilename;
    private Hashtable mMetadata;
    private String[] mFieldNames;
    private Rectangle2D.Double mExtents;
    private boolean mIsThreed;
    private ArrayList mAllRows;
    int mRowFetchIndex;
    private StringBuffer mAttributeBuffer;

    private String readLine(LineNumberReader lineNumberReader) throws IOException {
        String string;
        while ((string = lineNumberReader.readLine()) != null && string.length() > 0 && string.charAt(0) == '#') {
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GrassDataset(String string, String string2) throws FileNotFoundException, IOException, MapyrusException {
        LineNumberReader lineNumberReader = null;
        try {
            Row row;
            FileOrURL fileOrURL = new FileOrURL(string);
            lineNumberReader = fileOrURL.getReader();
            this.mFilename = string;
            this.mMetadata = new Hashtable();
            this.mAttributeBuffer = new StringBuffer();
            this.mRowFetchIndex = 0;
            String string3 = this.readLine(lineNumberReader);
            while (string3 != null && string3.length() > 0 && Character.isLetter(string3.charAt(0))) {
                StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
                if (stringTokenizer.countTokens() > 1) {
                    String string4 = stringTokenizer.nextToken();
                    String string5 = stringTokenizer.nextToken();
                    this.mMetadata.put(string4, string5);
                }
                string3 = this.readLine(lineNumberReader);
            }
            if (string3 == null || string3.length() == 0) {
                throw new MapyrusException(MapyrusMessages.get("invalidgrassfile") + ": " + string);
            }
            int n = 0;
            int n2 = 0;
            char c = string3.charAt(n2++);
            while (Character.isDigit(c) || c == '.' || c == ':' || c == '-' || c == 'N' || c == 'S' || c == 'E' || c == 'W' || c == '|') {
                if (c == '|') {
                    ++n;
                }
                if (++n2 == string3.length()) break;
                c = string3.charAt(n2);
            }
            this.mIsThreed = n > 2;
            double d = 3.4028234663852886E38;
            double d2 = 3.4028234663852886E38;
            double d3 = 1.4E-45f;
            double d4 = 1.4E-45f;
            this.mAllRows = new ArrayList();
            do {
                row = this.parseRow(lineNumberReader, string3);
                this.mAllRows.add(row);
                Argument argument = (Argument)row.get(0);
                double[] dArray = argument.getGeometryValue();
                double d5 = dArray[3];
                double d6 = dArray[4];
                if (d5 < d) {
                    d = d5;
                }
                if (d5 > d3) {
                    d3 = d5;
                }
                if (d6 < d2) {
                    d2 = d6;
                }
                if (!(d6 > d4)) continue;
                d4 = d6;
            } while ((string3 = this.readLine(lineNumberReader)) != null);
            this.mExtents = new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
            this.mFieldNames = new String[row.size()];
            int n3 = 0;
            int n4 = 1;
            this.mFieldNames[n3++] = "GEOMETRY";
            if (this.mIsThreed) {
                this.mFieldNames[n3++] = "Z";
            }
            while (n3 < this.mFieldNames.length) {
                this.mFieldNames[n3++] = DefaultFieldNames.get(n4++);
            }
            Object var25_23 = null;
            if (lineNumberReader == null) return;
        }
        catch (Throwable throwable) {
            Object var25_24 = null;
            if (lineNumberReader == null) throw throwable;
            lineNumberReader.close();
            throw throwable;
        }
        lineNumberReader.close();
    }

    public String getProjection() {
        return "";
    }

    public Hashtable getMetadata() {
        return this.mMetadata;
    }

    public String[] getFieldNames() {
        return this.mFieldNames;
    }

    public Rectangle2D.Double getWorlds() {
        return this.mExtents;
    }

    private double parseDMS(String string) {
        double d;
        int n = string.length();
        char c = string.charAt(n - 1);
        if (c == 'N' || c == 'E' || c == 'S' || c == 'W') {
            int n2 = string.indexOf(58);
            String string2 = string.substring(0, n2);
            int n3 = string.indexOf(58, n2 + 1);
            String string3 = string.substring(n2, n3 - n2);
            String string4 = string.substring(n3 + 1, n - n3);
            d = Double.parseDouble(string2) + Double.parseDouble(string3) / 60.0 + Double.parseDouble(string4) / 3600.0;
            if (c == 'S' || c == 'W') {
                d = -d;
            }
        } else {
            d = Double.parseDouble(string);
        }
        return d;
    }

    /*
     * Unable to fully structure code
     */
    private Row parseRow(LineNumberReader var1_1, String var2_2) throws MapyrusException {
        var3_3 = new Row();
        var10_4 = var2_2.length();
        var12_5 = 0;
        var13_6 = 0;
        var11_7 = var2_2.indexOf(124);
        if (var11_7 >= 0) {
            var12_5 = var2_2.indexOf(124, var11_7 + 1);
            if (this.mIsThreed && var12_5 >= 0) {
                var13_6 = var2_2.indexOf(124, var12_5 + 1);
            }
        }
        if (var11_7 < 0 || var12_5 < 0 || var13_6 < 0) {
            throw new MapyrusException(MapyrusMessages.get("invalidgrassfile") + ": " + this.mFilename + ":" + var1_1.getLineNumber() + ": " + var2_2);
        }
        try {
            var15_8 = var2_2.substring(0, var11_7);
            var4_10 = this.parseDMS(var15_8);
            var16_11 = var2_2.substring(var11_7 + 1, var12_5);
            var6_12 = this.parseDMS(var16_11);
            var17_13 = new double[]{100.0, 1.0, 0.0, var4_10, var6_12};
            var3_3.add(new Argument(100, var17_13));
            if (this.mIsThreed) {
                var18_14 = var2_2.substring(var12_5 + 1, var13_6);
                var8_17 = this.parseDMS(var18_14);
                var3_3.add(new Argument(var8_17));
                var14_18 = var13_6 + 1;
            } else {
                var14_18 = var12_5 + 1;
            }
            while (var14_18 < var10_4) {
                block15: {
                    this.mAttributeBuffer.setLength(0);
                    var19_19 = var2_2.charAt(var14_18);
                    ++var14_18;
                    if (var19_19 == '#' || var19_19 == '%' || Character.isDigit(var19_19)) {
                        if (Character.isDigit(var19_19)) {
                            this.mAttributeBuffer.append(var19_19);
                        }
                        while (var14_18 < var10_4) {
                            var18_15 = var2_2.charAt(var14_18);
                            ++var14_18;
                            if (Character.isWhitespace(var18_15)) break;
                            this.mAttributeBuffer.append(var18_15);
                        }
                        var3_3.add(new Argument(Double.parseDouble(this.mAttributeBuffer.toString())));
                        continue;
                    }
                    if (var19_19 != '@') continue;
                    var18_16 = var2_2.charAt(var14_18);
                    v0 = var20_20 = var18_16 == '\"';
                    if (!var20_20) ** GOTO lbl68
                    ++var14_18;
                    var21_21 = 0;
                    while (var14_18 < var10_4) {
                        var18_16 = var2_2.charAt(var14_18);
                        ++var14_18;
                        if (var18_16 == '\"') {
                            if (var21_21 != 92) break block15;
                            this.mAttributeBuffer.deleteCharAt(this.mAttributeBuffer.length() - 1);
                        }
                        this.mAttributeBuffer.append(var18_16);
                    }
                    break block15;
lbl-1000:
                    // 1 sources

                    {
                        var18_16 = var2_2.charAt(var14_18);
                        ++var14_18;
                        if (Character.isWhitespace(var18_16)) break;
                        this.mAttributeBuffer.append(var18_16);
lbl68:
                        // 2 sources

                        ** while (var14_18 < var10_4)
                    }
                }
                var3_3.add(new Argument(1, this.mAttributeBuffer.toString()));
            }
        }
        catch (NumberFormatException var15_9) {
            throw new MapyrusException(MapyrusMessages.get("invalidgrassfile") + ": " + this.mFilename + ":" + var1_1.getLineNumber() + ": " + var2_2);
        }
        return var3_3;
    }

    public Row fetch() throws MapyrusException {
        Row row = this.mRowFetchIndex < this.mAllRows.size() ? (Row)this.mAllRows.get(this.mRowFetchIndex++) : null;
        return row;
    }

    public void close() throws MapyrusException {
        this.mAllRows = null;
    }
}

