/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.dataset;

import java.awt.geom.Rectangle2D;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.mapyrus.Argument;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.Row;
import org.mapyrus.dataset.ConnectionPool;
import org.mapyrus.dataset.GeographicDataset;
import org.mapyrus.dataset.WKBGeometryParser;

public class JDBCDataset
implements GeographicDataset {
    private Connection mConnection = null;
    private Statement mStatement = null;
    private ResultSet mResultSet = null;
    private String mSql;
    private String mUrl;
    private String[] mFieldNames;
    private int[] mFieldTypes;

    public JDBCDataset(String string, String string2) throws MapyrusException {
        String string3 = null;
        Properties properties = new Properties();
        this.mSql = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            int n = string4.indexOf(61);
            if (n <= 0) continue;
            String string5 = string4.substring(0, n);
            String string6 = string4.substring(n + 1);
            if (string5.equals("driver")) {
                string3 = string6;
                continue;
            }
            if (string5.equals("url")) {
                this.mUrl = string6;
                continue;
            }
            properties.put(string5, string6);
        }
        try {
            if (string3 != null) {
                Class.forName(string3);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MapyrusException(MapyrusMessages.get("nojdbcclass") + ": " + classNotFoundException.getMessage() + ": " + string3);
        }
        try {
            this.mConnection = ConnectionPool.get(this.mUrl, properties);
        }
        catch (SQLException sQLException) {
            String string7 = sQLException.getSQLState();
            string7 = string7 != null ? ": " + string7 : "";
            throw new MapyrusException(sQLException.getErrorCode() + ": " + sQLException.getMessage() + string7 + ": " + this.mUrl);
        }
        try {
            this.mStatement = this.mConnection.createStatement();
            try {
                this.mStatement.setQueryTimeout(30);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.mResultSet = this.mStatement.executeQuery(this.mSql);
            ResultSetMetaData resultSetMetaData = this.mResultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            this.mFieldNames = new String[n];
            this.mFieldTypes = new int[n];
            int n2 = 0;
            while (n2 < n) {
                boolean bl;
                this.mFieldNames[n2] = resultSetMetaData.getColumnName(n2 + 1);
                char c = this.mFieldNames[n2].charAt(0);
                boolean bl2 = bl = Character.isLetter(c) || c == '$';
                if (bl) {
                    int n3 = 1;
                    while (bl && n3 < this.mFieldNames[n2].length()) {
                        c = this.mFieldNames[n2].charAt(n3);
                        bl = c == '.' || c == '_' || Character.isLetterOrDigit(c);
                        ++n3;
                    }
                }
                if (!bl) {
                    throw new MapyrusException(MapyrusMessages.get("invalidfieldname") + ": " + this.mFieldNames[n2]);
                }
                this.mFieldTypes[n2] = resultSetMetaData.getColumnType(n2 + 1);
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            try {
                this.close(false);
            }
            catch (MapyrusException mapyrusException) {
                // empty catch block
            }
            String string8 = sQLException.getSQLState();
            string8 = string8 != null ? ": " + string8 : "";
            throw new MapyrusException(sQLException.getErrorCode() + ": " + sQLException.getMessage() + string8 + ": " + this.mSql);
        }
        catch (MapyrusException mapyrusException) {
            try {
                this.close(false);
            }
            catch (MapyrusException mapyrusException2) {
                // empty catch block
            }
            throw mapyrusException;
        }
    }

    public String getProjection() {
        return null;
    }

    public Hashtable getMetadata() {
        return null;
    }

    public String[] getFieldNames() {
        return this.mFieldNames;
    }

    public Rectangle2D.Double getWorlds() {
        return new Rectangle2D.Double(-180.0, -90.0, 180.0, 90.0);
    }

    public Row fetch() throws MapyrusException {
        Row row;
        block40: {
            try {
                if (this.mResultSet.next()) {
                    row = new Row();
                    int n = 0;
                    while (n < this.mFieldTypes.length) {
                        Argument argument;
                        block39: {
                            double[] dArray;
                            Object[] objectArray;
                            Object object;
                            if (this.mFieldTypes[n] == -6) {
                                argument = new Argument(this.mResultSet.getByte(n + 1));
                            } else if (this.mFieldTypes[n] == 5) {
                                argument = new Argument(this.mResultSet.getShort(n + 1));
                            } else if (this.mFieldTypes[n] == 4) {
                                argument = new Argument(this.mResultSet.getInt(n + 1));
                            } else if (this.mFieldTypes[n] == -5) {
                                argument = new Argument(this.mResultSet.getLong(n + 1));
                            } else if (this.mFieldTypes[n] == 7) {
                                argument = new Argument(this.mResultSet.getFloat(n + 1));
                            } else if (this.mFieldTypes[n] == 6 || this.mFieldTypes[n] == 8) {
                                argument = new Argument(this.mResultSet.getDouble(n + 1));
                            } else if (this.mFieldTypes[n] == 3 || this.mFieldTypes[n] == 2) {
                                argument = new Argument(this.mResultSet.getDouble(n + 1));
                            } else if (this.mFieldTypes[n] == -7) {
                                boolean bl = this.mResultSet.getBoolean(n + 1);
                                argument = bl ? Argument.numericOne : Argument.numericZero;
                            } else if (this.mFieldTypes[n] == 1 || this.mFieldTypes[n] == 12 || this.mFieldTypes[n] == -1 || this.mFieldTypes[n] == 2005) {
                                object = this.mResultSet.getString(n + 1);
                                argument = object == null ? Argument.emptyString : new Argument(1, (String)object);
                            } else if (this.mFieldTypes[n] == -2 || this.mFieldTypes[n] == -3 || this.mFieldTypes[n] == -4) {
                                object = this.mResultSet.getBytes(n + 1);
                                if (object == null) {
                                    argument = Argument.emptyGeometry;
                                } else {
                                    objectArray = WKBGeometryParser.parse((byte[])object);
                                    argument = new Argument((int)objectArray[0], (double[])objectArray);
                                }
                            } else if (this.mFieldTypes[n] == 2004) {
                                object = this.mResultSet.getBlob(n + 1);
                                if (object == null) {
                                    argument = Argument.emptyGeometry;
                                } else {
                                    objectArray = object.getBytes(0L, (int)object.length());
                                    dArray = WKBGeometryParser.parse((byte[])objectArray);
                                    argument = new Argument((int)dArray[0], dArray);
                                }
                            } else if (this.mFieldTypes[n] == 91 || this.mFieldTypes[n] == 92 || this.mFieldTypes[n] == 93) {
                                object = this.mResultSet.getString(n + 1);
                                argument = object == null ? Argument.emptyString : new Argument(1, (String)object);
                            } else if (this.mFieldTypes[n] == 1111) {
                                object = this.mResultSet.getBytes(n + 1);
                                if (object == null || ((Object)object).length == 0) {
                                    argument = Argument.emptyString;
                                } else {
                                    try {
                                        objectArray = this.parseHexDigits((byte[])object);
                                        if (objectArray != null) {
                                            dArray = WKBGeometryParser.parse((byte[])objectArray);
                                            argument = new Argument((int)dArray[0], dArray);
                                            break block39;
                                        }
                                        argument = new Argument(1, new String((byte[])object));
                                    }
                                    catch (MapyrusException mapyrusException) {
                                        argument = new Argument(1, new String((byte[])object));
                                    }
                                }
                            } else {
                                throw new MapyrusException(MapyrusMessages.get("unknownfieldtype") + ": " + this.mFieldTypes[n]);
                            }
                        }
                        row.add(argument);
                        ++n;
                    }
                    break block40;
                }
                row = null;
            }
            catch (SQLException sQLException) {
                String string = sQLException.getSQLState();
                string = string != null ? ": " + string : "";
                throw new MapyrusException(sQLException.getErrorCode() + ": " + sQLException.getMessage() + string + ": " + this.mSql);
            }
        }
        return row;
    }

    private byte[] parseHexDigits(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length / 2];
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = byArray[n2];
            if (n3 >= 48 && n3 <= 57) {
                n3 -= 48;
            } else if (n3 >= 65 && n3 <= 70) {
                n3 = n3 - 65 + 10;
            } else if (n3 >= 97 && n3 <= 102) {
                n3 = n3 - 97 + 10;
            } else {
                return null;
            }
            if (n2 % 2 != 0) {
                byArray2[n2 / 2] = (byte)(n << 4 | n3);
            }
            n = n3;
            ++n2;
        }
        return byArray2;
    }

    private void close(boolean bl) throws MapyrusException {
        try {
            if (this.mStatement != null) {
                this.mStatement.close();
            }
        }
        catch (SQLException sQLException) {
            String string = sQLException.getSQLState();
            string = string != null ? ": " + string : "";
            throw new MapyrusException(sQLException.getErrorCode() + ": " + sQLException.getMessage() + string);
        }
        finally {
            if (this.mConnection != null) {
                ConnectionPool.put(this.mUrl, this.mConnection, bl);
            }
            this.mConnection = null;
            this.mStatement = null;
        }
    }

    public void close() throws MapyrusException {
        this.close(true);
    }
}

