/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.dataset;

import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.mapyrus.Argument;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.Row;
import org.mapyrus.dataset.GeographicDataset;

public class ShapefileDataset
implements GeographicDataset {
    private static final int MAGIC_NUMBER = 9994;
    private static final byte DBF_HEADER_SENTINEL = 13;
    private static final byte DBF_DELETED_RECORD = 42;
    private static final int NULL_SHAPE = 0;
    private static final int POINT = 1;
    private static final int POLYLINE = 3;
    private static final int POLYGON = 5;
    private static final int MULTIPOINT = 8;
    private static final int POINT_Z = 11;
    private static final int POLYLINE_Z = 13;
    private static final int POLYGON_Z = 15;
    private static final int MULTIPOINT_Z = 18;
    private static final int POINT_M = 21;
    private static final int POLYLINE_M = 23;
    private static final int POLYGON_M = 25;
    private static final int MULTIPOINT_M = 28;
    private static final int MULTIPATCH = 31;
    private static final byte DBF_CHARACTER = 67;
    private static final byte DBF_DATE = 68;
    private static final byte DBF_NUMBER = 78;
    private static final byte DBF_FLOATING = 70;
    private static final byte DBF_LOGICAL = 76;
    private DataInputStream mShapeStream;
    private DataInputStream mDBFStream;
    private String mFilename;
    private int mShapeFileLength;
    private int mShapeFileType;
    private int mGeometryType;
    private int mDBFRecordLength;
    private String mProjection;
    private ArrayList mDBFFieldsToFetch;
    private int mNDBFFieldsToFetch;
    private String[] mFieldNames;
    private int[] mFieldTypes;
    private int[] mDBFFieldTypes;
    private int[] mDBFFieldLengths;
    private Rectangle2D.Double mExtents;
    private Rectangle2D.Double mQueryExtents;
    private int mBytesRead;
    private byte[] mDBFRecord;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ShapefileDataset(String string, String string2) throws FileNotFoundException, IOException, MapyrusException {
        HashSet<String> hashSet;
        block23: {
            String string3;
            String string4;
            String string5;
            block22: {
                hashSet = null;
                double d = -3.4028234663852886E38;
                double d2 = -3.4028234663852886E38;
                double d3 = 3.4028234663852886E38;
                double d4 = 3.4028234663852886E38;
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                block11: while (true) {
                    double d5;
                    if (!stringTokenizer.hasMoreTokens()) {
                        this.mQueryExtents = new Rectangle2D.Double(d2, d, d4 - d2, d3 - d);
                        if (!string.endsWith(".shp") && !string.endsWith(".dbf") && !string.endsWith(".shx")) break;
                        this.mFilename = string.substring(0, string.length() - 4);
                        string5 = this.mFilename + ".shp";
                        string4 = this.mFilename + ".dbf";
                        string3 = this.mFilename + ".prj";
                        break block22;
                    }
                    String string6 = stringTokenizer.nextToken();
                    if (string6.startsWith("dbffields=")) {
                        hashSet = new HashSet<String>();
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string6.substring(10), ",");
                        while (true) {
                            if (!stringTokenizer2.hasMoreTokens()) continue block11;
                            string6 = stringTokenizer2.nextToken();
                            hashSet.add(string6);
                        }
                    }
                    if (!string6.startsWith("xmin=") && !string6.startsWith("ymin=") && !string6.startsWith("xmax=") && !string6.startsWith("ymax=")) continue;
                    String string7 = string6.substring(5);
                    try {
                        d5 = Double.parseDouble(string7);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new MapyrusException(MapyrusMessages.get("invalidnumber") + ": " + string7);
                    }
                    if (string6.startsWith("xmin=")) {
                        d2 = d5;
                        continue;
                    }
                    if (string6.startsWith("ymin=")) {
                        d = d5;
                        continue;
                    }
                    if (string6.startsWith("xmax=")) {
                        d4 = d5;
                        continue;
                    }
                    d3 = d5;
                }
                if (string.endsWith(".SHP") || string.endsWith(".DBF") || string.endsWith(".SHX")) {
                    this.mFilename = string.substring(0, string.length() - 4);
                    string5 = this.mFilename + ".SHP";
                    string4 = this.mFilename + ".DBF";
                    string3 = this.mFilename + ".PRJ";
                } else {
                    this.mFilename = string;
                    string5 = string + ".shp";
                    string4 = string + ".dbf";
                    string3 = string + ".prj";
                }
            }
            this.mShapeStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string5)));
            try {
                this.mDBFStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string4)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.mDBFStream = null;
            }
            BufferedReader bufferedReader = null;
            try {
                try {
                    bufferedReader = new BufferedReader(new FileReader(string3));
                    this.mProjection = bufferedReader.readLine();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.mProjection = "";
                    Object var24_20 = null;
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    break block23;
                }
                Object var24_19 = null;
                if (bufferedReader == null) break block23;
            }
            catch (Throwable throwable) {
                Object var24_21 = null;
                if (bufferedReader == null) throw throwable;
                bufferedReader.close();
                throw throwable;
            }
            bufferedReader.close();
        }
        try {
            this.readShapeHeader();
            this.readDBFHeader(hashSet);
            if (this.mQueryExtents.intersects(this.mExtents)) {
                this.mBytesRead = 0;
                this.mDBFRecord = new byte[this.mDBFRecordLength];
                return;
            }
            this.mBytesRead = this.mShapeFileLength;
            return;
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
        catch (MapyrusException mapyrusException) {
            this.close();
            throw mapyrusException;
        }
    }

    private long readLittleEndianLong(DataInputStream dataInputStream) throws IOException {
        long l = dataInputStream.read();
        long l2 = dataInputStream.read();
        long l3 = dataInputStream.read();
        long l4 = dataInputStream.read();
        long l5 = dataInputStream.read();
        long l6 = dataInputStream.read();
        long l7 = dataInputStream.read();
        long l8 = dataInputStream.read();
        long l9 = (l8 << 56) + (l7 << 48) + (l6 << 40) + (l5 << 32) + (l4 << 24) + (l3 << 16) + (l2 << 8) + l;
        return l9;
    }

    private int readLittleEndianInt(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.read();
        int n2 = dataInputStream.read();
        int n3 = dataInputStream.read();
        int n4 = dataInputStream.read();
        int n5 = (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
        return n5;
    }

    private short readLittleEndianShort(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.read();
        int n2 = dataInputStream.read();
        return (short)((n2 << 8) + n);
    }

    private double readLittleEndianDouble(DataInputStream dataInputStream) throws IOException {
        long l = this.readLittleEndianLong(dataInputStream);
        double d = Double.longBitsToDouble(l);
        return d;
    }

    private void readShapeHeader() throws IOException, MapyrusException {
        int n = this.mShapeStream.readInt();
        if (n != 9994) {
            throw new MapyrusException(this.mFilename + ": " + MapyrusMessages.get("notshapefile"));
        }
        this.mShapeStream.readInt();
        this.mShapeStream.readInt();
        this.mShapeStream.readInt();
        this.mShapeStream.readInt();
        this.mShapeStream.readInt();
        this.mShapeFileLength = this.mShapeStream.readInt() * 2 - 100;
        this.readLittleEndianInt(this.mShapeStream);
        this.mShapeFileType = this.readLittleEndianInt(this.mShapeStream);
        double d = this.readLittleEndianDouble(this.mShapeStream);
        double d2 = this.readLittleEndianDouble(this.mShapeStream);
        double d3 = this.readLittleEndianDouble(this.mShapeStream);
        double d4 = this.readLittleEndianDouble(this.mShapeStream);
        this.readLittleEndianDouble(this.mShapeStream);
        this.readLittleEndianDouble(this.mShapeStream);
        this.readLittleEndianDouble(this.mShapeStream);
        this.readLittleEndianDouble(this.mShapeStream);
        this.mExtents = new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
        switch (this.mShapeFileType) {
            case 0: {
                this.mGeometryType = 0;
                break;
            }
            case 1: 
            case 11: 
            case 21: {
                this.mGeometryType = 100;
                break;
            }
            case 3: 
            case 13: 
            case 23: {
                this.mGeometryType = 104;
                break;
            }
            case 5: 
            case 15: 
            case 25: 
            case 31: {
                this.mGeometryType = 105;
                break;
            }
            case 8: 
            case 18: 
            case 28: {
                this.mGeometryType = 103;
            }
        }
    }

    private String unpackString(byte[] byArray, int n, int n2) {
        int n3 = n + n2 - 1;
        while (n3 >= n && (byArray[n3] == 0 || Character.isWhitespace((char)byArray[n3]))) {
            --n3;
        }
        String string = n3 < n ? "" : new String(byArray, n, n3 - n + 1);
        return string;
    }

    private void readDBFHeader(HashSet hashSet) throws IOException {
        byte[] byArray;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        int n = 0;
        int n2 = 0;
        this.mNDBFFieldsToFetch = 0;
        int n3 = 0;
        this.mDBFFieldsToFetch = new ArrayList();
        if (this.mDBFStream != null) {
            this.mDBFStream.skipBytes(4);
            this.readLittleEndianInt(this.mDBFStream);
            n2 = this.readLittleEndianShort(this.mDBFStream);
            this.mDBFRecordLength = this.readLittleEndianShort(this.mDBFStream);
            this.mDBFStream.skipBytes(20);
            n = 32;
            do {
                byArray = new byte[32];
                byArray[0] = (byte)this.mDBFStream.read();
                ++n;
                if (byArray[0] == 13) continue;
                this.mDBFStream.read(byArray, 1, byArray.length - 1);
                String string = this.unpackString(byArray, 0, 11);
                boolean bl = hashSet == null || hashSet.contains(string);
                this.mDBFFieldsToFetch.add(new Boolean(bl));
                if (bl) {
                    ++this.mNDBFFieldsToFetch;
                }
                n += byArray.length - 1;
                arrayList.add(byArray);
                ++n3;
            } while (byArray[0] != 13);
        }
        this.mFieldNames = new String[this.mNDBFFieldsToFetch + 1];
        this.mFieldTypes = new int[this.mNDBFFieldsToFetch + 1];
        this.mDBFFieldTypes = new int[n3];
        this.mDBFFieldLengths = new int[n3];
        this.mFieldNames[this.mNDBFFieldsToFetch] = "GEOMETRY";
        this.mFieldTypes[this.mNDBFFieldsToFetch] = 4;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            byArray = (byte[])arrayList.get(n5);
            this.mDBFFieldTypes[n5] = byArray[11];
            this.mDBFFieldLengths[n5] = byArray[16] > 0 ? byArray[16] : 256 + byArray[16];
            if (((Boolean)this.mDBFFieldsToFetch.get(n5)).booleanValue()) {
                this.mFieldNames[n4] = this.unpackString(byArray, 0, 11);
                switch (this.mDBFFieldTypes[n5]) {
                    case 67: 
                    case 68: {
                        this.mFieldTypes[n4] = 1;
                        break;
                    }
                    case 70: 
                    case 76: 
                    case 78: {
                        this.mFieldTypes[n4] = 0;
                    }
                }
                ++n4;
            }
            ++n5;
        }
        int n6 = n2 - n;
        if (n6 > 0) {
            this.mDBFStream.skipBytes(n6);
        }
    }

    public String getProjection() {
        return this.mProjection;
    }

    public Hashtable getMetadata() {
        return null;
    }

    public String[] getFieldNames() {
        return this.mFieldNames;
    }

    public Rectangle2D.Double getWorlds() {
        return this.mExtents;
    }

    public Row fetch() throws MapyrusException {
        Row row;
        boolean bl = false;
        double[] dArray = null;
        try {
            row = new Row();
            while (!bl && this.mBytesRead < this.mShapeFileLength) {
                int n;
                int n2;
                int n3;
                block37: {
                    int n4;
                    int n5;
                    double d;
                    double d2;
                    double d3;
                    double d4;
                    block39: {
                        boolean bl2;
                        block38: {
                            block36: {
                                this.mShapeStream.readInt();
                                n3 = this.mShapeStream.readInt() * 2;
                                int n6 = this.readLittleEndianInt(this.mShapeStream);
                                n2 = 4;
                                if (n6 != 0) break block36;
                                dArray = Argument.emptyGeometry.getGeometryValue();
                                bl = true;
                                break block37;
                            }
                            if (this.mShapeFileType != 1 && this.mShapeFileType != 11 && this.mShapeFileType != 21) break block38;
                            dArray = new double[]{100.0, 1.0, 0.0, this.readLittleEndianDouble(this.mShapeStream), this.readLittleEndianDouble(this.mShapeStream)};
                            n2 += 16;
                            bl = this.mQueryExtents.outcode(dArray[3], dArray[4]) == 0;
                            break block37;
                        }
                        if (this.mShapeFileType != 3 && this.mShapeFileType != 5 && this.mShapeFileType != 13 && this.mShapeFileType != 15 && this.mShapeFileType != 23 && this.mShapeFileType != 25 && this.mShapeFileType != 31) break block39;
                        d4 = this.readLittleEndianDouble(this.mShapeStream);
                        d3 = this.readLittleEndianDouble(this.mShapeStream);
                        d2 = this.readLittleEndianDouble(this.mShapeStream);
                        d = this.readLittleEndianDouble(this.mShapeStream);
                        n2 += 32;
                        bl = this.mQueryExtents.intersects(d4, d3, d2 - d4, d - d3);
                        if (!bl) break block37;
                        int n7 = this.readLittleEndianInt(this.mShapeStream);
                        n5 = this.readLittleEndianInt(this.mShapeStream);
                        n2 += 8;
                        int[] nArray = new int[n7];
                        n = 0;
                        while (n < n7) {
                            nArray[n] = this.readLittleEndianInt(this.mShapeStream);
                            ++n;
                        }
                        n2 += n7 * 4;
                        if (this.mShapeFileType == 31) {
                            this.mShapeStream.skipBytes(n7 * 4);
                            n2 += n7 * 4;
                        }
                        dArray = new double[2 + n7 * 2 + n5 * 3];
                        int n8 = 0;
                        int n9 = 0;
                        boolean bl3 = bl2 = this.mShapeFileType == 3 || this.mShapeFileType == 23 || this.mShapeFileType == 13;
                        if (bl2) {
                            dArray[0] = 104.0;
                            dArray[1] = n7;
                        } else {
                            dArray[0] = 102.0;
                        }
                        int n10 = 0;
                        n4 = 2;
                        double d5 = Double.MAX_VALUE;
                        double d6 = Double.MAX_VALUE;
                        n = 0;
                        while (n < n5) {
                            block42: {
                                double d7;
                                double d8;
                                block41: {
                                    block40: {
                                        d8 = this.readLittleEndianDouble(this.mShapeStream);
                                        d7 = this.readLittleEndianDouble(this.mShapeStream);
                                        n2 += 16;
                                        if (n10 >= n7 || nArray[n10] != n) break block40;
                                        if (bl2) {
                                            if (n10 > 0) {
                                                dArray[n9] = n8;
                                            }
                                            n8 = 0;
                                            dArray[n4] = 101.0;
                                            n9 = n4 + 1;
                                            n4 += 2;
                                        }
                                        dArray[n4] = 0.0;
                                        ++n4;
                                        ++n10;
                                        break block41;
                                    }
                                    if (d8 == d6 && d7 == d5) break block42;
                                    dArray[n4] = 1.0;
                                    ++n4;
                                }
                                dArray[n4] = d6 = d8;
                                dArray[n4 + 1] = d5 = d7;
                                n4 += 2;
                                ++n8;
                            }
                            ++n;
                        }
                        if (bl2) {
                            dArray[n9] = n8;
                        } else {
                            dArray[1] = n8;
                        }
                        break block37;
                    }
                    if (this.mShapeFileType == 8 || this.mShapeFileType == 18 || this.mShapeFileType == 28) {
                        d4 = this.readLittleEndianDouble(this.mShapeStream);
                        d3 = this.readLittleEndianDouble(this.mShapeStream);
                        d2 = this.readLittleEndianDouble(this.mShapeStream);
                        d = this.readLittleEndianDouble(this.mShapeStream);
                        n2 += 32;
                        bl = this.mQueryExtents.intersects(d4, d3, d2 - d4, d - d3);
                        if (bl) {
                            n5 = this.readLittleEndianInt(this.mShapeStream);
                            n2 += 4;
                            dArray = new double[n5 * 5 + 2];
                            dArray[0] = 103.0;
                            dArray[1] = n5;
                            n4 = 2;
                            n = 0;
                            while (n < n5) {
                                dArray[n4] = 100.0;
                                dArray[n4 + 1] = 1.0;
                                dArray[n4 + 2] = 0.0;
                                dArray[n4 + 3] = this.readLittleEndianDouble(this.mShapeStream);
                                dArray[n4 + 4] = this.readLittleEndianDouble(this.mShapeStream);
                                n4 += 5;
                                n2 += 16;
                                ++n;
                            }
                        }
                    }
                }
                if (n2 < n3) {
                    this.mShapeStream.skipBytes(n3 - n2);
                }
                this.mBytesRead += n3 + 8;
                if (this.mNDBFFieldsToFetch > 0) {
                    this.mDBFStream.read(this.mDBFRecord);
                    while (this.mDBFRecord[0] == 42) {
                        this.mDBFStream.read(this.mDBFRecord);
                    }
                }
                if (!bl) continue;
                if (this.mNDBFFieldsToFetch > 0) {
                    int n11 = 1;
                    n = 0;
                    while (n < this.mDBFFieldTypes.length) {
                        Argument argument = null;
                        if (((Boolean)this.mDBFFieldsToFetch.get(n)).booleanValue()) {
                            if (this.mDBFFieldTypes[n] == 67 || this.mDBFFieldTypes[n] == 68) {
                                argument = new Argument(1, this.unpackString(this.mDBFRecord, n11, this.mDBFFieldLengths[n]));
                            } else if (this.mDBFFieldTypes[n] == 78 || this.mDBFFieldTypes[n] == 70) {
                                double d;
                                String string = this.unpackString(this.mDBFRecord, n11, this.mDBFFieldLengths[n]);
                                try {
                                    d = Double.parseDouble(string);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    d = 0.0;
                                }
                                argument = new Argument(d);
                            } else if (this.mDBFFieldTypes[n] == 76) {
                                switch ((char)this.mDBFRecord[n11]) {
                                    case 'T': 
                                    case 'Y': 
                                    case 't': 
                                    case 'y': {
                                        argument = Argument.numericOne;
                                        break;
                                    }
                                    default: {
                                        argument = Argument.numericZero;
                                    }
                                }
                            }
                            row.add(argument);
                        }
                        n11 += this.mDBFFieldLengths[n];
                        ++n;
                    }
                }
                row.add(new Argument(this.mGeometryType, dArray));
            }
        }
        catch (IOException iOException) {
            throw new MapyrusException(iOException.getMessage());
        }
        if (bl) {
            return row;
        }
        return null;
    }

    public void close() throws MapyrusException {
        try {
            this.mShapeStream.close();
        }
        catch (IOException iOException) {
            throw new MapyrusException(iOException.getMessage());
        }
        finally {
            try {
                if (this.mDBFStream != null) {
                    this.mDBFStream.close();
                }
            }
            catch (IOException iOException) {
                throw new MapyrusException(iOException.getMessage());
            }
        }
    }
}

