/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.dataset;

import java.awt.geom.Rectangle2D;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.mapyrus.Argument;
import org.mapyrus.Constants;
import org.mapyrus.FileOrURL;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.Row;
import org.mapyrus.dataset.GeographicDataset;

public class TextfileDataset
implements GeographicDataset {
    private LineNumberReader mReader;
    private String mFilename;
    private Process mProcess;
    private Character mDelimiter;
    private String mComment;
    private int mMaxFields;

    private String readLine() throws IOException {
        String string;
        while ((string = this.mReader.readLine()) != null && this.mComment.length() > 0 && string.startsWith(this.mComment)) {
        }
        return string;
    }

    public TextfileDataset(String string, String string2, InputStream inputStream) throws FileNotFoundException, IOException, MapyrusException {
        Object object;
        if (string.equals("-")) {
            this.mReader = new LineNumberReader(new InputStreamReader(inputStream));
        } else if (string.endsWith("|")) {
            object = string.substring(0, string.length() - 1).trim();
            String[] stringArray = Constants.getOSName().indexOf("WIN") >= 0 ? new String[]{object} : new String[]{"sh", "-c", object};
            this.mProcess = Runtime.getRuntime().exec(stringArray);
            this.mReader = new LineNumberReader(new InputStreamReader(this.mProcess.getInputStream()));
        } else {
            object = new FileOrURL(string);
            this.mReader = ((FileOrURL)object).getReader();
        }
        this.mFilename = string;
        this.mDelimiter = null;
        this.mComment = "#";
        this.mMaxFields = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.startsWith("comment=")) {
                this.mComment = string3.substring(8);
                continue;
            }
            if (!string3.startsWith("delimiter=") || string3.length() != 11) continue;
            this.mDelimiter = new Character(string3.charAt(10));
        }
    }

    public String getProjection() {
        return "";
    }

    public Hashtable getMetadata() {
        return new Hashtable();
    }

    public String[] getFieldNames() {
        return null;
    }

    public Rectangle2D.Double getWorlds() {
        return new Rectangle2D.Double(-180.0, -90.0, 180.0, 90.0);
    }

    /*
     * Unable to fully structure code
     */
    private boolean readNextRow(Row var1_1) throws MapyrusException {
        block12: {
            block11: {
                try {
                    var4_2 = this.readLine();
                }
                catch (IOException var5_3) {
                    throw new MapyrusException(var5_3.getMessage() + ": " + this.mFilename);
                }
                if (var4_2 == null) {
                    return false;
                }
                var1_1.clear();
                var5_4 = new Argument(1, var4_2);
                var1_1.add(var5_4);
                if (this.mDelimiter != null) break block11;
                var2_5 = new StringTokenizer(var4_2);
                while (var2_5.hasMoreTokens()) {
                    var3_6 = var2_5.nextToken();
                    var1_1.add(new Argument(1, var3_6));
                }
                break block12;
            }
            var6_7 = this.mDelimiter.charValue();
            var7_8 = 0;
            var8_9 = var4_2.indexOf(var6_7);
            if (var8_9 >= 0) ** GOTO lbl36
            var1_1.add(var5_4);
            break block12;
lbl-1000:
            // 1 sources

            {
                if (var7_8 == var8_9) {
                    var1_1.add(Argument.emptyString);
                } else {
                    var1_1.add(new Argument(1, var4_2.substring(var7_8, var8_9)));
                }
                var7_8 = var8_9 + 1;
                var8_9 = var4_2.indexOf(var6_7, var7_8);
lbl36:
                // 2 sources

                ** while (var8_9 >= 0)
            }
lbl37:
            // 1 sources

            var1_1.add(new Argument(1, var4_2.substring(var7_8)));
        }
        var6_7 = this.mMaxFields - var1_1.size();
        if (var6_7 > 0) {
            while (var6_7-- > 0) {
                var1_1.add(Argument.emptyString);
            }
        } else if (var6_7 < 0) {
            this.mMaxFields = var1_1.size();
        }
        return true;
    }

    public Row fetch() throws MapyrusException {
        Row row = new Row();
        if (this.readNextRow(row)) {
            return row;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws MapyrusException {
        try {
            try {
                if (this.mProcess != null) {
                    while (this.mReader.read() > 0) {
                    }
                }
                if (this.mProcess != null) {
                    try {
                        int n = this.mProcess.waitFor();
                        if (n != 0) {
                            throw new MapyrusException(MapyrusMessages.get("processerror") + ": " + this.mFilename);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        throw new MapyrusException(interruptedException.getMessage());
                    }
                }
                Object var3_4 = null;
            }
            catch (IOException iOException) {
                throw new MapyrusException(iOException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            try {
                this.mReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        this.mReader.close();
        return;
    }
}

