/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.dataset;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;

public class WKBGeometryParser {
    private static byte BIG_ENDIAN = 0;
    private static byte LITTLE_ENDIAN = 1;
    private static int WKB_POINT = 1;
    private static int WKB_LINESTRING = 2;
    private static int WKB_POLYGON = 3;
    private static int WKB_MULTIPOINT = 4;
    private static int WKB_MULTILINESTRING = 5;
    private static int WKB_MULTIPOLYGON = 6;
    private static int WKB_GEOMETRY_COLLECTION = 7;

    private static String convertToHexDigits(int n, ByteBuffer byteBuffer) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("0x");
        String string = Integer.toHexString(n &= 0xFF);
        if (string.length() == 1) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        int n2 = 0;
        while (n2 < 6) {
            if (byteBuffer.hasRemaining()) {
                n = byteBuffer.get();
                string = Integer.toHexString(n &= 0xFF);
                if (string.length() == 1) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(string);
            }
            ++n2;
        }
        if (byteBuffer.hasRemaining()) {
            stringBuffer.append("...");
        }
        return stringBuffer.toString();
    }

    private static int parseGeometry(ByteBuffer byteBuffer, double[] dArray, int n) throws MapyrusException {
        int n2 = n;
        if (byteBuffer.remaining() < 21) {
            String string = "";
            if (byteBuffer.hasRemaining()) {
                string = WKBGeometryParser.convertToHexDigits(byteBuffer.get(), byteBuffer);
            }
            throw new MapyrusException(MapyrusMessages.get("invalidogcwkb") + ": " + string);
        }
        byte by = byteBuffer.get();
        if (by == BIG_ENDIAN) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        } else if (by == LITTLE_ENDIAN) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            throw new MapyrusException(MapyrusMessages.get("invalidogcwkb") + ": " + WKBGeometryParser.convertToHexDigits(by, byteBuffer));
        }
        int n3 = byteBuffer.getInt();
        if (n3 == WKB_POINT) {
            dArray[n2++] = 100.0;
            dArray[n2++] = 1.0;
            dArray[n2++] = 0.0;
            dArray[n2++] = byteBuffer.getDouble();
            dArray[n2++] = byteBuffer.getDouble();
        } else if (n3 == WKB_LINESTRING) {
            dArray[n2++] = 101.0;
            int n4 = n2++;
            int n5 = byteBuffer.getInt();
            dArray[n4] = n5;
            boolean bl = false;
            int n6 = 0;
            while (n6 < n5) {
                dArray[n2++] = (double)bl;
                dArray[n2++] = byteBuffer.getDouble();
                dArray[n2++] = byteBuffer.getDouble();
                bl = true;
                ++n6;
            }
        } else if (n3 == WKB_POLYGON) {
            dArray[n2++] = 102.0;
            int n7 = n2++;
            int n8 = 0;
            int n9 = byteBuffer.getInt();
            int n10 = 0;
            while (n10 < n9) {
                int n11 = byteBuffer.getInt();
                n8 += n11;
                boolean bl = false;
                int n12 = 0;
                while (n12 < n11) {
                    dArray[n2++] = (double)bl;
                    dArray[n2++] = byteBuffer.getDouble();
                    dArray[n2++] = byteBuffer.getDouble();
                    bl = true;
                    ++n12;
                }
                ++n10;
            }
            dArray[n7] = n8;
        } else if (n3 == WKB_MULTIPOINT) {
            dArray[n2++] = 103.0;
            int n13 = n2++;
            int n14 = byteBuffer.getInt();
            dArray[n13] = n14;
            int n15 = 0;
            while (n15 < n14) {
                int n16 = WKBGeometryParser.parseGeometry(byteBuffer, dArray, n2);
                n2 += n16;
                ++n15;
            }
        } else if (n3 == WKB_MULTILINESTRING) {
            dArray[n2++] = 104.0;
            int n17 = n2++;
            int n18 = byteBuffer.getInt();
            dArray[n17] = n18;
            int n19 = 0;
            while (n19 < n18) {
                int n20 = WKBGeometryParser.parseGeometry(byteBuffer, dArray, n2);
                n2 += n20;
                ++n19;
            }
        } else if (n3 == WKB_MULTIPOLYGON) {
            dArray[n2++] = 105.0;
            int n21 = n2++;
            int n22 = byteBuffer.getInt();
            dArray[n21] = n22;
            int n23 = 0;
            while (n23 < n22) {
                int n24 = WKBGeometryParser.parseGeometry(byteBuffer, dArray, n2);
                n2 += n24;
                ++n23;
            }
        } else if (n3 == WKB_GEOMETRY_COLLECTION) {
            dArray[n2++] = 106.0;
            int n25 = n2++;
            int n26 = byteBuffer.getInt();
            dArray[n25] = n26;
            int n27 = 0;
            while (n27 < n26) {
                int n28 = WKBGeometryParser.parseGeometry(byteBuffer, dArray, n2);
                n2 += n28;
                ++n27;
            }
        } else {
            throw new MapyrusException(MapyrusMessages.get("invalidogcwkb") + ": " + WKBGeometryParser.convertToHexDigits(n3, byteBuffer));
        }
        return n2 - n;
    }

    public static double[] parse(byte[] byArray) throws MapyrusException {
        double[] dArray = new double[(byArray.length + 7) / 8 * 2];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        WKBGeometryParser.parseGeometry(byteBuffer, dArray, 0);
        return dArray;
    }
}

