/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.font;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.mapyrus.Constants;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;

public class PostScriptFont {
    private static final int LINE_LENGTH = 30;
    private String mFontName;
    private StringBuffer mFileContents;

    public PostScriptFont(String string, boolean bl) throws IOException, MapyrusException {
        if (bl) {
            if (!string.toLowerCase().endsWith(".pfb")) {
                throw new MapyrusException(MapyrusMessages.get("notapfbfile") + ": " + string);
            }
        } else if (!string.toLowerCase().endsWith(".pfa")) {
            throw new MapyrusException(MapyrusMessages.get("notapfafile") + ": " + string);
        }
        if (bl) {
            this.readPfbFile(string);
        } else {
            this.readPfaFile(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readPfbFile(String string) throws IOException, MapyrusException {
        Object var2_2 = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            int n;
            ArrayList<byte[]> arrayList;
            block22: {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
                byte[] byArray = new byte[2];
                byte[] byArray2 = new byte[4];
                arrayList = new ArrayList<byte[]>();
                n = 0;
                if (bufferedInputStream.read(byArray) != byArray.length) {
                    throw new IOException(MapyrusMessages.get("unexpectedeof") + ": " + string);
                }
                do {
                    if (byArray[1] == 3) {
                        if (arrayList.size() < 3) {
                            throw new MapyrusException(MapyrusMessages.get("notapfbfile") + ": " + string);
                        }
                        break block22;
                    }
                    if (byArray[0] != -128) {
                        throw new MapyrusException(MapyrusMessages.get("notapfbfile") + ": " + string);
                    }
                    if (bufferedInputStream.read(byArray2) != byArray2.length) {
                        throw new IOException(MapyrusMessages.get("unexpectedeof") + ": " + string);
                    }
                    int n2 = ByteBuffer.wrap(byArray2).order(ByteOrder.LITTLE_ENDIAN).getInt();
                    n += n2;
                    byte[] byArray3 = new byte[n2];
                    if (bufferedInputStream.read(byArray3) != byArray3.length) {
                        throw new IOException(MapyrusMessages.get("unexpectedeof") + ": " + string);
                    }
                    arrayList.add(byArray3);
                } while (bufferedInputStream.read(byArray) == byArray.length);
                throw new IOException(MapyrusMessages.get("unexpectedeof") + ": " + string);
            }
            this.mFileContents = new StringBuffer(131072);
            this.mFileContents.append("<< /Type /FontFile /Length ");
            long l = n * 2 + Constants.LINE_SEPARATOR.length();
            this.mFileContents.append(l += (long)(n / 30 * Constants.LINE_SEPARATOR.length()));
            this.mFileContents.append(Constants.LINE_SEPARATOR);
            this.mFileContents.append("/Length1 ");
            this.mFileContents.append(((byte[])arrayList.get(0)).length);
            this.mFileContents.append(" /Length2 ");
            this.mFileContents.append(((byte[])arrayList.get(1)).length);
            this.mFileContents.append(" /Length3 ");
            this.mFileContents.append(((byte[])arrayList.get(2)).length);
            this.mFileContents.append(" /Filter /ASCIIHexDecode >>");
            this.mFileContents.append(Constants.LINE_SEPARATOR);
            this.mFileContents.append("stream");
            this.mFileContents.append(Constants.LINE_SEPARATOR);
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            int n4 = 0;
            block6: while (true) {
                if (n4 >= arrayList.size()) {
                    this.mFileContents.append(Constants.LINE_SEPARATOR);
                    this.mFileContents.append("endstream");
                    Object var18_18 = null;
                    break;
                }
                boolean bl = true;
                byte[] byArray = (byte[])arrayList.get(n4);
                int n5 = 0;
                while (true) {
                    String string2;
                    if (n5 >= byArray.length) {
                        ++n4;
                        continue block6;
                    }
                    if (n4 == 0 && bl) {
                        if (byArray[n5] == 13 || byArray[n5] == 10) {
                            bl = false;
                            this.mFontName = this.parseFontName(stringBuffer.toString());
                            if (this.mFontName == null) {
                                throw new MapyrusException(MapyrusMessages.get("notapfafile") + ": " + string);
                            }
                        } else {
                            stringBuffer.append((char)byArray[n5]);
                        }
                    }
                    if ((string2 = Integer.toHexString(byArray[n5] & 0xFF)).length() < 2) {
                        this.mFileContents.append('0');
                    }
                    this.mFileContents.append(string2);
                    if (++n3 % 30 == 0) {
                        this.mFileContents.append(Constants.LINE_SEPARATOR);
                    }
                    ++n5;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            try {
                if (bufferedInputStream == null) throw throwable;
                bufferedInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (bufferedInputStream == null) return;
        bufferedInputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readPfaFile(String string) throws IOException, MapyrusException {
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(string));
            String string3 = bufferedReader.readLine();
            if (string3 == null) {
                throw new MapyrusException(MapyrusMessages.get("notapfafile") + ": " + string);
            }
            this.mFontName = this.parseFontName(string3);
            if (this.mFontName == null) {
                throw new MapyrusException(MapyrusMessages.get("notapfafile") + ": " + string);
            }
            this.mFileContents = new StringBuffer(131072);
            this.mFileContents.append(string3);
            this.mFileContents.append(Constants.LINE_SEPARATOR);
            while ((string2 = bufferedReader.readLine()) != null) {
                this.mFileContents.append(string2);
                this.mFileContents.append(Constants.LINE_SEPARATOR);
            }
            Object var6_5 = null;
            if (bufferedReader == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (bufferedReader == null) throw throwable;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
    }

    private String parseFontName(String string) {
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() > 1 && (string3 = stringTokenizer.nextToken()).startsWith("%!PS-AdobeFont")) {
            string2 = stringTokenizer.nextToken();
        }
        return string2;
    }

    public String getName() {
        return this.mFontName;
    }

    public String toString() {
        return "PostScript Font " + this.mFontName;
    }

    public String getFontDefinition() {
        return this.mFileContents.toString();
    }
}

