/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.FileInputStream;
import java.io.IOException;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;

public class TrueTypeFont {
    private String mFontName;
    private String mFilename;

    public TrueTypeFont(String string) throws IOException, MapyrusException {
        if (!string.toLowerCase().endsWith(".ttf")) {
            throw new MapyrusException(MapyrusMessages.get("notattffile") + ": " + string);
        }
        this.mFilename = string;
        Font font = this.getFont();
        this.mFontName = font.getPSName();
    }

    public String getName() {
        return this.mFontName;
    }

    public String toString() {
        return "TrueType Font " + this.mFontName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Font getFont() throws IOException, MapyrusException {
        Font font = null;
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(this.mFilename);
                font = Font.createFont(0, fileInputStream);
            }
            catch (FontFormatException fontFormatException) {
                throw new MapyrusException(MapyrusMessages.get("notattffile") + ": " + this.mFilename);
            }
            Object var5_3 = null;
            if (fileInputStream == null) return font;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (fileInputStream == null) throw throwable;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
        return font;
    }
}

