/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.function;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.mapyrus.Argument;
import org.mapyrus.ContextStack;
import org.mapyrus.LRUCache;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.function.Function;

public class Match
implements Function {
    private static final int MAX_COMPILED_REGEX = 100;
    private static LRUCache mRegexCache = new LRUCache(100);

    public static synchronized Pattern compileRegex(String string) throws MapyrusException {
        Pattern pattern = (Pattern)mRegexCache.get(string);
        if (pattern == null) {
            try {
                pattern = Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new MapyrusException(MapyrusMessages.get("invalidregex") + ": " + patternSyntaxException.getMessage());
            }
            mRegexCache.put(string, pattern);
        }
        return pattern;
    }

    public Argument evaluate(ContextStack contextStack, ArrayList arrayList) throws MapyrusException {
        int n;
        Argument argument = (Argument)arrayList.get(0);
        Argument argument2 = (Argument)arrayList.get(1);
        Pattern pattern = Match.compileRegex(argument2.toString());
        Matcher matcher = pattern.matcher(argument.toString());
        Argument argument3 = matcher.find() ? ((n = matcher.start() + 1) == 1 ? Argument.numericOne : new Argument(n)) : Argument.numericZero;
        return argument3;
    }

    public int getMaxArgumentCount() {
        return 2;
    }

    public int getMinArgumentCount() {
        return 2;
    }

    public String getName() {
        return "match";
    }
}

