/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.image;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.mapyrus.Constants;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;

public class BMPImage {
    private static final int BI_RGB = 0;
    private static final int BI_RLE8 = 1;
    private static final int BI_RLE4 = 2;
    private BufferedImage mImage;
    private int[] mColorTable;

    public BMPImage(URL uRL) throws MapyrusException, IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(uRL.openStream()));
        this.init(dataInputStream, uRL.toString());
    }

    public BMPImage(String string) throws MapyrusException, IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        this.init(fileInputStream, string);
    }

    public BMPImage(InputStream inputStream, String string) throws MapyrusException, IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        this.init(bufferedInputStream, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(InputStream inputStream, String string) throws MapyrusException, IOException {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            byte[] byArray = new byte[14];
            if (inputStream.read(byArray) != byArray.length) {
                throw new EOFException(MapyrusMessages.get("unexpectedeof") + ": " + string);
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byte by = byteBuffer.get();
            byte by2 = byteBuffer.get();
            if (by != 66 || by2 != 77) {
                throw new MapyrusException(MapyrusMessages.get("notabmpfile") + ": " + string);
            }
            int n6 = byteBuffer.getInt(10);
            byte[] byArray2 = new byte[40];
            if (inputStream.read(byArray2) != byArray2.length) {
                throw new EOFException(MapyrusMessages.get("unexpectedeof") + ": " + string);
            }
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray2);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            int n7 = byteBuffer2.getInt();
            int n8 = byteBuffer2.getInt();
            int n9 = byteBuffer2.getInt();
            byteBuffer2.getShort();
            short s = byteBuffer2.getShort();
            int n10 = byteBuffer2.getInt();
            byteBuffer2.getInt();
            byteBuffer2.getInt();
            byteBuffer2.getInt();
            int n11 = byteBuffer2.getInt();
            if (n10 != 0) {
                throw new MapyrusException(MapyrusMessages.get("notabmpfile") + ": " + string);
            }
            int n12 = byArray.length + byArray2.length;
            while (n12 < byArray.length + n7) {
                if (inputStream.read() == -1) {
                    throw new EOFException(MapyrusMessages.get("unexpectedeof") + ": " + string);
                }
                ++n12;
            }
            if (s != 24) {
                n5 = 1 << s;
                this.mColorTable = new int[n5];
                if (n11 != 0) {
                    n5 = Math.min(n5, n11);
                }
                int n13 = 0;
                while (n13 < n5 && n12 < n6) {
                    n4 = inputStream.read();
                    n3 = inputStream.read();
                    n2 = inputStream.read();
                    inputStream.read();
                    this.mColorTable[n13] = n = n2 << 16 | n3 << 8 | n4;
                    n12 += 4;
                    ++n13;
                }
            }
            while (n12 < n6) {
                inputStream.read();
                ++n12;
            }
            this.mImage = new BufferedImage(n8, n9, 1);
            n5 = (n8 * s + 7) / 8;
            n5 = (n5 + 3) / 4 * 4;
            int[] nArray = new int[n5];
            n4 = 0;
            while (n4 < n9) {
                n3 = 0;
                while (n3 < n5) {
                    nArray[n3] = inputStream.read();
                    ++n3;
                }
                n2 = 0;
                while (n2 < n8) {
                    n = 0;
                    switch (s) {
                        case 1: {
                            n = nArray[n2 / 8];
                            int n14 = 7 - n2 % 8;
                            n >>= n14;
                            n &= 1;
                            n = this.mColorTable[n];
                            break;
                        }
                        case 4: {
                            n = nArray[n2 / 2];
                            if (n2 % 2 == 0) {
                                n >>= 4;
                            }
                            n &= 0xF;
                            n = this.mColorTable[n];
                            break;
                        }
                        case 8: {
                            n = nArray[n2];
                            n = this.mColorTable[n];
                            break;
                        }
                        case 24: {
                            int n15 = nArray[n2 * 3];
                            int n16 = nArray[n2 * 3 + 1];
                            int n17 = nArray[n2 * 3 + 2];
                            n = n17 << 16 | n16 << 8 | n15;
                        }
                    }
                    this.mImage.setRGB(n2, n9 - 1 - n4, n);
                    ++n2;
                }
                ++n4;
            }
            Object var28_28 = null;
        }
        catch (Throwable throwable) {
            Object var28_29 = null;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
    }

    public BufferedImage getBufferedImage() {
        return this.mImage;
    }

    public static void write(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(14);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(40);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        int n = bufferedImage.getHeight();
        int n2 = bufferedImage.getWidth();
        int n3 = (n2 * 3 + 3) / 4 * 4;
        int n4 = byteBuffer.capacity() + byteBuffer2.capacity() + n3 * n;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        byteBuffer.put((byte)66);
        byteBuffer.put((byte)77);
        byteBuffer.putInt(n4);
        byteBuffer.putShort((short)0);
        byteBuffer.putShort((short)0);
        byteBuffer.putInt(byteBuffer.capacity() + byteBuffer2.capacity());
        byteBuffer.rewind();
        bufferedOutputStream.write(byteBuffer.array());
        byteBuffer2.putInt(byteBuffer2.capacity());
        byteBuffer2.putInt(n2);
        byteBuffer2.putInt(n);
        byteBuffer2.putShort((short)1);
        byteBuffer2.putShort((short)24);
        byteBuffer2.putInt(0);
        byteBuffer2.putInt(0);
        int n5 = (int)Math.round(39.37007874015748 * (double)Constants.getScreenResolution());
        byteBuffer2.putInt(n5);
        byteBuffer2.putInt(n5);
        byteBuffer2.putInt(0);
        byteBuffer2.putInt(0);
        byteBuffer2.rewind();
        bufferedOutputStream.write(byteBuffer2.array());
        int n6 = 0;
        while (n6 < n) {
            int n7;
            int n8 = 0;
            while (n8 < n2) {
                n7 = bufferedImage.getRGB(n8, n - n6 - 1);
                int n9 = n7 >> 16 & 0xFF;
                int n10 = n7 >> 8 & 0xFF;
                int n11 = n7 & 0xFF;
                bufferedOutputStream.write(n11);
                bufferedOutputStream.write(n10);
                bufferedOutputStream.write(n9);
                ++n8;
            }
            n7 = n3 - n8 * 3;
            while (n7-- > 0) {
                bufferedOutputStream.write(0);
            }
            ++n6;
        }
        bufferedOutputStream.flush();
    }
}

