/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.image;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class BlendComposite
implements Composite {
    public static BlendComposite MULTIPLY = new BlendComposite("multiply", new Blender(){

        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
            int n = 0;
            while (n < 3) {
                nArray3[n] = nArray[n] * nArray2[n] / 256;
                ++n;
            }
        }
    });
    public static BlendComposite SCREEN = new BlendComposite("screen", new Blender(){

        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
            int n = 0;
            while (n < 3) {
                nArray3[n] = 255 - (255 - nArray[n]) * (255 - nArray2[n]) / 256;
                ++n;
            }
        }
    });
    public static BlendComposite OVERLAY = new BlendComposite("overlay", new Blender(){

        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
            int n = 0;
            while (n < 3) {
                nArray3[n] = nArray2[n] < 128 ? nArray2[n] * nArray[n] >> 7 : 255 - (255 - nArray2[n]) * (255 - nArray[n]) / 128;
                ++n;
            }
        }
    });
    public static BlendComposite DARKEN = new BlendComposite("darken", new Blender(){

        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
            int n = 0;
            while (n < 3) {
                nArray3[n] = Math.min(nArray2[n], nArray[n]);
                ++n;
            }
        }
    });
    public static BlendComposite LIGHTEN = new BlendComposite("lighten", new Blender(){

        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
            int n = 0;
            while (n < 3) {
                nArray3[n] = Math.max(nArray2[n], nArray[n]);
                ++n;
            }
        }
    });
    public static BlendComposite COLORDODGE = new BlendComposite("colordodge", new Blender(){

        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
            int n = 0;
            while (n < 3) {
                if (nArray[n] == 255) {
                    nArray3[n] = 255;
                } else {
                    nArray3[n] = nArray2[n] * 256 / (255 - nArray[n]);
                    if (nArray3[n] > 255) {
                        nArray3[n] = 255;
                    }
                }
                ++n;
            }
        }
    });
    public static BlendComposite COLORBURN = new BlendComposite("colorburn", new Blender(){

        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
            int n = 0;
            while (n < 3) {
                if (nArray[n] == 0) {
                    nArray3[n] = 0;
                } else {
                    nArray3[n] = 255 - (255 - nArray2[n]) * 256 / nArray[n];
                    if (nArray3[n] < 0) {
                        nArray3[n] = 0;
                    }
                }
                ++n;
            }
        }
    });
    public static BlendComposite HARDLIGHT = new BlendComposite("hardlight", new Blender(){

        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
            int n = 0;
            while (n < 3) {
                nArray3[n] = nArray[n] < 128 ? nArray[n] * nArray2[n] / 128 : 255 - (255 - nArray[n]) * (255 - nArray2[n]) / 128;
                ++n;
            }
        }
    });
    public static BlendComposite SOFTLIGHT = new BlendComposite("softlight", new Blender(){

        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
            int n = 0;
            while (n < 3) {
                if (nArray[n] < 128) {
                    nArray3[n] = nArray[n] == 0 ? 0 : 255 - (255 - nArray2[n]) * 256 / nArray[n];
                    if (nArray3[n] < 0) {
                        nArray3[n] = 0;
                    }
                } else {
                    nArray3[n] = nArray[n] == 255 ? 255 : nArray2[n] * 256 / (255 - nArray[n]);
                }
                if (nArray3[n] > 255) {
                    nArray3[n] = 255;
                }
                ++n;
            }
        }
    });
    public static BlendComposite DIFFERENCE = new BlendComposite("difference", new Blender(){

        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
            int n = 0;
            while (n < 3) {
                nArray3[n] = Math.abs(nArray2[n] - nArray[n]);
                ++n;
            }
        }
    });
    public static BlendComposite EXCLUSION = new BlendComposite("exclusion", new Blender(){

        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
            int n = 0;
            while (n < 3) {
                nArray3[n] = nArray2[n] + nArray[n] - nArray2[n] * nArray[n] / 128;
                ++n;
            }
        }
    });
    private String mName;
    private Blender mBlender;

    public BlendComposite(String string, Blender blender) {
        this.mName = string;
        this.mBlender = blender;
    }

    public CompositeContext createContext(ColorModel colorModel, ColorModel colorModel2, RenderingHints renderingHints) {
        BlendCompositeContext blendCompositeContext = new BlendCompositeContext();
        return blendCompositeContext;
    }

    public static BlendComposite getBlendComposite(String string) {
        BlendComposite blendComposite = null;
        if (string.equals(MULTIPLY.getName())) {
            blendComposite = MULTIPLY;
        } else if (string.equals(SCREEN.getName())) {
            blendComposite = SCREEN;
        } else if (string.equals(OVERLAY.getName())) {
            blendComposite = OVERLAY;
        } else if (string.equals(DARKEN.getName())) {
            blendComposite = DARKEN;
        } else if (string.equals(LIGHTEN.getName())) {
            blendComposite = LIGHTEN;
        } else if (string.equals(COLORDODGE.getName())) {
            blendComposite = COLORDODGE;
        } else if (string.equals(COLORBURN.getName())) {
            blendComposite = COLORBURN;
        } else if (string.equals(HARDLIGHT.getName())) {
            blendComposite = HARDLIGHT;
        } else if (string.equals(SOFTLIGHT.getName())) {
            blendComposite = SOFTLIGHT;
        } else if (string.equals(DIFFERENCE.getName())) {
            blendComposite = DIFFERENCE;
        } else if (string.equals(EXCLUSION.getName())) {
            blendComposite = EXCLUSION;
        }
        return blendComposite;
    }

    public String getName() {
        return this.mName;
    }

    private class BlendCompositeContext
    implements CompositeContext {
        private BlendCompositeContext() {
        }

        public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int n = Math.min(raster.getWidth(), raster2.getWidth());
            int n2 = Math.min(raster.getHeight(), raster2.getHeight());
            int[] nArray = new int[4];
            int[] nArray2 = new int[4];
            int[] nArray3 = new int[4];
            int n3 = 0;
            while (n3 < n2) {
                int n4 = 0;
                while (n4 < n) {
                    raster.getPixel(n4, n3, nArray);
                    int n5 = nArray[3];
                    raster2.getPixel(n4, n3, nArray2);
                    BlendComposite.this.mBlender.blend(nArray, nArray2, nArray3);
                    nArray3[3] = nArray[3] + nArray2[3];
                    int n6 = 0;
                    while (n6 < 4) {
                        if (n5 != 255) {
                            nArray3[n6] = nArray2[n6] + (nArray3[n6] - nArray2[n6]) * n5 / 256;
                        }
                        if (nArray3[n6] > 255) {
                            nArray3[n6] = 255;
                        }
                        ++n6;
                    }
                    writableRaster.setPixel(n4, n3, nArray3);
                    ++n4;
                }
                ++n3;
            }
        }

        public void dispose() {
        }
    }

    private static interface Blender {
        public void blend(int[] var1, int[] var2, int[] var3);
    }
}

