/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import org.mapyrus.Constants;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.image.BMPImage;
import org.mapyrus.image.PATImage;
import org.mapyrus.image.PNMImage;
import org.mapyrus.image.XBMImage;

public class ImageIOWrapper {
    public static BufferedImage read(File file, Color color) throws IOException, MapyrusException {
        String string = file.getName().toLowerCase();
        BufferedImage bufferedImage = string.endsWith(".ppm") || string.endsWith(".pgm") || string.endsWith(".pbm") ? new PNMImage(file.toString()).getBufferedImage() : (string.endsWith(".bmp") ? new BMPImage(file.toString()).getBufferedImage() : (string.endsWith(".pat") ? new PATImage(file.toString()).getBufferedImage() : (string.endsWith(".xbm") ? new XBMImage(file.toString(), color.getRGB()).getBufferedImage() : ImageIO.read(file))));
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage read(URL uRL, Color color) throws IOException, MapyrusException {
        BufferedImage bufferedImage;
        InputStream inputStream = null;
        try {
            String string = uRL.getPath().toLowerCase();
            URLConnection uRLConnection = uRL.openConnection();
            String string2 = uRLConnection.getContentType();
            inputStream = uRLConnection.getInputStream();
            if (string2.startsWith("text/") || string2.startsWith("application/vnd.ogc.")) {
                int n;
                StringBuffer stringBuffer = new StringBuffer();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((n = bufferedReader.read()) != -1) {
                    stringBuffer.append((char)n);
                    if (stringBuffer.length() < 1360) continue;
                    stringBuffer.append("...");
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("urlreturned") + ": " + string2 + Constants.LINE_SEPARATOR + uRL.toString() + Constants.LINE_SEPARATOR + stringBuffer);
            }
            bufferedImage = string2.equals("image/x-portable-pixmap") || string2.equals("image/x-portable-bitmap") || string2.equals("image/x-portable-graymap") ? new PNMImage(inputStream, string).getBufferedImage() : (string2.equals("image/bmp") ? new BMPImage(inputStream, string).getBufferedImage() : (string2.equals("image/x-xbm") ? new XBMImage(inputStream, string, color.getRGB()).getBufferedImage() : ImageIO.read(inputStream)));
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {}
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void write(BufferedImage bufferedImage, String string, File file) throws IOException {
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            ImageIOWrapper.write(bufferedImage, string, bufferedOutputStream);
            Object var5_4 = null;
            if (bufferedOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (bufferedOutputStream == null) throw throwable;
            bufferedOutputStream.close();
            throw throwable;
        }
        bufferedOutputStream.close();
    }

    public static void write(BufferedImage bufferedImage, String string, OutputStream outputStream) throws IOException {
        if (string.equalsIgnoreCase("ppm")) {
            PNMImage.write(bufferedImage, outputStream);
        } else if (string.equalsIgnoreCase("bmp")) {
            BMPImage.write(bufferedImage, outputStream);
        } else {
            ImageIO.write((RenderedImage)bufferedImage, string, outputStream);
        }
    }

    public static String[] getWriterFormatNames() {
        String[] stringArray = ImageIO.getWriterFormatNames();
        String[] stringArray2 = new String[stringArray.length + 2];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = "ppm";
        stringArray2[stringArray.length + 1] = "bmp";
        return stringArray2;
    }
}

