/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.image;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;

public class PATImage {
    private BufferedImage mImage;

    public PATImage(URL uRL) throws MapyrusException, IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(uRL.openStream()));
        this.init(dataInputStream, uRL.toString());
    }

    public PATImage(String string) throws MapyrusException, IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
        this.init(dataInputStream, string);
    }

    public PATImage(InputStream inputStream, String string) throws MapyrusException, IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        this.init(dataInputStream, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(DataInputStream dataInputStream, String string) throws MapyrusException, IOException {
        try {
            int n = dataInputStream.readInt();
            dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            byte[] byArray = new byte[4];
            if (dataInputStream.read(byArray) != byArray.length) {
                throw new MapyrusException(MapyrusMessages.get("unexpectedeof") + ": " + string);
            }
            if (byArray[0] != 71 || byArray[1] != 80 || byArray[2] != 65 || byArray[3] != 84 || n2 <= 0 || n3 <= 0) {
                throw new MapyrusException(MapyrusMessages.get("notapatfile") + ": " + string);
            }
            int n5 = 24;
            while (n5++ < n) {
                if (dataInputStream.read() >= 0) continue;
                throw new MapyrusException(MapyrusMessages.get("unexpectedeof") + ": " + string);
            }
            this.mImage = new BufferedImage(n2, n3, 1);
            int n6 = 0;
            while (n6 < n3) {
                int n7 = 0;
                while (n7 < n2) {
                    int n8;
                    int n9;
                    int n10;
                    if (n4 == 1) {
                        n9 = n10 = dataInputStream.read();
                        n8 = n10;
                    } else {
                        n8 = dataInputStream.read();
                        n9 = dataInputStream.read();
                        n10 = dataInputStream.read();
                    }
                    if (n8 < 0 || n9 < 0 || n10 < 0) {
                        throw new MapyrusException(MapyrusMessages.get("unexpectedeof") + ": " + string);
                    }
                    int n11 = n8 << 16 | n9 << 8 | n10;
                    this.mImage.setRGB(n7, n6, n11);
                    ++n7;
                }
                ++n6;
            }
            Object var16_15 = null;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            try {
                dataInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            dataInputStream.close();
        }
        catch (IOException iOException) {}
    }

    public BufferedImage getBufferedImage() {
        return this.mImage;
    }
}

