/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.image;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;

public class PNMImage {
    private BufferedImage mImage;

    public PNMImage(URL uRL) throws MapyrusException, IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(uRL.openStream()));
        this.init(dataInputStream, uRL.toString());
    }

    public PNMImage(String string) throws MapyrusException, IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
        this.init(dataInputStream, string);
    }

    public PNMImage(InputStream inputStream, String string) throws MapyrusException, IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        this.init(dataInputStream, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(DataInputStream dataInputStream, String string) throws MapyrusException, IOException {
        try {
            boolean bl;
            boolean bl2;
            int n = dataInputStream.read();
            int n2 = dataInputStream.read();
            if (n == 80 && n2 == 54) {
                bl2 = false;
                bl = false;
            } else if (n == 80 && n2 == 53) {
                bl = true;
                bl2 = false;
            } else if (n == 80 && n2 == 52) {
                bl2 = true;
                bl = false;
            } else {
                throw new MapyrusException(MapyrusMessages.get("notappmfile") + ": " + string);
            }
            int n3 = this.readNumber(dataInputStream);
            int n4 = this.readNumber(dataInputStream);
            int n5 = 1;
            if (!bl2) {
                n5 = this.readNumber(dataInputStream);
            }
            int n6 = n5 < 256 ? 1 : 2;
            this.mImage = new BufferedImage(n3, n4, 1);
            int n7 = 0;
            int n8 = 0;
            while (n8 < n4) {
                int n9 = 0;
                int n10 = 0;
                while (n10 < n3) {
                    int n11;
                    int n12;
                    int n13;
                    if (n6 == 1) {
                        if (bl2) {
                            if (n9 == 0) {
                                n7 = dataInputStream.read();
                                n9 = 128;
                            }
                            n13 = (n7 & n9) != 0 ? 0 : 255;
                            n12 = n13;
                            n11 = n13;
                            n9 >>= 1;
                        } else if (bl) {
                            n12 = n13 = dataInputStream.read();
                            n11 = n13;
                        } else {
                            n11 = dataInputStream.read();
                            n12 = dataInputStream.read();
                            n13 = dataInputStream.read();
                        }
                    } else if (bl) {
                        n12 = n13 = dataInputStream.readShort();
                        n11 = n13;
                    } else {
                        n11 = dataInputStream.readShort();
                        n12 = dataInputStream.readShort();
                        n13 = dataInputStream.readShort();
                    }
                    int n14 = n11 << 16 | n12 << 8 | n13;
                    this.mImage.setRGB(n10, n8, n14);
                    ++n10;
                }
                ++n8;
            }
            Object var20_19 = null;
        }
        catch (Throwable throwable) {
            Object var20_20 = null;
            try {
                dataInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            dataInputStream.close();
        }
        catch (IOException iOException) {}
    }

    private int readNumber(InputStream inputStream) throws IOException {
        int n = 0;
        int n2 = inputStream.read();
        boolean bl = n2 == 35;
        while (n2 != -1 && (bl || Character.isWhitespace((char)n2))) {
            n2 = inputStream.read();
            if (n2 == 35) {
                bl = true;
                continue;
            }
            if (!bl || n2 != 13 && n2 != 10) continue;
            bl = false;
        }
        while (n2 >= 48 && n2 <= 57) {
            n = n * 10 + (n2 - 48);
            n2 = inputStream.read();
        }
        return n;
    }

    public BufferedImage getBufferedImage() {
        return this.mImage;
    }

    public static void write(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        outputStream.write(80);
        outputStream.write(54);
        outputStream.write(10);
        outputStream.write(Integer.toString(n).getBytes());
        outputStream.write(32);
        outputStream.write(Integer.toString(n2).getBytes());
        outputStream.write(10);
        outputStream.write(Integer.toString(255).getBytes());
        outputStream.write(10);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                int n5 = bufferedImage.getRGB(n4, n3);
                int n6 = n5 & 0xFF;
                int n7 = n5 >> 8 & 0xFF;
                int n8 = n5 >> 16 & 0xFF;
                outputStream.write(n8);
                outputStream.write(n7);
                outputStream.write(n6);
                ++n4;
            }
            ++n3;
        }
        outputStream.flush();
    }
}

