/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.io;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.zip.Deflater;
import org.mapyrus.Constants;

public class ASCII85Writer {
    private int[] mUnencodedBytes = new int[4];
    private int mNUnencodedBytes = 0;
    private char[] mEncodedChars = new char[5];
    private Writer mWriter;
    private int mNCharsOnLine;
    private Deflater mDeflater;
    private byte[] mDeflateBuffer;
    private int mNBytesBuffered;

    public ASCII85Writer(Writer writer, boolean bl) throws IOException {
        this.mWriter = writer;
        if (bl) {
            this.mDeflater = new Deflater();
            this.mDeflateBuffer = new byte[512];
            this.mNBytesBuffered = 0;
        }
        this.mWriter.write(32);
        this.mNCharsOnLine = 1;
    }

    private void writeEncoded(boolean bl) throws IOException {
        long l = (long)this.mUnencodedBytes[0] << 24;
        l |= (long)this.mUnencodedBytes[1] << 16;
        l |= (long)this.mUnencodedBytes[2] << 8;
        if (!bl && (l |= (long)this.mUnencodedBytes[3]) == 0L) {
            this.mWriter.write(122);
            ++this.mNCharsOnLine;
        } else {
            this.mEncodedChars[4] = (char)(l % 85L + 33L);
            this.mEncodedChars[3] = (char)((l /= 85L) % 85L + 33L);
            this.mEncodedChars[2] = (char)((l /= 85L) % 85L + 33L);
            this.mEncodedChars[1] = (char)((l /= 85L) % 85L + 33L);
            this.mEncodedChars[0] = (char)(l / 85L + 33L);
            if (bl) {
                this.mWriter.write(this.mEncodedChars, 0, this.mNUnencodedBytes + 1);
            } else {
                this.mWriter.write(this.mEncodedChars);
                this.mNCharsOnLine += this.mEncodedChars.length;
            }
        }
        if (this.mNCharsOnLine > 72) {
            this.mWriter.write(Constants.LINE_SEPARATOR + " ");
            this.mNCharsOnLine = 0;
        }
    }

    private void save(int n) throws IOException {
        this.mUnencodedBytes[this.mNUnencodedBytes++] = n;
        if (this.mNUnencodedBytes == this.mUnencodedBytes.length) {
            this.writeEncoded(false);
            this.mNUnencodedBytes = 0;
        }
    }

    public void write(int n) throws IOException {
        if (this.mDeflater != null) {
            if (n >= 128) {
                n -= 256;
            }
            this.mDeflateBuffer[this.mNBytesBuffered++] = (byte)n;
            if (this.mNBytesBuffered == this.mDeflateBuffer.length) {
                int n2;
                this.mDeflater.setInput(this.mDeflateBuffer);
                this.mDeflateBuffer = new byte[this.mDeflateBuffer.length];
                this.mNBytesBuffered = 0;
                while ((n2 = this.mDeflater.deflate(this.mDeflateBuffer)) > 0) {
                    int n3 = 0;
                    while (n3 < n2) {
                        this.save(this.mDeflateBuffer[n3] & 0xFF);
                        ++n3;
                    }
                }
            }
        } else {
            this.save(n);
        }
    }

    public void close() throws IOException {
        int n;
        if (this.mDeflater != null) {
            if (this.mNBytesBuffered > 0) {
                this.mDeflater.setInput(this.mDeflateBuffer, 0, this.mNBytesBuffered);
            }
            this.mDeflater.finish();
            this.mDeflateBuffer = new byte[this.mDeflateBuffer.length];
            while (!this.mDeflater.finished()) {
                n = this.mDeflater.deflate(this.mDeflateBuffer);
                int n2 = 0;
                while (n2 < n) {
                    this.save(this.mDeflateBuffer[n2] & 0xFF);
                    ++n2;
                }
            }
        }
        if (this.mNUnencodedBytes > 0) {
            n = this.mNUnencodedBytes;
            while (n < this.mUnencodedBytes.length) {
                this.mUnencodedBytes[n] = 0;
                ++n;
            }
            this.writeEncoded(true);
        }
    }

    public static void main(String[] stringArray) {
        String string = "The quick brown fox jumped over the lazy dog.";
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter("/tmp/ascii85.txt"));
            ASCII85Writer aSCII85Writer = new ASCII85Writer(printWriter, false);
            byte[] byArray = string.getBytes();
            int n = 0;
            while (n < 100) {
                int n2 = 0;
                while (n2 < byArray.length) {
                    aSCII85Writer.write(byArray[n2]);
                    ++n2;
                }
                ++n;
            }
            aSCII85Writer.close();
            printWriter.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }
}

