/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.svg;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.mapyrus.Constants;
import org.mapyrus.FileOrURL;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SVGFile
extends DefaultHandler {
    private Rectangle2D mBoundingBox;
    private StringBuffer mContents;
    private StringBuffer mSVGAttributes;
    private int mSVGTagCount;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SVGFile(String string) throws IOException, MapyrusException {
        InputStream inputStream = null;
        try {
            try {
                XMLReader xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
                xMLReader.setContentHandler(this);
                xMLReader.setEntityResolver(this);
                inputStream = new FileOrURL(string).getInputStream();
                xMLReader.parse(new InputSource(inputStream));
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new MapyrusException(MapyrusMessages.get("invalidsvg") + ": " + string + ": " + parserConfigurationException.getMessage());
            }
            catch (SAXException sAXException) {
                throw new MapyrusException(MapyrusMessages.get("invalidsvg") + ": " + string + ": " + sAXException.getMessage());
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (inputStream == null) return;
        inputStream.close();
        return;
    }

    public Rectangle2D getBoundingBox() {
        return this.mBoundingBox;
    }

    public void startDocument() {
        this.mContents = new StringBuffer(1024);
        this.mSVGAttributes = new StringBuffer(256);
    }

    public InputSource resolveEntity(String string, String string2) {
        return new InputSource(new StringReader(""));
    }

    private double parseSize(String string) {
        double d = 1.0;
        if (string.endsWith("pt")) {
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("px")) {
            string = string.substring(0, string.length() - 2);
            d = 72.0 / (double)Constants.getScreenResolution();
        } else if (string.endsWith("mm")) {
            string = string.substring(0, string.length() - 2);
            d = 2.834645669291339;
        } else if (string.endsWith("cm")) {
            string = string.substring(0, string.length() - 2);
            d = 28.34645669291339;
        } else if (string.endsWith("in")) {
            string = string.substring(0, string.length() - 2);
            d = 72.0;
        }
        double d2 = Double.parseDouble(string);
        return d2 * d;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (string3.equals("svg")) {
            ++this.mSVGTagCount;
        }
        if (string3.equals("svg") && this.mSVGTagCount == 1) {
            String string4 = attributes.getValue("width");
            String string5 = attributes.getValue("height");
            this.mBoundingBox = new Rectangle2D.Double(0.0, 0.0, this.parseSize(string4), this.parseSize(string5));
            int n = 0;
            while (n < attributes.getLength()) {
                if (!attributes.getQName(n).equals("width") && !attributes.getQName(n).equals("height")) {
                    this.mSVGAttributes.append(attributes.getQName(n));
                    this.mSVGAttributes.append("=\"");
                    this.mSVGAttributes.append(attributes.getValue(n));
                    this.mSVGAttributes.append("\"");
                    this.mSVGAttributes.append(Constants.LINE_SEPARATOR);
                }
                ++n;
            }
        } else {
            this.mContents.append("<").append(string3).append(" ");
            int n = 0;
            while (n < attributes.getLength()) {
                this.mContents.append(attributes.getQName(n));
                this.mContents.append("=\"");
                this.mContents.append(attributes.getValue(n));
                this.mContents.append("\"");
                this.mContents.append(Constants.LINE_SEPARATOR);
                ++n;
            }
            this.mContents.append(">");
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (string3.equals("svg")) {
            --this.mSVGTagCount;
            if (this.mSVGTagCount > 0) {
                this.mContents.append("</svg>");
            }
        } else {
            this.mContents.append("</").append(string3).append(">");
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            char c = cArray[n + n3];
            if (c == '&' || c == '<' || c == '>' || c == '\"' || c > '\u007f') {
                this.mContents.append("&#").append(Integer.toString(c)).append(";");
            } else {
                this.mContents.append(c);
            }
            ++n3;
        }
    }

    public String toString() {
        return this.mContents.toString();
    }

    public String getSVGAttributes() {
        return this.mSVGAttributes.toString();
    }
}

