/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __button_h
#define __button_h

G_BEGIN_DECLS

typedef struct {
    GtkWidget *button;
    GtkWidget *icon;
} MdhButtonWidgets;

typedef gboolean (*MdhButtonFunc) (gpointer data);

typedef struct {
    gpointer          toolbar;

    const gchar      *tooltip;

    MdhButtonFunc     callback;

    gboolean          hidden;

    gboolean          can_toggle;       /* can the button be hidden? */

    gboolean          enabled;

    MdhButtonWidgets  widgets;
} MdhButton;

MdhButton *mdh_button_new(gboolean enabled,
                          gboolean can_toggle,
                          const gchar *tooltip,
                          MdhButtonFunc func,
                          const gchar *image,
                          gint type);
void mdh_button_free(MdhButton *obj);

void mdh_button_toggle(MdhButton *obj);
void mdh_button_show(MdhButton *obj);
void mdh_button_hide(MdhButton *obj);
void mdh_button_reset(MdhButton *obj);

void mdh_button_foreach(gpointer toolbar, GFunc func, gpointer data);

gboolean mdh_button_hidden(MdhButton *obj);

gboolean mdh_button_execute_callback(MdhButton *obj, GError **err);

void mdh_button_set_relief(MdhButton *obj, GtkReliefStyle relief);
void mdh_button_set_tip(MdhButton *obj, const gchar *text);

#define MDH_BUTTON(b) ((MdhButton *) b)

MdhButton *B_Menu, *B_Toggle, *B_Run, *B_Pad;

#ifdef _MDH_HAS_MIXER
MdhButton *B_Volume;
#endif

G_END_DECLS

#endif /* __button_h */
