/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <unistd.h>

#include <gtk/gtk.h>

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#include "error.h"

static GSList *error_list;

#define _ERR_LOG_MAX 128

void mdh_error_add(const gchar *fmt, ...)
{
    gchar *msg, date[64];
    
    va_list args;

    if(g_slist_length(error_list) > _ERR_LOG_MAX)
        mdh_error_clear_all();

    va_start(args, fmt);
    msg = g_strdup_vprintf(fmt, args);
    va_end(args);

    {
        time_t timep = time(NULL);
        gsize len = g_strlcpy(date, ctime(&timep), sizeof(date));
        date[len - 1] = 0; /* strip trailing newline */
    }

    error_list = g_slist_append(error_list,
                                g_strdup_printf("%s - %s", date, msg));

    g_free(msg);
}

void mdh_error_clear_all(void)
{
    mdh_error_free_all();
    ADD_LOG("MailDooHicky error log cleared");
}

void mdh_error_free_all(void)
{
    g_slist_foreach(error_list, (GFunc) g_free, NULL);
    g_slist_free(error_list);
    error_list = NULL;
}

GSList *mdh_error_list(void)
{
    return(error_list);
}
