/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __mdh_h
#define __mdh_h

G_BEGIN_DECLS

const gchar *mdh_get_home_dir(void);
const gchar *mdh_get_cache_dir(void);
const gchar *mdh_get_config_file(void);
const gchar *mdh_get_browser(void);
const gchar *mdh_get_xterm(void);

#ifdef HAVE_OSS
# define _MDH_HAS_MIXER  1
#endif

#ifdef HAVE_STRFTIME
# define _MDH_HAS_TIME   1
#endif

#ifdef HAVE_GLIBTOP_H
# define _MDH_HAS_CPU    1
# define _MDH_HAS_DISK   1
# define _MDH_HAS_MEM    1
# define _MDH_HAS_NET    1
# define _MDH_HAS_UPTIME 1
#else /* HAVE_GLIBTOP_H */
# if (defined(HAVE_GETLOADAVG))
#  define _MDH_HAS_CPU    1
# endif
# if (defined(HAVE_STATFS) || defined(HAVE_STATVFS))
#  define _MDH_HAS_DISK   1
# endif
# if (defined(__linux__) || defined(__sun__) || defined(__FreeBSD__) || \
      defined(__NetBSD__) || defined(__OpenBSD__))
#  define _MDH_HAS_MEM    1
#  define _MDH_HAS_NET    1
#  define _MDH_HAS_UPTIME 1
# endif
#endif /* HAVE_GLIBTOP_H */

#if (defined(HAVE_CURL_CURL_H) && defined(HAVE_LIBXML_PARSER_H))
# define _MDH_HAS_WEATHER 1
#endif

#define _MDH_URL   "http://www.gozer.org/my_stuff/gtk/mdh.php"
#define _MDH_EMAIL "mdh at gozer dot org"

G_END_DECLS

#endif /* __mdh_h */
