/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __panel_h
#define __panel_h

G_BEGIN_DECLS

typedef enum {
    MDH_PANEL_FLAG_BOLD = 1 << 0,
    MDH_PANEL_FLAG_ICON = 1 << 1
} MdhPanelFlags;

typedef struct {
    GtkWidget *event_box;
    GtkWidget *frame;
    GtkWidget *label;
    GtkWidget *icon;
} MdhPanelWidgets;

typedef gboolean (*MdhPanelFunc) (gpointer data, GError **err);

typedef struct {
    MdhPanelFunc  main;      /* main function */
    MdhPanelFunc  startup;   /* startup function, can be NULL */
    MdhPanelFunc  shutdown;  /* shutdown function, can be NULL */
    MdhPanelFunc  callback;  /* callback function, ccan be NULL */

    void        (*config)  (const gchar *v_in, gchar **v_out,
                            const gchar *d_in, gchar **d_out,
                            const gchar *c_in, gchar **c_out,
                            const gint   i_in, gint   *i_out); /* can be NULL */
} MdhPanelFuncs;
    
typedef struct {
    gpointer         toolbar;

    gboolean         init;

    gint             interval;    /* timer interval */
    
    guint            handler;     /* timer handler mdh_timeout_del/add() */
    
    gboolean         busy;        /* panel is busy */

    gboolean         hidden;

    gboolean         enabled;
    gchar           *command;     /* click action command */
    gchar           *value;       /* panel value (/var/mail/logan, eth0) */
    gchar           *display;     /* display format (%L: %T) */
    gchar           *tooltip;     /* panel tooltip */

    gpointer         data;        /* arbitrary panel data */

    MdhPanelFlags    flags;

    MdhPanelWidgets  widgets;     /* gtk widgets */
    MdhPanelFuncs    funcs;       /* functions (initialization, main, etc) */
} MdhPanel;

MdhPanel *mdh_panel_new(void);
void mdh_panel_free(MdhPanel *obj);

void mdh_panel_start(MdhPanel *obj);
void mdh_panel_stop(MdhPanel *obj);

void mdh_panel_refresh(MdhPanel *obj);

void mdh_panel_toggle(MdhPanel *obj);
void mdh_panel_show(MdhPanel *obj);
void mdh_panel_hide(MdhPanel *obj);
void mdh_panel_reset(MdhPanel *obj);

void mdh_panel_foreach(gpointer toolbar, GFunc func, gpointer data);

gboolean mdh_panel_hidden(MdhPanel *obj);

gboolean mdh_panel_execute_func(MdhPanel *obj);
gboolean mdh_panel_execute_callback(MdhPanel *obj, GError **err);

MdhPanelFlags mdh_panel_flags(MdhPanel *obj);
void mdh_panel_flags_set(MdhPanel *obj, MdhPanelFlags flags);

void mdh_panel_set_shadow_type(MdhPanel *obj, GtkShadowType type);

void mdh_panel_set_tip(MdhPanel *obj, const gchar *text);
void mdh_panel_set_tip_r(MdhPanel *obj, const gchar *text);

void mdh_panel_set_text_r(MdhPanel *obj, gboolean bold, const gchar *fmt, ...);

void mdh_panel_set_markup(MdhPanel *obj, const gchar *markup);
void mdh_panel_set_markup_r(MdhPanel *obj, const gchar *markup);

void mdh_panel_set_icon(MdhPanel *obj, const gchar *base);
void mdh_panel_set_icon_r(MdhPanel *obj, const gchar *base);

void mdh_panel_set_font_desc(MdhPanel *obj, PangoFontDescription *font_desc);
void mdh_panel_set_font_desc_r(MdhPanel *obj, PangoFontDescription *font_desc);

void mdh_panel_set_font(MdhPanel *obj, const gchar *font);
void mdh_panel_set_font_r(MdhPanel *obj, const gchar *font);

#define mdh_panel_flags_bold(p) (mdh_panel_flags(p) & MDH_PANEL_FLAG_BOLD)
#define mdh_panel_flags_icon(p) (mdh_panel_flags(p) & MDH_PANEL_FLAG_ICON)

#define MDH_PANEL(p) ((MdhPanel *) p)

G_END_DECLS

#endif /* __panel_h */
