/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __panel_cpu_h
#define __panel_cpu_h

G_BEGIN_DECLS

#if _MDH_HAS_CPU

MdhPanelFlags mdh_panel_cpu_flags(MdhPanel *obj);
void mdh_panel_cpu_flags_set(MdhPanel *obj, MdhPanelFlags flags);

gint mdh_panel_cpu_threshold(MdhPanel *obj);
void mdh_panel_cpu_threshold_set(MdhPanel *obj, gint threshold);

MdhPanel *mdh_panel_cpu_new(const gchar *display,
                            const gchar *command,
                            gboolean enabled);

#define _CPU_MIN 1   /* min cpu interval */
#define _CPU_MAX 60  /* max cpu interval */
#define _CPU_DEF 3   /* default cpu interval */

#define _CPU_THRESH_MIN 1
#define _CPU_THRESH_MAX 100
#define _CPU_THRESH_DEF 90

#define _CPU_DIS "%p"

MdhPanel *P_Cpu;

#endif /* _MDH_HAS_CPU */

G_END_DECLS

#endif /* __panel_cpu_h */
