/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __panel_mail_h
#define __panel_mail_h

G_BEGIN_DECLS

MdhPanelFlags mdh_panel_mail_flags(MdhPanel *obj);
void mdh_panel_mail_flags_set(MdhPanel *obj, MdhPanelFlags flags);

gint mdh_panel_mail_threshold(MdhPanel *obj);
void mdh_panel_mail_threshold_set(MdhPanel *obj, gint threshold);

gint mdh_panel_mail_count(MdhPanel *obj);
void mdh_panel_mail_count_set(MdhPanel *obj, gint count);

MdhPanel *mdh_panel_mail_new(const gchar *value,
                             const gchar *display,
                             const gchar *command,
                             gboolean enabled);

#define _MAIL_MIN 5    /* min interval */
#define _MAIL_MAX 300  /* max interval */
#define _MAIL_DEF 30   /* default interval */

#define _MAIL_THRESH_MIN 1
#define _MAIL_THRESH_MAX 100
#define _MAIL_THRESH_DEF 1

#define _MAIL_DIS "%n/%t"

#define _MDH_PANEL_COUNT_MAIL_MIN  3
#define _MDH_PANEL_COUNT_MAIL_MAX 10

MdhPanel **P_Mail;

G_END_DECLS

#endif /* __panel_mail_h */
