/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __panel_net_h
#define __panel_net_h

G_BEGIN_DECLS

#if _MDH_HAS_NET

gint mdh_panel_net_count(MdhPanel *obj);
void mdh_panel_net_count_set(MdhPanel *obj, gint count);

MdhPanel *mdh_panel_net_new(const gchar *value,
                            const gchar *display,
                            const gchar *command,
                            gboolean enabled);

#define _NET_MIN 1   /* min interval */
#define _NET_MAX 60  /* max interval */
#define _NET_DEF 3   /* default interval */

#define _NET_DIS "%r/%t"

#ifdef __sun__
# define _MDH_PANEL_COUNT_NET_MIN  1
# define _MDH_PANEL_COUNT_NET_MAX  1
#else
# define _MDH_PANEL_COUNT_NET_MIN  3
# define _MDH_PANEL_COUNT_NET_MAX 10
#endif

MdhPanel **P_Net;

#endif /* _MDH_HAS_NET */

G_END_DECLS

#endif /* __panel_net_h */
