/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __panel_weather_h
#define __panel_weather_h

G_BEGIN_DECLS

#if _MDH_HAS_WEATHER

MdhPanelFlags mdh_panel_weather_flags(MdhPanel *obj);
void mdh_panel_weather_flags_set(MdhPanel *obj, MdhPanelFlags flags);

const gchar *mdh_panel_weather_unit(MdhPanel *obj);
void mdh_panel_weather_unit_metric_set(MdhPanel *obj, gboolean metric);

MdhPanel *mdh_panel_weather_new(const gchar *value,
                                const gchar *display,
                                const gchar *command,
                                gboolean enabled);

/* intervals */
#define _WEATHER_MIN  3600     /* minimum -  1 hour */
#define _WEATHER_MAX  86400    /* maximum - 24 hours */
#define _WEATHER_DEF  10800    /* default -  3 hours */

#define _WEATHER_ID_MIN  5     /* 54311    (zip code) or ... */
#define _WEATHER_ID_MAX  8     /* USWI0288 (Weather.com city code) */

#define _WEATHER_ID_VALID(v) \
            ((strlen(v) == _WEATHER_ID_MIN || strlen(v) == _WEATHER_ID_MAX))

#define _WEATHER_LOC  "54311"  /* Green Bay, WI */

#define _WEATHER_DIS  "%t"    /* 29F */

#define _WEATHER_URI_KEY  "&par=1007153928&key=3767903cb9a29239"

#define _WEATHER_URI      "http://www.weather.com/?"_WEATHER_URI_KEY

#define _WEATHER_UNIT_S   "standard"
#define _WEATHER_UNIT_M   "metric"

MdhPanel *P_Weather;

#endif /* _MDH_HAS_WEATHER */

G_END_DECLS

#endif /* __panel_weather_h */
