/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <uvm/uvm.h>

static gboolean sys_init = FALSE;

gboolean mdh_sys_init(GError **err)
{
    if(sys_init)
        return(TRUE);

    sys_init = TRUE;

    return(TRUE);
}

void mdh_sys_close(void)
{
    if(!sys_init)
        return;

    sys_init = FALSE;
}

gboolean mdh_sys_get_mem(guint64 *total, guint64 *free, GError **err)
{
    gint mib[2];
    size_t size = sizeof(struct uvmexp);
    static struct uvmexp uvm;

    g_return_val_if_fail(used != NULL, FALSE);
    g_return_val_if_fail(percent != NULL, FALSE);

    mib[0] = CTL_VM;
    mib[1] = VM_UVMEXP;

    if(sysctl(mib, 2, &uvm, &size, NULL, 0) == -1) {
        g_set_error(err, 0, 0, "sysctl: %s", g_strerror(errno));
        return(FALSE);
    }

    *total = (guint64) (uvm->npages + uvm->swpages) * uvm->pagesize;
    *free  = (guint64) ((uvm->free + uvm->inactive) +
                           (uvm->swpages - uvm->swpginuse)) * uvm->pagesize;

    return(TRUE);
}
