/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <unistd.h>

#include <gtk/gtk.h>

#include "mdh.h"

#include "ui_about.h"

#include "widget.h"
#include "window.h"
#include "util.h"

static const gchar *about_quote_list[] = {
        /* Family Guy */
        "Giggity, Giggity, Giggity!",
        "Victory is mine!",
        "I want them to have new hats!",
        "Guns don't kill people, dangerous minorities do.",
        "You're a naughty child and that's concentrated\nevil coming out the back of you.",
        "A girl answered a math problem, you know what the means...\n<span foreground=\"darkred\" style=\"italic\">A WITCH!</span>",
        "Good, good.",

        /* Futurama */
        "Good news everyone!",
        "Bite my splintery wooden ass!",
        "Bite my glorious golden ass!",
        "I'm so embarrassed, I wish everybody else was dead.",
        "My full name is Bender Bending Rodriguez.",
        "You'll just have to metaphorically make a deal with the Devil.\nBy Devil I Mean Robot-Devil.\nAnd by metaphorically I mean, get your coat.",
        "I hate bottles.",
        "Is desire to mate a feeling?",
        "That guy makes makes Speedy Gonzales look like regular Gonzales!",
        "I used to work in a pizzeria and as soon as I stop hallucinating\nand blasting puke, I'm gonna teach you to sell pizza - Earth style!",
        "The spirit is willing, but the flesh is spongy and bruised.",
        "You win again, gravity!",
        "The best way into a girl's bed is through her parents.\nHave sex with them, and you're in.",
        "Stop exploding you cowards!",
        "Pimp-mobile.",
        "Chumpette.",
        "Put on pants Zoidberg!",
        "I'll take 8!",
        "I've never been so happy to be beaten up by a girl.",
        "Brannigan's law is like Brannigan's love - hard and fast.",
        "Fly the white flag of war.",
        "I come swinging the olive branch of peace.",
        "Life... Death... Either way I'll be confined to a small cubicle!",
        "This concept of wuv confuses and infuriates us!",
        "I don't regret this, but I both rue and lament it.",
        "Fix it! Fix it! Fix it! Fix it! ... Fix it! Fix it!",
        "Big Pink, the only gum with the breath freshening power of ham.",
        "Stop being such a baby and chop my hands off!",
        "All glory to the hypnotoad!",
        "The number you have dialed has crashed into a planet.\nPlease make a note of it.",
        "If I said you had a beautiful body, would you take your\npants off and dance around a little?",
        "Baby, it'll blow your mind.",
        "I'll miss you, meat bag.",
        "Muhahaha, oily humanoids!",
        "<span foreground=\"purple\">Bam!</span>",

        /* There's Something About Mary */
        "Have you seen my baseball?",
        "Franks and beans!",
        "Is that ... hair gel?",

        /* Boogie Nights */
        "I'm a big bright shining star...",

        /* Back To The Future */
        "I'm your density.",

        /* Star Trek */
        "NU-CLE-AR WESSESLS!",

        /* Ghostbusters */
        "Are you the Keymaster?",
        "There is no Dana, only Zuul.",

        /* Silence Of The Lambs */
        "It places the lotion in the basket.",

        /* Fight Club */
        "It's only after you've lost everything that you're free to do anything.",
        "I am Jack's smirking revenge.",
        "You are not the car you drive.",
        "You are not the contents of your wallet.",

        /* Pee-wee's Big Adventure */
        "I'm rolling a big donut and this snake wearing a vest...",
        "But what?\nEveryone I know has a big but.\nC'mon Simone, lets talk about your big but.",

        /* Dracula 3000 */
        "All that bloodsuckin', that's some white people shit.",

        /* Skeleton Man */
        "If you can see it, I can shoot it.",
        "Beans is good.",
        "Get outta there!\nGo! Get outta here!\nMove! Move! Save yourself!\nC'mon! Go! Go! Go!\nGo! Go!\nStay covered! Go!\nThe place is gonna blow!\nThe place is gonna go!\nMove!\nGo! Go! Get outta here!\n\nGo! Save yourself!",

        /* Troll 2 */
        "Grampa Seth!",
        "Nilbog, a wonderful half-empty town!",
        "Joshua, start singing!",
        "Do you see this writing?\nDo you know what it means?\nHospitality.\nAnd you can't piss on hospitality. <span foreground=\"darkred\" style=\"italic\">I won't allow it!</span>",
        "They're eating her ... and then they're going to eat me ...\n<span foreground=\"darkred\" style=\"italic\">OH MY GOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOD!</span>",

        /* xXx */
        "Bitches Come!",

        /* Death Wish 3 */
        "The Giggler. That's his name. He laughs when he runs. Nobody catches him.\n<span style=\"italic\">(Jesus, he really moves!)</span>",
        "Hey! I said lend me five dollars, sucker!",

        /* Delta ;) */
        "We got you covered like a jimmy hat.",

        /* Sprout */
        "bob.c:324 Undefined Bananna: Chiquita"
    };

static gint about_quote_list_size = G_N_ELEMENTS(about_quote_list);

static void ui_about_view_mdh_home(void)
{
    GError *err = NULL;

    if(!mdh_browser_open_uri(_MDH_URL, &err)) {
        mdh_window_error("Failed to open URI.", err->message);
        g_error_free(err);
    }
}

static void ui_about_close(GtkWidget *widget)
{
    mdh_window_item_open_set(&wi_about, FALSE);
}

static void ui_about_quote_update(GtkWidget *widget)
{
    gint index = g_random_int_range(0, about_quote_list_size);
    
    mdh_clickable_set_text(widget,
                           about_quote_list[index],
                           MDH_MARKUP_SIZE_SMALLER | MDH_MARKUP_WEIGHT_BOLD);
}

void mdh_ui_about(void)
{
    GtkWidget *window,
              *vbox,
              *vbox2,
              *hbox,
              *image,
              *label,
              *hsep,
              *button;

    /*
     * http://www.geocrawler.com/mail/msg.php3?msg_id=6021322&list=522
     *   char buf[3] = { 0xc2, 0xa9, '\0' };
     *   char buf[7]; int len = g_unichar_to_utf8 (176, buf); buf[len] = '\0';
     */

    static gchar COPYRIGHT[3] = { 0xc2, 0xa9, 0 };
  /*static gchar TRADEMARK[4] = { 0xe2, 0x84, 0xa2, 0 };*/

    if(mdh_window_item_open(&wi_about))
        return;

    mdh_window_item_open_set(&wi_about, TRUE);

    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(window), "MailDooHicky: About");
    gtk_window_set_resizable(GTK_WINDOW(window), FALSE);

    g_signal_connect(G_OBJECT(window), "destroy",
                     G_CALLBACK(ui_about_close), NULL);

    g_signal_connect(G_OBJECT(window), "event",
                     G_CALLBACK(mdh_window_event), NULL);

    g_signal_connect(G_OBJECT(window), "expose_event",
                     G_CALLBACK(mdh_window_expose_event), NULL);

    gtk_container_set_border_width(GTK_CONTAINER(window), 5);

    vbox = gtk_vbox_new(FALSE, 2);
    gtk_widget_show(vbox);

    gtk_container_add(GTK_CONTAINER(window), vbox);
    
    hbox = gtk_hbox_new(FALSE, 5);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
    gtk_widget_show(hbox);
    
    image = gtk_image_new_from_stock(GTK_STOCK_ABOUT, GTK_ICON_SIZE_DIALOG);
    gtk_box_pack_start(GTK_BOX(hbox), image, FALSE, FALSE, 0);
    gtk_widget_show(image);
    
    gtk_misc_set_alignment(GTK_MISC(image), 0.5, 0.0);
    gtk_misc_set_padding(GTK_MISC(image), 0, 5);
    
    vbox2 = gtk_vbox_new(FALSE, 0);
    gtk_widget_show(vbox2);

    gtk_container_set_border_width(GTK_CONTAINER(vbox2), 5);
    
    gtk_container_add(GTK_CONTAINER(hbox), vbox2);
    
    label = gtk_label_new(NULL);
    gtk_box_pack_start(GTK_BOX(vbox2), label, FALSE, FALSE, 5);
    gtk_widget_show(label);

    mdh_label_set_markup(GTK_LABEL(label),
                         MDH_MARKUP_SIZE_LARGER | MDH_MARKUP_WEIGHT_BOLD,
                         "MailDooHicky v%s", PACKAGE_VERSION);

    button = mdh_clickable_uri(_MDH_URL, ui_about_view_mdh_home, NULL);
    gtk_box_pack_start(GTK_BOX(vbox2), button, FALSE, FALSE, 2);
    gtk_widget_show_all(button);

    mdh_widget_set_tip(NULL, button, "View MailDooHicky home");

    label = gtk_label_new(NULL);
    gtk_box_pack_start(GTK_BOX(vbox2), label, FALSE, FALSE, 0);
    gtk_widget_show(label);

    mdh_label_set_markup(GTK_LABEL(label), 0,
                        "%s 2003-2005 Mike Hokenson &lt;%s&gt;",
                         COPYRIGHT,
                         _MDH_EMAIL);

    label = gtk_label_new("Released under the GNU Public License");
    gtk_box_pack_start(GTK_BOX(vbox2), label, FALSE, FALSE, 5);
    gtk_widget_show(label);

    hsep = gtk_hseparator_new();
    gtk_box_pack_start(GTK_BOX(vbox2), hsep, FALSE, TRUE, 5);
    gtk_widget_show(hsep);

    button = mdh_clickable_new(NULL, ui_about_quote_update, NULL, 0, GDK_GUMBY);
    gtk_box_pack_start(GTK_BOX(vbox2), button, FALSE, FALSE, 5);
    gtk_widget_show_all(button);

    ui_about_quote_update(button);

    label = GTK_BIN(button)->child;

    gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
    gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_CENTER);

    gtk_widget_set_size_request(GTK_WIDGET(label), 400, -1);

    button = gtk_button_new_from_stock(GTK_STOCK_OK);
    gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
    gtk_widget_show(button);

    mdh_widget_grab_default(button);

    g_signal_connect_swapped(G_OBJECT(button), "clicked",
                             G_CALLBACK(gtk_widget_destroy), window);
                 
    gtk_widget_show(window);
}
