/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <unistd.h>

#include <gtk/gtk.h>

#include "mdh.h"

#include "toolbar.h"

#include "ui_error.h"

#include "error.h"
#include "widget.h"
#include "window.h"
#include "util.h"

static void ui_error_close(void)
{
    mdh_window_item_open_set(&wi_error, FALSE);
}

static void ui_error_refresh(GtkListStore *store)
{
    GSList *p;

    g_return_if_fail(store != NULL);

    /* clear the current list */
    gtk_list_store_clear(store);

    for(p = mdh_error_list(); p; p = g_slist_next(p)) {
        GtkTreeIter iter;

        gtk_list_store_append(store, &iter);
        gtk_list_store_set(store, &iter, 0, p->data, -1);
    }
}

static void ui_error_clear(GtkListStore *store)
{
    mdh_error_clear_all();
    ui_error_refresh(store);
}

void mdh_ui_error(void)
{
    GtkWidget *window;
    GtkWidget *vbox;
    GtkWidget *hbox;
    GtkWidget *button;

    GtkWidget *scrolled_window;

    GtkListStore *store;
    GtkWidget *tree;
    GtkCellRenderer *renderer;

    if(mdh_window_item_open(&wi_error))
        return;

    mdh_window_item_open_set(&wi_error, TRUE);

    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(window), "MailDooHicky: Error Log");

    gtk_widget_set_size_request(GTK_WIDGET(window), 575, 200);

    g_signal_connect(G_OBJECT(window), "destroy",
                     G_CALLBACK(ui_error_close), NULL);

    g_signal_connect(G_OBJECT(window), "event",
                     G_CALLBACK(mdh_window_event), NULL);

    g_signal_connect(G_OBJECT(window), "expose_event",
                     G_CALLBACK(mdh_window_expose_event), NULL);

    gtk_container_set_border_width(GTK_CONTAINER(window), 5);

    vbox = gtk_vbox_new(FALSE, 5);
    gtk_widget_show(vbox);

    gtk_container_add(GTK_CONTAINER(window), vbox);

    scrolled_window = gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window),
        GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    gtk_widget_show(scrolled_window);

    gtk_box_pack_start(GTK_BOX(vbox), scrolled_window, TRUE, TRUE, 0);

    store = gtk_list_store_new(1, G_TYPE_STRING);

    /* Create a view */
    tree = gtk_tree_view_new_with_model(GTK_TREE_MODEL(store));
    gtk_widget_show(tree);

    gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(tree), TRUE);

    gtk_container_add(GTK_CONTAINER(scrolled_window), tree);

    g_object_unref(G_OBJECT(store));

    gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(tree), FALSE);

    renderer = gtk_cell_renderer_text_new();

    gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(tree),
                                                -1,
                                                "Log Entry",
                                                renderer,
                                                "text",
                                                0,
                                                NULL);

    ui_error_refresh(store);

    hbox = gtk_hbox_new(TRUE, 3);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
    gtk_widget_show(hbox);

    button = gtk_button_new_from_stock(GTK_STOCK_CLEAR);
    gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, TRUE, 0);
    gtk_widget_show(button);

    mdh_widget_set_tip(NULL, button, "Clear error log");

    g_signal_connect_swapped(G_OBJECT(button), "clicked",
                             G_CALLBACK(ui_error_clear), store);

    button = gtk_button_new_from_stock(GTK_STOCK_REFRESH);
    gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, TRUE, 0);
    gtk_widget_show(button);

    mdh_widget_set_tip(NULL, button, "Refresh error log");

    g_signal_connect_swapped(G_OBJECT(button), "clicked",
                             G_CALLBACK(ui_error_refresh), store);

    button = gtk_button_new_from_stock(GTK_STOCK_CLOSE);
    gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, TRUE, 0);
    gtk_widget_show(button);

    mdh_widget_grab_default(button);

    mdh_widget_set_tip(NULL, button, "Close error log");

    g_signal_connect_swapped(G_OBJECT(button), "clicked",
                             G_CALLBACK(gtk_widget_destroy), window);

    gtk_widget_show(window);
}
