/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __widget_h
#define __widget_h

G_BEGIN_DECLS

typedef enum {
    MDH_MARKUP_SIZE_SMALL    = 1 <<  0,
    MDH_MARKUP_SIZE_MEDIUM   = 1 <<  1,
    MDH_MARKUP_SIZE_LARGE    = 1 <<  2,
    MDH_MARKUP_SIZE_SMALLER  = 1 <<  3,
    MDH_MARKUP_SIZE_LARGER   = 1 <<  4,

    MDH_MARKUP_WEIGHT_LIGHT  = 1 <<  5,
    MDH_MARKUP_WEIGHT_NORMAL = 1 <<  6,
    MDH_MARKUP_WEIGHT_BOLD   = 1 <<  7,
    MDH_MARKUP_WEIGHT_HEAVY  = 1 <<  8,

    MDH_MARKUP_UNDERLINE     = 1 <<  9,

    MDH_MARKUP_STRIKETHROUGH = 1 << 10,

    MDH_MARKUP_STYLE_ITALIC  = 1 << 11,
    MDH_MARKUP_STYLE_OBLIQUE = 1 << 12,

    MDH_MARKUP_FG_RED        = 1 << 13,
    MDH_MARKUP_FG_BLUE       = 1 << 24,
    MDH_MARKUP_FG_GREEN      = 1 << 25,
    MDH_MARKUP_FG_YELLOW     = 1 << 26,
    MDH_MARKUP_BG_RED        = 1 << 27,
    MDH_MARKUP_BG_BLUE       = 1 << 28,
    MDH_MARKUP_BG_GREEN      = 1 << 29,
    MDH_MARKUP_BG_YELLOW     = 1 << 30
} MdhMarkupFlags;

typedef enum {
    MDH_IMAGE_TYPE_STOCK,
    MDH_IMAGE_TYPE_FILE
} MdhImageType;

void mdh_widget_set_font_desc(GtkWidget *widget,
                              PangoFontDescription *font_desc);
void mdh_widget_set_font(GtkWidget *widget, const gchar *font);

void mdh_widget_set_tip(GtkTooltips *tips, GtkWidget *widget, const gchar *tip);

GtkWidget *mdh_button_new_from_stock(const gchar *stock_id, const gchar *text);

void mdh_label_set_markup(GtkLabel *label,
                          MdhMarkupFlags flags,
                          const gchar *fmt,
                          ...);

#define mdh_label_set_smaller(label, text) \
    (mdh_label_set_markup(GTK_LABEL(label), \
                          MDH_MARKUP_SIZE_SMALLER | MDH_MARKUP_WEIGHT_BOLD, \
                          "%s", text))

#define mdh_label_set_larger(label, text) \
    (mdh_label_set_markup(GTK_LABEL(label), \
                          MDH_MARKUP_SIZE_LARGER | MDH_MARKUP_WEIGHT_BOLD, \
                          "%s", text))

#define mdh_label_set_bold(label, text) \
    (mdh_label_set_markup(GTK_LABEL(label), MDH_MARKUP_WEIGHT_BOLD, "%s", text))

GtkWidget *mdh_clickable_new(const gchar *text,
                             gpointer func,
                             gpointer data,
                             MdhMarkupFlags flags,
                             GdkCursorType cursor);

#define mdh_clickable_set_text(label, text, flags) \
    (mdh_label_set_markup(GTK_LABEL(GTK_BIN(label)->child), flags, "%s", text))

#define mdh_clickable_help(text, func, data) \
    (mdh_clickable_new(text, func, data, \
                       MDH_MARKUP_WEIGHT_BOLD | MDH_MARKUP_UNDERLINE | \
                           MDH_MARKUP_FG_RED, \
                       GDK_QUESTION_ARROW))

#define mdh_clickable_uri(text, func, data) \
    (mdh_clickable_new(text, func, data, \
                       MDH_MARKUP_WEIGHT_BOLD | MDH_MARKUP_UNDERLINE | \
                           MDH_MARKUP_FG_BLUE, \
                       GDK_HAND2))

GtkWidget *mdh_frame_new_with_title(const gchar *title);

#define mdh_widget_grab_default(widget) \
    { \
        GTK_WIDGET_SET_FLAGS(GTK_WIDGET(widget), GTK_CAN_DEFAULT); \
        gtk_widget_grab_default(GTK_WIDGET(widget)); \
        gtk_widget_grab_focus(GTK_WIDGET(widget)); \
    }

GtkWidget *mdh_image_menu_item_new_from_stock(const gchar *label,
                                              const gchar *stock_id);
GtkWidget *mdh_image_menu_item_new_from_file(const gchar *label,
                                             const gchar *file);

#if (!defined(GTK_CHECK_VERSION) || !GTK_CHECK_VERSION(2, 6, 0))
gchar *gtk_combo_box_get_active_text(GtkComboBox *combo_box);
#endif

/* GtkStock items added in 2.6 */

#ifndef GTK_STOCK_ABOUT
#define GTK_STOCK_ABOUT GTK_STOCK_DIALOG_INFO
#endif

#ifndef GTK_STOCK_EDIT
#define GTK_STOCK_EDIT GTK_STOCK_PASTE
#endif

G_END_DECLS

#endif /* __widget_h */
