/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __window_h
#define __window_h

G_BEGIN_DECLS

typedef struct {
    GtkWidget *menu_item;
    gboolean   open;
} MdhWindowItem;

gboolean mdh_window_event(GtkWidget *widget, GdkEvent *event);
gboolean mdh_window_expose_event(GtkWidget *widget, GdkEventExpose *event);

void mdh_window_notice(const gchar *head, const gchar *body);
void mdh_window_error(const gchar *head, const gchar *body);

gboolean mdh_window_yes_no_prompt(const gchar *text);

gboolean mdh_window_item_open(MdhWindowItem *item);
void mdh_window_item_open_set(MdhWindowItem *item, gboolean open);

MdhWindowItem wi_about,
              wi_config,
              wi_custom,
              wi_error,
              wi_run,
              wi_scratch_pad;

#if _MDH_HAS_MIXER
MdhWindowItem wi_mixer;
#endif

G_END_DECLS

#endif /* __window_h */
