/*
 * basic.c:
 *   a general example that loads a specified .ini file, reads a few
 *   variables, makes some changes, and saves the changes to a new file.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gini.h>

#if (!defined(GINI_CHECK_VERSION) || !GINI_CHECK_VERSION(0, 4, 0))
# error "libgini version is too old"
#endif

gint main(void)
{
    GIni *ini;

    GError *err = NULL;

    gboolean use_realtime;
    gfloat equalizer_preamp;
    const gchar *filesel_path;

    gboolean sticky;

    gini_init();

    /* load the sample ini file */
    if(!(ini = gini_load("sample.ini", &err))) {
        g_warning("%s", err->message);
        g_error_free(err);

        /* not necessarily fatal, you can always create a new GIni... */
        ini = gini_new("sample.ini");
    }

    if(gini_get_file(ini))
        g_print("Loaded '%s', found %d sections.\n\n",
                gini_get_file(ini), gini_get_section_count(ini));

    g_print("Checking values...\n");

    if(gini_entry_get_boolean(ini, "xmms", "use_realtime", &use_realtime))
        g_print("  use_realtime = %s\n", (use_realtime) ? "TRUE" : "FALSE");
    else /* value missing, set default */
        use_realtime = FALSE;

    if(gini_entry_get_float(ini, "xmms", "equalizer_preamp", &equalizer_preamp))
        g_print("  equalizer_preamp = %g\n", equalizer_preamp);
    else
        equalizer_preamp = 0;

    if(gini_entry_get_string(ini, "xmms", "filesel_path", &filesel_path))
        g_print("  filesel_path = %s\n", filesel_path);
    else
        filesel_path = "/cdrom";

    /* doesn't exist in sample.ini */
    if(!gini_entry_get_boolean(ini, "xmms", "sticky", &sticky))
        sticky = FALSE;

    g_print("\n");

    /* change some settings */
    use_realtime = FALSE;
    filesel_path = "/dvd";

    g_print("Updating values.\n\n");

    /* update any changes */
    gini_entry_set_boolean(ini, "xmms", "use_realtime", use_realtime);
    gini_entry_set_float(ini, "xmms", "equalizer_preamp", equalizer_preamp);
    gini_entry_set_string(ini, "xmms", "filesel_path", filesel_path);
    gini_entry_set_boolean(ini, "xmms", "sticky", sticky);

    g_print("Saving everything to 'basic.ini'.\n");

    /* save to a specified file (or NULL to use the file loaded from) */
    if(!gini_save(ini, "basic.ini", &err)) {
        g_warning("%s", err->message);
        g_error_free(err);
    }

    gini_unref(ini);

    exit(0);
}
