/*
 * parse.c:
 *   a simple example that reads in the specified .ini file(s) and writes the
 *   processed data to stdout.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gini.h>

#if (!defined(GINI_CHECK_VERSION) || !GINI_CHECK_VERSION(0, 4, 0))
# error "libgini version is too old"
#endif

gint main(gint argc, gchar **argv)
{
    gint i;

    if(argc < 2) {
        fprintf(stderr, "Usage: %s [file1.ini file2.ini ...]\n", argv[0]);
        exit(1);
    }

    gini_init();

    for(i = 1; i < argc; i++) {
        GIni *ini;

        GError *err = NULL;

        if(argc > 2)
            g_print("--- %s ---\n", argv[i]);

        if((ini = gini_load(argv[i], &err))) {
            gini_write(ini, stdout);
            gini_unref(ini);
        } else {
            g_warning("%s", err->message);
            g_error_free(err);
        }
    }

    exit(0);
}
