/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __config_h
#define __config_h

G_BEGIN_DECLS

void mdh_config_load(const gchar *file);
void mdh_config_apply(void);
void mdh_config_save(void);
void mdh_config_free(void);

gboolean mdh_config_locked(const gchar *file, gchar **dpy, pid_t *pid);
gboolean mdh_config_lock(const gchar *file);
gboolean mdh_config_unlock(const gchar *file);

gboolean mdh_config_get_pointer(const gchar *section,
                                const gchar *variable,
                                gpointer *value);
void mdh_config_set_pointer(const gchar *section,
                            const gchar *variable,
                            gpointer value);

gboolean mdh_config_get_string(const gchar *section,
                               const gchar *variable,
                               const gchar **value);
void mdh_config_set_string(const gchar *section,
                           const gchar *variable,
                           const gchar *value);

gboolean mdh_config_get_boolean(const gchar *section,
                                const gchar *variable,
                                gboolean *value);
void mdh_config_set_boolean(const gchar *section,
                            const gchar *variable,
                            gboolean value);

gboolean mdh_config_get_int(const gchar *section,
                            const gchar *variable,
                            gint *value);
void mdh_config_set_int(const gchar *section,
                        const gchar *variable,
                        gint value);

G_END_DECLS

#endif /* __config_h */
