/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __custom_h
#define __custom_h

G_BEGIN_DECLS

typedef struct {
    GtkWidget *button;
    GtkWidget *label;
    GtkWidget *icon;
} MdhCustomWidgets;
    
typedef struct {
    gpointer          toolbar;

    gboolean          hidden;

    gboolean          enabled;

    gchar            *value;
    gchar            *icon;
    gchar            *command;
    gchar            *tooltip;

    MdhCustomWidgets  widgets;
} MdhCustom;

#define _MDH_BUTTON_COUNT_CUSTOM_DEF 10
#define _MDH_BUTTON_COUNT_CUSTOM_MAX 25

const gchar *mdh_custom_icon_default(void);

MdhCustom *mdh_custom_new(gboolean enabled,
                          const gchar *value,
                          const gchar *command,
                          const gchar *tooltip,
                          const gchar *icon);
void mdh_custom_set_values(MdhCustom *obj,
                           gboolean enabled,
                           const gchar *value,
                           const gchar *command,
                           const gchar *tooltip,
                           const gchar *icon);
void mdh_custom_free_values(MdhCustom *obj);
void mdh_custom_free(MdhCustom *obj);

void mdh_custom_toggle(MdhCustom *obj);
void mdh_custom_show(MdhCustom *obj);
void mdh_custom_hide(MdhCustom *obj);
void mdh_custom_reset(MdhCustom *obj);

void mdh_custom_foreach(gpointer toolbar, GFunc func, gpointer data);

gboolean mdh_custom_hidden(MdhCustom *obj);

gboolean mdh_custom_execute_callback(MdhCustom *obj, GError **err);

void mdh_custom_set_relief(MdhCustom *obj, GtkReliefStyle relief);
void mdh_custom_set_tip(MdhCustom *obj, const gchar *text);

void mdh_custom_set_font_desc(MdhCustom *obj, PangoFontDescription *font_desc);
void mdh_custom_set_font(MdhCustom *obj, const gchar *font);

gint mdh_custom_count(void);
void mdh_custom_count_set(gint count);

#define MDH_CUSTOM(c) ((MdhCustom *) c)

MdhCustom **B_Cust;

G_END_DECLS

#endif /* __custom_h */
